/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.foodeffects.config.library.element;

import java.lang.reflect.Field;
import org.infernalstudios.foodeffects.config.library.element.ConfigElement;
import org.infernalstudios.foodeffects.config.library.element.handler.IConfigElementHandler;
import org.infernalstudios.foodeffects.config.library.util.Util;

public class PrimitiveConfigElement<T>
extends ConfigElement<T> {
    private final Class<?> primitiveType = Util.getPrimitive(this.getType());

    public PrimitiveConfigElement(Field field, IConfigElementHandler<T, ?> handler) {
        super(field, handler);
        if (this.primitiveType == null) {
            throw new IllegalArgumentException(String.format("defaultValue must be a primitive type, got %s", this.getType()));
        }
    }

    @Override
    public boolean extendsFrom(Class<?> clazz) {
        return this.primitiveType.isAssignableFrom(clazz) || super.extendsFrom(clazz);
    }
}

