/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.foodeffects.config.library;

import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.file.FileWatcher;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import org.infernalstudios.foodeffects.config.library.ConfigBuilder;
import org.infernalstudios.foodeffects.config.library.element.IConfigElement;
import org.infernalstudios.foodeffects.config.library.element.handler.BooleanElementHandler;
import org.infernalstudios.foodeffects.config.library.element.handler.DoubleElementHandler;
import org.infernalstudios.foodeffects.config.library.element.handler.FloatElementHandler;
import org.infernalstudios.foodeffects.config.library.element.handler.IConfigElementHandler;
import org.infernalstudios.foodeffects.config.library.element.handler.IntegerElementHandler;
import org.infernalstudios.foodeffects.config.library.element.handler.ListElementHandler;
import org.infernalstudios.foodeffects.config.library.element.handler.NumberElementHandler;
import org.infernalstudios.foodeffects.config.library.element.handler.StringElementHandler;

public final class Config {
    private final CommentedFileConfig config;
    private final List<IConfigElement<?>> elements;
    private final List<Consumer<ReloadStage>> reloadListeners = new CopyOnWriteArrayList<Consumer<ReloadStage>>();
    protected static final Map<Class<?>, IConfigElementHandler<?, ?>> HANDLERS = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Config(CommentedFileConfig config, List<IConfigElement<?>> elements) {
        this.config = config;
        this.elements = new CopyOnWriteArrayList(elements);
        this.reload();
        CommentedFileConfig commentedFileConfig = this.config;
        synchronized (commentedFileConfig) {
            this.save();
        }
        try {
            FileWatcher.defaultInstance().addWatch(config.getNioPath(), (Runnable)new Thread(){

                @Override
                public void run() {
                    Config.this.reload();
                }
            });
        }
        catch (IOException e) {
            System.err.println(String.format("Couldn't watch file \"%s\" for changes.", config.getNioPath().toAbsolutePath().toString()));
        }
    }

    public CommentedFileConfig getConfig() {
        return this.config;
    }

    public Iterator<IConfigElement<?>> getElements() {
        return this.elements.iterator();
    }

    public void save() {
        for (IConfigElement<?> element : this.elements) {
            this.config.set(element.getName(), element.getTypeHandler().serialize(element));
            this.config.setComment(element.getName(), element.getComment());
        }
        this.config.save();
    }

    public void reload() {
        for (Consumer<ReloadStage> listener : this.reloadListeners) {
            listener.accept(ReloadStage.PRE);
        }
        this.config.load();
        boolean shouldSave = false;
        for (IConfigElement<?> iConfigElement : this.elements) {
            Object obj = this.config.get(iConfigElement.getName());
            IConfigElementHandler<?, ?> handler = iConfigElement.getTypeHandler();
            if (obj != null && handler.canHandle(obj.getClass())) {
                handler.update(iConfigElement, handler.deserialize(obj));
                continue;
            }
            this.config.set(iConfigElement.getName(), handler.serialize(iConfigElement));
            shouldSave = true;
        }
        if (shouldSave) {
            for (Consumer consumer : this.reloadListeners) {
                consumer.accept(ReloadStage.SAVE);
            }
            this.save();
        }
        for (Consumer consumer : this.reloadListeners) {
            consumer.accept(ReloadStage.POST);
        }
    }

    public void onReload(Consumer<ReloadStage> runnable) {
        this.reloadListeners.add(runnable);
    }

    public static ConfigBuilder builder(String path) throws IOException {
        return Config.builder(Paths.get(path, new String[0]));
    }

    public static ConfigBuilder builder(File file) throws IOException {
        return Config.builder(file.toPath());
    }

    public static ConfigBuilder builder(Path path) throws IOException {
        return new ConfigBuilder(path);
    }

    public static <T> void registerHandler(Class<T> clazz, IConfigElementHandler<T, ?> handler) {
        HANDLERS.put(clazz, handler);
    }

    public static <T> IConfigElementHandler<T, ?> getHandler(Class<T> clazz) {
        IConfigElementHandler<?, ?> handler = HANDLERS.get(clazz);
        if (handler == null) {
            for (IConfigElementHandler<T, T> iConfigElementHandler : HANDLERS.values()) {
                if (!iConfigElementHandler.canHandle(clazz)) continue;
                handler = iConfigElementHandler;
                break;
            }
        }
        return handler;
    }

    static {
        Config.registerHandler(Boolean.class, BooleanElementHandler.INSTANCE);
        Config.registerHandler(Boolean.TYPE, BooleanElementHandler.INSTANCE);
        Config.registerHandler(Double.class, DoubleElementHandler.INSTANCE);
        Config.registerHandler(Double.TYPE, DoubleElementHandler.INSTANCE);
        Config.registerHandler(Float.class, FloatElementHandler.INSTANCE);
        Config.registerHandler(Float.TYPE, FloatElementHandler.INSTANCE);
        Config.registerHandler(Integer.class, IntegerElementHandler.INSTANCE);
        Config.registerHandler(Integer.TYPE, IntegerElementHandler.INSTANCE);
        Config.registerHandler(String.class, StringElementHandler.INSTANCE);
        Config.registerHandler(Number.class, NumberElementHandler.INSTANCE);
        Config.registerHandler(List.class, ListElementHandler.INSTANCE);
    }

    public static enum ReloadStage {
        PRE,
        SAVE,
        POST;

    }
}

