/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.foodeffects;

import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.moddiscovery.ModFileInfo;
import org.infernalstudios.foodeffects.EffectData;
import org.infernalstudios.foodeffects.FoodEffects;
import org.infernalstudios.foodeffects.config.FoodEffectsConfig;

@Mod.EventBusSubscriber(modid="foodeffects")
public class FoodEffectsEvents {
    @SubscribeEvent
    public void onLivingEntityUseItemStart(LivingEntityUseItemEvent.Start event) {
        ItemStack stack = event.getItem();
        if ((stack.m_41720_() == Items.f_42572_ || stack.m_41720_() == Items.f_42780_) && FoodEffectsConfig.eat_cookies_berries_fast) {
            event.setDuration(16);
        }
    }

    @SubscribeEvent
    public void onLivingEntityUseItemFinish(LivingEntityUseItemEvent.Finish event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            FoodEffectsEvents.onEat(player, event.getItem().m_41720_());
        }
    }

    public static void onEat(Player player, Item item) {
        for (EffectData effect : FoodEffectsConfig.effects) {
            if (effect == null) {
                FoodEffects.LOGGER.traceExit("EffectData is null! This should never happen, please report this to the developers at: %s", (Object)((ModFileInfo)ModList.get().getModFileById("foodeffects")).getIssueURL().toString());
                continue;
            }
            if (effect.getItem() == null) {
                FoodEffects.LOGGER.traceExit("Item is null! This should never happen, please report this to the developers at: %s", (Object)((ModFileInfo)ModList.get().getModFileById("foodeffects")).getIssueURL().toString());
                continue;
            }
            if (effect.getEffect() == null) {
                FoodEffects.LOGGER.traceExit("Effect is null! This should never happen, please report this to the developers at: %s", (Object)((ModFileInfo)ModList.get().getModFileById("foodeffects")).getIssueURL().toString());
                continue;
            }
            if (!effect.getItemLocation().equals((Object)item.getRegistryName())) continue;
            if (effect.getDuration() == 0) {
                player.m_21195_(effect.getEffect());
                continue;
            }
            player.m_7292_(new MobEffectInstance(effect.getEffect(), effect.getDuration(), effect.getAmplifier()));
        }
    }
}

