/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.foodeffects;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.ConfigFormat;
import com.electronwill.nightconfig.toml.TomlFormat;
import java.util.HashMap;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.ForgeRegistries;

public record EffectData(ResourceLocation item, ResourceLocation effect, int duration, int amplifier) {
    public ResourceLocation getItemLocation() {
        return this.item;
    }

    @Nullable
    public Item getItem() {
        return (Item)ForgeRegistries.ITEMS.getValue(this.getItemLocation());
    }

    public ResourceLocation getEffectLocation() {
        return this.effect;
    }

    @Nullable
    public MobEffect getEffect() {
        return (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(this.getEffectLocation());
    }

    public int getDuration() {
        return this.duration;
    }

    public int getAmplifier() {
        return this.amplifier;
    }

    public Config toConfig() {
        CommentedConfig config = CommentedConfig.of(() -> new HashMap(4), (ConfigFormat)TomlFormat.instance());
        config.set("item", (Object)this.getItemLocation().toString());
        config.set("effect", (Object)this.getEffectLocation().toString());
        config.set("duration", (Object)((double)this.getDuration() / 20.0));
        config.set("amplifier", (Object)this.getAmplifier());
        config.setComment("item", " Determines what item this effect is applied to.");
        config.setComment("effect", " Determines what effect consuming the item will give in addition to any existing effects.");
        config.setComment("duration", " Determines how long the effect lasts. If set to 0, the effect will be removed.\n Range: [0, 1000000]");
        config.setComment("amplifier", " Determines how strong the effect is. Amplifiers start at 0.\n Range: [0, 255]");
        return config;
    }

    @Override
    public String toString() {
        return "EffectData [item=" + this.item + ", effect=" + this.effect + ", duration=" + this.duration + ", amplifier=" + this.amplifier + "]";
    }

    public static EffectData fromConfig(Config config) {
        return new EffectData(ResourceLocation.m_135820_((String)((String)config.get("item"))), ResourceLocation.m_135820_((String)((String)config.get("effect"))), (int)(((Number)config.get("duration")).doubleValue() * 20.0), config.getInt("amplifier"));
    }

    public static EffectData of(Item item, MobEffect effect, int duration, int amplifier) {
        return new EffectData(item.getRegistryName(), effect.getRegistryName(), duration, amplifier);
    }

    public static EffectData of(ResourceLocation item, ResourceLocation effect, int duration, int amplifier) {
        return new EffectData(item, effect, duration, amplifier);
    }
}

