/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.spawner.blocks;

import javax.annotation.Nonnull;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.api.infusable.DefaultInfusable;
import mcjty.lib.api.infusable.IInfusable;
import mcjty.lib.blockcommands.Command;
import mcjty.lib.blockcommands.ServerCommand;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.GenericItemHandler;
import mcjty.lib.container.SlotDefinition;
import mcjty.lib.network.PacketServerCommandTyped;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericEnergyStorage;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.tileentity.TickingTileEntity;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.Logging;
import mcjty.rftoolsbase.RFToolsBase;
import mcjty.rftoolsutility.modules.spawner.SpawnerConfiguration;
import mcjty.rftoolsutility.modules.spawner.SpawnerModule;
import mcjty.rftoolsutility.modules.spawner.blocks.SpawnerTileEntity;
import mcjty.rftoolsutility.setup.RFToolsUtilityMessages;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.common.util.LazyOptional;

public class MatterBeamerTileEntity
extends TickingTileEntity {
    public static final int TICKTIME = 20;
    public static final int SLOT_MATERIAL = 0;
    public static final Lazy<ContainerFactory> CONTAINER_FACTORY = Lazy.of(() -> new ContainerFactory(1).slot(SlotDefinition.generic().in(), 0, 28, 8).playerSlots(10, 70));
    @Cap(type=CapType.ITEMS_AUTOMATION)
    private final GenericItemHandler items = GenericItemHandler.basic((GenericTileEntity)this, CONTAINER_FACTORY);
    @Cap(type=CapType.ENERGY)
    private final GenericEnergyStorage energyStorage = new GenericEnergyStorage((GenericTileEntity)this, true, (long)SpawnerConfiguration.BEAMER_MAXENERGY, (long)SpawnerConfiguration.BEAMER_RECEIVEPERTICK);
    @Cap(type=CapType.CONTAINER)
    private final LazyOptional<MenuProvider> screenHandler = LazyOptional.of(() -> new DefaultContainerProvider("Matter Beamer").containerSupplier(DefaultContainerProvider.container(SpawnerModule.CONTAINER_MATTER_BEAMER, CONTAINER_FACTORY, (GenericTileEntity)this)).itemHandler(() -> this.items).energyHandler(() -> this.energyStorage).setupSync((GenericTileEntity)this));
    @Cap(type=CapType.INFUSABLE)
    private final IInfusable infusable = new DefaultInfusable((BlockEntity)this);
    public static final Key<BlockPos> VALUE_DESTINATION = new Key("destination", Type.BLOCKPOS);
    private BlockPos destination = null;
    private boolean glowing = false;
    private int ticker = 20;
    public static final Key<BlockPos> PARAM_DESTINATION = new Key("dest", Type.BLOCKPOS);
    @ServerCommand
    public static final Command<?> CMD_SETDESTINATION = Command.create((String)"setDestination", (te, player, params) -> te.setDestination((BlockPos)params.get(PARAM_DESTINATION)));

    public MatterBeamerTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)SpawnerModule.TYPE_MATTER_BEAMER.get(), pos, state);
    }

    public boolean isPowered() {
        return this.powerLevel != 0;
    }

    public boolean isGlowing() {
        return this.glowing;
    }

    protected void tickServer() {
        if (this.powerLevel == 0) {
            this.disableBlockGlow();
            return;
        }
        --this.ticker;
        if (this.ticker > 0) {
            return;
        }
        this.ticker = 20;
        BlockEntity te = null;
        if (this.destination != null) {
            te = this.f_58857_.m_7702_(this.destination);
            if (!(te instanceof SpawnerTileEntity)) {
                this.setDestination(null);
                return;
            }
        } else {
            return;
        }
        ItemStack itemStack = this.items.getStackInSlot(0);
        if (itemStack.m_41619_()) {
            this.disableBlockGlow();
            return;
        }
        SpawnerTileEntity spawnerTileEntity = (SpawnerTileEntity)te;
        int maxblocks = (int)((double)SpawnerConfiguration.beamBlocksPerSend * (1.01 + (double)this.infusable.getInfusedFactor() * 2.0));
        int numblocks = Math.min(maxblocks, itemStack.m_41613_());
        int rf = (int)((float)(SpawnerConfiguration.beamRfPerObject * numblocks) * (4.0f - this.infusable.getInfusedFactor()) / 4.0f);
        if (this.energyStorage.getEnergyStored() < rf) {
            return;
        }
        this.energyStorage.consumeEnergy((long)rf);
        if (spawnerTileEntity.addMatter(itemStack, numblocks, this.infusable.getInfusedFactor())) {
            this.items.decrStackSize(0, numblocks);
            this.enableBlockGlow();
        }
    }

    private void disableBlockGlow() {
        if (this.glowing) {
            this.glowing = false;
            this.f_58857_.m_7731_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(this.glowing)), 11);
            this.markDirtyQuick();
        }
    }

    private void enableBlockGlow() {
        if (!this.glowing) {
            this.glowing = true;
            this.f_58857_.m_7731_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(this.glowing)), 11);
            this.markDirtyQuick();
        }
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet) {
        boolean oldglowing = this.glowing;
        super.onDataPacket(net, packet);
        super.onDataPacket(net, packet);
        if (this.f_58857_.f_46443_ && oldglowing != this.glowing) {
            this.f_58857_.m_7731_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(this.glowing)), 11);
        }
    }

    public AABB getRenderBoundingBox() {
        int xCoord = this.m_58899_().m_123341_();
        int yCoord = this.m_58899_().m_123342_();
        int zCoord = this.m_58899_().m_123343_();
        return new AABB((double)(xCoord - 4), (double)(yCoord - 4), (double)(zCoord - 4), (double)(xCoord + 5), (double)(yCoord + 5), (double)(zCoord + 5));
    }

    public boolean wrenchUse(Level world, BlockPos pos, Direction side, Player player) {
        if (world.f_46443_) {
            world.m_7785_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_12216_, SoundSource.BLOCKS, 1.0f, 1.0f, false);
            this.useWrench(player);
        }
        return true;
    }

    private void useWrench(Player player) {
        BlockPos coord = RFToolsBase.instance.clientInfo.getSelectedTE();
        BlockEntity tileEntity = null;
        if (coord != null) {
            tileEntity = this.f_58857_.m_7702_(coord);
        }
        if (!(tileEntity instanceof MatterBeamerTileEntity)) {
            RFToolsBase.instance.clientInfo.setSelectedTE(this.m_58899_());
            SpawnerTileEntity destinationTE = this.getDestinationTE();
            if (destinationTE == null) {
                RFToolsBase.instance.clientInfo.setDestinationTE(null);
            } else {
                RFToolsBase.instance.clientInfo.setDestinationTE(destinationTE.m_58899_());
            }
            Logging.message((Player)player, (String)"Select a spawner as destination");
        } else if (coord.equals((Object)this.m_58899_())) {
            RFToolsBase.instance.clientInfo.setSelectedTE(null);
            RFToolsBase.instance.clientInfo.setDestinationTE(null);
            this.setDestination(null);
            Logging.message((Player)player, (String)"Destination cleared!");
        }
    }

    public void setDestination(BlockPos destination) {
        this.destination = destination;
        this.disableBlockGlow();
        this.m_6596_();
        if (this.f_58857_.f_46443_) {
            PacketServerCommandTyped packet = new PacketServerCommandTyped(this.m_58899_(), this.getDimension(), CMD_SETDESTINATION.name(), TypedMap.builder().put(PARAM_DESTINATION, (Object)destination).build());
            RFToolsUtilityMessages.INSTANCE.sendToServer((Object)packet);
        } else {
            this.m_6596_();
        }
    }

    public BlockPos getDestination() {
        return this.destination;
    }

    private SpawnerTileEntity getDestinationTE() {
        if (this.destination == null) {
            return null;
        }
        BlockEntity te = this.f_58857_.m_7702_(this.destination);
        if (te instanceof SpawnerTileEntity) {
            return (SpawnerTileEntity)te;
        }
        this.destination = null;
        this.m_6596_();
        return null;
    }

    public void m_142466_(CompoundTag tagCompound) {
        super.m_142466_(tagCompound);
        this.destination = BlockPosTools.read((CompoundTag)tagCompound, (String)"dest");
        this.glowing = tagCompound.m_128471_("glowing");
    }

    public void m_183515_(@Nonnull CompoundTag tagCompound) {
        super.m_183515_(tagCompound);
        BlockPosTools.write((CompoundTag)tagCompound, (String)"dest", (BlockPos)this.destination);
        tagCompound.m_128379_("glowing", this.glowing);
    }

    public void saveClientDataToNBT(CompoundTag tagCompound) {
        BlockPosTools.write((CompoundTag)tagCompound, (String)"dest", (BlockPos)this.destination);
        tagCompound.m_128379_("glowing", this.glowing);
    }

    public void loadClientDataFromNBT(CompoundTag tagCompound) {
        this.destination = BlockPosTools.read((CompoundTag)tagCompound, (String)"dest");
        this.glowing = tagCompound.m_128471_("glowing");
    }
}

