/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.environmental.recipes;

import com.google.gson.JsonObject;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.rftoolsutility.modules.environmental.recipes.SyringeBasedRecipe;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class SyringeRecipeSerializer
extends ForgeRegistryEntry<RecipeSerializer<?>>
implements RecipeSerializer<SyringeBasedRecipe> {
    private final ShapedRecipe.Serializer serializer = new ShapedRecipe.Serializer();

    @Nonnull
    public SyringeBasedRecipe fromJson(@Nonnull ResourceLocation recipeId, @Nonnull JsonObject root) {
        ShapedRecipe shapedRecipe = this.serializer.m_6729_(recipeId, root);
        String mob = root.get("mob").getAsString();
        int syringe = root.get("syringe").getAsInt();
        return new SyringeBasedRecipe(shapedRecipe, new ResourceLocation(mob), syringe);
    }

    @Nullable
    public SyringeBasedRecipe fromNetwork(@Nonnull ResourceLocation recipeId, @Nonnull FriendlyByteBuf buffer) {
        ShapedRecipe shapedRecipe = this.serializer.m_8005_(recipeId, buffer);
        ResourceLocation mobId = buffer.m_130281_();
        int syringeIndex = buffer.readInt();
        return new SyringeBasedRecipe(shapedRecipe, mobId, syringeIndex);
    }

    public void toNetwork(@Nonnull FriendlyByteBuf buffer, @Nonnull SyringeBasedRecipe recipe) {
        this.serializer.m_6178_(buffer, (ShapedRecipe)recipe);
        buffer.m_130085_(recipe.getMobId());
        buffer.writeInt(recipe.getSyringeIndex());
    }
}

