/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.machine;

import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.IContentsListener;
import mekanism.api.RelativeSide;
import mekanism.api.Upgrade;
import mekanism.api.annotations.NonNull;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.math.FloatingLong;
import mekanism.common.base.MekFakePlayer;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.energy.MinerEnergyContainer;
import mekanism.common.capabilities.holder.energy.EnergyContainerHelper;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.capabilities.resolver.BasicCapabilityResolver;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.filter.BaseFilter;
import mekanism.common.content.filter.IFilter;
import mekanism.common.content.miner.MinerFilter;
import mekanism.common.content.miner.ThreadMinerSearch;
import mekanism.common.integration.computer.ComputerException;
import mekanism.common.integration.computer.SpecialComputerMethodWrapper;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import mekanism.common.integration.energy.EnergyCompatUtils;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.SyncableBoolean;
import mekanism.common.inventory.container.sync.SyncableEnum;
import mekanism.common.inventory.container.sync.SyncableInt;
import mekanism.common.inventory.container.sync.SyncableItemStack;
import mekanism.common.inventory.container.sync.SyncableRegistryEntry;
import mekanism.common.inventory.container.sync.list.SyncableFilterList;
import mekanism.common.inventory.container.tile.DigitalMinerConfigContainer;
import mekanism.common.inventory.slot.BasicInventorySlot;
import mekanism.common.inventory.slot.EnergyInventorySlot;
import mekanism.common.lib.chunkloading.IChunkLoader;
import mekanism.common.lib.collection.HashList;
import mekanism.common.lib.inventory.Finder;
import mekanism.common.lib.inventory.TileTransitRequest;
import mekanism.common.lib.inventory.TransitRequest;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.registries.MekanismItems;
import mekanism.common.tags.MekanismTags;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.component.TileComponentChunkLoader;
import mekanism.common.tile.interfaces.IBoundingBlock;
import mekanism.common.tile.interfaces.IHasSortableFilters;
import mekanism.common.tile.interfaces.IHasVisualization;
import mekanism.common.tile.interfaces.ISustainedData;
import mekanism.common.tile.interfaces.ITileFilterHolder;
import mekanism.common.tile.transmitter.TileEntityLogisticalTransporterBase;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import mekanism.common.util.StackUtils;
import mekanism.common.util.UpgradeUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.PathNavigationRegion;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class TileEntityDigitalMiner
extends TileEntityMekanism
implements ISustainedData,
IChunkLoader,
IBoundingBlock,
ITileFilterHolder<MinerFilter<?>>,
IHasSortableFilters,
IHasVisualization {
    public static final int DEFAULT_HEIGHT_RANGE = 60;
    public static final int DEFAULT_RADIUS = 10;
    private Long2ObjectMap<BitSet> oresToMine = Long2ObjectMaps.emptyMap();
    private HashList<MinerFilter<?>> filters = new HashList();
    public ThreadMinerSearch searcher = new ThreadMinerSearch(this);
    private int radius;
    private boolean inverse;
    private boolean inverseRequiresReplacement;
    private Item inverseReplaceTarget = Items.f_41852_;
    private int minY;
    private int maxY = this.minY + 60;
    private boolean doEject = false;
    private boolean doPull = false;
    public ItemStack missingStack = ItemStack.f_41583_;
    private int delay;
    private int delayLength;
    private int cachedToMine;
    private boolean silkTouch;
    private boolean running;
    private int delayTicks;
    private boolean initCalc;
    private int numPowering;
    private boolean clientRendering;
    private final TileComponentChunkLoader<TileEntityDigitalMiner> chunkLoaderComponent;
    @Nullable
    private ChunkPos targetChunk;
    private MinerEnergyContainer energyContainer;
    private List<IInventorySlot> mainSlots;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getEnergyItem"})
    private EnergyInventorySlot energySlot;

    public TileEntityDigitalMiner(BlockPos pos, BlockState state) {
        super(MekanismBlocks.DIGITAL_MINER, pos, state);
        this.delayLength = MekanismConfig.general.minerTicksPerMine.get();
        this.initCalc = false;
        this.chunkLoaderComponent = new TileComponentChunkLoader<TileEntityDigitalMiner>(this);
        this.radius = 10;
        this.addCapabilityResolver(BasicCapabilityResolver.constant(Capabilities.CONFIG_CARD_CAPABILITY, this));
        this.addDisabledCapabilities(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
    }

    @Override
    @Nonnull
    protected IEnergyContainerHolder getInitialEnergyContainers(IContentsListener listener) {
        EnergyContainerHelper builder = EnergyContainerHelper.forSide(this::getDirection);
        this.energyContainer = MinerEnergyContainer.input(this, listener);
        builder.addContainer(this.energyContainer, RelativeSide.LEFT, RelativeSide.RIGHT, RelativeSide.BOTTOM);
        return builder.build();
    }

    @Override
    @Nonnull
    protected IInventorySlotHolder getInitialInventory(IContentsListener listener) {
        this.mainSlots = new ArrayList<IInventorySlot>();
        InventorySlotHelper builder = InventorySlotHelper.forSide(this::getDirection, side -> side == RelativeSide.TOP, side -> side == RelativeSide.BACK);
        BiPredicate<@NonNull ItemStack, @NonNull AutomationType> canInsert = (stack, automationType) -> automationType != AutomationType.EXTERNAL || this.isReplaceTarget(stack.m_41720_());
        BiPredicate<@NonNull ItemStack, @NonNull AutomationType> canExtract = (stack, automationType) -> automationType == AutomationType.MANUAL || !this.isReplaceTarget(stack.m_41720_());
        for (int slotY = 0; slotY < 3; ++slotY) {
            for (int slotX = 0; slotX < 9; ++slotX) {
                BasicInventorySlot slot = BasicInventorySlot.at(canExtract, canInsert, listener, 8 + slotX * 18, 92 + slotY * 18);
                builder.addSlot(slot, RelativeSide.BACK, RelativeSide.TOP);
                this.mainSlots.add(slot);
            }
        }
        this.energySlot = EnergyInventorySlot.fillOrConvert(this.energyContainer, () -> ((TileEntityDigitalMiner)this).m_58904_(), listener, 152, 20);
        builder.addSlot(this.energySlot);
        return builder.build();
    }

    private void closeInvalidScreens() {
        if (this.getActive() && !this.playersUsing.isEmpty()) {
            for (Player player : new ObjectOpenHashSet((Collection)this.playersUsing)) {
                if (!(player.f_36096_ instanceof DigitalMinerConfigContainer)) continue;
                player.m_6915_();
            }
        }
    }

    @Override
    protected void onUpdateClient() {
        super.onUpdateClient();
        this.closeInvalidScreens();
    }

    @Override
    protected void onUpdateServer() {
        super.onUpdateServer();
        this.closeInvalidScreens();
        if (!this.initCalc) {
            if (this.searcher.state == ThreadMinerSearch.State.FINISHED) {
                boolean prevRunning = this.running;
                this.reset();
                this.start();
                this.running = prevRunning;
            }
            this.initCalc = true;
        }
        this.energySlot.fillContainerOrConvert();
        if (MekanismUtils.canFunction(this) && this.running && this.searcher.state == ThreadMinerSearch.State.FINISHED && !this.oresToMine.isEmpty()) {
            FloatingLong energyPerTick = this.energyContainer.getEnergyPerTick();
            if (this.energyContainer.extract(energyPerTick, Action.SIMULATE, AutomationType.INTERNAL).equals(energyPerTick)) {
                this.setActive(true);
                if (this.delay > 0) {
                    --this.delay;
                }
                this.energyContainer.extract(energyPerTick, Action.EXECUTE, AutomationType.INTERNAL);
                if (this.delay == 0) {
                    this.tryMineBlock();
                    this.delay = this.getDelay();
                }
            } else {
                this.setActive(false);
            }
        } else {
            this.setActive(false);
        }
        if (this.doEject && this.delayTicks == 0) {
            Direction oppositeDirection = this.getOppositeDirection();
            BlockEntity ejectInv = WorldUtils.getTileEntity((BlockGetter)this.f_58857_, this.m_58899_().m_7494_().m_5484_(oppositeDirection, 2));
            BlockEntity ejectTile = WorldUtils.getTileEntity((BlockGetter)this.m_58904_(), this.m_58899_().m_7494_().m_142300_(oppositeDirection));
            if (ejectInv != null && ejectTile != null) {
                TileTransitRequest ejectMap = InventoryUtils.getEjectItemMap(ejectTile, oppositeDirection, this.mainSlots);
                if (!ejectMap.isEmpty()) {
                    TransitRequest.TransitResponse response;
                    if (ejectInv instanceof TileEntityLogisticalTransporterBase) {
                        TileEntityLogisticalTransporterBase transporter = (TileEntityLogisticalTransporterBase)ejectInv;
                        response = transporter.getTransmitter().insert(ejectTile, (TransitRequest)ejectMap, null, true, 0);
                    } else {
                        response = ejectMap.addToInventory(ejectInv, oppositeDirection, 0, false);
                    }
                    if (!response.isEmpty()) {
                        response.useAll();
                    }
                }
                this.delayTicks = 10;
            }
        } else if (this.delayTicks > 0) {
            --this.delayTicks;
        }
    }

    public void updateFromSearch(Long2ObjectMap<BitSet> oresToMine, int found) {
        this.oresToMine = oresToMine;
        this.cachedToMine = found;
        this.updateTargetChunk(null);
        this.markForSave();
    }

    public int getDelay() {
        return this.delayLength;
    }

    @ComputerMethod
    public boolean getSilkTouch() {
        return this.silkTouch;
    }

    @ComputerMethod
    public int getRadius() {
        return this.radius;
    }

    @ComputerMethod
    public int getMinY() {
        return this.minY;
    }

    @ComputerMethod
    public int getMaxY() {
        return this.maxY;
    }

    @ComputerMethod(nameOverride="getInverseMode")
    public boolean getInverse() {
        return this.inverse;
    }

    @ComputerMethod(nameOverride="getInverseModeRequiresReplacement")
    public boolean getInverseRequiresReplacement() {
        return this.inverseRequiresReplacement;
    }

    @ComputerMethod(nameOverride="getInverseModeReplaceTarget")
    public Item getInverseReplaceTarget() {
        return this.inverseReplaceTarget;
    }

    private void setSilkTouch(boolean newSilkTouch) {
        boolean changed = this.silkTouch != newSilkTouch;
        this.silkTouch = newSilkTouch;
        if (changed && this.m_58898_() && !this.isRemote()) {
            this.energyContainer.updateMinerEnergyPerTick();
        }
    }

    public void toggleSilkTouch() {
        this.setSilkTouch(!this.getSilkTouch());
        this.markForSave();
    }

    public void toggleInverse() {
        this.inverse = !this.inverse;
        this.markForSave();
    }

    public void toggleInverseRequiresReplacement() {
        this.inverseRequiresReplacement = !this.inverseRequiresReplacement;
        this.markForSave();
    }

    public void setInverseReplaceTarget(Item target) {
        if (target != this.inverseReplaceTarget) {
            this.inverseReplaceTarget = target;
            this.markForSave();
        }
    }

    public void toggleAutoEject() {
        this.doEject = !this.doEject;
        this.markForSave();
    }

    public void toggleAutoPull() {
        this.doPull = !this.doPull;
        this.markForSave();
    }

    public void setRadiusFromPacket(int newRadius) {
        this.setRadius(Math.min(Math.max(0, newRadius), MekanismConfig.general.minerMaxRadius.get()));
        this.sendUpdatePacket();
        this.markForSave();
    }

    private void setRadius(int newRadius) {
        boolean changed = this.radius != newRadius;
        this.radius = newRadius;
        if (changed && this.m_58898_() && !this.isRemote()) {
            this.energyContainer.updateMinerEnergyPerTick();
            this.getChunkLoader().refreshChunkTickets();
        }
    }

    public void setMinYFromPacket(int newMinY) {
        if (this.f_58857_ != null) {
            this.setMinY(Math.min(Math.max(this.f_58857_.m_141937_(), newMinY), this.getMaxY()));
            this.sendUpdatePacket();
            this.markForSave();
        }
    }

    private void setMinY(int newMinY) {
        boolean changed = this.minY != newMinY;
        this.minY = newMinY;
        if (changed && this.m_58898_() && !this.isRemote()) {
            this.energyContainer.updateMinerEnergyPerTick();
        }
    }

    public void setMaxYFromPacket(int newMaxY) {
        if (this.f_58857_ != null) {
            this.setMaxY(Math.max(Math.min(newMaxY, this.f_58857_.m_151558_() - 1), this.getMinY()));
            this.sendUpdatePacket();
            this.markForSave();
        }
    }

    private void setMaxY(int newMaxY) {
        boolean changed = this.maxY != newMaxY;
        this.maxY = newMaxY;
        if (changed && this.m_58898_() && !this.isRemote()) {
            this.energyContainer.updateMinerEnergyPerTick();
        }
    }

    @Override
    public void moveUp(int filterIndex) {
        this.filters.swap(filterIndex, filterIndex - 1);
        this.markForSave();
    }

    @Override
    public void moveDown(int filterIndex) {
        this.filters.swap(filterIndex, filterIndex + 1);
        this.markForSave();
    }

    private void tryMineBlock() {
        long target = this.targetChunk == null ? ChunkPos.f_45577_ : this.targetChunk.m_45588_();
        ObjectIterator it = this.oresToMine.long2ObjectEntrySet().iterator();
        block0: while (it.hasNext()) {
            Long2ObjectMap.Entry entry = (Long2ObjectMap.Entry)it.next();
            long chunk = entry.getLongKey();
            BitSet chunkToMine = (BitSet)entry.getValue();
            ChunkPos currentChunk = null;
            if (target == chunk) {
                currentChunk = this.targetChunk;
            }
            int next = 0;
            while (true) {
                BlockState state;
                BlockPos pos;
                Optional<BlockState> blockState;
                int index;
                if ((index = chunkToMine.nextSetBit(next)) == -1) {
                    it.remove();
                    continue block0;
                }
                if (currentChunk == null) {
                    currentChunk = new ChunkPos(chunk);
                    this.updateTargetChunk(currentChunk);
                    target = chunk;
                }
                if ((blockState = WorldUtils.getBlockState((BlockGetter)this.f_58857_, pos = this.getPosFromIndex(index))).isPresent() && !(state = blockState.get()).m_60795_() && !state.m_204336_(MekanismTags.Blocks.MINER_BLACKLIST)) {
                    MinerFilter<?> matchingFilter = null;
                    for (MinerFilter<?> filter : this.filters) {
                        if (!filter.canFilter(state)) continue;
                        matchingFilter = filter;
                        break;
                    }
                    if (this.inverse == (matchingFilter == null) && this.canMine(state, pos)) {
                        List<ItemStack> drops = this.getDrops(state, pos);
                        if (this.canInsert(drops) && this.setReplace(pos, matchingFilter)) {
                            this.add(drops);
                            this.missingStack = ItemStack.f_41583_;
                            this.f_58857_.m_46796_(2001, pos, Block.m_49956_((BlockState)state));
                            --this.cachedToMine;
                            chunkToMine.clear(index);
                            if (chunkToMine.isEmpty()) {
                                it.remove();
                                this.updateTargetChunk(null);
                            }
                        }
                        return;
                    }
                }
                --this.cachedToMine;
                chunkToMine.clear(index);
                if (chunkToMine.isEmpty()) {
                    it.remove();
                    continue block0;
                }
                next = index + 1;
            }
        }
        this.updateTargetChunk(null);
    }

    private boolean setReplace(BlockPos pos, @Nullable MinerFilter<?> filter) {
        ItemStack stack;
        Item replaceTarget;
        if (this.f_58857_ == null) {
            return false;
        }
        if (filter == null) {
            replaceTarget = this.inverseReplaceTarget;
            stack = this.getReplace(replaceTarget, this::inverseReplaceTargetMatches);
        } else {
            replaceTarget = filter.replaceTarget;
            stack = this.getReplace(replaceTarget, filter::replaceTargetMatches);
        }
        if (stack.m_41619_()) {
            if (replaceTarget == Items.f_41852_ || filter == null && !this.inverseRequiresReplacement || filter != null && !filter.requiresReplacement) {
                this.f_58857_.m_7471_(pos, false);
                this.f_58857_.m_151555_(GameEvent.f_157794_, pos);
                return true;
            }
            this.missingStack = new ItemStack((ItemLike)replaceTarget);
            return false;
        }
        BlockState newState = this.withFakePlayer(fakePlayer -> StackUtils.getStateForPlacement(stack, pos, (Player)fakePlayer));
        if (newState == null || !newState.m_60710_((LevelReader)this.f_58857_, pos)) {
            return false;
        }
        this.f_58857_.m_151555_(GameEvent.f_157794_, pos);
        this.f_58857_.m_46597_(pos, newState);
        this.f_58857_.m_151555_(GameEvent.f_157797_, pos);
        return true;
    }

    private boolean canMine(BlockState state, BlockPos pos) {
        return this.withFakePlayer(dummy -> !MinecraftForge.EVENT_BUS.post((Event)new BlockEvent.BreakEvent(this.f_58857_, pos, state, (Player)dummy)));
    }

    private <R> R withFakePlayer(Function<MekFakePlayer, R> fakePlayerConsumer) {
        return (R)MekFakePlayer.withFakePlayer((ServerLevel)this.f_58857_, this.f_58858_.m_123341_(), this.f_58858_.m_123342_(), this.f_58858_.m_123343_(), dummy -> {
            dummy.setEmulatingUUID(this.getOwnerUUID());
            return fakePlayerConsumer.apply((MekFakePlayer)((Object)dummy));
        });
    }

    private ItemStack getReplace(Item replaceTarget, Predicate<Item> replaceStackMatches) {
        TransitRequest.TransitResponse response;
        TransitRequest request;
        BlockEntity pullInv;
        if (replaceTarget == Items.f_41852_) {
            return ItemStack.f_41583_;
        }
        for (IInventorySlot slot : this.mainSlots) {
            ItemStack slotStack = slot.getStack();
            if (!replaceStackMatches.test(slotStack.m_41720_())) continue;
            MekanismUtils.logMismatchedStackSize(slot.shrinkStack(1, Action.EXECUTE), 1L);
            return StackUtils.size(slotStack, 1);
        }
        if ((replaceTarget == Items.f_42594_ || replaceTarget == Items.f_41905_) && this.upgradeComponent.isUpgradeInstalled(Upgrade.STONE_GENERATOR)) {
            return new ItemStack((ItemLike)replaceTarget);
        }
        if (this.doPull && (pullInv = this.getPullInv()) != null && InventoryUtils.isItemHandler(pullInv, Direction.DOWN) && !(request = TransitRequest.definedItem(pullInv, Direction.DOWN, 1, Finder.item(replaceTarget))).isEmpty() && (response = request.createSimpleResponse()).useAll().m_41619_()) {
            return StackUtils.size(response.getStack(), 1);
        }
        return ItemStack.f_41583_;
    }

    public boolean canInsert(List<ItemStack> toInsert) {
        if (toInsert.isEmpty()) {
            return true;
        }
        int slots = this.mainSlots.size();
        Int2ObjectOpenHashMap cachedStacks = new Int2ObjectOpenHashMap();
        for (ItemStack stackToInsert : toInsert) {
            if (stackToInsert.m_41619_()) continue;
            ItemStack stack = stackToInsert.m_41777_();
            for (int i = 0; i < slots; ++i) {
                IInventorySlot slot = this.mainSlots.get(i);
                boolean wasEmpty = slot.isEmpty();
                if (wasEmpty && cachedStacks.containsKey(i)) {
                    ItemCount cachedItem = (ItemCount)cachedStacks.get(i);
                    if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)cachedItem.stack)) continue;
                    int limit = slot.getLimit(stack);
                    int stackSize = stack.m_41613_();
                    int total = stackSize + cachedItem.count;
                    if (total <= limit) {
                        cachedItem.count = total;
                        stack = ItemStack.f_41583_;
                        break;
                    }
                    int toAdd = total - limit;
                    if (toAdd <= 0) continue;
                    cachedItem.count += toAdd;
                    stack = StackUtils.size(stack, stackSize - toAdd);
                    continue;
                }
                int stackSize = stack.m_41613_();
                stack = slot.insertItem(stack, Action.SIMULATE, AutomationType.INTERNAL);
                int remainderSize = stack.m_41613_();
                if (wasEmpty && remainderSize < stackSize) {
                    cachedStacks.put(i, (Object)new ItemCount(stackToInsert, stackSize - remainderSize));
                }
                if (stack.m_41619_()) break;
            }
            if (stack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    private BlockEntity getPullInv() {
        return WorldUtils.getTileEntity((BlockGetter)this.m_58904_(), this.m_58899_().m_6630_(2));
    }

    private void add(List<ItemStack> stacks) {
        for (ItemStack stack : stacks) {
            IInventorySlot slot;
            Iterator<IInventorySlot> iterator = this.mainSlots.iterator();
            while (iterator.hasNext() && !(stack = (slot = iterator.next()).insertItem(stack, Action.EXECUTE, AutomationType.INTERNAL)).m_41619_()) {
            }
        }
    }

    public void start() {
        if (this.m_58904_() == null) {
            return;
        }
        if (this.searcher.state == ThreadMinerSearch.State.IDLE) {
            BlockPos startingPos = this.getStartingPos();
            this.searcher.setChunkCache(new PathNavigationRegion(this.m_58904_(), startingPos, startingPos.m_142082_(this.getDiameter(), this.getMaxY() - this.getMinY() + 1, this.getDiameter())));
            this.searcher.start();
        }
        this.running = true;
        this.markForSave();
    }

    public void stop() {
        if (this.searcher.state == ThreadMinerSearch.State.SEARCHING) {
            this.searcher.interrupt();
            this.reset();
        } else if (this.searcher.state == ThreadMinerSearch.State.FINISHED) {
            this.running = false;
            this.markForSave();
            this.updateTargetChunk(null);
        }
    }

    public void reset() {
        this.searcher = new ThreadMinerSearch(this);
        this.running = false;
        this.cachedToMine = 0;
        this.oresToMine = Long2ObjectMaps.emptyMap();
        this.missingStack = ItemStack.f_41583_;
        this.setActive(false);
        this.updateTargetChunk(null);
        this.markForSave();
    }

    public boolean isReplaceTarget(Item target) {
        if (this.inverse) {
            return this.inverseReplaceTargetMatches(target);
        }
        for (MinerFilter<?> filter : this.filters) {
            if (!filter.replaceTargetMatches(target)) continue;
            return true;
        }
        return false;
    }

    private boolean inverseReplaceTargetMatches(Item target) {
        return this.inverseReplaceTarget != Items.f_41852_ && this.inverseReplaceTarget == target;
    }

    @Override
    public void m_142466_(@Nonnull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.running = nbt.m_128471_("running");
        this.delay = nbt.m_128451_("delay");
        this.numPowering = nbt.m_128451_("numPowering");
        NBTUtils.setEnumIfPresent(nbt, "state", ThreadMinerSearch.State::byIndexStatic, s -> {
            if (!this.initCalc && s == ThreadMinerSearch.State.SEARCHING) {
                s = ThreadMinerSearch.State.FINISHED;
            }
            this.searcher.state = s;
        });
        this.energyContainer.updateMinerEnergyPerTick();
    }

    @Override
    public void m_142339_(@Nonnull Level world) {
        super.m_142339_(world);
        this.energyContainer.updateMinerEnergyPerTick();
    }

    @Override
    public void m_183515_(@Nonnull CompoundTag nbtTags) {
        super.m_183515_(nbtTags);
        nbtTags.m_128379_("running", this.running);
        nbtTags.m_128405_("delay", this.delay);
        nbtTags.m_128405_("numPowering", this.numPowering);
        NBTUtils.writeEnum(nbtTags, "state", this.searcher.state);
    }

    public int getTotalSize() {
        return this.getDiameter() * this.getDiameter() * (this.getMaxY() - this.getMinY() + 1);
    }

    public int getDiameter() {
        return this.radius * 2 + 1;
    }

    public BlockPos getStartingPos() {
        return new BlockPos(this.m_58899_().m_123341_() - this.radius, this.getMinY(), this.m_58899_().m_123343_() - this.radius);
    }

    private BlockPos getPosFromIndex(int index) {
        int diameter = this.getDiameter();
        BlockPos start = this.getStartingPos();
        return start.m_142082_(index % diameter, index / diameter / diameter, index / diameter % diameter);
    }

    @Override
    public boolean isPowered() {
        return this.redstone || this.numPowering > 0;
    }

    @Nonnull
    public AABB getRenderBoundingBox() {
        if (this.isClientRendering() && this.canDisplayVisuals()) {
            return new AABB((double)(this.f_58858_.m_123341_() - this.radius), (double)this.minY, (double)(this.f_58858_.m_123343_() - this.radius), (double)(this.f_58858_.m_123341_() + this.radius + 1), (double)(this.maxY + 1), (double)(this.f_58858_.m_123343_() + this.radius + 1));
        }
        return super.getRenderBoundingBox();
    }

    @Override
    public boolean isClientRendering() {
        return this.clientRendering;
    }

    @Override
    public void toggleClientRendering() {
        this.clientRendering = !this.clientRendering;
    }

    @Override
    public boolean canDisplayVisuals() {
        return this.getRadius() <= 64;
    }

    @Override
    public void onBoundingBlockPowerChange(BlockPos boundingPos, int oldLevel, int newLevel) {
        if (oldLevel > 0) {
            if (newLevel == 0) {
                --this.numPowering;
            }
        } else if (newLevel > 0) {
            ++this.numPowering;
        }
    }

    @Override
    public int getBoundingComparatorSignal(Vec3i offset) {
        Direction facing = this.getDirection();
        Direction back = facing.m_122424_();
        if (offset.equals((Object)new Vec3i(back.m_122429_(), 1, back.m_122431_()))) {
            return this.getCurrentRedstoneLevel();
        }
        Direction left = MekanismUtils.getLeft(facing);
        if (offset.equals((Object)new Vec3i(left.m_122429_(), 0, left.m_122431_()))) {
            return this.getCurrentRedstoneLevel();
        }
        Direction right = left.m_122424_();
        if (offset.equals((Object)new Vec3i(right.m_122429_(), 0, right.m_122431_()))) {
            return this.getCurrentRedstoneLevel();
        }
        return 0;
    }

    @Override
    protected void notifyComparatorChange() {
        super.notifyComparatorChange();
        Direction facing = this.getDirection();
        Direction left = MekanismUtils.getLeft(facing);
        this.f_58857_.m_46717_(this.f_58858_.m_142300_(left), (Block)MekanismBlocks.BOUNDING_BLOCK.getBlock());
        this.f_58857_.m_46717_(this.f_58858_.m_142300_(left.m_122424_()), (Block)MekanismBlocks.BOUNDING_BLOCK.getBlock());
        this.f_58857_.m_46717_(this.f_58858_.m_142300_(facing.m_122424_()).m_7494_(), (Block)MekanismBlocks.BOUNDING_BLOCK.getBlock());
    }

    @Override
    public void configurationDataSet() {
        super.configurationDataSet();
        if (this.isRunning()) {
            this.stop();
            this.reset();
            this.start();
        }
    }

    @Override
    public void writeSustainedData(CompoundTag dataMap) {
        dataMap.m_128405_("radius", this.getRadius());
        dataMap.m_128405_("min", this.getMinY());
        dataMap.m_128405_("max", this.getMaxY());
        dataMap.m_128379_("eject", this.doEject);
        dataMap.m_128379_("pull", this.doPull);
        dataMap.m_128379_("silkTouch", this.getSilkTouch());
        dataMap.m_128379_("inverse", this.inverse);
        if (this.inverseReplaceTarget != Items.f_41852_) {
            NBTUtils.writeRegistryEntry(dataMap, "replaceStack", this.inverseReplaceTarget);
        }
        dataMap.m_128379_("inverseReplace", this.inverseRequiresReplacement);
        if (!this.filters.isEmpty()) {
            ListTag filterTags = new ListTag();
            for (MinerFilter<?> filter : this.filters) {
                filterTags.add((Object)filter.write(new CompoundTag()));
            }
            dataMap.m_128365_("filters", (Tag)filterTags);
        }
    }

    @Override
    public void readSustainedData(CompoundTag dataMap) {
        this.setRadius(Math.min(dataMap.m_128451_("radius"), MekanismConfig.general.minerMaxRadius.get()));
        NBTUtils.setIntIfPresent(dataMap, "min", this::setMinY);
        NBTUtils.setIntIfPresent(dataMap, "max", this::setMaxY);
        NBTUtils.setBooleanIfPresent(dataMap, "eject", eject -> {
            this.doEject = eject;
        });
        NBTUtils.setBooleanIfPresent(dataMap, "pull", pull -> {
            this.doPull = pull;
        });
        NBTUtils.setBooleanIfPresent(dataMap, "silkTouch", this::setSilkTouch);
        NBTUtils.setBooleanIfPresent(dataMap, "inverse", inverse -> {
            this.inverse = inverse;
        });
        this.inverseReplaceTarget = NBTUtils.readRegistryEntry(dataMap, "replaceStack", ForgeRegistries.ITEMS, Items.f_41852_);
        NBTUtils.setBooleanIfPresent(dataMap, "inverseReplace", requiresReplace -> {
            this.inverseRequiresReplacement = requiresReplace;
        });
        this.filters.clear();
        NBTUtils.setListIfPresent(dataMap, "filters", 10, tagList -> {
            int size = tagList.size();
            for (int i = 0; i < size; ++i) {
                IFilter<?> filter = BaseFilter.readFromNBT(tagList.m_128728_(i));
                if (!(filter instanceof MinerFilter)) continue;
                MinerFilter minerFilter = (MinerFilter)filter;
                this.filters.add(minerFilter);
            }
        });
    }

    @Override
    public Map<String, String> getTileDataRemap() {
        Object2ObjectOpenHashMap remap = new Object2ObjectOpenHashMap();
        remap.put("radius", "radius");
        remap.put("min", "min");
        remap.put("max", "max");
        remap.put("eject", "eject");
        remap.put("pull", "pull");
        remap.put("silkTouch", "silkTouch");
        remap.put("inverse", "inverse");
        remap.put("replaceStack", "replaceStack");
        remap.put("inverseReplace", "inverseReplace");
        remap.put("filters", "filters");
        return remap;
    }

    @Override
    public void recalculateUpgrades(Upgrade upgrade) {
        super.recalculateUpgrades(upgrade);
        if (upgrade == Upgrade.SPEED) {
            this.delayLength = MekanismUtils.getTicks(this, MekanismConfig.general.minerTicksPerMine.get());
        }
    }

    @Override
    public List<Component> getInfo(Upgrade upgrade) {
        return UpgradeUtils.getMultScaledInfo(this, upgrade);
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getOffsetCapabilityIfEnabled(@Nonnull Capability<T> capability, Direction side, @Nonnull Vec3i offset) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemHandlerManager.resolve(capability, side);
        }
        return this.getCapability(capability, side);
    }

    @Override
    public boolean isOffsetCapabilityDisabled(@Nonnull Capability<?> capability, Direction side, @Nonnull Vec3i offset) {
        if (!capability.isRegistered()) {
            return true;
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.notItemPort(side, offset);
        }
        if (EnergyCompatUtils.isEnergyCapability(capability)) {
            return this.notEnergyPort(side, offset);
        }
        if (this.canEverResolve(capability) && IBoundingBlock.super.isOffsetCapabilityDisabled(capability, side, offset)) {
            return this.notItemPort(side, offset) && this.notEnergyPort(side, offset);
        }
        return false;
    }

    private boolean notItemPort(Direction side, Vec3i offset) {
        if (offset.equals((Object)new Vec3i(0, 1, 0))) {
            return side != Direction.UP;
        }
        Direction back = this.getOppositeDirection();
        if (offset.equals((Object)new Vec3i(back.m_122429_(), 1, back.m_122431_()))) {
            return side != back;
        }
        return true;
    }

    private boolean notEnergyPort(Direction side, Vec3i offset) {
        if (offset.equals((Object)Vec3i.f_123288_)) {
            return side != Direction.DOWN;
        }
        Direction left = this.getLeftSide();
        if (offset.equals((Object)new Vec3i(left.m_122429_(), 0, left.m_122431_()))) {
            return side != left;
        }
        Direction right = left.m_122424_();
        if (offset.equals((Object)new Vec3i(right.m_122429_(), 0, right.m_122431_()))) {
            return side != right;
        }
        return true;
    }

    public TileComponentChunkLoader<TileEntityDigitalMiner> getChunkLoader() {
        return this.chunkLoaderComponent;
    }

    private void updateTargetChunk(@Nullable ChunkPos target) {
        if (!Objects.equals(this.targetChunk, target)) {
            this.targetChunk = target;
            this.getChunkLoader().refreshChunkTickets();
        }
    }

    @Override
    public Set<ChunkPos> getChunkSet() {
        ChunkPos minerChunk = new ChunkPos(this.f_58858_);
        if (this.targetChunk != null && this.f_58858_.m_123341_() - this.radius >> 4 <= this.targetChunk.f_45578_ && this.targetChunk.f_45578_ <= this.f_58858_.m_123341_() + this.radius >> 4 && this.f_58858_.m_123343_() - this.radius >> 4 <= this.targetChunk.f_45579_ && this.targetChunk.f_45579_ <= this.f_58858_.m_123343_() + this.radius >> 4) {
            ObjectArraySet chunks = new ObjectArraySet(2);
            chunks.add(minerChunk);
            chunks.add(this.targetChunk);
            return chunks;
        }
        return Collections.singleton(minerChunk);
    }

    @Override
    @ComputerMethod
    public HashList<MinerFilter<?>> getFilters() {
        return this.filters;
    }

    public MinerEnergyContainer getEnergyContainer() {
        return this.energyContainer;
    }

    @ComputerMethod
    public int getToMine() {
        return !this.isRemote() && this.searcher.state == ThreadMinerSearch.State.SEARCHING ? this.searcher.found : this.cachedToMine;
    }

    @ComputerMethod
    public boolean isRunning() {
        return this.running;
    }

    @ComputerMethod(nameOverride="getAutoEject")
    public boolean getDoEject() {
        return this.doEject;
    }

    @ComputerMethod(nameOverride="getAutoPull")
    public boolean getDoPull() {
        return this.doPull;
    }

    @Override
    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        this.addConfigContainerTrackers(container);
        container.track(SyncableBoolean.create(this::getDoEject, value -> {
            this.doEject = value;
        }));
        container.track(SyncableBoolean.create(this::getDoPull, value -> {
            this.doPull = value;
        }));
        container.track(SyncableBoolean.create(this::isRunning, value -> {
            this.running = value;
        }));
        container.track(SyncableBoolean.create(this::getSilkTouch, this::setSilkTouch));
        container.track(SyncableEnum.create(ThreadMinerSearch.State::byIndexStatic, ThreadMinerSearch.State.IDLE, () -> this.searcher.state, value -> {
            this.searcher.state = value;
        }));
        container.track(SyncableInt.create(this::getToMine, value -> {
            this.cachedToMine = value;
        }));
        container.track(SyncableItemStack.create(() -> this.missingStack, value -> {
            this.missingStack = value;
        }));
    }

    public void addConfigContainerTrackers(MekanismContainer container) {
        container.track(SyncableInt.create(this::getRadius, this::setRadius));
        container.track(SyncableInt.create(this::getMinY, this::setMinY));
        container.track(SyncableInt.create(this::getMaxY, this::setMaxY));
        container.track(SyncableBoolean.create(this::getInverse, value -> {
            this.inverse = value;
        }));
        container.track(SyncableBoolean.create(this::getInverseRequiresReplacement, value -> {
            this.inverseRequiresReplacement = value;
        }));
        container.track(SyncableRegistryEntry.create(this::getInverseReplaceTarget, value -> {
            this.inverseReplaceTarget = value;
        }));
        container.track(SyncableFilterList.create(this::getFilters, value -> {
            HashList filters;
            this.filters = value instanceof HashList ? (filters = (HashList)value) : new HashList(value);
        }));
    }

    @Override
    @Nonnull
    public CompoundTag getReducedUpdateTag() {
        CompoundTag updateTag = super.getReducedUpdateTag();
        updateTag.m_128405_("radius", this.getRadius());
        updateTag.m_128405_("min", this.getMinY());
        updateTag.m_128405_("max", this.getMaxY());
        return updateTag;
    }

    @Override
    public void handleUpdateTag(@Nonnull CompoundTag tag) {
        super.handleUpdateTag(tag);
        NBTUtils.setIntIfPresent(tag, "radius", this::setRadius);
        NBTUtils.setIntIfPresent(tag, "min", this::setMinY);
        NBTUtils.setIntIfPresent(tag, "max", this::setMaxY);
    }

    private List<ItemStack> getDrops(BlockState state, BlockPos pos) {
        if (state.m_60795_()) {
            return Collections.emptyList();
        }
        ItemStack stack = MekanismItems.ATOMIC_DISASSEMBLER.getItemStack();
        if (this.getSilkTouch()) {
            stack.m_41663_(Enchantments.f_44985_, 1);
        }
        return this.withFakePlayer(fakePlayer -> state.m_60724_(new LootContext.Builder((ServerLevel)this.getWorldNN()).m_78977_(this.getWorldNN().f_46441_).m_78972_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)pos)).m_78972_(LootContextParams.f_81463_, (Object)stack).m_78984_(LootContextParams.f_81455_, (Object)fakePlayer).m_78984_(LootContextParams.f_81462_, (Object)WorldUtils.getTileEntity((BlockGetter)this.getWorldNN(), pos))));
    }

    @ComputerMethod
    private FloatingLong getEnergyUsage() {
        return this.getActive() ? this.energyContainer.getEnergyPerTick() : FloatingLong.ZERO;
    }

    @ComputerMethod
    private int getSlotCount() {
        return this.mainSlots.size();
    }

    @ComputerMethod
    private ItemStack getItemInSlot(int slot) throws ComputerException {
        int slots = this.getSlotCount();
        if (slot < 0 || slot >= slots) {
            throw new ComputerException("Slot: '%d' is out of bounds, as this digital miner only has '%d' slots (zero indexed).", slot, slots);
        }
        return this.mainSlots.get(slot).getStack();
    }

    @ComputerMethod
    private ThreadMinerSearch.State getState() {
        return this.searcher.state;
    }

    @ComputerMethod
    private void setAutoEject(boolean eject) throws ComputerException {
        this.validateSecurityIsPublic();
        if (this.doEject != eject) {
            this.toggleAutoEject();
        }
    }

    @ComputerMethod
    private void setAutoPull(boolean pull) throws ComputerException {
        this.validateSecurityIsPublic();
        if (this.doPull != pull) {
            this.toggleAutoPull();
        }
    }

    @ComputerMethod(nameOverride="setSilkTouch")
    private void computerSetSilkTouch(boolean silk) throws ComputerException {
        this.validateSecurityIsPublic();
        this.setSilkTouch(silk);
    }

    @ComputerMethod(nameOverride="start")
    private void computerStart() throws ComputerException {
        this.validateSecurityIsPublic();
        this.start();
    }

    @ComputerMethod(nameOverride="stop")
    private void computerStop() throws ComputerException {
        this.validateSecurityIsPublic();
        this.stop();
    }

    @ComputerMethod(nameOverride="reset")
    private void computerReset() throws ComputerException {
        this.validateSecurityIsPublic();
        this.reset();
    }

    @ComputerMethod
    private int getMaxRadius() {
        return MekanismConfig.general.minerMaxRadius.get();
    }

    private void validateCanChangeConfiguration() throws ComputerException {
        this.validateSecurityIsPublic();
        if (this.searcher.state != ThreadMinerSearch.State.IDLE) {
            throw new ComputerException("Miner must be stopped and reset before its targeting configuration is changed.");
        }
    }

    @ComputerMethod(nameOverride="setRadius")
    private void computerSetRadius(int radius) throws ComputerException {
        this.validateCanChangeConfiguration();
        if (radius < 0 || radius > MekanismConfig.general.minerMaxRadius.get()) {
            throw new ComputerException("Radius '%d' is out of range must be between 0 and %d. (Inclusive)", radius, MekanismConfig.general.minerMaxRadius.get());
        }
        this.setRadiusFromPacket(radius);
    }

    @ComputerMethod(nameOverride="setMinY")
    private void computerSetMinY(int minY) throws ComputerException {
        this.validateCanChangeConfiguration();
        if (this.f_58857_ != null) {
            int min = this.f_58857_.m_141937_();
            if (minY < min || minY > this.getMaxY()) {
                throw new ComputerException("Min Y '%d' is out of range must be between %d and %d. (Inclusive)", minY, min, this.getMaxY());
            }
            this.setMinYFromPacket(minY);
        }
    }

    @ComputerMethod(nameOverride="setMaxY")
    private void computerSetMaxY(int maxY) throws ComputerException {
        this.validateCanChangeConfiguration();
        if (this.f_58857_ != null) {
            int max = this.f_58857_.m_151558_() - 1;
            if (maxY < this.getMinY() || maxY > max) {
                throw new ComputerException("Max Y '%d' is out of range must be between %d and %d. (Inclusive)", maxY, this.getMinY(), max);
            }
            this.setMaxYFromPacket(maxY);
        }
    }

    @ComputerMethod
    private void setInverseMode(boolean enabled) throws ComputerException {
        this.validateCanChangeConfiguration();
        if (this.inverse != enabled) {
            this.toggleInverse();
        }
    }

    @ComputerMethod
    private void setInverseModeRequiresReplacement(boolean requiresReplacement) throws ComputerException {
        this.validateCanChangeConfiguration();
        if (this.inverseRequiresReplacement != requiresReplacement) {
            this.toggleInverseRequiresReplacement();
        }
    }

    @ComputerMethod
    private void setInverseModeReplaceTarget(Item target) throws ComputerException {
        this.validateCanChangeConfiguration();
        this.setInverseReplaceTarget(target);
    }

    @ComputerMethod
    private void clearInverseModeReplaceTarget() throws ComputerException {
        this.setInverseModeReplaceTarget(Items.f_41852_);
    }

    @ComputerMethod
    private boolean addFilter(MinerFilter<?> filter) throws ComputerException {
        this.validateCanChangeConfiguration();
        return this.filters.add(filter);
    }

    @ComputerMethod
    private boolean removeFilter(MinerFilter<?> filter) throws ComputerException {
        this.validateCanChangeConfiguration();
        return this.filters.remove(filter);
    }

    private static class ItemCount {
        private final ItemStack stack;
        private int count;

        public ItemCount(ItemStack stack, int count) {
            this.stack = stack;
            this.count = count;
        }
    }
}

