/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network.to_server;

import mekanism.common.content.filter.BaseFilter;
import mekanism.common.content.filter.IFilter;
import mekanism.common.content.miner.MinerFilter;
import mekanism.common.content.oredictionificator.OredictionificatorItemFilter;
import mekanism.common.content.qio.filter.QIOFilter;
import mekanism.common.content.transporter.SorterFilter;
import mekanism.common.lib.collection.HashList;
import mekanism.common.network.IMekanismPacket;
import mekanism.common.tile.TileEntityLogisticalSorter;
import mekanism.common.tile.machine.TileEntityDigitalMiner;
import mekanism.common.tile.machine.TileEntityOredictionificator;
import mekanism.common.tile.qio.TileEntityQIOFilterHandler;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class PacketEditFilter
implements IMekanismPacket {
    private final IFilter<?> filter;
    private final IFilter<?> edited;
    private final boolean delete;
    private final BlockPos pos;

    public PacketEditFilter(BlockPos pos, boolean deletion, IFilter<?> filter, IFilter<?> edited) {
        this.pos = pos;
        this.delete = deletion;
        this.filter = filter;
        this.edited = edited;
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        ServerPlayer player = context.getSender();
        if (player == null) {
            return;
        }
        BlockEntity tile = WorldUtils.getTileEntity((BlockGetter)player.f_19853_, this.pos);
        if (tile != null) {
            TileEntityQIOFilterHandler qioFilterHandler;
            HashList<QIOFilter<?>> filters;
            int index;
            if (this.filter instanceof SorterFilter && tile instanceof TileEntityLogisticalSorter) {
                TileEntityLogisticalSorter sorter = (TileEntityLogisticalSorter)tile;
                HashList<SorterFilter<?>> filters2 = sorter.getFilters();
                int index2 = filters2.indexOf(this.filter);
                if (index2 != -1) {
                    filters2.remove(index2);
                    if (!this.delete) {
                        filters2.add(index2, (SorterFilter)this.edited);
                    }
                }
            } else if (this.filter instanceof MinerFilter && tile instanceof TileEntityDigitalMiner) {
                TileEntityDigitalMiner miner = (TileEntityDigitalMiner)tile;
                HashList<MinerFilter<?>> filters3 = miner.getFilters();
                int index3 = filters3.indexOf(this.filter);
                if (index3 != -1) {
                    filters3.remove(index3);
                    if (!this.delete) {
                        filters3.add(index3, (MinerFilter)this.edited);
                    }
                }
            } else if (this.filter instanceof OredictionificatorItemFilter && tile instanceof TileEntityOredictionificator) {
                TileEntityOredictionificator oredictionificator = (TileEntityOredictionificator)tile;
                HashList<OredictionificatorItemFilter> filters4 = oredictionificator.getFilters();
                int index4 = filters4.indexOf(this.filter);
                if (index4 != -1) {
                    filters4.remove(index4);
                    if (!this.delete) {
                        filters4.add(index4, (OredictionificatorItemFilter)this.edited);
                    }
                }
            } else if (this.filter instanceof QIOFilter && tile instanceof TileEntityQIOFilterHandler && (index = (filters = (qioFilterHandler = (TileEntityQIOFilterHandler)tile).getFilters()).indexOf(this.filter)) != -1) {
                filters.remove(index);
                if (!this.delete) {
                    filters.add(index, (QIOFilter)this.edited);
                }
            }
            tile.m_6596_();
        }
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.pos);
        buffer.writeBoolean(this.delete);
        this.filter.write(buffer);
        if (!this.delete) {
            this.edited.write(buffer);
        }
    }

    public static PacketEditFilter decode(FriendlyByteBuf buffer) {
        BlockPos pos = buffer.m_130135_();
        boolean delete = buffer.readBoolean();
        IFilter<?> filter = BaseFilter.readFromPacket(buffer);
        IFilter<?> edited = null;
        if (!delete) {
            edited = BaseFilter.readFromPacket(buffer);
        }
        return new PacketEditFilter(pos, delete, filter, edited);
    }
}

