/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item.block;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.Upgrade;
import mekanism.api.math.FloatingLong;
import mekanism.api.math.FloatingLongSupplier;
import mekanism.api.text.EnumColor;
import mekanism.api.text.TextComponentUtil;
import mekanism.api.tier.ITier;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.attribute.AttributeEnergy;
import mekanism.common.block.attribute.AttributeUpgradeSupport;
import mekanism.common.block.attribute.Attributes;
import mekanism.common.capabilities.ItemCapabilityWrapper;
import mekanism.common.capabilities.energy.BasicEnergyContainer;
import mekanism.common.capabilities.energy.item.RateLimitEnergyHandler;
import mekanism.common.capabilities.security.item.ItemStackSecurityObject;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class ItemBlockMekanism<BLOCK extends Block>
extends BlockItem {
    @Nonnull
    private final BLOCK block;

    public ItemBlockMekanism(@Nonnull BLOCK block, Item.Properties properties) {
        super(block, properties);
        this.block = block;
    }

    @Nonnull
    public BLOCK m_40614_() {
        return this.block;
    }

    public ITier getTier() {
        return null;
    }

    public EnumColor getTextColor(ItemStack stack) {
        ITier tier = this.getTier();
        return tier == null ? null : tier.getBaseTier().getTextColor();
    }

    @Nonnull
    public Component m_7626_(@Nonnull ItemStack stack) {
        EnumColor color = this.getTextColor(stack);
        if (color == null) {
            return super.m_7626_(stack);
        }
        return TextComponentUtil.build(color, super.m_7626_(stack));
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        if (this.exposesEnergyCap(oldStack) && this.exposesEnergyCap(newStack)) {
            return oldStack.m_41720_() != newStack.m_41720_();
        }
        return super.shouldCauseReequipAnimation(oldStack, newStack, slotChanged);
    }

    public boolean shouldCauseBlockBreakReset(ItemStack oldStack, ItemStack newStack) {
        if (this.exposesEnergyCap(oldStack) && this.exposesEnergyCap(newStack)) {
            return oldStack.m_41720_() != newStack.m_41720_();
        }
        return super.shouldCauseBlockBreakReset(oldStack, newStack);
    }

    protected void gatherCapabilities(List<ItemCapabilityWrapper.ItemCapability> capabilities, ItemStack stack, CompoundTag nbt) {
        if (Attribute.has(this.block, Attributes.AttributeSecurity.class)) {
            capabilities.add(new ItemStackSecurityObject());
        }
        if (this.exposesEnergyCap(stack)) {
            AttributeEnergy attributeEnergy = Attribute.get(this.block, AttributeEnergy.class);
            AttributeUpgradeSupport upgradeSupport = Attribute.get(this.block, AttributeUpgradeSupport.class);
            FloatingLongSupplier maxEnergy = upgradeSupport != null && upgradeSupport.supportedUpgrades().contains(Upgrade.ENERGY) ? new UpgradeBasedFloatingLongCache(stack, attributeEnergy::getStorage) : attributeEnergy::getStorage;
            capabilities.add(RateLimitEnergyHandler.create(maxEnergy, BasicEnergyContainer.manualOnly, BasicEnergyContainer.alwaysTrue));
        }
    }

    protected boolean exposesEnergyCap(ItemStack stack) {
        return Attribute.has(this.block, AttributeEnergy.class) && stack.m_41741_() == 1;
    }

    public final ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag nbt) {
        ArrayList<ItemCapabilityWrapper.ItemCapability> capabilities = new ArrayList<ItemCapabilityWrapper.ItemCapability>();
        this.gatherCapabilities(capabilities, stack, nbt);
        if (capabilities.isEmpty()) {
            return super.initCapabilities(stack, nbt);
        }
        return new ItemCapabilityWrapper(stack, (ItemCapabilityWrapper.ItemCapability[])capabilities.toArray(ItemCapabilityWrapper.ItemCapability[]::new));
    }

    private static class UpgradeBasedFloatingLongCache
    implements FloatingLongSupplier {
        private final ItemStack stack;
        private final FloatingLongSupplier baseStorage;
        @Nullable
        private CompoundTag lastNBT;
        private FloatingLong value;

        private UpgradeBasedFloatingLongCache(ItemStack stack, FloatingLongSupplier baseStorage) {
            this.stack = stack;
            this.lastNBT = ItemDataUtils.hasData(stack, "componentUpgrade", 10) ? ItemDataUtils.getCompound(stack, "componentUpgrade").m_6426_() : null;
            this.baseStorage = baseStorage;
            this.value = MekanismUtils.getMaxEnergy(this.stack, this.baseStorage.get());
        }

        @Override
        @Nonnull
        public FloatingLong get() {
            if (ItemDataUtils.hasData(this.stack, "componentUpgrade", 10)) {
                CompoundTag upgrades = ItemDataUtils.getCompound(this.stack, "componentUpgrade");
                if (this.lastNBT == null || !this.lastNBT.equals((Object)upgrades)) {
                    this.lastNBT = upgrades.m_6426_();
                    this.value = MekanismUtils.getMaxEnergy(this.stack, this.baseStorage.get());
                }
            } else if (this.lastNBT != null) {
                this.lastNBT = null;
                this.value = MekanismUtils.getMaxEnergy(this.stack, this.baseStorage.get());
            }
            return this.value;
        }
    }
}

