/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.gear.mekatool;

import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.gear.ICustomModule;
import mekanism.api.gear.IModule;
import mekanism.api.gear.config.IModuleConfigItem;
import mekanism.api.gear.config.ModuleConfigItemCreator;
import mekanism.api.gear.config.ModuleEnumData;
import mekanism.api.text.EnumColor;
import mekanism.api.text.IHasTextComponent;
import mekanism.api.text.TextComponentUtil;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.block.BlockBounding;
import mekanism.common.config.MekanismConfig;
import mekanism.common.network.to_client.PacketLightningRender;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

@ParametersAreNonnullByDefault
public class ModuleVeinMiningUnit
implements ICustomModule<ModuleVeinMiningUnit> {
    private IModuleConfigItem<Boolean> extendedMode;
    private IModuleConfigItem<ExcavationRange> excavationRange;

    @Override
    public void init(IModule<ModuleVeinMiningUnit> module, ModuleConfigItemCreator configItemCreator) {
        this.extendedMode = configItemCreator.createDisableableConfigItem("extended_mode", MekanismLang.MODULE_EXTENDED_MODE, false, MekanismConfig.gear.mekaToolExtendedMining);
        this.excavationRange = configItemCreator.createConfigItem("excavation_range", MekanismLang.MODULE_EXCAVATION_RANGE, new ModuleEnumData<ExcavationRange>(ExcavationRange.class, module.getInstalledCount() + 1, ExcavationRange.LOW));
    }

    public boolean isExtended() {
        return this.extendedMode.get();
    }

    public int getExcavationRange() {
        return this.excavationRange.get().getRange();
    }

    public static boolean canVeinBlock(BlockState state) {
        return !(state.m_60734_() instanceof BlockBounding);
    }

    public static Object2IntMap<BlockPos> findPositions(Level world, Map<BlockPos, BlockState> initial, int extendedRange, Object2BooleanMap<Block> oreTracker) {
        Object2IntLinkedOpenHashMap found = new Object2IntLinkedOpenHashMap();
        int maxVein = MekanismConfig.gear.disassemblerMiningCount.get();
        int maxCount = initial.size() + maxVein * oreTracker.size();
        LinkedHashMap<BlockPos, BlockState> frontier = new LinkedHashMap<BlockPos, BlockState>(initial);
        TraversalDistance dist = new TraversalDistance(frontier.size());
        while (!frontier.isEmpty()) {
            Iterator iterator = frontier.entrySet().iterator();
            Map.Entry blockEntry = iterator.next();
            iterator.remove();
            BlockPos blockPos = (BlockPos)blockEntry.getKey();
            found.put((Object)blockPos, dist.getDistance());
            if (found.size() >= maxCount) break;
            Block block = ((BlockState)blockEntry.getValue()).m_60734_();
            boolean isOre = oreTracker.getBoolean((Object)block);
            if (isOre || extendedRange > dist.getDistance()) {
                for (BlockPos nextPos : BlockPos.m_121940_((BlockPos)blockPos.m_142082_(-1, -1, -1), (BlockPos)blockPos.m_142082_(1, 1, 1))) {
                    Optional<BlockState> nextState;
                    if (found.containsKey((Object)nextPos) || frontier.containsKey(nextPos) || !(nextState = WorldUtils.getBlockState((BlockGetter)world, nextPos)).isPresent() || !nextState.get().m_60713_(block)) continue;
                    frontier.put(nextPos.m_7949_(), nextState.get());
                    Mekanism.packetHandler().sendToAllTracking(new PacketLightningRender(PacketLightningRender.LightningPreset.TOOL_AOE, Objects.hash(blockPos, nextPos), Vec3.m_82512_((Vec3i)blockPos), Vec3.m_82512_((Vec3i)nextPos), 10), world, blockPos);
                }
            }
            dist.updateDistance(found.size(), frontier.size());
        }
        return found;
    }

    @Override
    public void addHUDStrings(IModule<ModuleVeinMiningUnit> module, Player player, Consumer<Component> hudStringAdder) {
        if (module.isEnabled() && MekanismConfig.gear.mekaToolExtendedMining.get()) {
            hudStringAdder.accept((Component)MekanismLang.MODULE_EXTENDED_ENABLED.translateColored(EnumColor.DARK_GRAY, this.isExtended() ? EnumColor.BRIGHT_GREEN : EnumColor.DARK_RED, this.isExtended() ? MekanismLang.MODULE_ENABLED_LOWER : MekanismLang.MODULE_DISABLED_LOWER));
        }
    }

    public static enum ExcavationRange implements IHasTextComponent
    {
        OFF(0),
        LOW(2),
        MED(4),
        HIGH(6),
        EXTREME(8);

        private final int range;
        private final Component label;

        private ExcavationRange(int range) {
            this.range = range;
            this.label = TextComponentUtil.getString(Integer.toString(range));
        }

        @Override
        public Component getTextComponent() {
            return this.label;
        }

        public int getRange() {
            return this.range;
        }
    }

    private static class TraversalDistance {
        private int distance = 0;
        private int next;

        public TraversalDistance(int next) {
            this.next = next;
        }

        public void updateDistance(int found, int frontierSize) {
            if (found == this.next) {
                ++this.distance;
                this.next += frontierSize;
            }
        }

        public int getDistance() {
            return this.distance;
        }
    }
}

