/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.capabilities.fluid.item;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.IntSupplier;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.AutomationType;
import mekanism.api.annotations.NonNull;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.common.capabilities.fluid.BasicFluidTank;
import mekanism.common.capabilities.fluid.item.ItemStackMekanismFluidHandler;
import mekanism.common.capabilities.fluid.item.RateLimitFluidHandler;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.TriPredicate;
import net.minecraftforge.fluids.FluidStack;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class RateLimitMultiTankFluidHandler
extends ItemStackMekanismFluidHandler {
    private final List<IExtendedFluidTank> tanks;

    public static RateLimitMultiTankFluidHandler create(@Nonnull Collection<FluidTankSpec> fluidTanks) {
        return new RateLimitMultiTankFluidHandler(fluidTanks);
    }

    private RateLimitMultiTankFluidHandler(@Nonnull Collection<FluidTankSpec> fluidTanks) {
        ArrayList<RateLimitFluidHandler.RateLimitFluidTank> tankProviders = new ArrayList<RateLimitFluidHandler.RateLimitFluidTank>();
        for (FluidTankSpec spec : fluidTanks) {
            tankProviders.add(new RateLimitFluidHandler.RateLimitFluidTank(spec.rate, spec.capacity, spec.canExtract, (fluid, automationType) -> spec.canInsert.test(fluid, (Object)automationType, (Object)this.getStack()), spec.isValid, this));
        }
        this.tanks = Collections.unmodifiableList(tankProviders);
    }

    @Override
    protected List<IExtendedFluidTank> getInitialTanks() {
        return this.tanks;
    }

    public static class FluidTankSpec {
        private static final TriPredicate<@NonNull FluidStack, @NonNull AutomationType, @NonNull ItemStack> alwaysTrue = (gas, automationType, stack) -> true;
        final IntSupplier rate;
        final IntSupplier capacity;
        final Predicate<@NonNull FluidStack> isValid;
        final BiPredicate<@NonNull FluidStack, @NonNull AutomationType> canExtract;
        final TriPredicate<@NonNull FluidStack, @NonNull AutomationType, @NonNull ItemStack> canInsert;

        public FluidTankSpec(IntSupplier rate, IntSupplier capacity, BiPredicate<@NonNull FluidStack, @NonNull AutomationType> canExtract, TriPredicate<@NonNull FluidStack, @NonNull AutomationType, @NonNull ItemStack> canInsert, Predicate<@NonNull FluidStack> isValid) {
            this.rate = rate;
            this.capacity = capacity;
            this.isValid = isValid;
            this.canExtract = canExtract;
            this.canInsert = canInsert;
        }

        public static FluidTankSpec create(IntSupplier rate, IntSupplier capacity) {
            return new FluidTankSpec(rate, capacity, BasicFluidTank.alwaysTrueBi, alwaysTrue, BasicFluidTank.alwaysTrue);
        }

        public static FluidTankSpec createFillOnly(IntSupplier rate, IntSupplier capacity, Predicate<@NonNull FluidStack> isValid) {
            return FluidTankSpec.createFillOnly(rate, capacity, alwaysTrue, isValid);
        }

        public static FluidTankSpec createFillOnly(IntSupplier rate, IntSupplier capacity, TriPredicate<@NonNull FluidStack, @NonNull AutomationType, @NonNull ItemStack> canInsert, Predicate<@NonNull FluidStack> isValid) {
            return new FluidTankSpec(rate, capacity, BasicFluidTank.notExternal, canInsert, isValid);
        }

        public boolean isValid(@NonNull FluidStack gas) {
            return this.isValid.test(gas);
        }
    }
}

