/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.item.block;

import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import javax.annotation.Nonnull;
import mekanism.client.model.ModelFluidTank;
import mekanism.client.render.FluidRenderMap;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.render.ModelRenderer;
import mekanism.client.render.RenderResizableCuboid;
import mekanism.client.render.item.MekanismISTER;
import mekanism.common.item.block.machine.ItemBlockFluidTank;
import mekanism.common.tier.FluidTankTier;
import mekanism.common.util.StorageUtils;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class RenderFluidTankItem
extends MekanismISTER {
    public static final RenderFluidTankItem RENDERER = new RenderFluidTankItem();
    private static final FluidRenderMap<Int2ObjectMap<MekanismRenderer.Model3D>> cachedCenterFluids = new FluidRenderMap();
    private static final int stages = 1400;
    private ModelFluidTank modelFluidTank;

    public static void resetCachedModels() {
        cachedCenterFluids.clear();
    }

    @Override
    public void m_6213_(@Nonnull ResourceManager resourceManager) {
        this.modelFluidTank = new ModelFluidTank(this.getEntityModels());
    }

    @Override
    public void m_108829_(@Nonnull ItemStack stack, @Nonnull ItemTransforms.TransformType transformType, @Nonnull PoseStack matrix, @Nonnull MultiBufferSource renderer, int light, int overlayLight) {
        float fluidScale;
        FluidTankTier tier = ((ItemBlockFluidTank)stack.m_41720_()).getTier();
        FluidStack fluid = StorageUtils.getStoredFluidFromNBT(stack);
        if (!fluid.isEmpty() && (fluidScale = (float)fluid.getAmount() / (float)tier.getStorage()) > 0.0f) {
            int modelNumber = ModelRenderer.getStage(fluid, 1400, (double)fluidScale);
            MekanismRenderer.renderObject(this.getFluidModel(fluid, modelNumber), matrix, renderer.m_6299_(Sheets.m_110792_()), MekanismRenderer.getColorARGB(fluid, fluidScale), MekanismRenderer.calculateGlowLight(light, fluid), overlayLight, RenderResizableCuboid.FaceDisplay.FRONT, transformType != ItemTransforms.TransformType.GUI);
        }
        matrix.m_85836_();
        matrix.m_85837_(0.5, -0.4, 0.5);
        matrix.m_85841_(0.9f, 0.8f, 0.9f);
        matrix.m_85841_(1.168f, 1.168f, 1.168f);
        matrix.m_85837_(0.0, -0.06, 0.0);
        this.modelFluidTank.render(matrix, renderer, light, overlayLight, tier, stack.m_41790_());
        matrix.m_85849_();
    }

    private MekanismRenderer.Model3D getFluidModel(@Nonnull FluidStack fluid, int stage) {
        if (cachedCenterFluids.containsKey(fluid) && ((Int2ObjectMap)cachedCenterFluids.get(fluid)).containsKey(stage)) {
            return (MekanismRenderer.Model3D)((Int2ObjectMap)cachedCenterFluids.get(fluid)).get(stage);
        }
        MekanismRenderer.Model3D model = new MekanismRenderer.Model3D();
        model.setTexture(MekanismRenderer.getFluidTexture(fluid, MekanismRenderer.FluidType.STILL));
        if (fluid.getFluid().getAttributes().getStillTexture(fluid) != null) {
            model.minX = 0.135f;
            model.minY = 0.0725f;
            model.minZ = 0.135f;
            model.maxX = 0.865f;
            model.maxY = 0.0525f + 0.875f * ((float)stage / 1400.0f);
            model.maxZ = 0.865f;
        }
        ((Int2ObjectMap)cachedCenterFluids.computeIfAbsent(fluid, f -> new Int2ObjectOpenHashMap())).put(stage, (Object)model);
        return model;
    }
}

