/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.model.baked;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.function.BiPredicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.client.render.lib.QuadTransformation;
import mekanism.client.render.lib.QuadUtils;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.data.IModelData;

public class ExtensionBakedModel<T>
implements BakedModel {
    protected final BakedModel original;
    private final LoadingCache<QuadsKey<T>, List<BakedQuad>> cache = CacheBuilder.newBuilder().build(new CacheLoader<QuadsKey<T>, List<BakedQuad>>(){

        @Nonnull
        public List<BakedQuad> load(@Nonnull QuadsKey<T> key) {
            return ExtensionBakedModel.this.createQuads(key);
        }
    });
    private final Map<List<Pair<BakedModel, RenderType>>, List<Pair<BakedModel, RenderType>>> cachedLayerRedirects = new Object2ObjectOpenHashMap();

    public ExtensionBakedModel(BakedModel original) {
        this.original = original;
    }

    @Nonnull
    @Deprecated
    public List<BakedQuad> m_6840_(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand) {
        return this.original.m_6840_(state, side, rand);
    }

    public boolean m_7541_() {
        return this.original.m_7541_();
    }

    public boolean m_7539_() {
        return this.original.m_7539_();
    }

    public boolean m_7547_() {
        return this.original.m_7547_();
    }

    public boolean m_7521_() {
        return this.original.m_7521_();
    }

    @Nonnull
    @Deprecated
    public TextureAtlasSprite m_6160_() {
        return this.original.m_6160_();
    }

    @Nonnull
    public ItemOverrides m_7343_() {
        return this.original.m_7343_();
    }

    public BakedModel handlePerspective(ItemTransforms.TransformType cameraTransformType, PoseStack mat) {
        return this.original.handlePerspective(cameraTransformType, mat);
    }

    @Nonnull
    @Deprecated
    public ItemTransforms m_7442_() {
        return this.original.m_7442_();
    }

    public boolean doesHandlePerspectives() {
        return this.original.doesHandlePerspectives();
    }

    @Nullable
    protected QuadsKey<T> createKey(QuadsKey<T> key, IModelData data) {
        return key;
    }

    protected List<BakedQuad> createQuads(QuadsKey<T> key) {
        List<BakedQuad> ret = key.getQuads();
        if (key.getTransformation() != null) {
            ret = QuadUtils.transformBakedQuads(ret, key.getTransformation());
        }
        return ret;
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData data) {
        List quads = this.original.getQuads(state, side, rand, data);
        QuadsKey key = this.createKey(new QuadsKey(state, side, rand, MinecraftForgeClient.getRenderType(), quads), data);
        if (key == null) {
            return quads;
        }
        return (List)this.cache.getUnchecked(key);
    }

    public boolean isLayered() {
        return this.original.isLayered();
    }

    @Nonnull
    public List<Pair<BakedModel, RenderType>> getLayerModels(ItemStack stack, boolean fabulous) {
        return this.cachedLayerRedirects.computeIfAbsent(this.original.getLayerModels(stack, fabulous), originalLayerModels -> originalLayerModels.stream().map(layerModel -> layerModel.mapFirst(this::wrapModel)).toList());
    }

    protected ExtensionBakedModel<T> wrapModel(BakedModel model) {
        return new ExtensionBakedModel<T>(model);
    }

    public static class QuadsKey<T> {
        @Nullable
        private final BlockState state;
        @Nullable
        private final Direction side;
        private final Random random;
        private final RenderType layer;
        private final List<BakedQuad> quads;
        private QuadTransformation transformation;
        private T data;
        private int dataHash;
        private BiPredicate<T, T> equality;

        public QuadsKey(@Nullable BlockState state, @Nullable Direction side, Random random, RenderType layer, List<BakedQuad> quads) {
            this.state = state;
            this.side = side;
            this.random = random;
            this.layer = layer;
            this.quads = quads;
        }

        public QuadsKey<T> transform(QuadTransformation transformation) {
            this.transformation = transformation;
            return this;
        }

        public QuadsKey<T> data(T data, int dataHash, BiPredicate<T, T> equality) {
            this.data = data;
            this.dataHash = dataHash;
            this.equality = equality;
            return this;
        }

        @Nullable
        public BlockState getBlockState() {
            return this.state;
        }

        @Nullable
        public Direction getSide() {
            return this.side;
        }

        public Random getRandom() {
            return this.random;
        }

        public RenderType getLayer() {
            return this.layer;
        }

        public List<BakedQuad> getQuads() {
            return this.quads;
        }

        public QuadTransformation getTransformation() {
            return this.transformation;
        }

        public T getData() {
            return this.data;
        }

        public int hashCode() {
            return Objects.hash(this.state, this.side, this.layer, this.transformation, this.dataHash);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof QuadsKey)) {
                return false;
            }
            QuadsKey other = (QuadsKey)obj;
            if (this.side != other.side || this.layer != other.layer || !Objects.equals(this.state, other.state)) {
                return false;
            }
            if (this.transformation != null && !this.transformation.equals(other.transformation)) {
                return false;
            }
            return this.data == null || this.equality.test(this.data, other.getData());
        }
    }

    public static class TransformedBakedModel<T>
    extends ExtensionBakedModel<T> {
        private final QuadTransformation transform;

        public TransformedBakedModel(BakedModel original, QuadTransformation transform) {
            super(original);
            this.transform = transform;
        }

        @Override
        @Nonnull
        @Deprecated
        public List<BakedQuad> m_6840_(BlockState state, Direction side, @Nonnull Random rand) {
            return QuadUtils.transformBakedQuads(this.original.m_6840_(state, side, rand), this.transform);
        }

        @Override
        public BakedModel handlePerspective(ItemTransforms.TransformType cameraTransformType, PoseStack mat) {
            this.original.handlePerspective(cameraTransformType, mat);
            return this;
        }

        @Override
        @Nullable
        protected QuadsKey<T> createKey(QuadsKey<T> key, IModelData data) {
            return key.transform(this.transform);
        }

        @Override
        protected TransformedBakedModel<T> wrapModel(BakedModel model) {
            return new TransformedBakedModel<T>(model, this.transform);
        }
    }

    public static class LightedBakedModel
    extends TransformedBakedModel<Void> {
        public LightedBakedModel(BakedModel original) {
            super(original, QuadTransformation.filtered_fullbright);
        }

        @Override
        protected LightedBakedModel wrapModel(BakedModel model) {
            return new LightedBakedModel(model);
        }
    }
}

