/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes.inputs;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.Action;
import mekanism.api.MekanismAPI;
import mekanism.api.annotations.NonNull;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.math.MathUtils;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.ingredients.InputIngredient;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.inputs.ILongInputHandler;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class InputHelper {
    private InputHelper() {
    }

    public static IInputHandler<@NonNull ItemStack> getInputHandler(final IInventorySlot slot, final CachedRecipe.OperationTracker.RecipeError notEnoughError) {
        Objects.requireNonNull(slot, "Slot cannot be null.");
        Objects.requireNonNull(notEnoughError, "Not enough input error cannot be null.");
        return new IInputHandler<ItemStack>(){

            @Override
            public ItemStack getInput() {
                return slot.getStack();
            }

            @Override
            public ItemStack getRecipeInput(InputIngredient<@NonNull ItemStack> recipeIngredient) {
                ItemStack input = this.getInput();
                if (input.m_41619_()) {
                    return ItemStack.f_41583_;
                }
                return recipeIngredient.getMatchingInstance(input);
            }

            @Override
            public void use(ItemStack recipeInput, int operations) {
                if (operations == 0) {
                    return;
                }
                if (!recipeInput.m_41619_()) {
                    int amount = recipeInput.m_41613_() * operations;
                    InputHelper.logMismatchedStackSize(slot.shrinkStack(amount, Action.EXECUTE), amount);
                }
            }

            @Override
            public void calculateOperationsCanSupport(CachedRecipe.OperationTracker tracker, ItemStack recipeInput, int usageMultiplier) {
                if (usageMultiplier > 0) {
                    int operations;
                    if (!recipeInput.m_41619_() && (operations = this.getInput().m_41613_() / (recipeInput.m_41613_() * usageMultiplier)) > 0) {
                        tracker.updateOperations(operations);
                        return;
                    }
                    tracker.resetProgress(notEnoughError);
                }
            }
        };
    }

    public static <STACK extends ChemicalStack<?>> ILongInputHandler<@NonNull STACK> getInputHandler(IChemicalTank<?, STACK> tank, CachedRecipe.OperationTracker.RecipeError notEnoughError) {
        Objects.requireNonNull(tank, "Tank cannot be null.");
        Objects.requireNonNull(notEnoughError, "Not enough input error cannot be null.");
        return new ChemicalInputHandler<STACK>(tank, notEnoughError);
    }

    public static <STACK extends ChemicalStack<?>> ILongInputHandler<@NonNull STACK> getConstantInputHandler(IChemicalTank<?, STACK> tank) {
        Objects.requireNonNull(tank, "Tank cannot be null.");
        return new ChemicalInputHandler<STACK>(tank, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_SECONDARY_INPUT){

            @Override
            protected void resetProgress(CachedRecipe.OperationTracker tracker) {
                tracker.updateOperations(0);
            }
        };
    }

    public static IInputHandler<@NonNull FluidStack> getInputHandler(final IExtendedFluidTank tank, final CachedRecipe.OperationTracker.RecipeError notEnoughError) {
        Objects.requireNonNull(tank, "Tank cannot be null.");
        Objects.requireNonNull(notEnoughError, "Not enough input error cannot be null.");
        return new IInputHandler<FluidStack>(){

            @Override
            @Nonnull
            public FluidStack getInput() {
                return tank.getFluid();
            }

            @Override
            @Nonnull
            public FluidStack getRecipeInput(InputIngredient<@NonNull FluidStack> recipeIngredient) {
                FluidStack input = this.getInput();
                if (input.isEmpty()) {
                    return FluidStack.EMPTY;
                }
                return recipeIngredient.getMatchingInstance(input);
            }

            @Override
            public void use(FluidStack recipeInput, int operations) {
                if (operations == 0 || recipeInput.isEmpty()) {
                    return;
                }
                FluidStack inputFluid = this.getInput();
                if (!inputFluid.isEmpty()) {
                    int amount = recipeInput.getAmount() * operations;
                    InputHelper.logMismatchedStackSize(tank.shrinkStack(amount, Action.EXECUTE), amount);
                }
            }

            @Override
            public void calculateOperationsCanSupport(CachedRecipe.OperationTracker tracker, FluidStack recipeInput, int usageMultiplier) {
                if (usageMultiplier > 0) {
                    int operations;
                    if (!recipeInput.isEmpty() && (operations = this.getInput().getAmount() / (recipeInput.getAmount() * usageMultiplier)) > 0) {
                        tracker.updateOperations(operations);
                        return;
                    }
                    tracker.resetProgress(notEnoughError);
                }
            }
        };
    }

    private static void logMismatchedStackSize(long actual, long expected) {
        if (expected != actual) {
            MekanismAPI.logger.error("Stack size changed by a different amount ({}) than requested ({}).", (Object)actual, (Object)expected, (Object)new Exception());
        }
    }

    private static class ChemicalInputHandler<STACK extends ChemicalStack<?>>
    implements ILongInputHandler<STACK> {
        private final IChemicalTank<?, STACK> tank;
        private final CachedRecipe.OperationTracker.RecipeError notEnoughError;

        private ChemicalInputHandler(IChemicalTank<?, STACK> tank, CachedRecipe.OperationTracker.RecipeError notEnoughError) {
            this.tank = tank;
            this.notEnoughError = notEnoughError;
        }

        @Override
        @Nonnull
        public STACK getInput() {
            return this.tank.getStack();
        }

        @Override
        @Nonnull
        public STACK getRecipeInput(InputIngredient<@NonNull STACK> recipeIngredient) {
            Object input = this.getInput();
            if (((ChemicalStack)input).isEmpty()) {
                return this.tank.getEmptyStack();
            }
            return (STACK)((ChemicalStack)recipeIngredient.getMatchingInstance(input));
        }

        @Override
        public void use(STACK recipeInput, long operations) {
            if (operations == 0L || ((ChemicalStack)recipeInput).isEmpty()) {
                return;
            }
            Object inputGas = this.getInput();
            if (!((ChemicalStack)inputGas).isEmpty()) {
                long amount = ((ChemicalStack)recipeInput).getAmount() * operations;
                InputHelper.logMismatchedStackSize(this.tank.shrinkStack(amount, Action.EXECUTE), amount);
            }
        }

        @Override
        public void calculateOperationsCanSupport(CachedRecipe.OperationTracker tracker, STACK recipeInput, long usageMultiplier) {
            if (usageMultiplier > 0L) {
                int operations;
                if (!((ChemicalStack)recipeInput).isEmpty() && (operations = MathUtils.clampToInt(((ChemicalStack)this.getInput()).getAmount() / (((ChemicalStack)recipeInput).getAmount() * usageMultiplier))) > 0) {
                    tracker.updateOperations(operations);
                    return;
                }
                this.resetProgress(tracker);
            }
        }

        protected void resetProgress(CachedRecipe.OperationTracker tracker) {
            tracker.resetProgress(this.notEnoughError);
        }
    }
}

