/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.heat;

import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.IContentsListener;
import mekanism.api.heat.IHeatCapacitor;
import mekanism.api.heat.ISidedHeatHandler;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.Direction;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public interface IMekanismHeatHandler
extends ISidedHeatHandler,
IContentsListener {
    default public boolean canHandleHeat() {
        return true;
    }

    @Override
    default public int getHeatCapacitorCount(@Nullable Direction side) {
        return this.getHeatCapacitors(side).size();
    }

    public List<IHeatCapacitor> getHeatCapacitors(@Nullable Direction var1);

    @Nullable
    default public IHeatCapacitor getHeatCapacitor(int capacitor, @Nullable Direction side) {
        List<IHeatCapacitor> capacitors = this.getHeatCapacitors(side);
        return capacitor >= 0 && capacitor < capacitors.size() ? capacitors.get(capacitor) : null;
    }

    @Override
    default public double getTemperature(int capacitor, @Nullable Direction side) {
        IHeatCapacitor heatCapacitor = this.getHeatCapacitor(capacitor, side);
        return heatCapacitor == null ? 300.0 : heatCapacitor.getTemperature();
    }

    @Override
    default public double getInverseConduction(int capacitor, @Nullable Direction side) {
        IHeatCapacitor heatCapacitor = this.getHeatCapacitor(capacitor, side);
        return heatCapacitor == null ? 1.0 : heatCapacitor.getInverseConduction();
    }

    @Override
    default public double getHeatCapacity(int capacitor, @Nullable Direction side) {
        IHeatCapacitor heatCapacitor = this.getHeatCapacitor(capacitor, side);
        return heatCapacitor == null ? 1.0 : heatCapacitor.getHeatCapacity();
    }

    @Override
    default public void handleHeat(int capacitor, double transfer, @Nullable Direction side) {
        IHeatCapacitor heatCapacitor = this.getHeatCapacitor(capacitor, side);
        if (heatCapacitor != null) {
            heatCapacitor.handleHeat(transfer);
        }
    }

    default public double getInverseInsulation(int capacitor, @Nullable Direction side) {
        IHeatCapacitor heatCapacitor = this.getHeatCapacitor(capacitor, side);
        return heatCapacitor == null ? 0.0 : heatCapacitor.getInverseInsulation();
    }

    default public double getTotalInverseInsulation(@Nullable Direction side) {
        int heatCapacitorCount = this.getHeatCapacitorCount(side);
        if (heatCapacitorCount == 1) {
            return this.getInverseInsulation(0, side);
        }
        double sum = 0.0;
        double totalCapacity = this.getTotalHeatCapacity(side);
        for (int capacitor = 0; capacitor < heatCapacitorCount; ++capacitor) {
            sum += this.getInverseInsulation(capacitor, side) * (this.getHeatCapacity(capacitor, side) / totalCapacity);
        }
        return sum;
    }
}

