/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.chemical.infuse;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.infuse.InfuseType;
import mekanism.api.providers.IInfuseTypeProvider;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.IRegistryDelegate;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public final class InfusionStack
extends ChemicalStack<InfuseType> {
    public static final InfusionStack EMPTY = new InfusionStack(MekanismAPI.EMPTY_INFUSE_TYPE, 0L);

    public InfusionStack(IInfuseTypeProvider infuseTypeProvider, long amount) {
        super((InfuseType)infuseTypeProvider.getChemical(), amount);
    }

    public InfusionStack(InfusionStack stack, long amount) {
        this((IInfuseTypeProvider)stack.getType(), amount);
    }

    @Override
    protected IRegistryDelegate<InfuseType> getDelegate(InfuseType infuseType) {
        if (MekanismAPI.infuseTypeRegistry().getKey((IForgeRegistryEntry)infuseType) == null) {
            MekanismAPI.logger.fatal("Failed attempt to create a InfusionStack for an unregistered InfuseType {} (type {})", (Object)infuseType.getRegistryName(), (Object)infuseType.getClass().getName());
            throw new IllegalArgumentException("Cannot create a InfusionStack from an unregistered infusion type");
        }
        return infuseType.delegate;
    }

    @Override
    protected InfuseType getEmptyChemical() {
        return MekanismAPI.EMPTY_INFUSE_TYPE;
    }

    public static InfusionStack readFromNBT(@Nullable CompoundTag nbtTags) {
        if (nbtTags == null || nbtTags.m_128456_()) {
            return EMPTY;
        }
        InfuseType type = InfuseType.readFromNBT(nbtTags);
        if (type.isEmptyType()) {
            return EMPTY;
        }
        long amount = nbtTags.m_128454_("amount");
        if (amount <= 0L) {
            return EMPTY;
        }
        return new InfusionStack(type, amount);
    }

    public static InfusionStack readFromPacket(FriendlyByteBuf buf) {
        InfuseType infuseType = (InfuseType)buf.readRegistryId();
        long amount = buf.m_130258_();
        if (infuseType.isEmptyType()) {
            return EMPTY;
        }
        return new InfusionStack(infuseType, amount);
    }

    public InfusionStack copy() {
        if (this.isEmpty()) {
            return EMPTY;
        }
        return new InfusionStack(this, this.getAmount());
    }
}

