/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.chemical;

import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.infuse.InfuseType;
import mekanism.api.chemical.pigment.Pigment;
import mekanism.api.chemical.slurry.Slurry;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.StringRepresentable;

public enum ChemicalType implements StringRepresentable
{
    GAS("gas", c -> c instanceof Gas),
    INFUSION("infuse_type", c -> c instanceof InfuseType),
    PIGMENT("pigment", c -> c instanceof Pigment),
    SLURRY("slurry", c -> c instanceof Slurry);

    private static final Map<String, ChemicalType> nameToType;
    private final Predicate<Chemical<?>> instanceCheck;
    private final String name;

    private ChemicalType(String name, Predicate<Chemical<?>> instanceCheck) {
        this.name = name;
        this.instanceCheck = instanceCheck;
    }

    @Nonnull
    public String m_7912_() {
        return this.name;
    }

    public boolean isInstance(Chemical<?> chemical) {
        return this.instanceCheck.test(chemical);
    }

    public void write(@Nonnull CompoundTag nbt) {
        nbt.m_128359_("chemicalType", this.m_7912_());
    }

    @Nullable
    public static ChemicalType fromString(String name) {
        return nameToType.get(name);
    }

    @Nullable
    public static ChemicalType fromNBT(@Nullable CompoundTag nbt) {
        if (nbt != null && nbt.m_128425_("chemicalType", 8)) {
            return ChemicalType.fromString(nbt.m_128461_("chemicalType"));
        }
        return null;
    }

    public static ChemicalType getTypeFor(Chemical<?> chemical) {
        if (chemical instanceof Gas) {
            return GAS;
        }
        if (chemical instanceof InfuseType) {
            return INFUSION;
        }
        if (chemical instanceof Pigment) {
            return PIGMENT;
        }
        if (chemical instanceof Slurry) {
            return SLURRY;
        }
        throw new IllegalStateException("Unknown chemical type");
    }

    public static ChemicalType getTypeFor(ChemicalStack<?> stack) {
        return ChemicalType.getTypeFor(stack.getType());
    }

    public static ChemicalType getTypeFor(ChemicalStackIngredient<?, ?> ingredient) {
        if (ingredient instanceof ChemicalStackIngredient.GasStackIngredient) {
            return GAS;
        }
        if (ingredient instanceof ChemicalStackIngredient.InfusionStackIngredient) {
            return INFUSION;
        }
        if (ingredient instanceof ChemicalStackIngredient.PigmentStackIngredient) {
            return PIGMENT;
        }
        if (ingredient instanceof ChemicalStackIngredient.SlurryStackIngredient) {
            return SLURRY;
        }
        throw new IllegalStateException("Unknown chemical ingredient type");
    }

    static {
        ChemicalType[] values = ChemicalType.values();
        nameToType = new Object2ObjectArrayMap(values.length);
        for (ChemicalType type : values) {
            nameToType.put(type.m_7912_(), type);
        }
    }
}

