/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.world;

import com.brandon3055.draconicevolution.network.DraconicNetwork;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBossEventPacket;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.BossEvent;

public class ShieldedServerBossInfo
extends ServerBossEvent {
    private float shieldPower = 0.0f;
    private int crystals = 0;
    private boolean immune = false;

    public ShieldedServerBossInfo(Component name, BossEvent.BossBarColor color, BossEvent.BossBarOverlay overlay) {
        super(name, color, overlay);
    }

    public void setShieldPower(float shieldPower) {
        if (this.shieldPower != shieldPower) {
            this.shieldPower = shieldPower;
            if (this.m_8323_()) {
                for (ServerPlayer player : this.f_8296_) {
                    DraconicNetwork.sendBossShieldPacket(player, this.m_18860_(), 2, e -> e.writeFloat(this.shieldPower));
                }
            }
        }
    }

    public void setCrystals(int crystals) {
        if (this.crystals != crystals) {
            this.crystals = crystals;
            if (this.m_8323_()) {
                for (ServerPlayer player : this.f_8296_) {
                    DraconicNetwork.sendBossShieldPacket(player, this.m_18860_(), 3, e -> e.writeByte(this.crystals));
                }
            }
        }
    }

    public void setImmune(boolean immune) {
        if (this.immune != immune) {
            this.immune = immune;
            if (this.m_8323_()) {
                for (ServerPlayer player : this.f_8296_) {
                    DraconicNetwork.sendBossShieldPacket(player, this.m_18860_(), 4, e -> e.writeBoolean(this.immune));
                }
            }
        }
    }

    public void m_8321_(boolean visible) {
        boolean prev = this.m_8323_();
        super.m_8321_(visible);
        if (prev != visible) {
            for (ServerPlayer player : this.f_8296_) {
                if (visible) {
                    DraconicNetwork.sendBossShieldPacket(player, this.m_18860_(), 0, e -> e.writeFloat(this.shieldPower).writeByte(this.crystals).writeBoolean(this.immune));
                    continue;
                }
                DraconicNetwork.sendBossShieldPacket(player, this.m_18860_(), 1, null);
            }
        }
    }

    public void m_6543_(ServerPlayer player) {
        if (this.f_8296_.add(player) && this.m_8323_()) {
            player.f_8906_.m_141995_((Packet)ClientboundBossEventPacket.m_178639_((BossEvent)this));
            DraconicNetwork.sendBossShieldPacket(player, this.m_18860_(), 0, e -> e.writeFloat(this.shieldPower).writeByte(this.crystals).writeBoolean(this.immune));
        }
    }

    public void m_6539_(ServerPlayer player) {
        if (this.f_8296_.remove(player) && this.m_8323_()) {
            player.f_8906_.m_141995_((Packet)ClientboundBossEventPacket.m_178641_((UUID)this.m_18860_()));
            DraconicNetwork.sendBossShieldPacket(player, this.m_18860_(), 1, null);
        }
    }
}

