/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.world;

import com.brandon3055.brandonscore.utils.MathUtils;
import com.brandon3055.brandonscore.utils.SimplexNoise;
import com.brandon3055.brandonscore.utils.Utils;
import com.brandon3055.brandonscore.worldentity.WorldEntity;
import com.brandon3055.brandonscore.worldentity.WorldEntityHandler;
import com.brandon3055.draconicevolution.blocks.tileentity.TileChaosCrystal;
import com.brandon3055.draconicevolution.entity.guardian.GuardianFightManager;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.init.DEWorldGen;
import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class ChaosIslandFeature
extends Feature<NoneFeatureConfiguration> {
    public final int islandYPos;
    public final int islandSeparation;
    public final int islandSize;

    public ChaosIslandFeature(Codec<NoneFeatureConfiguration> codec, int islandYPos, int islandSeparation, int islandSize) {
        super(codec);
        this.islandYPos = islandYPos;
        this.islandSeparation = islandSeparation;
        this.islandSize = islandSize;
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        BlockPos origin = context.m_159777_();
        ChunkPos chunkPos = new ChunkPos(origin);
        ChunkPos closestSpawn = this.getClosestSpawn(chunkPos);
        if (closestSpawn.f_45578_ == 0 && closestSpawn.f_45579_ == 0) {
            return false;
        }
        WorldGenLevel level = context.m_159774_();
        Random rand = context.m_159776_();
        BlockPos islandOrigin = closestSpawn.m_151384_(0, this.islandYPos, 0);
        if (islandOrigin.m_123331_((Vec3i)origin) > (double)(this.islandSize * 5 * (this.islandSize * 5))) {
            return false;
        }
        boolean chunkModified = false;
        if (!DEWorldGen.chaosIslandVoidMode) {
            chunkModified = this.genIslandChunk(level, origin, islandOrigin, rand);
            chunkModified |= this.genCoreChunk(level, origin, islandOrigin, rand);
            chunkModified |= this.genRingChunk(level, origin, islandOrigin, rand);
        }
        if (ChaosIslandFeature.inChunk(origin, islandOrigin)) {
            level.m_7731_(islandOrigin, DEContent.chaos_crystal.m_49966_(), 3);
            BlockEntity blockEntity = level.m_7702_(islandOrigin);
            if (blockEntity instanceof TileChaosCrystal) {
                TileChaosCrystal tile = (TileChaosCrystal)blockEntity;
                tile.onValidPlacement();
            }
            WorldEntityHandler.addWorldEntity((Level)level.m_6018_(), (WorldEntity)new GuardianFightManager(islandOrigin));
            chunkModified = true;
        }
        return chunkModified;
    }

    public boolean genIslandChunk(WorldGenLevel level, BlockPos chunkOrigin, BlockPos islandOrigin, Random rand) {
        boolean chunkModified = false;
        int minY = this.islandYPos - 40;
        int maxY = this.islandYPos + 40;
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)chunkOrigin.m_142082_(0, minY - chunkOrigin.m_123342_(), 0), (BlockPos)chunkOrigin.m_142082_(16, maxY - chunkOrigin.m_123342_(), 16))) {
            double density;
            double plateauFalloff;
            int x = pos.m_123341_() - islandOrigin.m_123341_();
            int y = pos.m_123342_() - islandOrigin.m_123342_();
            int z = pos.m_123343_() - islandOrigin.m_123343_();
            double dist = Math.sqrt(pos.m_123331_((Vec3i)islandOrigin));
            double xd = (double)x / (double)this.islandSize;
            double yd = 0.5 + (double)y / 32.0;
            double zd = (double)z / (double)this.islandSize;
            double centerFalloff = 1.0 / ((dist *= 80.0 / (double)this.islandSize) * 0.05);
            if (centerFalloff < 0.0) {
                centerFalloff = 0.0;
            }
            if ((plateauFalloff = yd < 0.4 ? yd * 2.5 : (yd <= 0.6 ? 1.0 : (yd > 0.6 && yd < 1.0 ? 1.0 - (yd - 0.6) * 2.5 : 0.0))) == 0.0 || centerFalloff == 0.0) continue;
            double heightMapFalloff = 0.0;
            for (int octave = 1; octave < 5; ++octave) {
                heightMapFalloff += (SimplexNoise.noise((double)(xd * (double)octave + (double)islandOrigin.m_123341_()), (double)(zd * (double)octave + (double)islandOrigin.m_123343_())) + 1.0) * 0.5 * 0.01 * ((double)octave * 10.0 * 1.0 - dist * 0.001);
            }
            if (heightMapFalloff <= 0.0) {
                heightMapFalloff = 0.0;
            }
            if ((heightMapFalloff += (0.5 - Math.abs(yd - 0.5)) * 0.15) == 0.0 || !((density = centerFalloff * plateauFalloff * heightMapFalloff) > 0.1) || !level.m_46859_(pos) || level.m_8055_(pos).m_60734_() == Blocks.f_50627_) continue;
            level.m_7731_(pos, dist > 60.0 || dist > (double)rand.nextInt(60) ? Blocks.f_50259_.m_49966_() : Blocks.f_50080_.m_49966_(), 3);
            chunkModified = true;
        }
        return chunkModified;
    }

    public boolean genCoreChunk(WorldGenLevel level, BlockPos chunkOrigin, BlockPos islandOrigin, Random rand) {
        boolean chunkModified = false;
        int coreHeight = 10;
        int coreWidth = 20;
        int originX = islandOrigin.m_123341_();
        int originZ = islandOrigin.m_123343_();
        for (int y = this.islandYPos - coreHeight; y <= this.islandYPos + coreHeight; ++y) {
            int yDist = Math.abs(y - this.islandYPos);
            int inRadius = yDist - 3;
            double yp = (double)(coreHeight - yDist) / (double)coreHeight;
            int outRadius = (int)(yp * (double)coreWidth);
            outRadius -= outRadius * outRadius / 100;
            BlockPos sliceMin = new BlockPos(originX - outRadius, y, originZ - outRadius);
            BlockPos sliceMax = new BlockPos(originX + outRadius, y, originZ + outRadius);
            BlockPos slicePos = new BlockPos(originX, y, originZ);
            for (BlockPos pos : BlockPos.m_121940_((BlockPos)sliceMin, (BlockPos)sliceMax)) {
                if (!ChaosIslandFeature.inChunk(chunkOrigin, pos)) continue;
                double distSq = pos.m_123331_((Vec3i)islandOrigin);
                double distXZSq = pos.m_123331_((Vec3i)slicePos);
                this.genCoreSlice(level, distSq, distXZSq, pos, inRadius, coreWidth, true, rand);
                this.genCoreSlice(level, distSq, distXZSq, pos, outRadius, coreWidth, false, rand);
            }
        }
        return chunkModified;
    }

    public boolean genCoreSlice(WorldGenLevel level, double distSq, double distXZSq, BlockPos pos, int ringRadius, int coreRadious, boolean fillIn, Random rand) {
        Block b;
        int yOffset = Math.abs(this.islandYPos - pos.m_123342_());
        double oRad = (double)coreRadious - (double)(yOffset * yOffset) / 10.0;
        if (distSq > (oRad - 3.0) * (oRad - 3.0) && rand.nextDouble() * 3.0 < distSq - (oRad - 3.0) * (oRad - 3.0)) {
            return false;
        }
        if (fillIn && Math.sqrt(distXZSq) <= (double)ringRadius) {
            if (Math.sqrt(distSq) < 9.0) {
                level.m_7731_(pos, DEContent.infused_obsidian.m_49966_(), 3);
            } else {
                level.m_7731_(pos, Blocks.f_50080_.m_49966_(), 3);
            }
            return true;
        }
        if (!fillIn && distXZSq >= (double)((ringRadius - 1) * (ringRadius - 1))) {
            level.m_7731_(pos, Blocks.f_50080_.m_49966_(), 3);
            return true;
        }
        if (!fillIn && distXZSq <= (double)((ringRadius - 1) * (ringRadius - 1)) && ((b = level.m_8055_(pos).m_60734_()) == Blocks.f_50016_ || b == Blocks.f_50259_ || b == Blocks.f_50080_)) {
            level.m_7731_(pos, Blocks.f_50627_.m_49966_(), 3);
            return true;
        }
        return false;
    }

    public boolean genRingChunk(WorldGenLevel level, BlockPos chunkOrigin, BlockPos islandOrigin, Random rand) {
        boolean chunkModified = false;
        int outerRadius = this.islandSize * 4;
        int rings = 4;
        int width = 20;
        int spacing = 20;
        for (int x = chunkOrigin.m_123341_(); x < chunkOrigin.m_123341_() + 16; ++x) {
            for (int z = chunkOrigin.m_123343_(); z < chunkOrigin.m_123343_() + 16; ++z) {
                int distSq = (int)Utils.getDistanceSq((double)x, (double)z, (double)islandOrigin.m_123341_(), (double)islandOrigin.m_123343_());
                for (int i = 0; i < rings; ++i) {
                    int max = outerRadius - (width + spacing) * i;
                    int min = outerRadius - width - (width + spacing) * i;
                    if (distSq >= max * max || distSq < min * min) continue;
                    int y = 10 + (int)((double)(islandOrigin.m_123341_() - x) * 0.1) + (rand.nextInt(10) - 5);
                    BlockPos setPos = new BlockPos(x, y + this.islandYPos, z);
                    if (0.1f > rand.nextFloat()) {
                        level.m_7731_(setPos, Blocks.f_50259_.m_49966_(), 3);
                        chunkModified = true;
                    }
                    if (!(0.001f > rand.nextFloat()) || DEWorldGen.DRACONIUM_ORE_PLACED_END == null) continue;
                    level.m_7731_(setPos, DEContent.ore_draconium_end.m_49966_(), 3);
                    chunkModified = true;
                }
            }
        }
        return chunkModified;
    }

    public ChunkPos getClosestSpawn(ChunkPos pos) {
        return new ChunkPos(MathUtils.getNearestMultiple((int)(pos.f_45578_ * 16), (int)this.islandSeparation) / 16, MathUtils.getNearestMultiple((int)(pos.f_45579_ * 16), (int)this.islandSeparation) / 16);
    }

    private static boolean inChunk(BlockPos ref, BlockPos test) {
        int x = ref.m_123341_() - ref.m_123341_() % 16;
        int z = ref.m_123343_() - ref.m_123343_() % 16;
        return test.m_123341_() >= x && test.m_123343_() >= z && test.m_123341_() <= x + 15 && test.m_123343_() <= z + 15;
    }

    public static void generateObelisk(ServerLevel world, BlockPos genPos, Random rand) {
        for (int i = 0; i < 20; i += 3) {
            LightningBolt entity = new LightningBolt(EntityType.f_20465_, (Level)world);
            entity.m_6034_((double)(genPos.m_123341_() - 2 + rand.nextInt(5)), (double)(genPos.m_123342_() - rand.nextInt(20)), (double)(genPos.m_123343_() - 2 + rand.nextInt(5)));
            world.m_7967_((Entity)entity);
        }
        if (DEWorldGen.chaosIslandVoidMode) {
            return;
        }
        int r = 3;
        BlockPos.m_121990_((BlockPos)genPos.m_142082_(-r, -25, -r), (BlockPos)genPos.m_142082_(r, 4, r)).forEach(pos -> {
            if (pos.m_123342_() < genPos.m_123342_()) {
                double pct = (double)(genPos.m_123342_() - pos.m_123342_()) / 25.0;
                if (Utils.getDistance((double)pos.m_123341_(), (double)pos.m_123343_(), (double)genPos.m_123341_(), (double)genPos.m_123343_()) <= (double)r + 0.5 && 1.0 - pct > rand.nextDouble()) {
                    float block = rand.nextFloat();
                    if ((double)block < 0.1) {
                        world.m_7731_(pos, DEContent.infused_obsidian.m_49966_(), 3);
                    } else if ((double)block < 0.4) {
                        world.m_7731_(pos, Blocks.f_50197_.m_49966_(), 3);
                    } else {
                        world.m_7731_(pos, Blocks.f_50080_.m_49966_(), 3);
                    }
                }
            }
            int relY = pos.m_123342_() - genPos.m_123342_();
            int absRelX = Math.abs(pos.m_123341_() - genPos.m_123341_());
            int absRelZ = Math.abs(pos.m_123343_() - genPos.m_123343_());
            if ((absRelX == 2 || absRelZ == 2) && absRelX <= 2 && absRelZ <= 2 && relY < 4 && relY > -1) {
                world.m_7731_(pos, Blocks.f_50183_.m_49966_(), 3);
            }
            if (relY == 4 && absRelX <= 2 && absRelZ <= 2) {
                world.m_7731_(pos, Blocks.f_50412_.m_49966_(), 3);
            }
        });
    }
}

