/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.lib;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import com.brandon3055.brandonscore.api.power.IOInfo;
import com.brandon3055.brandonscore.api.power.IOPStorage;
import com.brandon3055.brandonscore.api.power.IOTracker;
import com.brandon3055.brandonscore.api.power.IOTrackerSelfTimed;
import com.brandon3055.brandonscore.lib.IMCDataSerializable;
import com.brandon3055.brandonscore.lib.IValueHashable;
import com.brandon3055.brandonscore.utils.Utils;
import com.google.common.math.BigIntegerMath;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.common.util.INBTSerializable;
import org.jetbrains.annotations.VisibleForTesting;

public class OPStorageOP
implements INBTSerializable<CompoundTag>,
IValueHashable<ComparableValue>,
IMCDataSerializable,
IOPStorage {
    @VisibleForTesting
    protected long valueStorage = 0L;
    @VisibleForTesting
    protected BigInteger overflowCount = BigInteger.ZERO;
    protected IOTracker ioTracker;
    private Supplier<Long> capacity;
    private static BigInteger prefixEnd = new BigInteger("975781955236953990712502012356953416011859675");
    private static NumberFormat decimalFormat = new DecimalFormat("0.######E0", DecimalFormatSymbols.getInstance(Locale.ROOT));

    public OPStorageOP(Supplier<Long> capacity) {
        this.capacity = capacity;
    }

    public long extractOP(long maxExtract, boolean simulate) {
        if (!this.overflowCount.equals(BigInteger.ZERO)) {
            if (!simulate) {
                this.valueStorage -= maxExtract;
                if (this.valueStorage <= 0L) {
                    this.valueStorage = Long.MAX_VALUE;
                    this.overflowCount = this.overflowCount.subtract(BigInteger.ONE);
                }
                if (this.ioTracker != null) {
                    this.ioTracker.energyExtracted(maxExtract);
                }
            }
            return maxExtract;
        }
        long energyExtracted = Math.min(this.valueStorage, maxExtract);
        if (!simulate) {
            this.valueStorage -= energyExtracted;
            if (this.ioTracker != null) {
                this.ioTracker.energyExtracted(energyExtracted);
            }
        }
        return energyExtracted;
    }

    public long receiveOP(long maxReceive, boolean simulate) {
        long limit = this.capacity.get();
        if (limit != -1L) {
            long energyReceived = Math.min(limit - this.valueStorage, maxReceive);
            if (!simulate) {
                this.valueStorage += energyReceived;
                if (this.ioTracker != null) {
                    this.ioTracker.energyInserted(energyReceived);
                }
            }
            return energyReceived;
        }
        if (!simulate) {
            long maxB4Over = Long.MAX_VALUE - this.valueStorage;
            if (maxReceive > maxB4Over) {
                this.valueStorage = maxReceive - maxB4Over;
                this.overflowCount = this.overflowCount.add(BigInteger.ONE);
            } else {
                this.valueStorage += maxReceive;
            }
            if (this.ioTracker != null) {
                this.ioTracker.energyInserted(maxReceive);
            }
        }
        return maxReceive;
    }

    public long getOPStored() {
        if (this.capacity.get() == -1L) {
            if (!this.overflowCount.equals(BigInteger.ZERO)) {
                return 0x3FFFFFFFFFFFFFFFL;
            }
            return Math.min(this.valueStorage, 0x3FFFFFFFFFFFFFFFL);
        }
        return this.valueStorage;
    }

    public long getUncappedStored() {
        if (!this.overflowCount.equals(BigInteger.ZERO)) {
            return Long.MAX_VALUE;
        }
        return this.valueStorage;
    }

    public long getMaxOPStored() {
        long cap = this.capacity.get();
        return cap == -1L ? Long.MAX_VALUE : cap;
    }

    public void validateStorage() {
        long cap = this.capacity.get();
        if (cap != -1L) {
            this.overflowCount = BigInteger.ZERO;
            this.valueStorage = Math.min(this.valueStorage, cap);
        }
    }

    public void serializeMCD(MCDataOutput output) {
        output.writeVarLong(this.valueStorage);
        output.writeBytes(this.overflowCount.toByteArray());
        output.writeBoolean(this.ioTracker != null);
        if (this.ioTracker != null) {
            output.writeVarLong(this.ioTracker.currentInput());
            output.writeVarLong(this.ioTracker.currentOutput());
        }
    }

    public void deSerializeMCD(MCDataInput input) {
        this.valueStorage = input.readVarLong();
        this.overflowCount = new BigInteger(input.readBytes());
        if (input.readBoolean()) {
            if (this.ioTracker == null) {
                this.ioTracker = new IOTrackerSelfTimed();
            }
            this.ioTracker.syncClientValues(input.readVarLong(), input.readVarLong());
        } else if (this.ioTracker != null) {
            this.ioTracker = null;
        }
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128356_("storage", this.valueStorage);
        if (!this.overflowCount.equals(BigInteger.ZERO)) {
            tag.m_128382_("overflow", this.overflowCount.toByteArray());
        }
        return tag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.valueStorage = nbt.m_128454_("storage");
        if (nbt.m_128425_("overflow", 7)) {
            this.overflowCount = new BigInteger(nbt.m_128463_("overflow"));
        }
    }

    public boolean canExtract() {
        return true;
    }

    public boolean canReceive() {
        return true;
    }

    public void setIOTracker(@Nullable IOTracker ioTracker) {
        this.ioTracker = ioTracker;
    }

    @Nullable
    public IOInfo getIOInfo() {
        return this.ioTracker;
    }

    public long modifyEnergyStored(long amount) {
        if (amount > 0L) {
            return this.receiveOP(amount, false);
        }
        return this.extractOP(-amount, false);
    }

    public ComparableValue getValueHash() {
        return new ComparableValue(this);
    }

    public boolean checkValueHash(Object vh) {
        if (vh instanceof ComparableValue) {
            boolean mainCheck;
            ComparableValue v = (ComparableValue)vh;
            boolean bl = mainCheck = v.valueStorage == this.valueStorage && v.overflowCount.equals(this.overflowCount);
            if (this.ioTracker != null) {
                return mainCheck && v.currentInput == this.ioTracker.currentInput() && v.currentOutput == this.ioTracker.currentOutput();
            }
            return mainCheck;
        }
        return false;
    }

    public boolean isUnlimited() {
        return this.capacity.get() == -1L;
    }

    public String getReadable() {
        if (this.overflowCount.compareTo(prefixEnd) > 0) {
            return decimalFormat.format(this.overflowCount) + " x (2^64)";
        }
        BigInteger value = BigInteger.valueOf(this.valueStorage).add(this.overflowCount.multiply(BigInteger.valueOf(Long.MAX_VALUE)));
        if (value.equals(BigInteger.ZERO)) {
            return "0";
        }
        int digits = BigIntegerMath.log10((BigInteger)value, (RoundingMode)RoundingMode.DOWN);
        int prefixStep = digits / 3 * 3;
        if (digits < 6) {
            return Utils.addCommas((long)value.longValue());
        }
        BigDecimal decimal = new BigDecimal(value).divide(BigDecimal.valueOf(10L).pow(prefixStep), 3, RoundingMode.DOWN);
        return decimal.doubleValue() + I18n.m_118938_((String)("numprefix.draconicevolution.10-" + prefixStep), (Object[])new Object[0]);
    }

    public String getReadableCapacity() {
        if (this.capacity.get() == -1L) {
            return "~1x10^1300000000";
        }
        long cap = this.capacity.get();
        int digits = (int)Math.log10(cap);
        int prefixStep = digits / 3 * 3;
        if (digits < 6) {
            return Utils.addCommas((long)cap) + " OP";
        }
        double decimal = (double)cap / Math.pow(10.0, prefixStep);
        return (double)Math.round(decimal * 1000.0) / 1000.0 + I18n.m_118938_((String)("numprefix.draconicevolution.10-" + prefixStep), (Object[])new Object[0]);
    }

    public String getScientific() {
        if (this.overflowCount.compareTo(prefixEnd) > 0) {
            return decimalFormat.format(this.overflowCount) + " x (2^64) OP";
        }
        return decimalFormat.format(this.getStoredBig());
    }

    public BigInteger getStoredBig() {
        return BigInteger.valueOf(this.valueStorage).add(this.overflowCount.multiply(BigInteger.valueOf(Long.MAX_VALUE)));
    }

    protected static class ComparableValue {
        private long valueStorage;
        private BigInteger overflowCount;
        private long currentInput = 0L;
        private long currentOutput = 0L;

        public ComparableValue(OPStorageOP storage) {
            this.valueStorage = storage.valueStorage;
            this.overflowCount = storage.overflowCount;
            if (storage.ioTracker != null) {
                this.currentInput = storage.ioTracker.currentInput();
                this.currentOutput = storage.ioTracker.currentOutput();
            }
        }
    }
}

