/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.lib;

import com.brandon3055.brandonscore.handlers.IProcess;
import com.brandon3055.brandonscore.multiblock.MultiBlockDefinition;
import com.brandon3055.brandonscore.multiblock.MultiBlockPart;
import com.brandon3055.draconicevolution.blocks.tileentity.MultiBlockController;
import com.brandon3055.draconicevolution.lib.WTFException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public class MultiBlockBuilder
implements IProcess {
    private final Level level;
    private final BlockPos inWorldOrigin;
    private final MultiBlockDefinition definition;
    private final Player player;
    private MultiBlockController controller;
    private boolean isDead = false;
    private Map<BlockPos, MultiBlockPart> workList = new HashMap<BlockPos, MultiBlockPart>();
    private LinkedList<BlockPos> workOrder = new LinkedList();

    public MultiBlockBuilder(Level level, BlockPos inWorldOrigin, MultiBlockDefinition definition, Player player, @Nullable MultiBlockController controller) {
        this.level = level;
        this.inWorldOrigin = inWorldOrigin;
        this.definition = definition;
        this.player = player;
        this.controller = controller;
        this.buildWorkList();
    }

    private void buildWorkList() {
        Map structureBlocks = this.definition.getBlocksAt(this.inWorldOrigin);
        for (Map.Entry entry : structureBlocks.entrySet()) {
            BlockPos pos = (BlockPos)entry.getKey();
            MultiBlockPart part = (MultiBlockPart)entry.getValue();
            if (part.isMatch(this.level, pos)) continue;
            if (this.level.m_46859_(pos)) {
                this.workList.put(pos, part);
                continue;
            }
            this.isDead = true;
            this.player.m_6352_((Component)new TranslatableComponent("struct_build.brandonscore.found_invalid", new Object[]{this.level.m_8055_(pos).m_60734_().m_49954_(), "[X: " + pos.m_123341_() + ", Y: " + pos.m_123342_() + ", Z: " + pos.m_123343_() + "]"}).m_130940_(ChatFormatting.RED), Util.f_137441_);
            return;
        }
        this.workOrder.addAll(this.workList.keySet());
        this.workOrder.sort(Comparator.comparingInt(value -> (int)value.m_123331_((Vec3i)this.inWorldOrigin)));
    }

    public void updateProcess() {
        if (this.workOrder.isEmpty() || !this.player.m_6084_() || this.player.f_19853_ != this.level) {
            this.isDead = true;
            if (this.controller != null) {
                this.controller.validateStructure();
            }
            return;
        }
        BlockPos pos = this.workOrder.poll();
        MultiBlockPart part = this.workList.get(pos);
        if (part.isMatch(this.level, pos)) {
            return;
        }
        if (!this.level.m_46859_(pos)) {
            this.player.m_6352_((Component)new TranslatableComponent("struct_build.brandonscore.found_invalid", new Object[]{this.level.m_8055_(pos).m_60734_().m_49954_(), "[X: " + pos.m_123341_() + ", Y: " + pos.m_123342_() + ", Z: " + pos.m_123343_() + "]"}).m_130940_(ChatFormatting.RED), Util.f_137441_);
            this.isDead = true;
            return;
        }
        Block placeBlock = this.extractPart(this.player, part);
        if (placeBlock != null) {
            this.level.m_46597_(pos, placeBlock.m_49966_());
            SoundType soundtype = placeBlock.getSoundType(placeBlock.m_49966_(), (LevelReader)this.level, pos, (Entity)this.player);
            this.level.m_6263_(null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, soundtype.m_56777_(), SoundSource.BLOCKS, (soundtype.m_56773_() + 1.0f) / 2.0f, soundtype.m_56774_() * 0.8f);
        } else {
            this.player.m_6352_((Component)new TranslatableComponent("struct_build.brandonscore.missing_required", new Object[]{part.getFirstValidBlock().m_49954_()}).m_130940_(ChatFormatting.RED), Util.f_137441_);
            this.isDead = true;
        }
    }

    @Nullable
    private Block extractPart(Player player, MultiBlockPart part) {
        if (player.m_150110_().f_35937_) {
            return part.getFirstValidBlock();
        }
        LazyOptional opHandler = player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        if (opHandler.isPresent()) {
            IItemHandler handler = (IItemHandler)opHandler.orElseThrow(WTFException::new);
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack extracted;
                ItemStack inSlot = handler.getStackInSlot(i);
                if (inSlot.m_41619_() || !(inSlot.m_41720_() instanceof BlockItem)) continue;
                Block slotBlock = ((BlockItem)inSlot.m_41720_()).m_40614_();
                if (!part.validBlocks().contains(slotBlock) || (extracted = handler.extractItem(i, 1, false)).m_41619_() || !(extracted.m_41720_() instanceof BlockItem) || ((BlockItem)extracted.m_41720_()).m_40614_() != slotBlock) continue;
                return slotBlock;
            }
        }
        return null;
    }

    public boolean isDead() {
        return this.isDead;
    }
}

