/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.lib;

import com.brandon3055.brandonscore.handlers.IProcess;
import com.brandon3055.brandonscore.handlers.ProcessHandler;
import com.brandon3055.draconicevolution.network.DraconicNetwork;
import com.brandon3055.draconicevolution.utils.LogHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.network.protocol.game.ClientboundLightUpdatePacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ThreadedLevelLightEngine;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;

public class ExplosionHelper {
    private final ServerLevel serverWorld;
    private BlockPos start;
    private HashSet<LevelChunk> modifiedChunks = new HashSet();
    private HashSet<Long> blocksToUpdate = new HashSet();
    private HashSet<Long> lightUpdates = new HashSet();
    private HashSet<Long> tilesToRemove = new HashSet();
    private HashMap<ChunkPos, LevelChunk> chunkCache = new HashMap();
    private static final BlockState AIR = Blocks.f_50016_.m_49966_();
    public BlockPos.MutableBlockPos mPos = new BlockPos.MutableBlockPos();
    public LinkedList<HashSet<Long>> toRemove = new LinkedList();

    public ExplosionHelper(ServerLevel serverWorld, BlockPos start) {
        this.serverWorld = serverWorld;
        this.start = start;
    }

    public void setBlocksForRemoval(LinkedList<HashSet<Long>> list) {
        this.toRemove = list;
    }

    public void addBlocksForUpdate(Collection<Long> blocksToUpdate) {
        this.blocksToUpdate.addAll(blocksToUpdate);
    }

    private void removeBlock(BlockPos pos) {
        LevelChunk chunk = this.getChunk(pos);
        BlockState oldState = chunk.m_8055_(pos);
        if (oldState.m_60734_() instanceof EntityBlock) {
            this.serverWorld.m_7471_(pos, false);
            this.serverWorld.m_5518_().m_142202_(pos);
            return;
        }
        LevelChunkSection storage = this.getBlockStorage(pos);
        if (storage != null) {
            storage.m_62986_(pos.m_123341_() & 0xF, pos.m_123342_() & 0xF, pos.m_123343_() & 0xF, AIR);
        }
        this.setChunkModified(pos);
        this.serverWorld.m_5518_().m_142202_(pos);
    }

    public void setChunkModified(BlockPos blockPos) {
        LevelChunk chunk = this.getChunk(blockPos);
        this.setChunkModified(chunk);
    }

    public void setChunkModified(LevelChunk chunk) {
        this.modifiedChunks.add(chunk);
    }

    private LevelChunk getChunk(BlockPos pos) {
        ChunkPos cp = new ChunkPos(pos);
        if (!this.chunkCache.containsKey(cp)) {
            this.chunkCache.put(cp, this.serverWorld.m_6325_(pos.m_123341_() >> 4, pos.m_123343_() >> 4));
        }
        return this.chunkCache.get(cp);
    }

    private LevelChunkSection getBlockStorage(BlockPos pos) {
        LevelChunk chunk = this.getChunk(pos);
        return chunk.m_183278_(chunk.m_151564_(pos.m_123342_()));
    }

    public void finish() {
        LogHelper.dev("EH: finish");
        RemovalProcess process = new RemovalProcess(this);
        ProcessHandler.addProcess((IProcess)process);
    }

    public boolean isAirBlock(BlockPos pos) {
        return this.serverWorld.m_46859_(pos);
    }

    public BlockState getBlockState(BlockPos pos) {
        LevelChunkSection storage = this.getBlockStorage(pos);
        if (storage == null) {
            return Blocks.f_50016_.m_49966_();
        }
        return storage.m_62982_(pos.m_123341_() & 0xF, pos.m_123342_() & 0xF, pos.m_123343_() & 0xF);
    }

    private static class RemovalProcess
    implements IProcess {
        public boolean isDead = false;
        private ExplosionHelper helper;
        int index = 0;
        private MinecraftServer server;
        public BlockPos.MutableBlockPos mPos = new BlockPos.MutableBlockPos();

        public RemovalProcess(ExplosionHelper helper) {
            this.helper = helper;
            this.server = helper.serverWorld.m_142572_();
        }

        public void updateProcess() {
            this.server.f_129726_ = Util.m_137550_();
            while (Util.m_137550_() - this.server.f_129726_ < 50L && this.helper.toRemove.size() > 0) {
                LogHelper.dev("Processing chunks at rad: " + this.index);
                HashSet<Long> set = this.helper.toRemove.removeFirst();
                for (long pos : set) {
                    this.helper.removeBlock((BlockPos)this.mPos.m_122188_(pos));
                }
                ++this.index;
            }
            this.finishChunks();
            if (this.helper.toRemove.isEmpty()) {
                this.isDead = true;
                this.updateBlocks();
                DraconicNetwork.sendExplosionEffect((ResourceKey<Level>)this.helper.serverWorld.m_46472_(), this.helper.start, 0, true);
            }
        }

        public void finishChunks() {
            for (LevelChunk chunk : this.helper.modifiedChunks) {
                chunk.m_8094_(false);
                ThreadedLevelLightEngine lightManager = (ThreadedLevelLightEngine)this.helper.serverWorld.m_5518_();
                lightManager.m_9353_((ChunkAccess)chunk, true).thenRun(() -> this.helper.serverWorld.m_7726_().f_8325_.m_183262_(chunk.m_7697_(), false).forEach(e -> e.f_8906_.m_141995_((Packet)new ClientboundLightUpdatePacket(chunk.m_7697_(), this.helper.serverWorld.m_5518_(), null, null, false))));
                ClientboundLevelChunkWithLightPacket packet = new ClientboundLevelChunkWithLightPacket(chunk, this.helper.serverWorld.m_5518_(), null, null, false);
                this.helper.serverWorld.m_7726_().f_8325_.m_183262_(chunk.m_7697_(), false).forEach(e -> e.f_8906_.m_141995_((Packet)packet));
            }
            this.helper.modifiedChunks.clear();
        }

        private void updateBlocks() {
            LogHelper.startTimer("Updating Blocks");
            try {
                LogHelper.dev("Updating " + this.helper.blocksToUpdate.size() + " Blocks");
                int i = 0;
                ArrayList list = new ArrayList();
                for (long pos : this.helper.blocksToUpdate) {
                    BlockState state = this.helper.serverWorld.m_8055_((BlockPos)this.mPos.m_122188_(pos));
                    if (state.m_60734_() instanceof FallingBlock) {
                        state.m_60734_().m_7458_(state, this.helper.serverWorld, (BlockPos)this.helper.mPos.m_122188_(pos), this.helper.serverWorld.f_46441_);
                    }
                    state.m_60690_((Level)this.helper.serverWorld, (BlockPos)this.mPos.m_122188_(pos), Blocks.f_50016_, this.mPos.m_122188_(pos).m_7494_(), false);
                }
                LogHelper.dev("Total Falling Blocks " + i);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            LogHelper.stopTimer();
        }

        public boolean isDead() {
            return this.isDead;
        }
    }
}

