/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.items.tools;

import com.brandon3055.brandonscore.api.hud.IHudItem;
import com.brandon3055.brandonscore.lib.DelayedTask;
import com.brandon3055.brandonscore.network.BCoreNetwork;
import com.brandon3055.brandonscore.utils.TargetPos;
import com.brandon3055.draconicevolution.handlers.DESounds;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.items.tools.DislocatorAdvanced;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.AnvilUpdateEvent;

public class Dislocator
extends Item
implements IHudItem {
    public Dislocator(Item.Properties properties) {
        super(properties.m_41486_());
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }

    public Entity dislocateEntity(ItemStack stack, @Nonnull Entity user, @Nonnull Entity target, TargetPos targetPos) {
        if (target.f_19853_.f_46443_) {
            return target;
        }
        if (targetPos == null) {
            this.messageUser(user, (Component)new TranslatableComponent("dislocate.draconicevolution.not_set").m_130940_(ChatFormatting.RED));
            return target;
        }
        BCoreNetwork.sendSound((Level)target.f_19853_, (BlockPos)target.m_142538_(), (SoundEvent)DESounds.portal, (SoundSource)SoundSource.PLAYERS, (float)0.1f, (float)(target.f_19853_.f_46441_.nextFloat() * 0.1f + 0.9f), (boolean)false);
        Entity finalTarget = target = targetPos.teleport(target);
        DelayedTask.run((int)1, () -> BCoreNetwork.sendSound((Level)finalTarget.f_19853_, (BlockPos)finalTarget.m_142538_(), (SoundEvent)DESounds.portal, (SoundSource)SoundSource.PLAYERS, (float)0.1f, (float)(finalTarget.f_19853_.f_46441_.nextFloat() * 0.1f + 0.9f), (boolean)false));
        return target;
    }

    public void messageUser(Entity user, Component message) {
        if (user instanceof Player) {
            ((Player)user).m_5661_(message, true);
        }
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        if (entity instanceof Player && !(this instanceof DislocatorAdvanced)) {
            this.messageUser((Entity)player, (Component)new TranslatableComponent("dislocate.draconicevolution.player_need_advanced").m_130940_(ChatFormatting.RED));
            return true;
        }
        if (player.f_19853_.f_46443_ || !entity.m_6072_() || !(entity instanceof LivingEntity) || player.m_36335_().m_41521_((Item)this, 0.0f) > 0.0f) {
            return true;
        }
        TargetPos location = this.getTargetPos(stack, player.f_19853_);
        player.m_36335_().m_41524_((Item)this, 20);
        this.dislocateEntity(stack, (Entity)player, entity, location);
        stack.m_41622_(1, (LivingEntity)player, e -> {});
        if (location != null) {
            this.messageUser((Entity)player, (Component)new TextComponent(I18n.m_118938_((String)"dislocate.draconicevolution.entity_sent_to", (Object[])new Object[0]) + " " + location.getReadableName(false)).m_130940_(ChatFormatting.GREEN));
        }
        return true;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (world.f_46443_) {
            return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
        }
        TargetPos targetPos = this.getTargetPos(stack, world);
        if (player.m_6144_()) {
            if (targetPos == null) {
                targetPos = new TargetPos((Entity)player);
                this.setLocation(stack, targetPos);
                this.messageUser((Entity)player, (Component)new TranslatableComponent("dislocate.draconicevolution.bound_to").m_130946_("{" + targetPos.getReadableName(false) + "}").m_130940_(ChatFormatting.GREEN));
            } else {
                this.messageUser((Entity)player, (Component)new TranslatableComponent("dislocate.draconicevolution.already_bound").m_130940_(ChatFormatting.RED));
            }
            return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
        }
        if (targetPos == null) {
            this.messageUser((Entity)player, (Component)new TranslatableComponent("dislocate.draconicevolution.not_set").m_130940_(ChatFormatting.RED));
            return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
        }
        if (player.m_21223_() > 2.0f || player.m_150110_().f_35937_) {
            player.m_36335_().m_41524_((Item)this, 20);
            this.dislocateEntity(stack, (Entity)player, (Entity)player, targetPos);
            stack.m_41622_(1, (LivingEntity)player, e -> {});
            if (!player.m_150110_().f_35937_) {
                player.m_21153_(player.m_21223_() - 2.0f);
            }
        } else {
            this.messageUser((Entity)player, (Component)new TranslatableComponent("dislocate.draconicevolution.low_health").m_130940_(ChatFormatting.RED));
        }
        return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
    }

    public boolean m_5812_(ItemStack stack) {
        return this.getTargetPos(stack, null) != null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag flagIn) {
        TargetPos targetPos = this.getTargetPos(stack, world);
        if (targetPos == null) {
            tooltip.add((Component)new TranslatableComponent("dislocate.draconicevolution.un_set_info1").m_130940_(ChatFormatting.RED));
            tooltip.add((Component)new TranslatableComponent("dislocate.draconicevolution.un_set_info2").m_130940_(ChatFormatting.WHITE));
            tooltip.add((Component)new TranslatableComponent("dislocate.draconicevolution.un_set_info3").m_130940_(ChatFormatting.WHITE));
            tooltip.add((Component)new TranslatableComponent("dislocate.draconicevolution.un_set_info4").m_130940_(ChatFormatting.WHITE));
            tooltip.add((Component)new TranslatableComponent("dislocate.draconicevolution.un_set_info5").m_130940_(ChatFormatting.WHITE));
        } else {
            tooltip.add((Component)new TranslatableComponent("dislocate.draconicevolution.bound_to").m_130940_(ChatFormatting.GREEN));
            tooltip.add((Component)new TextComponent(ChatFormatting.WHITE + "{" + targetPos.getReadableName(flagIn.m_7050_()) + "}"));
            tooltip.add((Component)new TranslatableComponent("dislocate.draconicevolution.uses_remain", new Object[]{stack.m_41776_() - stack.m_41773_() + 1}).m_130940_(ChatFormatting.BLUE));
        }
    }

    public TargetPos getTargetPos(ItemStack stack, @Nullable Level world) {
        CompoundTag targetTag = stack.m_41737_("target");
        if (targetTag != null) {
            return new TargetPos(targetTag);
        }
        return null;
    }

    public void setLocation(ItemStack stack, TargetPos pos) {
        stack.m_41700_("target", (Tag)pos.writeToNBT());
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return true;
    }

    public boolean m_6832_(ItemStack toRepair, ItemStack repair) {
        return repair.m_41720_() == DEContent.ingot_draconium;
    }

    public float getXpRepairRatio(ItemStack stack) {
        return 1.0f;
    }

    public void generateHudText(ItemStack stack, Player player, List<Component> displayList) {
        TargetPos location = this.getTargetPos(stack, player.f_19853_);
        if (location != null) {
            displayList.add(stack.m_41786_());
            displayList.add((Component)new TextComponent("{" + location.getReadableName(false) + ")"));
        }
    }

    public static void onAnvilUpdate(AnvilUpdateEvent event) {
        if (event.getLeft().m_41720_() == DEContent.dislocator && event.getRight().m_41720_() == DEContent.ingot_draconium && event.getLeft().m_41773_() > 0) {
            event.setOutput(event.getLeft().m_41777_());
            event.getOutput().m_41721_(0);
            event.setCost(1);
            event.setMaterialCost(1);
        }
    }

    public boolean m_41386_(DamageSource source) {
        return source == DamageSource.f_19317_;
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        if (entity.m_32059_() >= 0) {
            entity.m_32064_();
        }
        return super.onEntityItemUpdate(stack, entity);
    }
}

