/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.items.equipment;

import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.brandonscore.utils.EnergyUtils;
import com.brandon3055.brandonscore.utils.Utils;
import com.brandon3055.draconicevolution.api.IReaperItem;
import com.brandon3055.draconicevolution.api.capability.DECapabilities;
import com.brandon3055.draconicevolution.api.capability.ModuleHost;
import com.brandon3055.draconicevolution.api.modules.ModuleCategory;
import com.brandon3055.draconicevolution.api.modules.ModuleTypes;
import com.brandon3055.draconicevolution.api.modules.data.ProjectileData;
import com.brandon3055.draconicevolution.api.modules.data.SpeedData;
import com.brandon3055.draconicevolution.api.modules.entities.AutoFireEntity;
import com.brandon3055.draconicevolution.api.modules.lib.ModularOPStorage;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleHostImpl;
import com.brandon3055.draconicevolution.entity.projectile.DraconicArrowEntity;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.init.EquipCfg;
import com.brandon3055.draconicevolution.init.ModuleCfg;
import com.brandon3055.draconicevolution.init.TechProperties;
import com.brandon3055.draconicevolution.items.equipment.IModularItem;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.SpectralArrow;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;

public class ModularBow
extends BowItem
implements IReaperItem,
IModularItem {
    private final TechLevel techLevel;

    public ModularBow(TechProperties props) {
        super((Item.Properties)props);
        this.techLevel = props.getTechLevel();
    }

    @Override
    public TechLevel getTechLevel() {
        return this.techLevel;
    }

    @Override
    public ModuleHostImpl createHost(ItemStack stack) {
        ModuleHostImpl host = new ModuleHostImpl(this.techLevel, ModuleCfg.toolWidth(this.techLevel), ModuleCfg.toolHeight(this.techLevel), "bow", ModuleCfg.removeInvalidModules, new ModuleCategory[0]);
        host.addCategories(ModuleCategory.RANGED_WEAPON);
        return host;
    }

    @Override
    @Nullable
    public ModularOPStorage createOPStorage(ItemStack stack, ModuleHostImpl host) {
        return new ModularOPStorage(host, EquipCfg.getBaseToolEnergy(this.techLevel), EquipCfg.getBaseToolTransfer(this.techLevel));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        this.addModularItemInformation(stack, worldIn, tooltip, flagIn);
    }

    @Override
    public int getReaperLevel(ItemStack stack) {
        return this.techLevel.index;
    }

    public void onUsingTick(ItemStack stack, LivingEntity player, int count) {
        AutoFireEntity entity;
        if (this.m_8105_(stack) - count >= ModularBow.getChargeTicks(stack) && (entity = (AutoFireEntity)((ModuleHost)stack.getCapability(DECapabilities.MODULE_HOST_CAPABILITY).orElseThrow(IllegalStateException::new)).getEntitiesByType(ModuleTypes.AUTO_FIRE).map(e -> (AutoFireEntity)e).findAny().orElse(null)) != null && entity.getAutoFireEnabled()) {
            InteractionHand usingHand = player.m_7655_();
            player.m_5810_();
            stack.m_41674_(player.f_19853_, player, 0);
            player.m_6672_(usingHand);
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack;
        boolean hasAmmo = !player.m_6298_(stack = player.m_21120_(hand)).m_41619_() || EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44952_, (ItemStack)stack) > 0;
        InteractionResultHolder ret = ForgeEventFactory.onArrowNock((ItemStack)stack, (Level)world, (Player)player, (InteractionHand)hand, (boolean)hasAmmo);
        if (ret != null) {
            return ret;
        }
        if (EnergyUtils.getEnergyStored((ItemStack)stack) < ModularBow.calculateShotEnergy(stack)) {
            hasAmmo = false;
        }
        if (!player.m_150110_().f_35937_ && !hasAmmo) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        player.m_6672_(hand);
        return InteractionResultHolder.m_19096_((Object)stack);
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity entity, int timeLeft) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            boolean noAmmoRequired = player.m_150110_().f_35937_ || EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44952_, (ItemStack)stack) > 0;
            ItemStack ammoStack = player.m_6298_(stack);
            int drawTime = this.m_8105_(stack) - timeLeft;
            if ((drawTime = ForgeEventFactory.onArrowLoose((ItemStack)stack, (Level)level, (Player)player, (int)drawTime, (!ammoStack.m_41619_() || noAmmoRequired ? 1 : 0) != 0)) < 0) {
                return;
            }
            if (!ammoStack.m_41619_() || noAmmoRequired) {
                if (ammoStack.m_41619_()) {
                    ammoStack = new ItemStack((ItemLike)Items.f_42412_);
                }
                ModuleHost host = (ModuleHost)stack.getCapability(DECapabilities.MODULE_HOST_CAPABILITY).orElseThrow(IllegalStateException::new);
                ProjectileData projData = host.getModuleData(ModuleTypes.PROJ_MODIFIER, new ProjectileData(0.0f, 0.0f, 0.0f, 0.0f, 0.0f));
                float powerForTime = ModularBow.getPowerForTime(drawTime, stack) * (projData.velocity() + 1.0f);
                if ((double)powerForTime >= 0.1) {
                    boolean infiniteAmmo;
                    boolean bl = infiniteAmmo = player.m_150110_().f_35937_ || ammoStack.m_41720_() instanceof ArrowItem && ((ArrowItem)ammoStack.m_41720_()).isInfinite(ammoStack, stack, player);
                    if (!level.f_46443_) {
                        long energyRequired;
                        ArrowItem arrowitem = (ArrowItem)(ammoStack.m_41720_() instanceof ArrowItem ? ammoStack.m_41720_() : Items.f_42412_);
                        AbstractArrow arrowEntity = this.customArrow(arrowitem.m_6394_(level, ammoStack, (LivingEntity)player));
                        if (arrowEntity instanceof Arrow) {
                            ((Arrow)arrowEntity).m_36878_(ammoStack);
                        } else if (arrowEntity instanceof DraconicArrowEntity) {
                            ((DraconicArrowEntity)arrowEntity).setEffectsFromItem(ammoStack);
                        }
                        arrowEntity.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, powerForTime * 3.0f, 1.0f - projData.accuracy());
                        if (arrowEntity instanceof DraconicArrowEntity) {
                            DraconicArrowEntity deArrow = (DraconicArrowEntity)arrowEntity;
                            deArrow.setTechLevel(this.techLevel);
                            deArrow.setPenetration(projData.penetration());
                            deArrow.setGravComp(projData.antiGrav());
                            if (host.getEntitiesByType(ModuleTypes.PROJ_ANTI_IMMUNE).findAny().isPresent()) {
                                deArrow.setProjectileImmuneOverride(true);
                            }
                        }
                        if (powerForTime == 1.0f) {
                            arrowEntity.m_36762_(true);
                        }
                        arrowEntity.m_36781_(arrowEntity.m_36789_() * (double)(projData.damage() + 1.0f));
                        int j = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44988_, (ItemStack)stack);
                        if (j > 0) {
                            arrowEntity.m_36781_(arrowEntity.m_36789_() + (double)j * 0.5 + 0.5);
                        }
                        if (this.extractEnergy(player, stack, energyRequired = (long)((double)EquipCfg.bowBaseEnergy * arrowEntity.m_36789_() * (double)powerForTime * 3.0)) < energyRequired) {
                            return;
                        }
                        int k = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44989_, (ItemStack)stack);
                        if (k > 0) {
                            arrowEntity.m_36735_(k);
                        }
                        if (EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44990_, (ItemStack)stack) > 0) {
                            arrowEntity.m_20254_(100);
                        }
                        if (infiniteAmmo) {
                            arrowEntity.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
                        }
                        level.m_7967_((Entity)arrowEntity);
                    }
                    level.m_6263_((Player)null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11687_, SoundSource.PLAYERS, 1.0f, 1.0f / (level.f_46441_.nextFloat() * 0.4f + 1.2f) + powerForTime * 0.5f);
                    if (!infiniteAmmo && !player.m_150110_().f_35937_) {
                        ammoStack.m_41774_(1);
                        if (ammoStack.m_41619_()) {
                            player.m_150109_().m_36057_(ammoStack);
                        }
                    }
                    player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                }
            }
        }
    }

    public AbstractArrow customArrow(AbstractArrow arrow) {
        if (arrow.m_6095_() != EntityType.f_20548_ && arrow.m_6095_() != EntityType.f_20478_) {
            return arrow;
        }
        Entity owner = arrow.m_37282_();
        if (!(owner instanceof LivingEntity)) {
            return new DraconicArrowEntity(DEContent.draconicArrow, arrow.f_19853_);
        }
        DraconicArrowEntity newArrow = new DraconicArrowEntity(arrow.f_19853_, (LivingEntity)arrow.m_37282_());
        if (arrow instanceof SpectralArrow) {
            newArrow.setSpectral(((SpectralArrow)arrow).f_37409_);
        }
        return newArrow;
    }

    public static float calculateDamage(ItemStack stack) {
        ModuleHost host = (ModuleHost)stack.getCapability(DECapabilities.MODULE_HOST_CAPABILITY).orElseThrow(IllegalStateException::new);
        ProjectileData projData = host.getModuleData(ModuleTypes.PROJ_MODIFIER, new ProjectileData(0.0f, 0.0f, 0.0f, 0.0f, 0.0f));
        float baseDamage = 2.0f;
        baseDamage *= 1.0f + projData.damage();
        baseDamage *= 3.0f * (1.0f + projData.velocity());
        int j = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44988_, (ItemStack)stack);
        if (j > 0) {
            baseDamage = (float)((double)baseDamage + ((double)j * 0.5 + 0.5));
        }
        return baseDamage;
    }

    public static long calculateShotEnergy(ItemStack stack) {
        float damage = ModularBow.calculateDamage(stack);
        return (long)(damage * (float)EquipCfg.bowBaseEnergy);
    }

    public static float getPowerForTime(int time, ItemStack stack) {
        float fullChargeTime = ModularBow.getChargeTicks(stack);
        float power = (float)time / fullChargeTime;
        if ((power = (power * power + power * 2.0f) / 3.0f) > 1.0f) {
            power = 1.0f;
        }
        return power;
    }

    public static int getChargeTicks(ItemStack stack) {
        ModuleHost host = (ModuleHost)stack.getCapability(DECapabilities.MODULE_HOST_CAPABILITY).orElseThrow(IllegalStateException::new);
        SpeedData data = host.getModuleData(ModuleTypes.SPEED);
        float speedModifier = data == null ? 0.0f : (float)data.speedMultiplier();
        return (int)Math.ceil(20.0f / (speedModifier += 1.0f));
    }

    @Override
    public void addModularItemInformation(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        IModularItem.super.addModularItemInformation(stack, worldIn, tooltip, flagIn);
        if (worldIn != null && stack.getCapability(DECapabilities.MODULE_HOST_CAPABILITY).isPresent()) {
            tooltip.add((Component)new TranslatableComponent("tooltip.draconicevolution.bow.damage", new Object[]{Float.valueOf((float)Math.round(ModularBow.calculateDamage(stack) * 10.0f) / 10.0f)}).m_130940_(ChatFormatting.DARK_GREEN));
            tooltip.add((Component)new TranslatableComponent("tooltip.draconicevolution.bow.energy_per_shot", new Object[]{Utils.addCommas((long)ModularBow.calculateShotEnergy(stack))}).m_130940_(ChatFormatting.DARK_GREEN));
        }
    }

    public boolean m_142522_(ItemStack stack) {
        return this.damageBarVisible(stack);
    }

    public int m_142158_(ItemStack stack) {
        return this.damageBarWidth(stack);
    }

    public int m_142159_(ItemStack stack) {
        return this.damageBarColour(stack);
    }

    public boolean m_41386_(DamageSource source) {
        return source == DamageSource.f_19317_;
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        if (entity.m_32059_() >= 0) {
            entity.m_32064_();
        }
        return super.onEntityItemUpdate(stack, entity);
    }

    public boolean m_8120_(ItemStack p_41456_) {
        return true;
    }
}

