/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.items.equipment;

import codechicken.lib.inventory.InventoryUtils;
import codechicken.lib.raytracer.RayTracer;
import com.brandon3055.brandonscore.inventory.BlockToStackHelper;
import com.brandon3055.brandonscore.inventory.InventoryDynamic;
import com.brandon3055.brandonscore.lib.Pair;
import com.brandon3055.brandonscore.utils.EnergyUtils;
import com.brandon3055.draconicevolution.api.capability.DECapabilities;
import com.brandon3055.draconicevolution.api.capability.ModuleHost;
import com.brandon3055.draconicevolution.api.capability.PropertyProvider;
import com.brandon3055.draconicevolution.api.modules.ModuleHelper;
import com.brandon3055.draconicevolution.api.modules.ModuleTypes;
import com.brandon3055.draconicevolution.api.modules.data.AOEData;
import com.brandon3055.draconicevolution.init.EquipCfg;
import com.brandon3055.draconicevolution.items.equipment.IModularTieredItem;
import java.util.List;
import java.util.Random;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.network.protocol.game.ServerboundPlayerActionPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.ForgeHooks;

public interface IModularMiningTool
extends IModularTieredItem {
    public static final Random rand = new Random();

    default public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, Player player) {
        if (this.getEnergyStored(stack) < (long)EquipCfg.energyHarvest && !player.m_150110_().f_35937_) {
            return false;
        }
        ModuleHost host = (ModuleHost)stack.getCapability(DECapabilities.MODULE_HOST_CAPABILITY).orElseThrow(IllegalStateException::new);
        int aoe = host.getModuleData(ModuleTypes.AOE, new AOEData(0)).aoe();
        boolean aoeSafe = false;
        if (host instanceof PropertyProvider) {
            if (((PropertyProvider)((Object)host)).hasInt("mining_aoe")) {
                aoe = ((PropertyProvider)((Object)host)).getInt("mining_aoe").getValue();
            }
            if (((PropertyProvider)((Object)host)).hasBool("aoe_safe")) {
                aoeSafe = ((PropertyProvider)((Object)host)).getBool("aoe_safe").getValue();
            }
        }
        return this.breakAOEBlocks(host, stack, pos, aoe, 0, player, aoeSafe);
    }

    default public boolean breakAOEBlocks(ModuleHost host, ItemStack stack, BlockPos pos, int breakRadius, int breakDepth, Player player, boolean aoeSafe) {
        BlockState blockState = player.f_19853_.m_8055_(pos);
        if (!this.isCorrectToolForDrops(stack, blockState)) {
            return false;
        }
        InventoryDynamic inventoryDynamic = new InventoryDynamic();
        float refStrength = IModularMiningTool.blockStrength(blockState, player, player.f_19853_, pos);
        Pair<BlockPos, BlockPos> aoe = this.getMiningArea(pos, player, breakRadius, breakDepth);
        List<BlockPos> aoeBlocks = BlockPos.m_121990_((BlockPos)((BlockPos)aoe.key()), (BlockPos)((BlockPos)aoe.value())).map(BlockPos::new).toList();
        if (aoeSafe) {
            for (BlockPos block2 : aoeBlocks) {
                if (player.f_19853_.m_46859_(block2) || player.f_19853_.m_7702_(block2) == null) continue;
                if (player.f_19853_.f_46443_) {
                    player.m_6352_((Component)new TranslatableComponent("item_prop.draconicevolution.aoe_safe.blocked"), Util.f_137441_);
                } else {
                    ((ServerPlayer)player).f_8906_.m_141995_((Packet)new ClientboundBlockUpdatePacket((BlockGetter)((ServerPlayer)player).f_19853_, block2));
                }
                return true;
            }
        }
        aoeBlocks.forEach(block -> this.breakAOEBlock(stack, player.f_19853_, (BlockPos)block, player, refStrength, inventoryDynamic, rand.nextInt(Math.max(5, breakRadius * breakDepth / 5)) == 0));
        List items = player.f_19853_.m_45976_(ItemEntity.class, new AABB((BlockPos)aoe.key(), ((BlockPos)aoe.value()).m_142082_(1, 1, 1)));
        for (ItemEntity item : items) {
            if (player.f_19853_.f_46443_ || !item.m_6084_()) continue;
            InventoryUtils.insertItem((Container)inventoryDynamic, (ItemStack)item.m_32055_(), (boolean)false);
            item.m_146870_();
        }
        ModuleHelper.handleItemCollection(player, host, EnergyUtils.getStorage((ItemStack)stack), inventoryDynamic);
        return true;
    }

    public static float blockStrength(BlockState state, Player player, Level world, BlockPos pos) {
        float hardness = state.m_60800_((BlockGetter)world, pos);
        if (hardness < 0.0f) {
            return 0.0f;
        }
        if (!ForgeHooks.isCorrectToolForDrops((BlockState)state, (Player)player)) {
            return player.getDigSpeed(state, pos) / hardness / 100.0f;
        }
        return player.getDigSpeed(state, pos) / hardness / 30.0f;
    }

    default public Pair<BlockPos, BlockPos> getMiningArea(BlockPos pos, Player player, int breakRadius, int breakDepth) {
        BlockHitResult traceResult = RayTracer.retrace((Player)player);
        if (traceResult.m_6662_() == HitResult.Type.MISS) {
            return new Pair((Object)pos, (Object)pos);
        }
        int sideHit = traceResult.m_82434_().m_122411_();
        int xMax = breakRadius;
        int xMin = breakRadius;
        int yMax = breakRadius;
        int yMin = breakRadius;
        int zMax = breakRadius;
        int zMin = breakRadius;
        int yOffset = 0;
        switch (sideHit) {
            case 0: {
                yMax = breakDepth;
                yMin = 0;
                zMax = breakRadius;
                break;
            }
            case 1: {
                yMin = breakDepth;
                yMax = 0;
                zMax = breakRadius;
                break;
            }
            case 2: {
                xMax = breakRadius;
                zMin = 0;
                zMax = breakDepth;
                yOffset = breakRadius - 1;
                break;
            }
            case 3: {
                xMax = breakRadius;
                zMax = 0;
                zMin = breakDepth;
                yOffset = breakRadius - 1;
                break;
            }
            case 4: {
                xMax = breakDepth;
                xMin = 0;
                zMax = breakRadius;
                yOffset = breakRadius - 1;
                break;
            }
            case 5: {
                xMin = breakDepth;
                xMax = 0;
                zMax = breakRadius;
                yOffset = breakRadius - 1;
            }
        }
        if (breakRadius == 0) {
            yOffset = 0;
        }
        return new Pair((Object)pos.m_142082_(-xMin, yOffset - yMin, -zMin), (Object)pos.m_142082_(xMax, yOffset + yMax, zMax));
    }

    default public void breakAOEBlock(ItemStack stack, Level world, BlockPos pos, Player player, float refStrength, InventoryDynamic inventory, boolean breakFX) {
        if (world.m_46859_(pos)) {
            return;
        }
        BlockState state = world.m_8055_(pos);
        FluidState fluidState = world.m_6425_(pos);
        Block block = state.m_60734_();
        if (!this.isCorrectToolForDrops(stack, state)) {
            return;
        }
        float strength = IModularMiningTool.blockStrength(state, player, world, pos);
        if (!ForgeHooks.isCorrectToolForDrops((BlockState)state, (Player)player) || refStrength / strength > 10.0f) {
            return;
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            int xp = ForgeHooks.onBlockBreakEvent((Level)world, (GameType)serverPlayer.f_8941_.m_9290_(), (ServerPlayer)((ServerPlayer)player), (BlockPos)pos);
            if (xp == -1) {
                ServerPlayer mpPlayer = (ServerPlayer)player;
                mpPlayer.f_8906_.m_141995_((Packet)new ClientboundBlockUpdatePacket((BlockGetter)world, pos));
                return;
            }
            if (player.m_150110_().f_35937_) {
                if (block.onDestroyedByPlayer(state, world, pos, player, false, fluidState)) {
                    block.m_6786_((LevelAccessor)world, pos, state);
                }
            } else {
                stack.m_41686_(world, state, pos, player);
                BlockToStackHelper.breakAndCollectWithPlayer((Level)world, (BlockPos)pos, (InventoryDynamic)inventory, (Player)player, (int)xp);
                this.extractEnergy(player, stack, EquipCfg.energyHarvest);
            }
        } else {
            if (block.onDestroyedByPlayer(state, world, pos, player, true, fluidState)) {
                block.m_6786_((LevelAccessor)world, pos, state);
            }
            stack.m_41686_(world, state, pos, player);
            if (Minecraft.m_91087_().f_91077_ instanceof BlockHitResult) {
                Minecraft.m_91087_().m_91403_().m_104955_((Packet)new ServerboundPlayerActionPacket(ServerboundPlayerActionPacket.Action.STOP_DESTROY_BLOCK, pos, ((BlockHitResult)Minecraft.m_91087_().f_91077_).m_82434_()));
            }
        }
    }
}

