/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.items.equipment;

import codechicken.lib.math.MathHelper;
import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.brandonscore.api.power.IOPStorage;
import com.brandon3055.brandonscore.capability.MultiCapabilityProvider;
import com.brandon3055.brandonscore.utils.EnergyUtils;
import com.brandon3055.draconicevolution.api.capability.DECapabilities;
import com.brandon3055.draconicevolution.api.capability.ModuleHost;
import com.brandon3055.draconicevolution.api.capability.PropertyProvider;
import com.brandon3055.draconicevolution.api.config.BooleanProperty;
import com.brandon3055.draconicevolution.api.config.ConfigProperty;
import com.brandon3055.draconicevolution.api.config.DecimalProperty;
import com.brandon3055.draconicevolution.api.config.IntegerProperty;
import com.brandon3055.draconicevolution.api.crafting.IFusionDataTransfer;
import com.brandon3055.draconicevolution.api.event.ModularItemInitEvent;
import com.brandon3055.draconicevolution.api.modules.ModuleCategory;
import com.brandon3055.draconicevolution.api.modules.ModuleTypes;
import com.brandon3055.draconicevolution.api.modules.data.AOEData;
import com.brandon3055.draconicevolution.api.modules.data.SpeedData;
import com.brandon3055.draconicevolution.api.modules.lib.ModularOPStorage;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleHostImpl;
import com.brandon3055.draconicevolution.api.modules.lib.StackModuleContext;
import com.brandon3055.draconicevolution.client.keybinding.KeyBindings;
import com.brandon3055.draconicevolution.init.EquipCfg;
import com.brandon3055.draconicevolution.items.equipment.IModularArmor;
import com.brandon3055.draconicevolution.items.equipment.IModularMelee;
import com.brandon3055.draconicevolution.items.equipment.IModularMiningTool;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.extensions.IForgeItem;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.eventbus.api.Event;

public interface IModularItem
extends IForgeItem,
IFusionDataTransfer {
    public TechLevel getTechLevel();

    default public MultiCapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        if (DECapabilities.MODULE_HOST_CAPABILITY == null || DECapabilities.PROPERTY_PROVIDER_CAPABILITY == null || DECapabilities.OP_STORAGE == null) {
            return null;
        }
        MultiCapabilityProvider provider = new MultiCapabilityProvider();
        ModuleHostImpl host = this.createHost(stack);
        provider.addCapability((INBTSerializable)host, "module_host", new Capability[]{DECapabilities.MODULE_HOST_CAPABILITY, DECapabilities.PROPERTY_PROVIDER_CAPABILITY});
        ModularOPStorage opStorage = this.createOPStorage(stack, host);
        if (opStorage != null) {
            provider.addCapability((INBTSerializable)opStorage, "energy", new Capability[]{DECapabilities.OP_STORAGE, CapabilityEnergy.ENERGY});
            host.addCategories(ModuleCategory.ENERGY);
        }
        if (this instanceof IModularMiningTool) {
            host.addCategories(ModuleCategory.MINING_TOOL);
            host.addPropertyBuilder(props -> {
                props.add(new DecimalProperty("mining_speed", 1.0).range(0.0, 1.0).setFormatter(ConfigProperty.DecimalFormatter.PERCENT_1));
                AOEData aoe = host.getModuleData(ModuleTypes.AOE);
                if (aoe != null) {
                    props.add(new IntegerProperty("mining_aoe", aoe.aoe()).range(0, aoe.aoe()).setFormatter(ConfigProperty.IntegerFormatter.AOE));
                    props.add(new BooleanProperty("aoe_safe", false).setFormatter(ConfigProperty.BooleanFormatter.ENABLED_DISABLED));
                }
            });
        }
        if (this instanceof IModularMelee) {
            host.addCategories(ModuleCategory.MELEE_WEAPON);
            host.addPropertyBuilder(props -> {
                AOEData aoe = host.getModuleData(ModuleTypes.AOE);
                if (aoe != null) {
                    props.add(new DecimalProperty("attack_aoe", (double)aoe.aoe() * 1.5).range(0.0, (double)aoe.aoe() * 1.5).setFormatter(ConfigProperty.DecimalFormatter.AOE_1));
                }
            });
        }
        this.initCapabilities(stack, host, provider);
        MinecraftForge.EVENT_BUS.post((Event)new ModularItemInitEvent(stack, host, host));
        return provider;
    }

    default public void initCapabilities(ItemStack stack, ModuleHostImpl host, MultiCapabilityProvider provider) {
    }

    public ModuleHostImpl createHost(ItemStack var1);

    @Nullable
    public ModularOPStorage createOPStorage(ItemStack var1, ModuleHostImpl var2);

    @OnlyIn(value=Dist.CLIENT)
    default public void addModularItemInformation(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (!Screen.m_96638_()) {
            tooltip.add((Component)new TranslatableComponent("[Modular Item]").m_130940_(ChatFormatting.BLUE));
        }
        if (DECapabilities.MODULE_HOST_CAPABILITY != null) {
            LazyOptional opt = stack.getCapability(DECapabilities.MODULE_HOST_CAPABILITY);
            opt.ifPresent(host -> host.getModuleEntities().forEach(e -> e.addHostHoverText(stack, worldIn, tooltip, flagIn)));
            opt.ifPresent(host -> host.getInstalledTypes().map(host::getModuleData).filter(Objects::nonNull).forEach(data -> data.addHostHoverText(stack, worldIn, tooltip, flagIn)));
        }
        EnergyUtils.addEnergyInfo((ItemStack)stack, tooltip);
        if (EnergyUtils.isEnergyItem((ItemStack)stack) && EnergyUtils.getMaxEnergyStored((ItemStack)stack) == 0L) {
            tooltip.add((Component)new TranslatableComponent("modular_item.draconicevolution.requires_energy").m_130940_(ChatFormatting.RED));
            if (KeyBindings.toolModules != null && KeyBindings.toolModules.m_90863_() != null) {
                tooltip.add((Component)new TranslatableComponent("modular_item.draconicevolution.requires_energy_press", new Object[]{KeyBindings.toolModules.m_90863_().getString()}).m_130940_(ChatFormatting.BLUE));
            }
        }
    }

    default public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        HashMultimap map = HashMultimap.create();
        return map;
    }

    default public void handleTick(ItemStack stack, LivingEntity entity, @Nullable EquipmentSlot slot, boolean inEquipModSlot) {
        ModuleHost host = (ModuleHost)stack.getCapability(DECapabilities.MODULE_HOST_CAPABILITY).orElseThrow(IllegalStateException::new);
        StackModuleContext context = new StackModuleContext(stack, entity, slot).setInEquipModSlot(inEquipModSlot);
        host.handleTick(context);
    }

    default public boolean isEquipped(ItemStack stack, @Nullable EquipmentSlot slot, boolean inEquipSlot) {
        if (this instanceof IModularArmor) {
            return slot != null && slot.m_20743_() == EquipmentSlot.Type.ARMOR || inEquipSlot;
        }
        return true;
    }

    default public float getDestroySpeed(ItemStack stack, BlockState state) {
        ModuleHost host = (ModuleHost)stack.getCapability(DECapabilities.MODULE_HOST_CAPABILITY).orElseThrow(IllegalStateException::new);
        SpeedData data = host.getModuleData(ModuleTypes.SPEED);
        float moduleValue = data == null ? 0.0f : (float)data.speedMultiplier();
        float multiplier = MathHelper.map((float)((moduleValue + 1.0f) * (moduleValue + 1.0f)), (float)1.0f, (float)2.0f, (float)1.0f, (float)1.65f);
        float propVal = 1.0f;
        if (host instanceof PropertyProvider && ((PropertyProvider)((Object)host)).hasDecimal("mining_speed")) {
            propVal = (float)((PropertyProvider)((Object)host)).getDecimal("mining_speed").getValue();
            propVal *= propVal;
        }
        float aoe = host.getModuleData(ModuleTypes.AOE, new AOEData(0)).aoe();
        if (host instanceof PropertyProvider && ((PropertyProvider)((Object)host)).hasInt("mining_aoe")) {
            aoe = ((PropertyProvider)((Object)host)).getInt("mining_aoe").getValue();
        }
        if (this.getEnergyStored(stack) < (long)EquipCfg.energyHarvest) {
            multiplier = 0.0f;
        } else if (aoe > 0.0f) {
            float userTarget = multiplier * propVal;
            multiplier = Math.min(userTarget, multiplier / (1.0f + aoe * 10.0f));
        } else {
            multiplier *= propVal;
        }
        if (this.isCorrectToolForDrops(stack, state) && (multiplier > 0.0f || propVal == 0.0f)) {
            return this.getBaseEfficiency() * multiplier;
        }
        return propVal == 0.0f ? 0.0f : 1.0f;
    }

    default public boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        return super.isCorrectToolForDrops(stack, state);
    }

    default public float getBaseEfficiency() {
        return 1.0f;
    }

    @Nullable
    default public CompoundTag getShareTag(ItemStack stack) {
        return DECapabilities.writeToShareTag(stack, stack.m_41783_());
    }

    default public void readShareTag(ItemStack stack, @Nullable CompoundTag nbt) {
        stack.m_41751_(nbt);
        DECapabilities.readFromShareTag(stack, nbt);
    }

    default public long getEnergyStored(ItemStack stack) {
        return EnergyUtils.getEnergyStored((ItemStack)stack);
    }

    default public long extractEnergy(Player player, ItemStack stack, long amount) {
        if (player != null && player.m_150110_().f_35937_) {
            return amount;
        }
        IOPStorage storage = EnergyUtils.getStorage((ItemStack)stack);
        if (storage != null) {
            return storage.modifyEnergyStored(-amount);
        }
        return 0L;
    }

    default public boolean damageBarVisible(ItemStack stack) {
        long max = EnergyUtils.getMaxEnergyStored((ItemStack)stack);
        return max > 0L && EnergyUtils.getEnergyStored((ItemStack)stack) < max;
    }

    default public int damageBarWidth(ItemStack stack) {
        float charge = (float)EnergyUtils.getEnergyStored((ItemStack)stack) / (float)EnergyUtils.getMaxEnergyStored((ItemStack)stack);
        return Math.round(13.0f * charge);
    }

    default public int damageBarColour(ItemStack stack) {
        float maxEnergy = EnergyUtils.getMaxEnergyStored((ItemStack)stack);
        float energy = EnergyUtils.getEnergyStored((ItemStack)stack);
        float f = Math.max(0.0f, energy / maxEnergy);
        return Mth.m_14169_((float)(f / 3.0f), (float)1.0f, (float)1.0f);
    }

    default public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return oldStack.m_41720_() != newStack.m_41720_() || slotChanged;
    }
}

