/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.inventory;

import codechicken.lib.math.MathHelper;
import com.brandon3055.draconicevolution.blocks.reactor.tileentity.TileReactorCore;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.inventory.ContainerDETile;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class ContainerReactor
extends ContainerDETile<TileReactorCore> {
    public boolean fuelSlots = false;

    public ContainerReactor(int windowId, Inventory playerInv, FriendlyByteBuf extraData) {
        this(DEContent.container_reactor, windowId, playerInv, (TileReactorCore)ContainerReactor.getClientTile((FriendlyByteBuf)extraData));
    }

    public ContainerReactor(@Nullable MenuType<?> type, int windowId, Inventory player, TileReactorCore tile) {
        super(type, windowId, player, tile);
    }

    public void setSlotState() {
        this.fuelSlots = ((TileReactorCore)this.tile).reactorState.get() == TileReactorCore.ReactorState.COLD;
        this.f_38839_.clear();
        this.f_38841_.clear();
        if (this.fuelSlots) {
            int x;
            this.addPlayerSlots(13, 140);
            for (x = 0; x < 3; ++x) {
                this.m_38897_(new SlotReactor((TileReactorCore)this.tile, x, 183 + x * 18, 149));
            }
            for (x = 0; x < 3; ++x) {
                this.m_38897_(new SlotReactor((TileReactorCore)this.tile, 3 + x, 183 + x * 18, 180));
            }
        }
    }

    public void m_38946_() {
        super.m_38946_();
        if (((TileReactorCore)this.tile).reactorState.get() == TileReactorCore.ReactorState.COLD != this.fuelSlots) {
            this.setSlotState();
        }
    }

    @Override
    @Nullable
    public void m_150399_(int slotId, int dragType, ClickType clickTypeIn, Player player) {
        int maxFuel = 10383;
        int installedFuel = (int)(((TileReactorCore)this.tile).reactableFuel.get() + ((TileReactorCore)this.tile).convertedFuel.get());
        int free = maxFuel - installedFuel;
        Slot slot = this.m_38853_(slotId);
        if (slot instanceof SlotReactor && clickTypeIn == ClickType.PICKUP) {
            ItemStack stackInSlot = slot.m_7993_();
            ItemStack heldStack = player.f_36096_.m_142621_();
            if (!heldStack.m_41619_()) {
                ItemStack copy = heldStack.m_41777_();
                copy.m_41764_(1);
                int value = this.getFuelValue(copy);
                if (value > 0) {
                    int maxInsert = free / value;
                    int insert = Math.min(Math.min(heldStack.m_41613_(), maxInsert), dragType == 1 ? 1 : 64);
                    ((TileReactorCore)this.tile).reactableFuel.add((double)(insert * value));
                    heldStack.m_41774_(insert);
                } else {
                    value = this.getChaosValue(copy);
                    if (value > 0) {
                        int maxInsert = free / value;
                        int insert = Math.min(Math.min(heldStack.m_41613_(), maxInsert), dragType == 1 ? 1 : 64);
                        ((TileReactorCore)this.tile).convertedFuel.add((double)(insert * value));
                        heldStack.m_41774_(insert);
                    }
                }
                if (heldStack.m_41613_() <= 0) {
                    player.f_36096_.m_142503_(ItemStack.f_41583_);
                }
            } else if (!stackInSlot.m_41619_()) {
                ((TileReactorCore)this.tile).reactableFuel.subtract((double)this.getFuelValue(stackInSlot));
                ((TileReactorCore)this.tile).convertedFuel.subtract((double)this.getChaosValue(stackInSlot));
                player.f_36096_.m_142503_(stackInSlot);
            }
            return;
        }
        if (slotId <= 35) {
            super.m_150399_(slotId, dragType, clickTypeIn, player);
        }
    }

    private int getFuelValue(ItemStack stack) {
        if (stack.m_41619_()) {
            return 0;
        }
        if (stack.m_41720_() == DEContent.block_draconium_awakened.m_5456_()) {
            return stack.m_41613_() * 1296;
        }
        if (stack.m_41720_() == DEContent.ingot_draconium_awakened) {
            return stack.m_41613_() * 144;
        }
        if (stack.m_41720_() == DEContent.nugget_draconium_awakened) {
            return stack.m_41613_() * 16;
        }
        return 0;
    }

    private int getChaosValue(ItemStack stack) {
        if (stack.m_41619_()) {
            return 0;
        }
        if (stack.m_41720_() == DEContent.chaos_frag_large) {
            return stack.m_41613_() * 1296;
        }
        if (stack.m_41720_() == DEContent.chaos_frag_medium) {
            return stack.m_41613_() * 144;
        }
        if (stack.m_41720_() == DEContent.chaos_frag_small) {
            return stack.m_41613_() * 16;
        }
        return 0;
    }

    public static class SlotReactor
    extends Slot {
        private static Container emptyInventory = new SimpleContainer(0);
        private final TileReactorCore tile;

        public SlotReactor(TileReactorCore tile, int index, int xPosition, int yPosition) {
            super(emptyInventory, index, xPosition, yPosition);
            this.tile = tile;
        }

        public void m_40234_(ItemStack before, ItemStack after) {
            int i;
            if (!before.m_41619_() && !after.m_41619_() && before.m_41720_() == after.m_41720_() && (i = after.m_41613_() - before.m_41613_()) > 0) {
                this.m_7169_(before, i);
            }
        }

        public boolean m_5857_(@Nullable ItemStack stack) {
            return false;
        }

        @Nullable
        public ItemStack m_7993_() {
            int index = this.getSlotIndex();
            if (index < 3) {
                int fuel = MathHelper.floor((double)this.tile.reactableFuel.get());
                int block = fuel / 1296;
                int ingot = fuel % 1296 / 144;
                int nugget = fuel % 1296 % 144 / 16;
                if (index == 0 && block > 0) {
                    return new ItemStack((ItemLike)DEContent.block_draconium_awakened, block);
                }
                if (index == 1 && ingot > 0) {
                    return new ItemStack((ItemLike)DEContent.ingot_draconium_awakened, ingot);
                }
                if (index == 2 && nugget > 0) {
                    return new ItemStack((ItemLike)DEContent.nugget_draconium_awakened, nugget);
                }
            } else {
                int chaos = MathHelper.floor((double)this.tile.convertedFuel.get());
                int block = chaos / 1296;
                int ingot = chaos % 1296 / 144;
                int nugget = chaos % 1296 % 144 / 16;
                if (index == 3 && block > 0) {
                    return new ItemStack((ItemLike)DEContent.chaos_frag_large, block);
                }
                if (index == 4 && ingot > 0) {
                    return new ItemStack((ItemLike)DEContent.chaos_frag_medium, ingot);
                }
                if (index == 5 && nugget > 0) {
                    return new ItemStack((ItemLike)DEContent.chaos_frag_small, nugget);
                }
            }
            return ItemStack.f_41583_;
        }

        public void m_5852_(@Nonnull ItemStack stack) {
            this.m_6654_();
        }

        public void m_6654_() {
            this.tile.m_6596_();
        }

        public int m_6641_() {
            return 64;
        }

        public ItemStack m_6201_(int amount) {
            return ItemStack.f_41583_;
        }
    }
}

