/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.inventory;

import com.brandon3055.brandonscore.inventory.ContainerBCore;
import com.brandon3055.brandonscore.inventory.ContainerSlotLayout;
import com.brandon3055.brandonscore.inventory.PlayerSlot;
import com.brandon3055.brandonscore.lib.Pair;
import com.brandon3055.draconicevolution.api.capability.DECapabilities;
import com.brandon3055.draconicevolution.api.capability.PropertyProvider;
import com.brandon3055.draconicevolution.api.config.ConfigProperty;
import com.brandon3055.draconicevolution.client.gui.modular.itemconfig.PropertyData;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.integration.equipment.EquipmentManager;
import com.brandon3055.draconicevolution.inventory.GuiLayoutFactories;
import com.brandon3055.draconicevolution.lib.WTFException;
import com.google.common.collect.Streams;
import io.netty.buffer.ByteBuf;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.network.NetworkHooks;

public class ContainerConfigurableItem
extends ContainerBCore<Object> {
    private static final UUID DEFAULT_UUID = UUID.fromString("d12b41e3-16ce-4653-ab36-1cd913719af8");
    private UUID selectedId;
    private Runnable onInventoryChange;
    private Consumer<Boolean> onSelectionMade;
    private ItemStack stackCache = ItemStack.f_41583_;
    private boolean initialSync = false;
    private UUID lastSelected = null;

    public ContainerConfigurableItem(int windowId, Inventory player, FriendlyByteBuf extraData, ContainerSlotLayout.LayoutFactory<Object> factory) {
        super(DEContent.container_configurable_item, windowId, player, extraData, factory);
        PlayerSlot slot = PlayerSlot.fromBuff((ByteBuf)extraData);
        UUID found = this.getProviderID(slot.getStackInSlot(player.f_35978_));
        if (found != null) {
            this.stackCache = slot.getStackInSlot(player.f_35978_);
        }
        this.selectedId = found == null ? DEFAULT_UUID : found;
    }

    public ContainerConfigurableItem(int windowId, Inventory player, PlayerSlot itemSlot, ContainerSlotLayout.LayoutFactory<Object> factory) {
        super(DEContent.container_configurable_item, windowId, player, factory);
        this.sanitizeProviders();
        UUID found = this.getProviderID(itemSlot.getStackInSlot(player.f_35978_));
        if (found != null) {
            this.stackCache = itemSlot.getStackInSlot(player.f_35978_);
        }
        this.selectedId = found == null ? DEFAULT_UUID : found;
    }

    private Stream<ItemStack> getInventoryStacks() {
        return this.f_38839_.stream().map(Slot::m_7993_).filter(stack -> !stack.m_41619_());
    }

    public void setOnInventoryChange(Runnable onInventoryChange) {
        this.onInventoryChange = onInventoryChange;
    }

    public void setSelectionListener(Consumer<Boolean> onSelectionMade) {
        this.onSelectionMade = onSelectionMade;
    }

    public static Stream<PropertyProvider> getProviders(Stream<ItemStack> stacks) {
        return stacks.map(e -> e.getCapability(DECapabilities.PROPERTY_PROVIDER_CAPABILITY)).filter(LazyOptional::isPresent).map(e -> (PropertyProvider)e.orElseThrow(WTFException::new));
    }

    public PropertyProvider findProvider(UUID providerID) {
        return ContainerConfigurableItem.getProviders(this.getInventoryStacks()).filter(provider -> provider.getProviderID().equals(providerID)).findFirst().orElse(null);
    }

    private void sanitizeProviders() {
        HashSet uuids = new HashSet();
        ContainerConfigurableItem.getProviders(this.getInventoryStacks()).filter(provider -> !uuids.add(provider.getProviderID())).forEach(PropertyProvider::regenProviderID);
    }

    public void m_150399_(int slotId, int button, ClickType clickTypeIn, Player player) {
        LazyOptional optionalCap;
        Slot slot;
        if (slotId >= 0 && slotId < this.f_38839_.size() && (slot = (Slot)this.f_38839_.get(slotId)) != null && !slot.m_7993_().m_41619_() && (optionalCap = slot.m_7993_().getCapability(DECapabilities.PROPERTY_PROVIDER_CAPABILITY)).isPresent()) {
            PropertyProvider provider = (PropertyProvider)optionalCap.orElseThrow(WTFException::new);
            if (clickTypeIn == ClickType.PICKUP && button == 0 && player.f_36096_.m_142621_().m_41619_()) {
                this.selectedId = provider.getProviderID();
                if (this.onSelectionMade != null) {
                    this.onSelectionMade.accept(false);
                }
                this.stackCache = slot.m_7993_();
                return;
            }
        }
        if (slotId > 40) {
            return;
        }
        if (this.onInventoryChange != null) {
            this.onInventoryChange.run();
        }
        super.m_150399_(slotId, button, clickTypeIn, player);
    }

    public UUID getSelectedId() {
        return this.selectedId;
    }

    private UUID getProviderID(ItemStack stack) {
        LazyOptional optionalCap = stack.getCapability(DECapabilities.PROPERTY_PROVIDER_CAPABILITY);
        if (!stack.m_41619_() && optionalCap.isPresent()) {
            return ((PropertyProvider)optionalCap.orElseThrow(WTFException::new)).getProviderID();
        }
        return null;
    }

    private static Stream<ItemStack> getPlayerInventory(Inventory player) {
        return Streams.concat((Stream[])new Stream[]{player.f_35974_.stream(), player.f_35975_.stream(), player.f_35976_.stream(), EquipmentManager.getAllItems((LivingEntity)player.f_35978_).stream()}).filter(e -> !e.m_41619_());
    }

    public static Stream<Pair<ItemStack, PropertyProvider>> getStackProviders(Stream<ItemStack> stacks) {
        return stacks.map(e -> Pair.of((Object)e, (Object)e.getCapability(DECapabilities.PROPERTY_PROVIDER_CAPABILITY))).filter(e -> ((LazyOptional)e.value()).isPresent()).map(e -> Pair.of((Object)((ItemStack)e.key()), (Object)((PropertyProvider)((LazyOptional)e.value()).orElseThrow(WTFException::new))));
    }

    public static void handlePropertyData(Player player, PropertyData data) {
        if (data.isGlobal) {
            ContainerConfigurableItem.getStackProviders(ContainerConfigurableItem.getPlayerInventory(player.m_150109_())).filter(e -> ((PropertyProvider)e.value()).getProviderName().equals(data.providerName)).map(e -> Pair.of((Object)((ItemStack)e.key()), (Object)((PropertyProvider)e.value()).getProperty(data.getPropertyName()))).filter(e -> Objects.nonNull(e.value())).filter(e -> ((ConfigProperty)e.value()).getType() == data.type).forEach(e -> ((ConfigProperty)e.value()).loadData(data, (ItemStack)e.key()));
        } else {
            ContainerConfigurableItem.getStackProviders(ContainerConfigurableItem.getPlayerInventory(player.m_150109_())).filter(e -> ((PropertyProvider)e.value()).getProviderID().equals(data.providerID)).map(e -> Pair.of((Object)((ItemStack)e.key()), (Object)((PropertyProvider)e.value()).getProperty(data.getPropertyName()))).filter(e -> Objects.nonNull(e.value())).filter(e -> ((ConfigProperty)e.value()).getType() == data.type).findAny().ifPresent(e -> ((ConfigProperty)e.value()).loadData(data, (ItemStack)e.key()));
        }
    }

    public void m_38946_() {
        super.m_38946_();
    }

    public void m_182410_(int stateId, List<ItemStack> stacks, ItemStack carried) {
        super.m_182410_(stateId, stacks, carried);
        this.onSyncDataReceived();
    }

    public void m_182406_(int slotID, int stateId, ItemStack stack) {
        super.m_182406_(slotID, stateId, stack);
        this.onSyncDataReceived();
    }

    private void onSyncDataReceived() {
        if (!this.initialSync) {
            this.initialSync = true;
            if (this.onSelectionMade != null) {
                this.onSelectionMade.accept(true);
            }
        }
        if (this.onInventoryChange != null && this.selectedId != this.lastSelected || this.findProvider(this.selectedId) == null) {
            this.lastSelected = this.selectedId;
            this.onInventoryChange.run();
        }
    }

    public ItemStack getLastStack() {
        return this.stackCache;
    }

    public static void tryOpenGui(ServerPlayer sender) {
        ItemStack stack = sender.m_21205_();
        if (!stack.m_41619_() && stack.getCapability(DECapabilities.PROPERTY_PROVIDER_CAPABILITY).isPresent()) {
            PlayerSlot slot = new PlayerSlot((Player)sender, InteractionHand.MAIN_HAND);
            NetworkHooks.openGui((ServerPlayer)sender, (MenuProvider)new Provider(slot), arg_0 -> ((PlayerSlot)slot).toBuff(arg_0));
            return;
        }
        PlayerSlot slot = PlayerSlot.findStackActiveFirst((Inventory)sender.m_150109_(), e -> e.getCapability(DECapabilities.PROPERTY_PROVIDER_CAPABILITY).isPresent());
        if (slot != null) {
            NetworkHooks.openGui((ServerPlayer)sender, (MenuProvider)new Provider(slot), arg_0 -> ((PlayerSlot)slot).toBuff(arg_0));
            return;
        }
        sender.m_6352_((Component)new TranslatableComponent("gui.draconicevolution.item_config.no_configurable_items").m_130940_(ChatFormatting.RED), Util.f_137441_);
    }

    public static class Provider
    implements MenuProvider {
        private PlayerSlot slot;

        public Provider(PlayerSlot slot) {
            this.slot = slot;
        }

        public Component m_5446_() {
            return new TranslatableComponent("gui.draconicevolution.item_config.name");
        }

        @Nullable
        public AbstractContainerMenu m_7208_(int menuID, Inventory playerInventory, Player playerEntity) {
            return new ContainerConfigurableItem(menuID, playerInventory, this.slot, GuiLayoutFactories.CONFIGURABLE_ITEM_LAYOUT);
        }
    }
}

