/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.integration.jei;

import codechicken.lib.inventory.InventoryUtils;
import com.brandon3055.draconicevolution.DraconicEvolution;
import com.brandon3055.draconicevolution.api.crafting.IFusionInjector;
import com.brandon3055.draconicevolution.api.crafting.IFusionInventory;
import com.brandon3055.draconicevolution.api.crafting.IFusionRecipe;
import com.brandon3055.draconicevolution.api.crafting.IngredientStack;
import com.brandon3055.draconicevolution.blocks.tileentity.TileFusionCraftingCore;
import com.brandon3055.draconicevolution.inventory.ContainerFusionCraftingCore;
import com.brandon3055.draconicevolution.lib.WTFException;
import com.brandon3055.draconicevolution.network.DraconicNetwork;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IStackHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FusionRecipeTransferHelper
implements IRecipeTransferHandler<ContainerFusionCraftingCore, IFusionRecipe> {
    private final IStackHelper stackHelper;
    private final IRecipeTransferHandlerHelper handlerHelper;

    public FusionRecipeTransferHelper(IStackHelper stackHelper, IRecipeTransferHandlerHelper handlerHelper) {
        this.stackHelper = stackHelper;
        this.handlerHelper = handlerHelper;
    }

    @NotNull
    public Class<ContainerFusionCraftingCore> getContainerClass() {
        return ContainerFusionCraftingCore.class;
    }

    @NotNull
    public Class<IFusionRecipe> getRecipeClass() {
        return IFusionRecipe.class;
    }

    @Nullable
    public IRecipeTransferError transferRecipe(@NotNull ContainerFusionCraftingCore container, @NotNull IFusionRecipe recipe, @NotNull IRecipeSlotsView recipeSlots, @NotNull Player player, boolean maxTransfer, boolean doTransfer) {
        TileFusionCraftingCore core = (TileFusionCraftingCore)container.tile;
        core.updateInjectors();
        int validInjectors = (int)core.getInjectors().stream().filter(e -> e.getInjectorTier().index >= recipe.getRecipeTier().index).count();
        if (validInjectors < recipe.fusionIngredients().size()) {
            return this.handlerHelper.createUserErrorWithTooltip((Component)new TranslatableComponent("gui.draconicevolution.fusion_craft.ne_tier_injectors", new Object[]{recipe.getRecipeTier().getDisplayName().getString()}));
        }
        HashMap<Integer, Slot> inventorySlots = new HashMap<Integer, Slot>();
        for (Slot slot : container.f_38839_) {
            if (slot.f_40219_ >= 36) continue;
            inventorySlots.put(slot.f_40219_, slot);
        }
        List coreStacks = core.getInjectors().stream().map(IFusionInjector::getInjectorStack).collect(Collectors.toList());
        coreStacks.add(core.getCatalystStack());
        coreStacks.add(core.getOutputStack());
        int inputCount = 0;
        List slotViews = recipeSlots.getSlotViews();
        for (IRecipeSlotView view : slotViews) {
            if (view.getRole() != RecipeIngredientRole.INPUT || view.isEmpty()) continue;
            ++inputCount;
        }
        HashMap<Integer, ItemStack> availableItemStacks = new HashMap<Integer, ItemStack>();
        int filledCraftSlotCount = 0;
        int emptySlotCount = 0;
        for (Object slot : inventorySlots.values()) {
            ItemStack stack = slot.m_7993_();
            if (!stack.m_41619_()) {
                availableItemStacks.put(((Slot)slot).f_40219_, stack.m_41777_());
                continue;
            }
            ++emptySlotCount;
        }
        int lastIndex = 36;
        for (ItemStack stack : coreStacks) {
            if (stack.m_41619_()) continue;
            ++filledCraftSlotCount;
            availableItemStacks.put(lastIndex++, stack.m_41777_());
        }
        if (filledCraftSlotCount - inputCount > emptySlotCount) {
            String message = I18n.m_118938_((String)"jei.tooltip.error.recipe.transfer.inventory.full", (Object[])new Object[0]);
            return this.handlerHelper.createUserErrorWithTooltip((Component)new TextComponent(message));
        }
        List<IRecipeSlotView> missingStacks = this.checkForMissingIngredients(this.stackHelper, availableItemStacks, slotViews);
        if (missingStacks.size() > 0) {
            String message = I18n.m_118938_((String)"jei.tooltip.error.recipe.transfer.missing", (Object[])new Object[0]);
            return this.handlerHelper.createUserErrorForMissingSlots((Component)new TextComponent(message), missingStacks);
        }
        if (doTransfer) {
            DraconicNetwork.sendFusionRecipeMove(recipe, maxTransfer);
        }
        return null;
    }

    private List<IRecipeSlotView> checkForMissingIngredients(IStackHelper stackhelper, Map<Integer, ItemStack> availableItemStacks, List<IRecipeSlotView> slotViews) {
        ArrayList<IRecipeSlotView> missing = new ArrayList<IRecipeSlotView>();
        for (IRecipeSlotView slotView : slotViews) {
            List<ItemStack> requiredStacks;
            if (slotView.isEmpty() || slotView.getRole() != RecipeIngredientRole.INPUT || (requiredStacks = slotView.getAllIngredients().map(e -> e.getIngredient((IIngredientType)VanillaTypes.ITEM_STACK).orElse(ItemStack.f_41583_)).filter(e -> !e.m_41619_()).toList()).isEmpty()) continue;
            boolean foundIngredient = false;
            for (ItemStack stack : requiredStacks) {
                int required = stack.m_41613_();
                for (ItemStack available : availableItemStacks.values()) {
                    if (!stackhelper.isEquivalent(available, stack, UidContext.Ingredient)) continue;
                    int consume = Math.min(required, available.m_41613_());
                    available.m_41774_(consume);
                    if ((required -= consume) > 0) continue;
                    foundIngredient = true;
                    break;
                }
                availableItemStacks.entrySet().removeIf(e -> ((ItemStack)e.getValue()).m_41613_() <= 0);
                if (!foundIngredient) continue;
                break;
            }
            if (foundIngredient) continue;
            missing.add(slotView);
        }
        return missing;
    }

    public static void doServerSideTransfer(ServerPlayer player, ContainerFusionCraftingCore container, IFusionRecipe recipe, boolean maxTransfer) {
        TileFusionCraftingCore tile = (TileFusionCraftingCore)container.tile;
        LazyOptional optionalHandler = player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.UP);
        if (!optionalHandler.isPresent()) {
            DraconicEvolution.LOGGER.error("FusionRecipeTransferHelper: Player has no inventory capability");
            return;
        }
        IItemHandler playerItemHandler = (IItemHandler)optionalHandler.orElseThrow(WTFException::new);
        for (int i = 0; i < tile.itemHandler.getSlots(); ++i) {
            ItemStack stack = tile.itemHandler.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            stack = InventoryUtils.insertItem((IItemHandler)playerItemHandler, (ItemStack)stack, (boolean)false);
            tile.itemHandler.setStackInSlot(i, stack);
            if (stack.m_41619_()) continue;
            DraconicEvolution.LOGGER.error("FusionRecipeTransferHelper: Failed to transfer core inventory to player.");
            return;
        }
        for (IFusionInjector injector : tile.getInjectors()) {
            ItemStack stack = injector.getInjectorStack();
            if (stack.m_41619_()) continue;
            stack = InventoryUtils.insertItem((IItemHandler)playerItemHandler, (ItemStack)stack, (boolean)false);
            injector.setInjectorStack(stack);
            if (stack.m_41619_()) continue;
            DraconicEvolution.LOGGER.error("FusionRecipeTransferHelper: Failed to transfer core inventory to player.");
            return;
        }
        FusionRecipeTransferHelper.transferIngredients(playerItemHandler, tile, recipe, maxTransfer);
    }

    private static void transferIngredients(IItemHandler playerInv, IFusionInventory fusionInv, IFusionRecipe recipe, boolean maxTransfer) {
        int fullSets;
        ArrayList<ItemStack> availableStacks = new ArrayList<ItemStack>();
        for (int i = 0; i < playerInv.getSlots(); ++i) {
            availableStacks.add(playerInv.getStackInSlot(i).m_41777_());
        }
        for (fullSets = 0; (maxTransfer || fullSets == 0) && FusionRecipeTransferHelper.checkIngredient(availableStacks, recipe.getCatalyst(), true); ++fullSets) {
            boolean endCheck = false;
            for (IFusionRecipe.IFusionIngredient ingred : recipe.fusionIngredients()) {
                if (FusionRecipeTransferHelper.checkIngredient(availableStacks, ingred.get(), ingred.consume())) continue;
                endCheck = true;
                break;
            }
            if (endCheck) break;
        }
        int catCount = recipe.getCatalyst() instanceof IngredientStack ? ((IngredientStack)recipe.getCatalyst()).getCount() : 1;
        int maxStack = recipe.getCatalyst().m_43908_().length > 0 ? recipe.getCatalyst().m_43908_()[0].m_41741_() : 1;
        fullSets = Math.min(fullSets, maxStack / catCount);
        List<Object> injectors = fusionInv.getInjectors().stream().sorted(Comparator.comparing(e -> ((IFusionInjector)e).getInjectorTier().index).reversed()).toList();
        List<IFusionRecipe.IFusionIngredient> ingredients = recipe.fusionIngredients();
        if (injectors.size() < ingredients.size()) {
            DraconicEvolution.LOGGER.error("FusionRecipeTransferHelper: Unexpected error while transferring recipe");
            return;
        }
        for (int i = 0; i < fullSets; ++i) {
            ItemStack catalyst = FusionRecipeTransferHelper.getIngredient(fusionInv.getCatalystStack(), recipe.getCatalyst(), playerInv);
            fusionInv.setCatalystStack(catalyst);
            for (int fi = 0; fi < ingredients.size(); ++fi) {
                IFusionInjector injector = (IFusionInjector)injectors.get(fi);
                IFusionRecipe.IFusionIngredient ingredient = ingredients.get(fi);
                if (!ingredient.consume() && i > 0) continue;
                ItemStack stack = FusionRecipeTransferHelper.getIngredient(injector.getInjectorStack(), ingredient.get(), playerInv);
                injector.setInjectorStack(stack);
            }
        }
    }

    private static ItemStack getIngredient(ItemStack existing, Ingredient ingred, IItemHandler playerInv) {
        int count = ingred instanceof IngredientStack ? ((IngredientStack)ingred).getCount() : 1;
        for (int i = 0; i < playerInv.getSlots(); ++i) {
            ItemStack slot = playerInv.extractItem(i, count, true);
            if (!(ingred instanceof IngredientStack ? ((IngredientStack)ingred).itemTest(slot) : ingred.test(slot)) || !InventoryUtils.canStack((ItemStack)existing, (ItemStack)slot)) continue;
            int maxInsert = existing.m_41619_() ? count : Math.min(count, existing.m_41741_() - existing.m_41613_());
            ItemStack extracted = playerInv.extractItem(i, maxInsert, false);
            if (existing.m_41619_()) {
                existing = extracted;
            } else {
                existing.m_41769_(extracted.m_41613_());
            }
            if ((count -= extracted.m_41613_()) > 0) continue;
            return existing;
        }
        return existing;
    }

    private static boolean checkIngredient(List<ItemStack> availableStacks, Ingredient ingred, boolean consume) {
        int count = ingred instanceof IngredientStack ? ((IngredientStack)ingred).getCount() : 1;
        for (ItemStack stack : availableStacks) {
            if (!(ingred instanceof IngredientStack ? ((IngredientStack)ingred).itemTest(stack) : ingred.test(stack))) continue;
            int stackSize = stack.m_41613_();
            if (consume) {
                stack.m_41774_(Math.min(count, stack.m_41613_()));
            }
            if ((count -= stackSize) > 0) continue;
            availableStacks.removeIf(ItemStack::m_41619_);
            return true;
        }
        availableStacks.removeIf(ItemStack::m_41619_);
        return false;
    }
}

