/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.integration.jei;

import com.brandon3055.brandonscore.client.gui.modulargui.IModularGui;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiProgressIcon;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiStackIcon;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiTexture;
import com.brandon3055.brandonscore.integration.ModularGuiProperties;
import com.brandon3055.draconicevolution.api.DraconicAPI;
import com.brandon3055.draconicevolution.api.crafting.IFusionRecipe;
import com.brandon3055.draconicevolution.client.gui.GuiDraconiumChest;
import com.brandon3055.draconicevolution.client.gui.GuiEnergyCore;
import com.brandon3055.draconicevolution.client.gui.GuiFusionCraftingCore;
import com.brandon3055.draconicevolution.client.gui.modular.itemconfig.GuiConfigurableItem;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.integration.jei.FusionRecipeCategory;
import com.brandon3055.draconicevolution.integration.jei.FusionRecipeTransferHelper;
import com.brandon3055.draconicevolution.inventory.ContainerDraconiumChest;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.gui.handlers.IGuiClickableArea;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.helpers.IStackHelper;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import mezz.jei.api.recipe.transfer.IRecipeTransferInfo;
import mezz.jei.api.registration.IAdvancedRegistration;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IModIngredientRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public class DEJEIPlugin
implements IModPlugin {
    public static IJeiHelpers jeiHelpers = null;
    public static IJeiRuntime jeiRuntime = null;
    public static RecipeType<IFusionRecipe> FUSION_RECIPE_TYPE = RecipeType.create((String)"draconicevolution", (String)"fusion_crafting", IFusionRecipe.class);
    @Nullable
    private FusionRecipeCategory fusionRecipeCategory;

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addGuiScreenHandler(GuiConfigurableItem.class, gui -> null);
        registration.addGuiScreenHandler(GuiEnergyCore.class, gui -> gui.hideJEI.get() != false ? null : ModularGuiProperties.create((IModularGui)gui));
        registration.addGuiContainerHandler(GuiDraconiumChest.class, (IGuiContainerHandler)new IGuiContainerHandler<GuiDraconiumChest>(){

            public Collection<IGuiClickableArea> getGuiClickableAreas(GuiDraconiumChest gui, double mouseX, double mouseY) {
                if (gui.colourDialog.isVisible()) {
                    return Collections.emptyList();
                }
                GuiTexture craftIcon = gui.craftIcon;
                GuiProgressIcon smeltArrow = gui.furnaceProgress;
                IGuiClickableArea craftingArea = IGuiClickableArea.createBasic((int)(craftIcon.xPos() - gui.guiLeft()), (int)(craftIcon.yPos() - gui.guiTop()), (int)craftIcon.xSize(), (int)craftIcon.ySize(), (RecipeType[])new RecipeType[]{RecipeTypes.CRAFTING});
                IGuiClickableArea smeltingArea = IGuiClickableArea.createBasic((int)(smeltArrow.xPos() - gui.guiLeft()), (int)(smeltArrow.yPos() - gui.guiTop()), (int)smeltArrow.xSize(), (int)smeltArrow.ySize(), (RecipeType[])new RecipeType[]{RecipeTypes.SMELTING});
                return Lists.newArrayList((Object[])new IGuiClickableArea[]{craftingArea, smeltingArea});
            }
        });
        registration.addGuiContainerHandler(GuiFusionCraftingCore.class, (IGuiContainerHandler)new IGuiContainerHandler<GuiFusionCraftingCore>(){

            public Collection<IGuiClickableArea> getGuiClickableAreas(GuiFusionCraftingCore gui, double mouseX, double mouseY) {
                GuiStackIcon craftIcon = gui.stackIcon;
                IGuiClickableArea craftingArea = IGuiClickableArea.createBasic((int)(craftIcon.xPos() - gui.guiLeft()), (int)(craftIcon.yPos() - gui.guiTop()), (int)craftIcon.xSize(), (int)craftIcon.ySize(), (RecipeType[])new RecipeType[]{FUSION_RECIPE_TYPE});
                return Collections.singletonList(craftingArea);
            }
        });
    }

    public void registerAdvanced(IAdvancedRegistration registration) {
    }

    public void registerIngredients(IModIngredientRegistration registration) {
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IJeiHelpers jeiHelpers = registration.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        IRecipeCategory[] iRecipeCategoryArray = new IRecipeCategory[1];
        this.fusionRecipeCategory = new FusionRecipeCategory(guiHelper);
        iRecipeCategoryArray[0] = this.fusionRecipeCategory;
        registration.addRecipeCategories(iRecipeCategoryArray);
    }

    public void registerRecipes(IRecipeRegistration registration) {
        jeiHelpers = registration.getJeiHelpers();
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        if (world == null) {
            return;
        }
        registration.addRecipes(FUSION_RECIPE_TYPE, world.m_7465_().m_44013_(DraconicAPI.FUSION_RECIPE_TYPE));
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        IJeiHelpers jeiHelpers = registration.getJeiHelpers();
        IRecipeTransferHandlerHelper transferHelper = registration.getTransferHelper();
        IStackHelper stackHelper = jeiHelpers.getStackHelper();
        registration.addRecipeTransferHandler((IRecipeTransferHandler)new FusionRecipeTransferHelper(stackHelper, transferHelper), FUSION_RECIPE_TYPE);
        registration.addRecipeTransferHandler((IRecipeTransferInfo)new IRecipeTransferInfo<ContainerDraconiumChest, CraftingRecipe>(){

            public Class<ContainerDraconiumChest> getContainerClass() {
                return ContainerDraconiumChest.class;
            }

            public RecipeType<CraftingRecipe> getRecipeType() {
                return RecipeTypes.CRAFTING;
            }

            public ResourceLocation getRecipeCategoryUid() {
                return VanillaRecipeCategoryUid.CRAFTING;
            }

            public boolean canHandle(ContainerDraconiumChest container, CraftingRecipe recipe) {
                return true;
            }

            public List<Slot> getRecipeSlots(ContainerDraconiumChest container, CraftingRecipe recipe) {
                return container.craftInputSlots;
            }

            public List<Slot> getInventorySlots(ContainerDraconiumChest container, CraftingRecipe recipe) {
                return Stream.of(container.mainSlots, container.playerSlots).flatMap(Collection::stream).collect(Collectors.toList());
            }

            public Class<CraftingRecipe> getRecipeClass() {
                return CraftingRecipe.class;
            }
        });
        registration.addRecipeTransferHandler((IRecipeTransferInfo)new IRecipeTransferInfo<ContainerDraconiumChest, SmeltingRecipe>(){

            public Class<ContainerDraconiumChest> getContainerClass() {
                return ContainerDraconiumChest.class;
            }

            public boolean canHandle(ContainerDraconiumChest container, SmeltingRecipe recipe) {
                return true;
            }

            public List<Slot> getRecipeSlots(ContainerDraconiumChest container, SmeltingRecipe recipe) {
                return container.furnaceInputSlots;
            }

            public List<Slot> getInventorySlots(ContainerDraconiumChest container, SmeltingRecipe recipe) {
                return Stream.of(container.mainSlots, container.playerSlots).flatMap(Collection::stream).collect(Collectors.toList());
            }

            public Class<SmeltingRecipe> getRecipeClass() {
                return SmeltingRecipe.class;
            }

            public RecipeType<SmeltingRecipe> getRecipeType() {
                return RecipeTypes.SMELTING;
            }

            public ResourceLocation getRecipeCategoryUid() {
                return VanillaRecipeCategoryUid.FURNACE;
            }
        });
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)DEContent.crafting_core), new RecipeType[]{FUSION_RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)DEContent.draconium_chest), new RecipeType[]{RecipeTypes.CRAFTING, RecipeTypes.SMELTING});
    }

    private void hideFeature(Object feature) {
    }

    public void onRuntimeAvailable(IJeiRuntime iJeiRuntime) {
        jeiRuntime = iJeiRuntime;
    }

    public static void reloadJEI() {
    }

    @NotNull
    public ResourceLocation getPluginUid() {
        return new ResourceLocation("draconicevolution", "jei_plugin");
    }
}

