/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.integration.equipment;

import com.brandon3055.brandonscore.capability.MultiCapabilityProvider;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.integration.equipment.CurioWrapper;
import com.brandon3055.draconicevolution.integration.equipment.EquipmentManager;
import com.brandon3055.draconicevolution.lib.WTFException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.items.IItemHandlerModifiable;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;
import top.theillusivec4.curios.api.SlotTypePreset;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;

public class CuriosIntegration
extends EquipmentManager {
    public static final TagKey<Item> CURIO_TAG = ItemTags.create((ResourceLocation)new ResourceLocation("curios", "curio"));
    public static final TagKey<Item> BODY_TAG = ItemTags.create((ResourceLocation)new ResourceLocation("curios", "body"));
    public static Capability<ICurio> CURIO_CAP = CapabilityManager.get((CapabilityToken)new CapabilityToken<ICurio>(){});

    public static void sendIMC(InterModEnqueueEvent event) {
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> SlotTypePreset.CURIO.getMessageBuilder().size(2).build());
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> SlotTypePreset.BELT.getMessageBuilder().build());
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> SlotTypePreset.CHARM.getMessageBuilder().build());
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> SlotTypePreset.BODY.getMessageBuilder().build());
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> SlotTypePreset.BACK.getMessageBuilder().build());
    }

    public void addEquipCaps(ItemStack stack, MultiCapabilityProvider provider) {
        provider.addUnsavedCap(CURIO_CAP, (Object)new CurioWrapper(stack));
    }

    public LazyOptional<IItemHandlerModifiable> getInventory(LivingEntity entity) {
        return CuriosApi.getCuriosHelper().getEquippedCurios(entity);
    }

    public ItemStack findMatchingItem(Item item, LivingEntity entity) {
        return CuriosApi.getCuriosHelper().findFirstCurio(entity, item).map(SlotResult::stack).orElse(ItemStack.f_41583_);
    }

    public ItemStack findMatchingItem(Predicate<ItemStack> predicate, LivingEntity entity) {
        return CuriosApi.getCuriosHelper().findFirstCurio(entity, predicate).map(SlotResult::stack).orElse(ItemStack.f_41583_);
    }

    public List<ResourceLocation> getSlotIcons(LivingEntity entity) {
        LazyOptional optional = CuriosApi.getCuriosHelper().getCuriosHandler(entity);
        if (optional.isPresent()) {
            ICuriosItemHandler handler = (ICuriosItemHandler)optional.orElseThrow(WTFException::new);
            ArrayList<ResourceLocation> icons = new ArrayList<ResourceLocation>();
            handler.getCurios().forEach((s, h) -> {
                for (int i = 0; i < h.getSlots(); ++i) {
                    icons.add(CuriosApi.getIconHelper().getIcon(s));
                }
            });
            return icons;
        }
        return Collections.emptyList();
    }

    public static void generateTags(Function<TagKey<Item>, TagsProvider.TagAppender<Item>> builder) {
        builder.apply(CURIO_TAG).m_126584_((Object[])new Item[]{DEContent.dislocator_advanced, DEContent.magnet, DEContent.magnet_advanced, DEContent.capacitor_wyvern, DEContent.capacitor_draconic, DEContent.capacitor_chaotic, DEContent.capacitor_creative});
        builder.apply(BODY_TAG).m_126584_((Object[])new Item[]{DEContent.chestpiece_wyvern, DEContent.chestpiece_draconic, DEContent.chestpiece_chaotic});
    }
}

