/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.integration.crafttweaker.handler;

import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.MCItemStack;
import com.blamejared.crafttweaker.api.recipe.handler.IRecipeHandler;
import com.blamejared.crafttweaker.api.recipe.handler.IReplacementRule;
import com.blamejared.crafttweaker.api.recipe.handler.helper.ReplacementHandlerHelper;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker.api.util.IngredientUtil;
import com.blamejared.crafttweaker.api.util.StringUtil;
import com.brandon3055.draconicevolution.api.crafting.FusionRecipe;
import com.brandon3055.draconicevolution.api.crafting.IFusionRecipe;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;

@IRecipeHandler.For(value=FusionRecipe.class)
public class FusionRecipeHandler
implements IRecipeHandler<FusionRecipe> {
    public String dumpToCommandString(IRecipeManager manager, FusionRecipe recipe) {
        String outputStr = "<recipetype:draconicevolution:fusion_crafting>.addRecipe(%s, %s, %s, %s, TechLevel.%s, [%s]);";
        StringJoiner ingredientJoiner = new StringJoiner(", ");
        for (IFusionRecipe.IFusionIngredient fusionIngredient : recipe.fusionIngredients()) {
            ingredientJoiner.add("FusionIngredient.of(" + IIngredient.fromIngredient((Ingredient)fusionIngredient.get()).getCommandString() + ", " + fusionIngredient.consume() + ")");
        }
        return String.format(outputStr, StringUtil.quoteAndEscape((ResourceLocation)recipe.m_6423_()), new MCItemStack(recipe.m_8043_()).getCommandString(), IIngredient.fromIngredient((Ingredient)recipe.getCatalyst()).getCommandString(), recipe.getEnergyCost(), recipe.getRecipeTier().name(), ingredientJoiner);
    }

    public Optional<Function<ResourceLocation, FusionRecipe>> replaceIngredients(IRecipeManager manager, FusionRecipe recipe, List<IReplacementRule> rules) throws IRecipeHandler.ReplacementNotSupportedException {
        List iFusionIngredients = recipe.fusionIngredients().stream().map(iFusionIngredient -> (FusionRecipe.FusionIngredient)iFusionIngredient).collect(Collectors.toList());
        return ReplacementHandlerHelper.replaceIngredientList(iFusionIngredients, FusionRecipe.FusionIngredient.class, (Recipe)recipe, rules, newIngredients -> id -> new FusionRecipe((ResourceLocation)id, recipe.m_8043_(), recipe.getCatalyst(), recipe.getEnergyCost(), recipe.getRecipeTier(), (Collection<FusionRecipe.FusionIngredient>)newIngredients));
    }

    public <U extends Recipe<?>> boolean doesConflict(IRecipeManager manager, FusionRecipe firstRecipe, U secondRecipe) {
        FusionRecipe second = (FusionRecipe)secondRecipe;
        if (firstRecipe.fusionIngredients().size() != second.fusionIngredients().size()) {
            return false;
        }
        if (!IngredientUtil.canConflict((Ingredient)firstRecipe.getCatalyst(), (Ingredient)second.getCatalyst())) {
            return false;
        }
        List<FusionRecipe.FusionIngredient> firstIngredients = firstRecipe.fusionIngredients().stream().map(iFusionIngredient -> (FusionRecipe.FusionIngredient)iFusionIngredient).collect(Collectors.toList());
        List<FusionRecipe.FusionIngredient> secondIngredients = second.fusionIngredients().stream().map(iFusionIngredient -> (FusionRecipe.FusionIngredient)iFusionIngredient).collect(Collectors.toList());
        return this.craftVirtually(firstIngredients, secondIngredients);
    }

    private boolean craftVirtually(List<FusionRecipe.FusionIngredient> first, List<FusionRecipe.FusionIngredient> second) {
        BitSet visitData = new BitSet(second.size());
        block0: for (FusionRecipe.FusionIngredient target : first) {
            for (int i = 0; i < second.size(); ++i) {
                if (visitData.get(i)) continue;
                FusionRecipe.FusionIngredient attempt = second.get(i);
                if (!IngredientUtil.canConflict((Ingredient)target.get(), (Ingredient)attempt.get())) continue;
                visitData.set(i);
                continue block0;
            }
        }
        return visitData.nextClearBit(0) == second.size();
    }
}

