/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.integration.computers;

import com.brandon3055.brandonscore.utils.MathUtils;
import com.brandon3055.draconicevolution.blocks.reactor.tileentity.TileReactorComponent;
import com.brandon3055.draconicevolution.blocks.reactor.tileentity.TileReactorCore;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.shared.Capabilities;
import dan200.computercraft.shared.util.CapabilityUtil;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;

public class PeripheralReactorComponent
implements IPeripheral,
ICapabilityProvider {
    TileReactorComponent tile;
    TileReactorCore reactor;
    private LazyOptional<IPeripheral> self;

    public PeripheralReactorComponent(TileReactorComponent tile) {
        this.tile = tile;
    }

    public String getType() {
        return "draconic_reactor";
    }

    public boolean equals(IPeripheral other) {
        return false;
    }

    private boolean refreshCoreStatus() {
        this.reactor = this.tile.getCachedCore();
        return this.reactor != null;
    }

    @LuaFunction
    public final Map<Object, Object> getReactorInfo() {
        if (this.refreshCoreStatus()) {
            HashMap<Object, Object> map = new HashMap<Object, Object>();
            map.put("temperature", MathUtils.round((double)this.reactor.temperature.get(), (double)100.0));
            map.put("fieldStrength", MathUtils.round((double)this.reactor.shieldCharge.get(), (double)100.0));
            map.put("maxFieldStrength", MathUtils.round((double)this.reactor.maxShieldCharge.get(), (double)100.0));
            map.put("energySaturation", this.reactor.saturation.get());
            map.put("maxEnergySaturation", this.reactor.maxSaturation.get());
            map.put("fuelConversion", MathUtils.round((double)this.reactor.convertedFuel.get(), (double)1000.0));
            map.put("maxFuelConversion", this.reactor.reactableFuel.get() + this.reactor.convertedFuel.get());
            map.put("generationRate", (int)this.reactor.generationRate.get());
            map.put("fieldDrainRate", this.reactor.fieldDrain.get());
            map.put("fuelConversionRate", (int)Math.round(this.reactor.fuelUseRate.get() * 1000000.0));
            map.put("status", ((TileReactorCore.ReactorState)this.reactor.reactorState.get()).name().toLowerCase(Locale.ENGLISH));
            map.put("failSafe", this.reactor.failSafeMode.get());
            return map;
        }
        return null;
    }

    @LuaFunction
    public final boolean chargeReactor() {
        if (this.refreshCoreStatus()) {
            this.reactor.chargeReactor();
            return true;
        }
        return false;
    }

    @LuaFunction
    public final boolean activateReactor() {
        if (this.refreshCoreStatus()) {
            this.reactor.activateReactor();
            return true;
        }
        return false;
    }

    @LuaFunction
    public final boolean stopReactor() {
        if (this.refreshCoreStatus()) {
            this.reactor.shutdownReactor();
            return true;
        }
        return false;
    }

    @LuaFunction
    public final boolean toggleFailSafe() {
        if (this.refreshCoreStatus()) {
            this.reactor.toggleFailSafe();
            return true;
        }
        return false;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == Capabilities.CAPABILITY_PERIPHERAL) {
            if (this.self == null) {
                this.self = LazyOptional.of(() -> this);
            }
            return this.self.cast();
        }
        return LazyOptional.empty();
    }

    public void invalidate() {
        this.self = CapabilityUtil.invalidate(this.self);
    }
}

