/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.init;

import codechicken.lib.config.ConfigCategory;
import codechicken.lib.math.MathHelper;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.world.ChaosIslandFeature;
import com.mojang.serialization.Codec;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import net.covers1624.quack.util.CrashLock;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.data.worldgen.features.OreFeatures;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

public class DEWorldGen {
    private static final CrashLock LOCK = new CrashLock("Already Initialized.");
    public static final RuleTest END_STONE = new BlockMatchTest(Blocks.f_50259_);
    public static final DeferredRegister<Feature<?>> FEATURES = DeferredRegister.create((ResourceKey)Registry.f_122838_, (String)"draconicevolution");
    public static final DeferredRegister<ConfiguredFeature<?, ?>> CONFIGURED_FEATURES = DeferredRegister.create((ResourceKey)Registry.f_122881_, (String)"draconicevolution");
    public static final DeferredRegister<PlacedFeature> PLACED_FEATURES = DeferredRegister.create((ResourceKey)Registry.f_194567_, (String)"draconicevolution");
    public static RegistryObject<PlacedFeature> DRACONIUM_ORE_PLACED_OVERWORLD;
    public static RegistryObject<PlacedFeature> DRACONIUM_ORE_PLACED_NETHER;
    public static RegistryObject<PlacedFeature> DRACONIUM_ORE_PLACED_END;
    public static RegistryObject<PlacedFeature> ISLAND_FEATURE;
    public static boolean chaosIslandVoidMode;

    public static void init(ConfigCategory configTag) {
        LOCK.lock();
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        FEATURES.register(modEventBus);
        CONFIGURED_FEATURES.register(modEventBus);
        PLACED_FEATURES.register(modEventBus);
        MinecraftForge.EVENT_BUS.addListener(DEWorldGen::onBiomeLoad);
        Supplier<List<OreConfiguration.TargetBlockState>> ores = () -> List.of(OreConfiguration.m_161021_((RuleTest)OreFeatures.f_195072_, (BlockState)DEContent.ore_draconium_overworld.m_49966_()), OreConfiguration.m_161021_((RuleTest)OreFeatures.f_195073_, (BlockState)DEContent.ore_draconium_deepslate.m_49966_()), OreConfiguration.m_161021_((RuleTest)OreFeatures.f_195075_, (BlockState)DEContent.ore_draconium_nether.m_49966_()), OreConfiguration.m_161021_((RuleTest)END_STONE, (BlockState)DEContent.ore_draconium_end.m_49966_()));
        ConfigCategory worldGenTag = configTag.getCategory("World Gen");
        DRACONIUM_ORE_PLACED_OVERWORLD = DEWorldGen.createOreFeature("draconium_overworld", ores, worldGenTag, 8, 0.1, -64, -32);
        DRACONIUM_ORE_PLACED_NETHER = DEWorldGen.createOreFeature("draconium_nether", ores, worldGenTag, 18, 0.05, 0, 16);
        DRACONIUM_ORE_PLACED_END = DEWorldGen.createOreFeature("draconium_end", ores, worldGenTag, 8, 3.0, 0, 70);
        ISLAND_FEATURE = DEWorldGen.createChaosIslandFeature(worldGenTag);
    }

    private static RegistryObject<PlacedFeature> createOreFeature(String baseName, Supplier<List<OreConfiguration.TargetBlockState>> ores, ConfigCategory config, int size, double spawns, int minY, int maxY) {
        ConfigCategory category = config.getCategory(baseName);
        boolean enabled = category.getValue("enableGeneration").setComment("Allows you to disable generation of this ore").setDefaultBoolean(true).getBoolean();
        int cfgSize = category.getValue("maxVeinSize").setComment("Allows you to specify the maximum vein size for this ore").setDefaultInt(size).getInt();
        double cfgSpawns = category.getValue("spawnsPerChunk").setComment("The number of times this ore will attempt to spawn per chunk\nCan be a decimal number if less then one but will be rounded down to the nearest integer value if greater than or equal to one.").setDefaultDouble(spawns).getDouble();
        int cfgMinY = category.getValue("minYHeight").setComment("The minimum Y level this ore will spawn at").setDefaultInt(minY).getInt();
        int cfgMaxY = category.getValue("maxYHeight").setComment("The maximum Y level this ore will spawn at").setDefaultInt(maxY).getInt();
        if (!enabled) {
            return null;
        }
        RegistryObject configuredOre = CONFIGURED_FEATURES.register(baseName, () -> new ConfiguredFeature(Feature.f_65731_, (FeatureConfiguration)new OreConfiguration((List)ores.get(), cfgSize)));
        CountPlacement spawnChance = cfgSpawns >= 1.0 ? CountPlacement.m_191628_((int)((int)cfgSpawns)) : RarityFilter.m_191900_((int)((int)(1.0 / MathHelper.clip((double)cfgSpawns, (double)0.0078125, (double)1.0))));
        return PLACED_FEATURES.register(baseName, () -> DEWorldGen.lambda$createOreFeature$2(configuredOre, (PlacementModifier)spawnChance, cfgMinY, cfgMaxY));
    }

    private static RegistryObject<PlacedFeature> createChaosIslandFeature(ConfigCategory config) {
        ConfigCategory category = config.getCategory("Chaos Island");
        boolean enabled = category.getValue("enableGeneration").setComment("Allows you to disable generation of chaos islands").setDefaultBoolean(true).getBoolean();
        chaosIslandVoidMode = category.getValue("chaosIslandVoidMode").setComment("Allows you to disable generation of chaos islands").setDefaultBoolean(false).getBoolean();
        int yPos = category.getValue("chaosIslandYPosition").setComment("The island will generate so that the chaos crystal is at this y position").setDefaultInt(80).getInt();
        int seperation = category.getValue("chaosIslandSeparation").setComment("Toggles whether the full chaos island should spawn or just the guardian crystals, the chaos crystal, and the guardian.").setDefaultInt(10000).getInt();
        int size = category.getValue("chaosIslandSize").setComment("Rough radius of the main chaos island. If you prefer the smaller island from pre 1.18 set this to 80").setDefaultInt(160).getInt();
        if (!enabled) {
            return null;
        }
        RegistryObject islandFeature = FEATURES.register("chaos_island", () -> new ChaosIslandFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_, yPos, seperation, size));
        RegistryObject configuredIsland = CONFIGURED_FEATURES.register("chaos_island", () -> new ConfiguredFeature((Feature)((ChaosIslandFeature)((Object)((Object)islandFeature.get()))), (FeatureConfiguration)NoneFeatureConfiguration.f_67816_));
        return PLACED_FEATURES.register("chaos_island", () -> new PlacedFeature((Holder)configuredIsland.getHolder().get(), Collections.emptyList()));
    }

    public static void onBiomeLoad(BiomeLoadingEvent event) {
        Biome.BiomeCategory category = event.getCategory();
        List oreFeatures = event.getGeneration().getFeatures(GenerationStep.Decoration.UNDERGROUND_ORES);
        if (DEWorldGen.isLikelyOverworldBiome(category)) {
            if (DRACONIUM_ORE_PLACED_OVERWORLD != null) {
                DRACONIUM_ORE_PLACED_OVERWORLD.getHolder().ifPresent(oreFeatures::add);
            }
        } else if (category == Biome.BiomeCategory.NETHER) {
            if (DRACONIUM_ORE_PLACED_NETHER != null) {
                DRACONIUM_ORE_PLACED_NETHER.getHolder().ifPresent(oreFeatures::add);
            }
        } else if (category == Biome.BiomeCategory.THEEND) {
            if (DRACONIUM_ORE_PLACED_END != null) {
                DRACONIUM_ORE_PLACED_END.getHolder().ifPresent(oreFeatures::add);
            }
            if (ISLAND_FEATURE != null) {
                ISLAND_FEATURE.getHolder().ifPresent(holder -> event.getGeneration().getFeatures(GenerationStep.Decoration.RAW_GENERATION).add(holder));
            }
        }
    }

    public static boolean isLikelyOverworldBiome(Biome.BiomeCategory category) {
        return category != Biome.BiomeCategory.NONE && category != Biome.BiomeCategory.THEEND && category != Biome.BiomeCategory.NETHER;
    }

    private static /* synthetic */ PlacedFeature lambda$createOreFeature$2(RegistryObject configuredOre, PlacementModifier spawnChance, int cfgMinY, int cfgMaxY) {
        return new PlacedFeature((Holder)configuredOre.getHolder().get(), List.of(spawnChance, InSquarePlacement.m_191715_(), BiomeFilter.m_191561_(), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)cfgMinY), (VerticalAnchor)VerticalAnchor.m_158922_((int)cfgMaxY))));
    }
}

