/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.init;

import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.brandonscore.client.utils.CyclingItemGroup;
import com.brandon3055.draconicevolution.api.modules.Module;
import com.brandon3055.draconicevolution.api.modules.ModuleTypes;
import com.brandon3055.draconicevolution.api.modules.data.AOEData;
import com.brandon3055.draconicevolution.api.modules.data.AutoFeedData;
import com.brandon3055.draconicevolution.api.modules.data.DamageData;
import com.brandon3055.draconicevolution.api.modules.data.DamageModData;
import com.brandon3055.draconicevolution.api.modules.data.EnergyData;
import com.brandon3055.draconicevolution.api.modules.data.EnergyLinkData;
import com.brandon3055.draconicevolution.api.modules.data.FlightData;
import com.brandon3055.draconicevolution.api.modules.data.JumpData;
import com.brandon3055.draconicevolution.api.modules.data.ModuleData;
import com.brandon3055.draconicevolution.api.modules.data.NoData;
import com.brandon3055.draconicevolution.api.modules.data.ProjectileData;
import com.brandon3055.draconicevolution.api.modules.data.ShieldControlData;
import com.brandon3055.draconicevolution.api.modules.data.ShieldData;
import com.brandon3055.draconicevolution.api.modules.data.SpeedData;
import com.brandon3055.draconicevolution.api.modules.data.TreeHarvestData;
import com.brandon3055.draconicevolution.api.modules.data.UndyingData;
import com.brandon3055.draconicevolution.api.modules.items.EnderCollectionModuleItem;
import com.brandon3055.draconicevolution.api.modules.items.EnergyLinkModuleItem;
import com.brandon3055.draconicevolution.api.modules.items.EnergyModuleItem;
import com.brandon3055.draconicevolution.api.modules.items.ModuleItem;
import com.brandon3055.draconicevolution.api.modules.lib.BaseModule;
import com.brandon3055.draconicevolution.api.modules.lib.IDamageModifier;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleImpl;
import com.brandon3055.draconicevolution.init.ModuleCfg;
import com.brandon3055.draconicevolution.modules.ProjectileVelocityModule;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import net.covers1624.quack.util.SneakyUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.NewRegistryEvent;
import net.minecraftforge.registries.ObjectHolder;
import net.minecraftforge.registries.RegistryBuilder;

@Mod.EventBusSubscriber(modid="draconicevolution", bus=Mod.EventBusSubscriber.Bus.MOD)
@ObjectHolder(value="draconicevolution")
public class DEModules {
    private static final transient ArrayList<ResourceLocation> ITEM_REGISTRY_ORDER = new ArrayList();
    public static transient Map<BaseModule<?>, Item> moduleItemMap = new LinkedHashMap();
    private static final transient CyclingItemGroup moduleGroup = new CyclingItemGroup("draconicevolution.modules", 20, () -> moduleItemMap.values().toArray(new Item[0]), ITEM_REGISTRY_ORDER);
    public static IForgeRegistry<Module<?>> MODULE_REGISTRY;
    @ObjectHolder(value="draconium_energy")
    public static Module<EnergyData> draconiumEnergy;
    @ObjectHolder(value="wyvern_energy")
    public static Module<EnergyData> wyvernEnergy;
    @ObjectHolder(value="draconic_energy")
    public static Module<EnergyData> draconicEnergy;
    @ObjectHolder(value="chaotic_energy")
    public static Module<EnergyData> chaoticEnergy;
    @ObjectHolder(value="wyvern_energy_link")
    public static Module<EnergyLinkData> wyvernEnergyLink;
    @ObjectHolder(value="draconic_energy_link")
    public static Module<EnergyLinkData> draconicEnergyLink;
    @ObjectHolder(value="chaotic_energy_link")
    public static Module<EnergyLinkData> chaoticEnergyLink;
    @ObjectHolder(value="draconium_speed")
    public static Module<SpeedData> draconiumSpeed;
    @ObjectHolder(value="wyvern_speed")
    public static Module<SpeedData> wyvernSpeed;
    @ObjectHolder(value="draconic_speed")
    public static Module<SpeedData> draconicSpeed;
    @ObjectHolder(value="chaotic_speed")
    public static Module<SpeedData> chaoticSpeed;
    @ObjectHolder(value="draconium_damage")
    public static Module<DamageData> draconiumDamage;
    @ObjectHolder(value="wyvern_damage")
    public static Module<DamageData> wyvernDamage;
    @ObjectHolder(value="draconic_damage")
    public static Module<DamageData> draconicDamage;
    @ObjectHolder(value="chaotic_damage")
    public static Module<DamageData> chaoticDamage;
    @ObjectHolder(value="draconium_aoe")
    public static Module<AOEData> draconiumAOE;
    @ObjectHolder(value="wyvern_aoe")
    public static Module<AOEData> wyvernAOE;
    @ObjectHolder(value="draconic_aoe")
    public static Module<AOEData> draconicAOE;
    @ObjectHolder(value="chaotic_aoe")
    public static Module<AOEData> chaoticAOE;
    @ObjectHolder(value="wyvern_mining_stability")
    public static Module<NoData> wyvernMiningStability;
    @ObjectHolder(value="wyvern_tree_harvest")
    public static Module<TreeHarvestData> wyvernTreeHarvest;
    @ObjectHolder(value="draconic_tree_harvest")
    public static Module<TreeHarvestData> draconicTreeHarvest;
    @ObjectHolder(value="chaotic_tree_harvest")
    public static Module<TreeHarvestData> chaoticTreeHarvest;
    @ObjectHolder(value="wyvern_junk_filter")
    public static Module<NoData> wyvernJunkFilter;
    @ObjectHolder(value="wyvern_ender_collection")
    public static Module<NoData> wyvernEnderCollection;
    @ObjectHolder(value="draconic_ender_collection")
    public static Module<NoData> draconicEnderCollection;
    @ObjectHolder(value="wyvern_auto_fire")
    public static Module<NoData> wyvernAutoFire;
    @ObjectHolder(value="draconic_proj_anti_immune")
    public static Module<NoData> draconicProjAntiImmune;
    @ObjectHolder(value="wyvern_proj_velocity")
    public static Module<ProjectileData> wyvernProjVelocity;
    @ObjectHolder(value="draconic_proj_velocity")
    public static Module<ProjectileData> draconicProjVelocity;
    @ObjectHolder(value="chaotic_proj_velocity")
    public static Module<ProjectileData> chaoticProjVelocity;
    @ObjectHolder(value="wyvern_proj_accuracy")
    public static Module<ProjectileData> wyvernProjAccuracy;
    @ObjectHolder(value="draconic_proj_accuracy")
    public static Module<ProjectileData> draconicProjAccuracy;
    @ObjectHolder(value="chaotic_proj_accuracy")
    public static Module<ProjectileData> chaoticProjAccuracy;
    @ObjectHolder(value="wyvern_proj_grav_comp")
    public static Module<ProjectileData> wyvernProjGravComp;
    @ObjectHolder(value="draconic_proj_grav_comp")
    public static Module<ProjectileData> draconicProjGravComp;
    @ObjectHolder(value="chaotic_proj_grav_comp")
    public static Module<ProjectileData> chaoticProjGravComp;
    @ObjectHolder(value="wyvern_proj_penetration")
    public static Module<ProjectileData> wyvernProjPenetration;
    @ObjectHolder(value="draconic_proj_penetration")
    public static Module<ProjectileData> draconicProjPenetration;
    @ObjectHolder(value="chaotic_proj_penetration")
    public static Module<ProjectileData> chaoticProjPenetration;
    @ObjectHolder(value="wyvern_proj_damage")
    public static Module<ProjectileData> wyvernProjDamage;
    @ObjectHolder(value="draconic_proj_damage")
    public static Module<ProjectileData> draconicProjDamage;
    @ObjectHolder(value="chaotic_proj_damage")
    public static Module<ProjectileData> chaoticProjDamage;
    @ObjectHolder(value="draconic_fire_mod")
    public static Module<DamageModData> draconicFireMod;
    @ObjectHolder(value="chaotic_fire_mod")
    public static Module<DamageModData> chaoticFireMod;
    @ObjectHolder(value="draconic_lightning_mod")
    public static Module<DamageModData> draconicLightningMod;
    @ObjectHolder(value="chaotic_lightning_mod")
    public static Module<DamageModData> chaoticLightningMod;
    @ObjectHolder(value="draconic_ice_mod")
    public static Module<DamageModData> draconicIceMod;
    @ObjectHolder(value="chaotic_ice_mod")
    public static Module<DamageModData> chaoticIceMod;
    @ObjectHolder(value="wyvern_shield_control")
    public static Module<NoData> wyvernShieldControl;
    @ObjectHolder(value="draconic_shield_control")
    public static Module<NoData> draconicShieldControl;
    @ObjectHolder(value="chaotic_shield_control")
    public static Module<NoData> chaoticShieldControl;
    @ObjectHolder(value="wyvern_shield_capacity")
    public static Module<ShieldData> wyvernShieldCapacity;
    @ObjectHolder(value="draconic_shield_capacity")
    public static Module<ShieldData> draconicShieldCapacity;
    @ObjectHolder(value="chaotic_shield_capacity")
    public static Module<ShieldData> chaoticShieldCapacity;
    @ObjectHolder(value="wyvern_large_shield_capacity")
    public static Module<ShieldData> wyvernLargeShieldCapacity;
    @ObjectHolder(value="draconic_large_shield_capacity")
    public static Module<ShieldData> draconicLargeShieldCapacity;
    @ObjectHolder(value="chaotic_large_shield_capacity")
    public static Module<ShieldData> chaoticLargeShieldCapacity;
    @ObjectHolder(value="wyvern_shield_recovery")
    public static Module<ShieldData> wyvernShieldRecovery;
    @ObjectHolder(value="draconic_shield_recovery")
    public static Module<ShieldData> draconicShieldRecovery;
    @ObjectHolder(value="chaotic_shield_recovery")
    public static Module<ShieldData> chaoticShieldRecovery;
    @ObjectHolder(value="wyvern_cloaking")
    public static Module<NoData> wyvernCloaking;
    @ObjectHolder(value="wyvern_flight")
    public static Module<FlightData> wyvernFlight;
    @ObjectHolder(value="draconic_flight")
    public static Module<FlightData> draconicFlight;
    @ObjectHolder(value="chaotic_flight")
    public static Module<FlightData> chaoticFlight;
    @ObjectHolder(value="wyvern_undying")
    public static Module<NoData> wyvernUndying;
    @ObjectHolder(value="draconic_undying")
    public static Module<NoData> draconicUndying;
    @ObjectHolder(value="chaotic_undying")
    public static Module<NoData> chaoticUndying;
    @ObjectHolder(value="draconium_auto_feed")
    public static Module<NoData> draconiumAutoFeed;
    @ObjectHolder(value="wyvern_auto_feed")
    public static Module<NoData> wyvernAutoFeed;
    @ObjectHolder(value="draconic_auto_feed")
    public static Module<NoData> draconicAutoFeed;
    @ObjectHolder(value="wyvern_night_vision")
    public static Module<NoData> wyvernNightVision;
    @ObjectHolder(value="draconium_jump")
    public static Module<JumpData> draconiumJump;
    @ObjectHolder(value="wyvern_jump")
    public static Module<JumpData> wyvernJump;
    @ObjectHolder(value="draconic_jump")
    public static Module<JumpData> draconicJump;
    @ObjectHolder(value="chaotic_jump")
    public static Module<JumpData> chaoticJump;
    @ObjectHolder(value="wyvern_aqua_adapt")
    public static Module<NoData> wyvernAquaAdapt;
    @ObjectHolder(value="wyvern_hill_step")
    public static Module<NoData> wyvernHillStep;

    private static void registerModules() {
        Item.Properties multiProps = new Item.Properties().m_41491_((CreativeModeTab)moduleGroup);
        Item.Properties singleProps = new Item.Properties().m_41491_((CreativeModeTab)moduleGroup).m_41487_(1);
        DEModules.register(new ModuleImpl<EnergyData>(ModuleTypes.ENERGY_STORAGE, TechLevel.DRACONIUM, DEModules.energyData(1000000L, 16000L)), new EnergyModuleItem(multiProps), "draconium_energy");
        DEModules.register(new ModuleImpl<EnergyData>(ModuleTypes.ENERGY_STORAGE, TechLevel.WYVERN, DEModules.energyData(4000000L, 64000L)), new EnergyModuleItem(multiProps), "wyvern_energy");
        DEModules.register(new ModuleImpl<EnergyData>(ModuleTypes.ENERGY_STORAGE, TechLevel.DRACONIC, DEModules.energyData(16000000L, 256000L)), new EnergyModuleItem(multiProps), "draconic_energy");
        DEModules.register(new ModuleImpl<EnergyData>(ModuleTypes.ENERGY_STORAGE, TechLevel.CHAOTIC, DEModules.energyData(64000000L, 1024000L)), new EnergyModuleItem(multiProps), "chaotic_energy");
        DEModules.register(new ModuleImpl<EnergyLinkData>(ModuleTypes.ENERGY_LINK, TechLevel.WYVERN, DEModules.energyLinkData(4000000L, 512L, 2048L, false)), new EnergyLinkModuleItem(singleProps), "wyvern_energy_link");
        DEModules.register(new ModuleImpl<EnergyLinkData>(ModuleTypes.ENERGY_LINK, TechLevel.DRACONIC, DEModules.energyLinkData(16000000L, 2048L, 16000L, true)), new EnergyLinkModuleItem(singleProps), "draconic_energy_link");
        DEModules.register(new ModuleImpl<EnergyLinkData>(ModuleTypes.ENERGY_LINK, TechLevel.CHAOTIC, DEModules.energyLinkData(64000000L, 8192L, 128000L, true)), new EnergyLinkModuleItem(singleProps), "chaotic_energy_link");
        DEModules.register(new ModuleImpl<SpeedData>(ModuleTypes.SPEED, TechLevel.DRACONIUM, DEModules.speedData(0.1)), "draconium_speed");
        DEModules.register(new ModuleImpl<SpeedData>(ModuleTypes.SPEED, TechLevel.WYVERN, DEModules.speedData(0.25)), "wyvern_speed");
        DEModules.register(new ModuleImpl<SpeedData>(ModuleTypes.SPEED, TechLevel.DRACONIC, DEModules.speedData(0.5)), "draconic_speed");
        DEModules.register(new ModuleImpl<SpeedData>(ModuleTypes.SPEED, TechLevel.CHAOTIC, DEModules.speedData(1.5)), "chaotic_speed");
        DEModules.register(new ModuleImpl<DamageData>(ModuleTypes.DAMAGE, TechLevel.DRACONIUM, DEModules.damageData(2.0)), "draconium_damage");
        DEModules.register(new ModuleImpl<DamageData>(ModuleTypes.DAMAGE, TechLevel.WYVERN, DEModules.damageData(4.0)), "wyvern_damage");
        DEModules.register(new ModuleImpl<DamageData>(ModuleTypes.DAMAGE, TechLevel.DRACONIC, DEModules.damageData(8.0)), "draconic_damage");
        DEModules.register(new ModuleImpl<DamageData>(ModuleTypes.DAMAGE, TechLevel.CHAOTIC, DEModules.damageData(16.0)), "chaotic_damage");
        DEModules.register(new ModuleImpl<AOEData>(ModuleTypes.AOE, TechLevel.DRACONIUM, DEModules.aoeData(1)), "draconium_aoe");
        DEModules.register(new ModuleImpl<AOEData>(ModuleTypes.AOE, TechLevel.WYVERN, DEModules.aoeData(2)), "wyvern_aoe");
        DEModules.register(new ModuleImpl<AOEData>(ModuleTypes.AOE, TechLevel.DRACONIC, DEModules.aoeData(3)), "draconic_aoe");
        DEModules.register(new ModuleImpl<AOEData>(ModuleTypes.AOE, TechLevel.CHAOTIC, DEModules.aoeData(5)), "chaotic_aoe");
        DEModules.register(new ModuleImpl<TreeHarvestData>(ModuleTypes.TREE_HARVEST, TechLevel.WYVERN, DEModules.treeHarvestData(16, 5)), "wyvern_tree_harvest");
        DEModules.register(new ModuleImpl<TreeHarvestData>(ModuleTypes.TREE_HARVEST, TechLevel.DRACONIC, DEModules.treeHarvestData(48, 15)), "draconic_tree_harvest");
        DEModules.register(new ModuleImpl<TreeHarvestData>(ModuleTypes.TREE_HARVEST, TechLevel.CHAOTIC, DEModules.treeHarvestData(144, 45)), "chaotic_tree_harvest");
        DEModules.register(new ModuleImpl<NoData>(ModuleTypes.JUNK_FILTER, TechLevel.WYVERN, DEModules.noData()), "wyvern_junk_filter");
        DEModules.register(new ModuleImpl<NoData>(ModuleTypes.ENDER_COLLECTION, TechLevel.WYVERN, DEModules.noData()), new EnderCollectionModuleItem(multiProps), "wyvern_ender_collection");
        DEModules.register(new ModuleImpl<NoData>(ModuleTypes.ENDER_COLLECTION, TechLevel.DRACONIC, DEModules.noData(), 2, 2), new EnderCollectionModuleItem(multiProps), "draconic_ender_collection");
        DEModules.register(new ProjectileVelocityModule(ModuleTypes.PROJ_MODIFIER, TechLevel.WYVERN, DEModules.projVelocityData(0.15f, 1.0f)).setMaxInstall(8), "wyvern_proj_velocity");
        DEModules.register(new ProjectileVelocityModule(ModuleTypes.PROJ_MODIFIER, TechLevel.DRACONIC, DEModules.projVelocityData(0.35f, 0.5f)).setMaxInstall(8), "draconic_proj_velocity");
        DEModules.register(new ProjectileVelocityModule(ModuleTypes.PROJ_MODIFIER, TechLevel.CHAOTIC, DEModules.projVelocityData(0.75f, 0.0f)).setMaxInstall(8), "chaotic_proj_velocity");
        DEModules.register(new ModuleImpl<ProjectileData>(ModuleTypes.PROJ_MODIFIER, TechLevel.WYVERN, DEModules.projAccuracyData(0.125f, 2.0f), 2, 1), "wyvern_proj_accuracy");
        DEModules.register(new ModuleImpl<ProjectileData>(ModuleTypes.PROJ_MODIFIER, TechLevel.DRACONIC, DEModules.projAccuracyData(0.2f, 1.0f), 2, 1), "draconic_proj_accuracy");
        DEModules.register(new ModuleImpl<ProjectileData>(ModuleTypes.PROJ_MODIFIER, TechLevel.CHAOTIC, DEModules.projAccuracyData(0.25f, 0.0f), 2, 1), "chaotic_proj_accuracy");
        DEModules.register(new ModuleImpl<ProjectileData>(ModuleTypes.PROJ_MODIFIER, TechLevel.WYVERN, DEModules.projAntiGravData(0.2f, 2.0f), 2, 1), "wyvern_proj_grav_comp");
        DEModules.register(new ModuleImpl<ProjectileData>(ModuleTypes.PROJ_MODIFIER, TechLevel.DRACONIC, DEModules.projAntiGravData(0.25f, 1.0f), 2, 1), "draconic_proj_grav_comp");
        DEModules.register(new ModuleImpl<ProjectileData>(ModuleTypes.PROJ_MODIFIER, TechLevel.CHAOTIC, DEModules.projAntiGravData(0.5f, 0.0f), 2, 1), "chaotic_proj_grav_comp");
        DEModules.register(new ModuleImpl<ProjectileData>(ModuleTypes.PROJ_MODIFIER, TechLevel.WYVERN, DEModules.projPenetrationData(0.25f, 2.0f), 2, 2), "wyvern_proj_penetration");
        DEModules.register(new ModuleImpl<ProjectileData>(ModuleTypes.PROJ_MODIFIER, TechLevel.DRACONIC, DEModules.projPenetrationData(0.5f, 1.0f), 2, 2), "draconic_proj_penetration");
        DEModules.register(new ModuleImpl<ProjectileData>(ModuleTypes.PROJ_MODIFIER, TechLevel.CHAOTIC, DEModules.projPenetrationData(0.75f, 0.0f), 2, 2), "chaotic_proj_penetration");
        DEModules.register(new ModuleImpl<ProjectileData>(ModuleTypes.PROJ_MODIFIER, TechLevel.WYVERN, DEModules.projDamageData(0.25f, 2.0f)), "wyvern_proj_damage");
        DEModules.register(new ModuleImpl<ProjectileData>(ModuleTypes.PROJ_MODIFIER, TechLevel.DRACONIC, DEModules.projDamageData(0.5f, 1.0f)), "draconic_proj_damage");
        DEModules.register(new ModuleImpl<ProjectileData>(ModuleTypes.PROJ_MODIFIER, TechLevel.CHAOTIC, DEModules.projDamageData(0.75f, 0.0f)), "chaotic_proj_damage");
        DEModules.register(new ModuleImpl<NoData>(ModuleTypes.AUTO_FIRE, TechLevel.WYVERN, DEModules.noData()), "wyvern_auto_fire");
        DEModules.register(new ModuleImpl<NoData>(ModuleTypes.PROJ_ANTI_IMMUNE, TechLevel.DRACONIC, DEModules.noData()), "draconic_proj_anti_immune");
        DEModules.register(new ModuleImpl<ShieldControlData>(ModuleTypes.SHIELD_CONTROLLER, TechLevel.WYVERN, DEModules.shieldControl(20.0)), "wyvern_shield_control");
        DEModules.register(new ModuleImpl<ShieldControlData>(ModuleTypes.SHIELD_CONTROLLER, TechLevel.DRACONIC, DEModules.shieldControl(10.0)), "draconic_shield_control");
        DEModules.register(new ModuleImpl<ShieldControlData>(ModuleTypes.SHIELD_CONTROLLER, TechLevel.CHAOTIC, DEModules.shieldControl(5.0)), "chaotic_shield_control");
        DEModules.register(new ModuleImpl<ShieldData>(ModuleTypes.SHIELD_BOOST, TechLevel.WYVERN, DEModules.shieldData(25, 0.1)), "wyvern_shield_capacity");
        DEModules.register(new ModuleImpl<ShieldData>(ModuleTypes.SHIELD_BOOST, TechLevel.DRACONIC, DEModules.shieldData(50, 0.25)), "draconic_shield_capacity");
        DEModules.register(new ModuleImpl<ShieldData>(ModuleTypes.SHIELD_BOOST, TechLevel.CHAOTIC, DEModules.shieldData(100, 0.5)), "chaotic_shield_capacity");
        DEModules.register(new ModuleImpl<ShieldData>(ModuleTypes.SHIELD_BOOST, TechLevel.WYVERN, DEModules.shieldData(125, 0.0), 2, 2), "wyvern_large_shield_capacity");
        DEModules.register(new ModuleImpl<ShieldData>(ModuleTypes.SHIELD_BOOST, TechLevel.DRACONIC, DEModules.shieldData(250, 0.0), 2, 2), "draconic_large_shield_capacity");
        DEModules.register(new ModuleImpl<ShieldData>(ModuleTypes.SHIELD_BOOST, TechLevel.CHAOTIC, DEModules.shieldData(500, 0.0), 2, 2), "chaotic_large_shield_capacity");
        DEModules.register(new ModuleImpl<ShieldData>(ModuleTypes.SHIELD_BOOST, TechLevel.WYVERN, DEModules.shieldData(5, 1.0)), "wyvern_shield_recovery");
        DEModules.register(new ModuleImpl<ShieldData>(ModuleTypes.SHIELD_BOOST, TechLevel.DRACONIC, DEModules.shieldData(10, 2.5)), "draconic_shield_recovery");
        DEModules.register(new ModuleImpl<ShieldData>(ModuleTypes.SHIELD_BOOST, TechLevel.CHAOTIC, DEModules.shieldData(20, 5.0)), "chaotic_shield_recovery");
        DEModules.register(new ModuleImpl<FlightData>(ModuleTypes.FLIGHT, TechLevel.WYVERN, DEModules.flightData(true, false, 1.0), 2, 2), "wyvern_flight");
        DEModules.register(new ModuleImpl<FlightData>(ModuleTypes.FLIGHT, TechLevel.DRACONIC, DEModules.flightData(true, true, 2.0)), "draconic_flight");
        DEModules.register(new ModuleImpl<FlightData>(ModuleTypes.FLIGHT, TechLevel.CHAOTIC, DEModules.flightData(true, true, 3.5)), "chaotic_flight");
        DEModules.register(new ModuleImpl<UndyingData>(ModuleTypes.UNDYING, TechLevel.WYVERN, DEModules.undyingData(6.0f, 25.0f, 300, 2400, 5000000L, 2.0)), "wyvern_undying");
        DEModules.register(new ModuleImpl<UndyingData>(ModuleTypes.UNDYING, TechLevel.DRACONIC, DEModules.undyingData(12.0f, 50.0f, 600, 1200, 10000000L, 3.0)).setMaxInstall(2), "draconic_undying");
        DEModules.register(new ModuleImpl<UndyingData>(ModuleTypes.UNDYING, TechLevel.CHAOTIC, DEModules.undyingData(20.0f, 100.0f, 2400, 900, 20000000L, 3.0)).setMaxInstall(3), "chaotic_undying");
        DEModules.register(new ModuleImpl<AutoFeedData>(ModuleTypes.AUTO_FEED, TechLevel.DRACONIUM, DEModules.autoFeedData(40.0f)), "draconium_auto_feed");
        DEModules.register(new ModuleImpl<AutoFeedData>(ModuleTypes.AUTO_FEED, TechLevel.WYVERN, DEModules.autoFeedData(150.0f)), "wyvern_auto_feed");
        DEModules.register(new ModuleImpl<AutoFeedData>(ModuleTypes.AUTO_FEED, TechLevel.DRACONIC, DEModules.autoFeedData(400.0f)), "draconic_auto_feed");
        DEModules.register(new ModuleImpl<NoData>(ModuleTypes.NIGHT_VISION, TechLevel.WYVERN, DEModules.noData()), "wyvern_night_vision");
        DEModules.register(new ModuleImpl<NoData>(ModuleTypes.HILL_STEP, TechLevel.WYVERN, DEModules.noData()), "wyvern_hill_step");
        DEModules.register(new ModuleImpl<JumpData>(ModuleTypes.JUMP_BOOST, TechLevel.DRACONIUM, DEModules.jumpData(0.25)), "draconium_jump");
        DEModules.register(new ModuleImpl<JumpData>(ModuleTypes.JUMP_BOOST, TechLevel.WYVERN, DEModules.jumpData(0.75)), "wyvern_jump");
        DEModules.register(new ModuleImpl<JumpData>(ModuleTypes.JUMP_BOOST, TechLevel.DRACONIC, DEModules.jumpData(1.25)), "draconic_jump");
        DEModules.register(new ModuleImpl<JumpData>(ModuleTypes.JUMP_BOOST, TechLevel.CHAOTIC, DEModules.jumpData(4.0)), "chaotic_jump");
    }

    private static Function<Module<EnergyData>, EnergyData> energyData(long defCapacity, long defTransfer) {
        return e -> {
            long capacity = ModuleCfg.getModuleLong(e, "capacity", defCapacity);
            long transfer = ModuleCfg.getModuleLong(e, "transfer", defTransfer);
            return new EnergyData(capacity, transfer);
        };
    }

    private static Function<Module<EnergyLinkData>, EnergyLinkData> energyLinkData(long defActivation, long defOperation, long defTransfer, boolean defDimensional) {
        return e -> {
            long activation = ModuleCfg.getModuleLong(e, "activation", defActivation);
            long operation = ModuleCfg.getModuleLong(e, "operation", defOperation);
            long transfer = ModuleCfg.getModuleLong(e, "transfer", defTransfer);
            boolean dimensional = ModuleCfg.getModuleBoolean(e, "dimensional", defDimensional);
            return new EnergyLinkData(activation, operation, transfer, dimensional);
        };
    }

    private static Function<Module<ShieldData>, ShieldData> shieldData(int defCapacity, double defRechargePerSecond) {
        return e -> {
            int capacity = ModuleCfg.getModuleInt(e, "capacity", defCapacity);
            double recharge = ModuleCfg.getModuleDouble(e, "recharge", defRechargePerSecond / 20.0);
            return new ShieldData(capacity, recharge);
        };
    }

    private static Function<Module<ShieldControlData>, ShieldControlData> shieldControl(double defSeconds) {
        return e -> {
            int ticks = ModuleCfg.getModuleInt(e, "cool_down_ticks", (int)(defSeconds * 20.0));
            return new ShieldControlData(ticks);
        };
    }

    private static Function<Module<SpeedData>, SpeedData> speedData(double defMultiplier) {
        return e -> new SpeedData(ModuleCfg.getModuleDouble(e, "speed_boost", defMultiplier));
    }

    private static Function<Module<DamageData>, DamageData> damageData(double defDamage) {
        return e -> new DamageData(ModuleCfg.getModuleDouble(e, "damage_boost", defDamage));
    }

    private static Function<Module<AOEData>, AOEData> aoeData(int defAOE) {
        return e -> new AOEData(ModuleCfg.getModuleInt(e, "aoe", defAOE));
    }

    private static Function<Module<JumpData>, JumpData> jumpData(double defMultiplier) {
        return e -> new JumpData(ModuleCfg.getModuleDouble(e, "jump_boost", defMultiplier));
    }

    private static Function<Module<FlightData>, FlightData> flightData(boolean elytra, boolean creative, double defSpeed) {
        return e -> {
            double speed = ModuleCfg.getModuleDouble(e, "elytra_boost_speed", defSpeed);
            return new FlightData(elytra, creative, speed);
        };
    }

    private static Function<Module<UndyingData>, UndyingData> undyingData(float defHealthBoost, float defShieldBoost, int shieldBoostTime, int defChargeTime, long defChargeEnergy, double defInvulnSeconds) {
        return e -> {
            float health = (float)ModuleCfg.getModuleDouble(e, "health_boost", defHealthBoost);
            float shield = (float)ModuleCfg.getModuleDouble(e, "shield_boost", defShieldBoost);
            int shieldTime = ModuleCfg.getModuleInt(e, "shield_boost_time", shieldBoostTime);
            int charge = ModuleCfg.getModuleInt(e, "charge_ticks", defChargeTime);
            long energy = ModuleCfg.getModuleLong(e, "charge_energy", defChargeEnergy);
            double invuln = ModuleCfg.getModuleDouble(e, "invulnerable_time", defInvulnSeconds);
            return new UndyingData(health, shield, shieldTime, charge, energy, (int)(invuln * 20.0));
        };
    }

    private static Function<Module<AutoFeedData>, AutoFeedData> autoFeedData(float defFoodStorage) {
        return e -> {
            float foodStorage = (float)ModuleCfg.getModuleDouble(e, "food_storage", defFoodStorage);
            return new AutoFeedData(foodStorage);
        };
    }

    private static Function<Module<DamageModData>, DamageModData> dmgModData(IDamageModifier modifier) {
        return e -> new DamageModData(modifier);
    }

    private static Function<Module<ProjectileData>, ProjectileData> projectileData(float defVelocityModifier, float defAccuracyModifier, float defAntiGravModifier, float defPenetrationModifier, float defDamageModifier) {
        return e -> {
            float velocityModifier = (float)ModuleCfg.getModuleDouble(e, "velocity_modifier", defVelocityModifier);
            float accuracyModifier = (float)ModuleCfg.getModuleDouble(e, "accuracy_modifier", defAccuracyModifier);
            float antiGravModifier = (float)ModuleCfg.getModuleDouble(e, "anti_grav_modifier", defAntiGravModifier);
            float penetrationModifier = (float)ModuleCfg.getModuleDouble(e, "penetration_modifier", defPenetrationModifier);
            float damageModifier = (float)ModuleCfg.getModuleDouble(e, "damage_modifier", defDamageModifier);
            return new ProjectileData(velocityModifier, accuracyModifier, antiGravModifier, penetrationModifier, damageModifier);
        };
    }

    private static Function<Module<ProjectileData>, ProjectileData> projVelocityData(float velocityModifier, float penaltyModifier) {
        float accuracyPenalty = velocityModifier * -0.125f * penaltyModifier;
        float penetrationBoost = velocityModifier * 0.25f * (1.0f - penaltyModifier);
        return DEModules.projectileData(velocityModifier, accuracyPenalty, 0.0f, penetrationBoost, 0.0f);
    }

    private static Function<Module<ProjectileData>, ProjectileData> projAccuracyData(float accuracyModifier, float penaltyModifier) {
        float velocityPenalty = accuracyModifier * -0.25f * penaltyModifier;
        float penetrationPenalty = velocityPenalty * 0.25f;
        return DEModules.projectileData(velocityPenalty, accuracyModifier, 0.0f, penetrationPenalty, 0.0f);
    }

    private static Function<Module<ProjectileData>, ProjectileData> projAntiGravData(float antiGravModifier, float penaltyModifier) {
        float velocityPenalty = antiGravModifier * -0.0625f * penaltyModifier;
        float accuracyPenalty = antiGravModifier * -0.125f * penaltyModifier;
        float damagePenalty = antiGravModifier * -0.15f * penaltyModifier;
        float penetrationPenalty = velocityPenalty * 0.25f;
        return DEModules.projectileData(velocityPenalty, accuracyPenalty, antiGravModifier, penetrationPenalty, damagePenalty);
    }

    private static Function<Module<ProjectileData>, ProjectileData> projPenetrationData(float penetrationModifier, float penaltyModifier) {
        float accuracyPenalty = penetrationModifier * -0.25f * penaltyModifier;
        return DEModules.projectileData(0.0f, accuracyPenalty, 0.0f, penetrationModifier, 0.0f);
    }

    private static Function<Module<ProjectileData>, ProjectileData> projDamageData(float damageModifier, float penaltyModifier) {
        float accuracyPenalty = damageModifier * -0.125f * penaltyModifier;
        return DEModules.projectileData(0.0f, accuracyPenalty, 0.0f, 0.0f, damageModifier);
    }

    private static Function<Module<TreeHarvestData>, TreeHarvestData> treeHarvestData(int defRange, int defSpeed) {
        return e -> new TreeHarvestData(ModuleCfg.getModuleInt(e, "range", defRange), ModuleCfg.getModuleInt(e, "speed", defSpeed));
    }

    private static Function<Module<NoData>, NoData> noData() {
        return e -> new NoData();
    }

    @SubscribeEvent
    public static void createRegistries(NewRegistryEvent event) {
        event.create(new RegistryBuilder().setName(new ResourceLocation("draconicevolution", "modules")).setType((Class)SneakyUtils.unsafeCast(Module.class)).disableSaving(), ts -> {
            MODULE_REGISTRY = ts;
        });
    }

    private static void register(ModuleImpl<?> module, String name) {
        ModuleItem item = new ModuleItem(new Item.Properties().m_41491_((CreativeModeTab)moduleGroup), module);
        item.setRegistryName(name + "_module");
        module.setRegistryName(name);
        module.setModuleItem(item);
        moduleItemMap.put(module, item);
    }

    private static <T extends ModuleData<T>> void register(ModuleImpl<T> module, ModuleItem<T> item, String name) {
        item.setRegistryName(name + "_module");
        item.setModule(module);
        module.setRegistryName(name);
        module.setModuleItem(item);
        moduleItemMap.put(module, item);
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        moduleItemMap.clear();
        DEModules.registerModules();
        moduleItemMap.keySet().forEach(BaseModule::reloadData);
        moduleItemMap.values().forEach(e -> event.getRegistry().register((IForgeRegistryEntry)e));
        ModuleCfg.saveStateConfig();
    }

    @SubscribeEvent
    public static void registerModules(RegistryEvent.Register<Module<?>> event) {
        moduleItemMap.keySet().forEach(e -> event.getRegistry().register((IForgeRegistryEntry)e));
    }
}

