/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.init;

import codechicken.lib.model.ModelRegistryHelper;
import com.brandon3055.brandonscore.BrandonsCore;
import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.brandonscore.api.hud.AbstractHudElement;
import com.brandon3055.brandonscore.handlers.contributor.ContributorHandler;
import com.brandon3055.draconicevolution.DEConfig;
import com.brandon3055.draconicevolution.blocks.energynet.EnergyCrystal;
import com.brandon3055.draconicevolution.client.CustomBossInfoHandler;
import com.brandon3055.draconicevolution.client.DEGuiSprites;
import com.brandon3055.draconicevolution.client.DEMiscSprites;
import com.brandon3055.draconicevolution.client.DEShaders;
import com.brandon3055.draconicevolution.client.ModuleSpriteUploader;
import com.brandon3055.draconicevolution.client.gui.GuiCelestialManipulator;
import com.brandon3055.draconicevolution.client.gui.GuiDisenchanter;
import com.brandon3055.draconicevolution.client.gui.GuiDraconiumChest;
import com.brandon3055.draconicevolution.client.gui.GuiEnergyCore;
import com.brandon3055.draconicevolution.client.gui.GuiEnergyTransfuser;
import com.brandon3055.draconicevolution.client.gui.GuiEntityDetector;
import com.brandon3055.draconicevolution.client.gui.GuiFlowGate;
import com.brandon3055.draconicevolution.client.gui.GuiFusionCraftingCore;
import com.brandon3055.draconicevolution.client.gui.GuiGenerator;
import com.brandon3055.draconicevolution.client.gui.GuiGrinder;
import com.brandon3055.draconicevolution.client.gui.GuiReactor;
import com.brandon3055.draconicevolution.client.gui.modular.GuiModularItem;
import com.brandon3055.draconicevolution.client.gui.modular.itemconfig.GuiConfigurableItem;
import com.brandon3055.draconicevolution.client.handler.ClientEventHandler;
import com.brandon3055.draconicevolution.client.handler.ModularItemRenderOverrideHandler;
import com.brandon3055.draconicevolution.client.handler.OverlayRenderHandler;
import com.brandon3055.draconicevolution.client.keybinding.KeyBindings;
import com.brandon3055.draconicevolution.client.keybinding.KeyInputHandler;
import com.brandon3055.draconicevolution.client.render.entity.DraconicGuardianRenderer;
import com.brandon3055.draconicevolution.client.render.entity.GuardianCrystalRenderer;
import com.brandon3055.draconicevolution.client.render.entity.GuardianProjectileRenderer;
import com.brandon3055.draconicevolution.client.render.entity.GuardianWitherRenderer;
import com.brandon3055.draconicevolution.client.render.entity.projectile.DraconicArrowRenderer;
import com.brandon3055.draconicevolution.client.render.hud.ShieldHudElement;
import com.brandon3055.draconicevolution.client.render.item.RenderItemChaosShard;
import com.brandon3055.draconicevolution.client.render.item.RenderItemDraconiumChest;
import com.brandon3055.draconicevolution.client.render.item.RenderItemEnergyCrystal;
import com.brandon3055.draconicevolution.client.render.item.RenderItemMobSoul;
import com.brandon3055.draconicevolution.client.render.item.RenderItemReactorComponent;
import com.brandon3055.draconicevolution.client.render.item.RenderModularAxe;
import com.brandon3055.draconicevolution.client.render.item.RenderModularBow;
import com.brandon3055.draconicevolution.client.render.item.RenderModularChestpiece;
import com.brandon3055.draconicevolution.client.render.item.RenderModularHoe;
import com.brandon3055.draconicevolution.client.render.item.RenderModularPickaxe;
import com.brandon3055.draconicevolution.client.render.item.RenderModularShovel;
import com.brandon3055.draconicevolution.client.render.item.RenderModularStaff;
import com.brandon3055.draconicevolution.client.render.item.RenderModularSword;
import com.brandon3055.draconicevolution.client.render.tile.DraconiumChestTileRenderer;
import com.brandon3055.draconicevolution.client.render.tile.RenderEnergyCoreStabilizer;
import com.brandon3055.draconicevolution.client.render.tile.RenderTileCelestialManipulator;
import com.brandon3055.draconicevolution.client.render.tile.RenderTileChaosCrystal;
import com.brandon3055.draconicevolution.client.render.tile.RenderTileCraftingInjector;
import com.brandon3055.draconicevolution.client.render.tile.RenderTileDisenchanter;
import com.brandon3055.draconicevolution.client.render.tile.RenderTileDislocatorPedestal;
import com.brandon3055.draconicevolution.client.render.tile.RenderTileEnergyCore;
import com.brandon3055.draconicevolution.client.render.tile.RenderTileEnergyCrystal;
import com.brandon3055.draconicevolution.client.render.tile.RenderTileEnergyPylon;
import com.brandon3055.draconicevolution.client.render.tile.RenderTileEnergyTransfuser;
import com.brandon3055.draconicevolution.client.render.tile.RenderTileEntityDetector;
import com.brandon3055.draconicevolution.client.render.tile.RenderTileFusionCraftingCore;
import com.brandon3055.draconicevolution.client.render.tile.RenderTileGenerator;
import com.brandon3055.draconicevolution.client.render.tile.RenderTileGrinder;
import com.brandon3055.draconicevolution.client.render.tile.RenderTilePlacedItem;
import com.brandon3055.draconicevolution.client.render.tile.RenderTilePotentiometer;
import com.brandon3055.draconicevolution.client.render.tile.RenderTileReactorComponent;
import com.brandon3055.draconicevolution.client.render.tile.RenderTileReactorCore;
import com.brandon3055.draconicevolution.client.render.tile.RenderTileStabilizedSpawner;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.items.equipment.IModularArmor;
import net.covers1624.quack.util.CrashLock;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.ElytraLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.jetbrains.annotations.NotNull;

public class ClientInit {
    private static final CrashLock LOCK = new CrashLock("Already Initialized.");
    private static final ModelRegistryHelper MODEL_HELPER = new ModelRegistryHelper();
    public static ModuleSpriteUploader moduleSpriteUploader;
    public static ShieldHudElement hudElement;

    public static void init() {
        LOCK.lock();
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        modBus.addListener(ClientInit::clientSetupEvent);
        modBus.addListener(ClientInit::onModelRegistryEvent);
        modBus.addListener(ClientInit::registerRenderers);
        modBus.addListener(ClientInit::onAddRenderLayers);
        modBus.addListener(DEGuiSprites::initialize);
        modBus.addListener(DEMiscSprites::initialize);
        modBus.addListener(event -> {
            moduleSpriteUploader = new ModuleSpriteUploader();
        });
        modBus.addGenericListener(AbstractHudElement.class, ClientInit::registerHudElements);
        ModularItemRenderOverrideHandler.init();
        CustomBossInfoHandler.init();
        OverlayRenderHandler.init();
        DEShaders.init();
    }

    private static void clientSetupEvent(FMLClientSetupEvent event) {
        ClientInit.registerGuiFactories();
        ClientInit.registerItemRenderers();
        ClientInit.setupRenderLayers();
        MinecraftForge.EVENT_BUS.register((Object)new KeyInputHandler());
        MinecraftForge.EVENT_BUS.register((Object)new ClientEventHandler());
        KeyBindings.init();
    }

    private static void onModelRegistryEvent(ModelRegistryEvent event) {
    }

    private static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer(DEContent.tile_grinder, RenderTileGrinder::new);
        event.registerBlockEntityRenderer(DEContent.tile_draconium_chest, DraconiumChestTileRenderer::new);
        event.registerBlockEntityRenderer(DEContent.tile_storage_core, RenderTileEnergyCore::new);
        event.registerBlockEntityRenderer(DEContent.tile_energy_pylon, RenderTileEnergyPylon::new);
        event.registerBlockEntityRenderer(DEContent.tile_core_stabilizer, RenderEnergyCoreStabilizer::new);
        event.registerBlockEntityRenderer(DEContent.tile_stabilized_spawner, RenderTileStabilizedSpawner::new);
        event.registerBlockEntityRenderer(DEContent.tile_generator, RenderTileGenerator::new);
        event.registerBlockEntityRenderer(DEContent.tile_crystal_io, RenderTileEnergyCrystal::new);
        event.registerBlockEntityRenderer(DEContent.tile_crystal_relay, RenderTileEnergyCrystal::new);
        event.registerBlockEntityRenderer(DEContent.tile_crystal_wireless, RenderTileEnergyCrystal::new);
        event.registerBlockEntityRenderer(DEContent.tile_reactor_core, RenderTileReactorCore::new);
        event.registerBlockEntityRenderer(DEContent.tile_reactor_injector, RenderTileReactorComponent::new);
        event.registerBlockEntityRenderer(DEContent.tile_reactor_stabilizer, RenderTileReactorComponent::new);
        event.registerBlockEntityRenderer(DEContent.tile_crafting_core, RenderTileFusionCraftingCore::new);
        event.registerBlockEntityRenderer(DEContent.tile_crafting_injector, RenderTileCraftingInjector::new);
        event.registerBlockEntityRenderer(DEContent.tile_potentiometer, RenderTilePotentiometer::new);
        event.registerBlockEntityRenderer(DEContent.tile_energy_transfuser, RenderTileEnergyTransfuser::new);
        event.registerBlockEntityRenderer(DEContent.tile_chaos_crystal, RenderTileChaosCrystal::new);
        event.registerBlockEntityRenderer(DEContent.tile_dislocator_pedestal, RenderTileDislocatorPedestal::new);
        event.registerBlockEntityRenderer(DEContent.tile_placed_item, RenderTilePlacedItem::new);
        event.registerBlockEntityRenderer(DEContent.tile_disenchanter, RenderTileDisenchanter::new);
        event.registerBlockEntityRenderer(DEContent.tile_celestial_manipulator, RenderTileCelestialManipulator::new);
        event.registerBlockEntityRenderer(DEContent.tile_entity_detector, RenderTileEntityDetector::new);
        event.registerEntityRenderer(DEContent.draconicGuardian, DraconicGuardianRenderer::new);
        event.registerEntityRenderer(DEContent.guardianProjectile, GuardianProjectileRenderer::new);
        event.registerEntityRenderer(DEContent.guardianCrystal, GuardianCrystalRenderer::new);
        event.registerEntityRenderer(DEContent.draconicArrow, DraconicArrowRenderer::new);
        event.registerEntityRenderer(DEContent.guardianWither, GuardianWitherRenderer::new);
    }

    private static void registerGuiFactories() {
        MenuScreens.m_96206_(DEContent.container_generator, GuiGenerator::new);
        MenuScreens.m_96206_(DEContent.container_grinder, GuiGrinder::new);
        MenuScreens.m_96206_(DEContent.container_draconium_chest, GuiDraconiumChest::new);
        MenuScreens.m_96206_(DEContent.container_energy_core, GuiEnergyCore::new);
        MenuScreens.m_96206_(DEContent.container_modular_item, GuiModularItem::new);
        MenuScreens.m_96206_(DEContent.container_configurable_item, GuiConfigurableItem::new);
        MenuScreens.m_96206_(DEContent.container_reactor, GuiReactor::new);
        MenuScreens.m_96206_(DEContent.container_celestial_manipulator, GuiCelestialManipulator::new);
        MenuScreens.m_96206_(DEContent.container_disenchanter, GuiDisenchanter::new);
        MenuScreens.m_96206_(DEContent.container_fusion_crafting_core, GuiFusionCraftingCore::new);
        MenuScreens.m_96206_(DEContent.container_flow_gate, GuiFlowGate::new);
        MenuScreens.m_96206_(DEContent.container_entity_detector, GuiEntityDetector::new);
        MenuScreens.m_96206_(DEContent.container_energy_transfuser, GuiEnergyTransfuser::new);
    }

    private static void registerItemRenderers() {
        MODEL_HELPER.register(new ModelResourceLocation(DEContent.chaos_shard.getRegistryName(), "inventory"), (BakedModel)new RenderItemChaosShard(DEContent.chaos_shard));
        MODEL_HELPER.register(new ModelResourceLocation(DEContent.chaos_frag_large.getRegistryName(), "inventory"), (BakedModel)new RenderItemChaosShard(DEContent.chaos_frag_large));
        MODEL_HELPER.register(new ModelResourceLocation(DEContent.chaos_frag_medium.getRegistryName(), "inventory"), (BakedModel)new RenderItemChaosShard(DEContent.chaos_frag_medium));
        MODEL_HELPER.register(new ModelResourceLocation(DEContent.chaos_frag_small.getRegistryName(), "inventory"), (BakedModel)new RenderItemChaosShard(DEContent.chaos_frag_small));
        MODEL_HELPER.register(new ModelResourceLocation(DEContent.mob_soul.getRegistryName(), "inventory"), (BakedModel)new RenderItemMobSoul());
        MODEL_HELPER.register(new ModelResourceLocation(DEContent.crystal_io_basic.getRegistryName(), "inventory"), (BakedModel)new RenderItemEnergyCrystal(EnergyCrystal.CrystalType.CRYSTAL_IO, TechLevel.DRACONIUM));
        MODEL_HELPER.register(new ModelResourceLocation(DEContent.crystal_io_wyvern.getRegistryName(), "inventory"), (BakedModel)new RenderItemEnergyCrystal(EnergyCrystal.CrystalType.CRYSTAL_IO, TechLevel.WYVERN));
        MODEL_HELPER.register(new ModelResourceLocation(DEContent.crystal_io_draconic.getRegistryName(), "inventory"), (BakedModel)new RenderItemEnergyCrystal(EnergyCrystal.CrystalType.CRYSTAL_IO, TechLevel.DRACONIC));
        MODEL_HELPER.register(new ModelResourceLocation(DEContent.crystal_relay_basic.getRegistryName(), "inventory"), (BakedModel)new RenderItemEnergyCrystal(EnergyCrystal.CrystalType.RELAY, TechLevel.DRACONIUM));
        MODEL_HELPER.register(new ModelResourceLocation(DEContent.crystal_relay_wyvern.getRegistryName(), "inventory"), (BakedModel)new RenderItemEnergyCrystal(EnergyCrystal.CrystalType.RELAY, TechLevel.WYVERN));
        MODEL_HELPER.register(new ModelResourceLocation(DEContent.crystal_relay_draconic.getRegistryName(), "inventory"), (BakedModel)new RenderItemEnergyCrystal(EnergyCrystal.CrystalType.RELAY, TechLevel.DRACONIC));
        MODEL_HELPER.register(new ModelResourceLocation(DEContent.crystal_wireless_basic.getRegistryName(), "inventory"), (BakedModel)new RenderItemEnergyCrystal(EnergyCrystal.CrystalType.WIRELESS, TechLevel.DRACONIUM));
        MODEL_HELPER.register(new ModelResourceLocation(DEContent.crystal_wireless_wyvern.getRegistryName(), "inventory"), (BakedModel)new RenderItemEnergyCrystal(EnergyCrystal.CrystalType.WIRELESS, TechLevel.WYVERN));
        MODEL_HELPER.register(new ModelResourceLocation(DEContent.crystal_wireless_draconic.getRegistryName(), "inventory"), (BakedModel)new RenderItemEnergyCrystal(EnergyCrystal.CrystalType.WIRELESS, TechLevel.DRACONIC));
        MODEL_HELPER.register(new ModelResourceLocation(DEContent.draconium_chest.getRegistryName(), "inventory"), (BakedModel)new RenderItemDraconiumChest());
        MODEL_HELPER.register(new ModelResourceLocation(DEContent.reactor_core.getRegistryName(), "inventory"), (BakedModel)new RenderItemReactorComponent());
        MODEL_HELPER.register(new ModelResourceLocation(DEContent.reactor_stabilizer.getRegistryName(), "inventory"), (BakedModel)new RenderItemReactorComponent());
        MODEL_HELPER.register(new ModelResourceLocation(DEContent.reactor_injector.getRegistryName(), "inventory"), (BakedModel)new RenderItemReactorComponent());
        MODEL_HELPER.register(new ModelResourceLocation(DEContent.reactor_prt_stab_frame.getRegistryName(), "inventory"), (BakedModel)new RenderItemReactorComponent());
        MODEL_HELPER.register(new ModelResourceLocation(DEContent.reactor_prt_in_rotor.getRegistryName(), "inventory"), (BakedModel)new RenderItemReactorComponent());
        MODEL_HELPER.register(new ModelResourceLocation(DEContent.reactor_prt_out_rotor.getRegistryName(), "inventory"), (BakedModel)new RenderItemReactorComponent());
        MODEL_HELPER.register(new ModelResourceLocation(DEContent.reactor_prt_rotor_full.getRegistryName(), "inventory"), (BakedModel)new RenderItemReactorComponent());
        MODEL_HELPER.register(new ModelResourceLocation(DEContent.reactor_prt_focus_ring.getRegistryName(), "inventory"), (BakedModel)new RenderItemReactorComponent());
        if (DEConfig.fancyToolModels) {
            MODEL_HELPER.register(new ModelResourceLocation(DEContent.pickaxe_wyvern.getRegistryName(), "inventory"), (BakedModel)new RenderModularPickaxe(TechLevel.WYVERN));
            MODEL_HELPER.register(new ModelResourceLocation(DEContent.pickaxe_draconic.getRegistryName(), "inventory"), (BakedModel)new RenderModularPickaxe(TechLevel.DRACONIC));
            MODEL_HELPER.register(new ModelResourceLocation(DEContent.pickaxe_chaotic.getRegistryName(), "inventory"), (BakedModel)new RenderModularPickaxe(TechLevel.CHAOTIC));
            MODEL_HELPER.register(new ModelResourceLocation(DEContent.axe_wyvern.getRegistryName(), "inventory"), (BakedModel)new RenderModularAxe(TechLevel.WYVERN));
            MODEL_HELPER.register(new ModelResourceLocation(DEContent.axe_draconic.getRegistryName(), "inventory"), (BakedModel)new RenderModularAxe(TechLevel.DRACONIC));
            MODEL_HELPER.register(new ModelResourceLocation(DEContent.axe_chaotic.getRegistryName(), "inventory"), (BakedModel)new RenderModularAxe(TechLevel.CHAOTIC));
            MODEL_HELPER.register(new ModelResourceLocation(DEContent.shovel_wyvern.getRegistryName(), "inventory"), (BakedModel)new RenderModularShovel(TechLevel.WYVERN));
            MODEL_HELPER.register(new ModelResourceLocation(DEContent.shovel_draconic.getRegistryName(), "inventory"), (BakedModel)new RenderModularShovel(TechLevel.DRACONIC));
            MODEL_HELPER.register(new ModelResourceLocation(DEContent.shovel_chaotic.getRegistryName(), "inventory"), (BakedModel)new RenderModularShovel(TechLevel.CHAOTIC));
            MODEL_HELPER.register(new ModelResourceLocation(DEContent.sword_wyvern.getRegistryName(), "inventory"), (BakedModel)new RenderModularSword(TechLevel.WYVERN));
            MODEL_HELPER.register(new ModelResourceLocation(DEContent.sword_draconic.getRegistryName(), "inventory"), (BakedModel)new RenderModularSword(TechLevel.DRACONIC));
            MODEL_HELPER.register(new ModelResourceLocation(DEContent.sword_chaotic.getRegistryName(), "inventory"), (BakedModel)new RenderModularSword(TechLevel.CHAOTIC));
            MODEL_HELPER.register(new ModelResourceLocation(DEContent.bow_wyvern.getRegistryName(), "inventory"), (BakedModel)new RenderModularBow(TechLevel.WYVERN));
            MODEL_HELPER.register(new ModelResourceLocation(DEContent.bow_draconic.getRegistryName(), "inventory"), (BakedModel)new RenderModularBow(TechLevel.DRACONIC));
            MODEL_HELPER.register(new ModelResourceLocation(DEContent.bow_chaotic.getRegistryName(), "inventory"), (BakedModel)new RenderModularBow(TechLevel.CHAOTIC));
            MODEL_HELPER.register(new ModelResourceLocation(DEContent.staff_draconic.getRegistryName(), "inventory"), (BakedModel)new RenderModularStaff(TechLevel.DRACONIC));
            MODEL_HELPER.register(new ModelResourceLocation(DEContent.staff_chaotic.getRegistryName(), "inventory"), (BakedModel)new RenderModularStaff(TechLevel.CHAOTIC));
            MODEL_HELPER.register(new ModelResourceLocation(DEContent.hoe_wyvern.getRegistryName(), "inventory"), (BakedModel)new RenderModularHoe(TechLevel.WYVERN));
            MODEL_HELPER.register(new ModelResourceLocation(DEContent.hoe_draconic.getRegistryName(), "inventory"), (BakedModel)new RenderModularHoe(TechLevel.DRACONIC));
            MODEL_HELPER.register(new ModelResourceLocation(DEContent.hoe_chaotic.getRegistryName(), "inventory"), (BakedModel)new RenderModularHoe(TechLevel.CHAOTIC));
            MODEL_HELPER.register(new ModelResourceLocation(DEContent.chestpiece_wyvern.getRegistryName(), "inventory"), (BakedModel)new RenderModularChestpiece(TechLevel.WYVERN));
            MODEL_HELPER.register(new ModelResourceLocation(DEContent.chestpiece_draconic.getRegistryName(), "inventory"), (BakedModel)new RenderModularChestpiece(TechLevel.DRACONIC));
            MODEL_HELPER.register(new ModelResourceLocation(DEContent.chestpiece_chaotic.getRegistryName(), "inventory"), (BakedModel)new RenderModularChestpiece(TechLevel.CHAOTIC));
        }
    }

    private static void setupRenderLayers() {
        ItemBlockRenderTypes.setRenderLayer((Block)DEContent.grinder, (RenderType)RenderType.m_110457_());
        ItemBlockRenderTypes.setRenderLayer((Block)DEContent.generator, (RenderType)RenderType.m_110457_());
        ItemBlockRenderTypes.setRenderLayer((Block)DEContent.energy_transfuser, (RenderType)RenderType.m_110457_());
        ItemBlockRenderTypes.setRenderLayer((Block)DEContent.portal, (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)DEContent.ore_draconium_overworld, renderType -> renderType == RenderType.m_110451_() || renderType == RenderType.m_110457_());
        ItemBlockRenderTypes.setRenderLayer((Block)DEContent.ore_draconium_end, renderType -> renderType == RenderType.m_110451_() || renderType == RenderType.m_110457_());
        ItemBlockRenderTypes.setRenderLayer((Block)DEContent.ore_draconium_nether, renderType -> renderType == RenderType.m_110451_() || renderType == RenderType.m_110457_());
        ItemBlockRenderTypes.setRenderLayer((Block)DEContent.ore_draconium_deepslate, renderType -> renderType == RenderType.m_110451_() || renderType == RenderType.m_110457_());
    }

    private static void onAddRenderLayers(EntityRenderersEvent.AddLayers event) {
        for (String skin : event.getSkins()) {
            LivingEntityRenderer renderer = event.getSkin(skin);
            assert (renderer != null);
            renderer.m_115326_((RenderLayer)new ElytraLayer((RenderLayerParent)renderer, event.getEntityModels()){

                public boolean shouldRender(@NotNull ItemStack stack, @NotNull LivingEntity entity) {
                    if (ContributorHandler.shouldCancelElytra((LivingEntity)entity)) {
                        return false;
                    }
                    Item item = stack.m_41720_();
                    if (item instanceof IModularArmor) {
                        IModularArmor item2 = (IModularArmor)item;
                        return item2.canElytraFlyBC(stack, entity);
                    }
                    if (BrandonsCore.equipmentManager != null) {
                        IModularArmor item3;
                        ItemStack curio = BrandonsCore.equipmentManager.findMatchingItem(e -> e.m_41720_() instanceof IModularArmor, entity);
                        Item item4 = curio.m_41720_();
                        return item4 instanceof IModularArmor && (item3 = (IModularArmor)item4).canElytraFlyBC(curio, entity);
                    }
                    return false;
                }
            });
        }
    }

    public static void registerHudElements(RegistryEvent.Register<AbstractHudElement> event) {
        hudElement = new ShieldHudElement();
        event.getRegistry().register((IForgeRegistryEntry)((AbstractHudElement)hudElement.setRegistryName("shield_hud")));
    }

    static {
        hudElement = null;
    }
}

