/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.handlers;

import com.brandon3055.brandonscore.api.power.IOPStorage;
import com.brandon3055.brandonscore.api.power.IOPStorageModifiable;
import com.brandon3055.draconicevolution.api.capability.DECapabilities;
import com.brandon3055.draconicevolution.api.capability.ModuleHost;
import com.brandon3055.draconicevolution.api.capability.PropertyProvider;
import com.brandon3055.draconicevolution.api.modules.ModuleTypes;
import com.brandon3055.draconicevolution.api.modules.data.JumpData;
import com.brandon3055.draconicevolution.api.modules.data.SpeedData;
import com.brandon3055.draconicevolution.api.modules.entities.FlightEntity;
import com.brandon3055.draconicevolution.api.modules.entities.ShieldControlEntity;
import com.brandon3055.draconicevolution.api.modules.entities.UndyingEntity;
import com.brandon3055.draconicevolution.init.EquipCfg;
import com.brandon3055.draconicevolution.integration.equipment.EquipmentManager;
import com.brandon3055.draconicevolution.items.equipment.IModularItem;
import com.brandon3055.draconicevolution.items.equipment.ModularChestpiece;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import net.minecraft.core.NonNullList;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="draconicevolution", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ModularArmorEventHandler {
    private static final EquipmentSlot[] ARMOR_SLOTS = new EquipmentSlot[]{EquipmentSlot.FEET, EquipmentSlot.LEGS, EquipmentSlot.CHEST, EquipmentSlot.HEAD};
    public static final UUID WALK_SPEED_UUID = UUID.fromString("0ea6ce8e-d2e8-11e5-ab30-625662870761");
    private static final DamageSource KILL_COMMAND = new DamageSource("administrative.kill").m_19381_().m_19380_().m_19382_();
    public static Map<Player, Boolean> playersWithFlight = new WeakHashMap<Player, Boolean>();
    public static List<UUID> playersWithUphillStep = new ArrayList<UUID>();

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onEntityAttacked(LivingAttackEvent event) {
        if (event.isCanceled() || event.getAmount() <= 0.0f || event.getEntityLiving().f_19853_.f_46443_ || event.getSource() == KILL_COMMAND) {
            return;
        }
        LivingEntity entity = event.getEntityLiving();
        ItemStack chestStack = ModularChestpiece.getChestpiece(entity);
        LazyOptional optionalHost = chestStack.getCapability(DECapabilities.MODULE_HOST_CAPABILITY);
        if (chestStack.m_41619_() || !optionalHost.isPresent()) {
            return;
        }
        if (event.getAmount() == Float.MAX_VALUE && event.getSource() == DamageSource.f_19317_) {
            event.setCanceled(true);
            event.getEntityLiving().m_6469_(KILL_COMMAND, Float.MAX_VALUE);
            return;
        }
        ModuleHost host = (ModuleHost)optionalHost.orElseThrow(IllegalStateException::new);
        if (host.getEntitiesByType(ModuleTypes.UNDYING).anyMatch(module -> ((UndyingEntity)module).tryBlockDamage(event))) {
            return;
        }
        ShieldControlEntity shieldControl = host.getEntitiesByType(ModuleTypes.SHIELD_CONTROLLER).map(e -> (ShieldControlEntity)e).findAny().orElse(null);
        if (shieldControl == null) {
            return;
        }
        shieldControl.tryBlockDamage(event);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onEntityDamaged(LivingDamageEvent event) {
        if (event.isCanceled() || event.getAmount() <= 0.0f || event.getEntityLiving().f_19853_.f_46443_ || event.getSource() == KILL_COMMAND) {
            return;
        }
        LivingEntity entity = event.getEntityLiving();
        ItemStack chestStack = ModularChestpiece.getChestpiece(entity);
        LazyOptional optionalHost = chestStack.getCapability(DECapabilities.MODULE_HOST_CAPABILITY);
        if (chestStack.m_41619_() || !optionalHost.isPresent()) {
            return;
        }
        ModuleHost host = (ModuleHost)optionalHost.orElseThrow(IllegalStateException::new);
        if (host.getEntitiesByType(ModuleTypes.UNDYING).anyMatch(module -> ((UndyingEntity)module).tryBlockDamage(event))) {
            return;
        }
        ShieldControlEntity shieldControl = host.getEntitiesByType(ModuleTypes.SHIELD_CONTROLLER).map(e -> (ShieldControlEntity)e).findAny().orElse(null);
        if (shieldControl == null) {
            return;
        }
        shieldControl.tryBlockDamage(event);
    }

    @SubscribeEvent
    public static void onEntityFall(LivingFallEvent event) {
        LivingEntity entity = event.getEntityLiving();
        float jumpBoost = ModularArmorEventHandler.getJumpBoost(entity, true);
        if (jumpBoost > 0.0f) {
            event.setDistance(Math.max(0.0f, event.getDistance() - (jumpBoost *= 2.0f)));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onEntityDeath(LivingDeathEvent event) {
        if (event.isCanceled() || event.getEntityLiving().f_19853_.f_46443_) {
            return;
        }
        LivingEntity entity = event.getEntityLiving();
        ArrayList<UndyingEntity> undyingModules = new ArrayList<UndyingEntity>();
        if (entity instanceof Player) {
            EquipmentSlot[] player = (EquipmentSlot[])entity;
            NonNullList stacks = player.m_150109_().f_35974_;
            for (int i = 0; i < stacks.size(); ++i) {
                ModularArmorEventHandler.getUndyingEntities((ItemStack)stacks.get(i), undyingModules, (EquipmentSlot)(player.m_150109_().f_35977_ == i ? EquipmentSlot.MAINHAND : null), false);
            }
            for (EquipmentSlot slot : ARMOR_SLOTS) {
                ModularArmorEventHandler.getUndyingEntities((ItemStack)player.m_150109_().f_35975_.get(slot.m_20749_()), undyingModules, slot, false);
            }
            for (ItemStack stack : player.m_150109_().f_35976_) {
                ModularArmorEventHandler.getUndyingEntities(stack, undyingModules, EquipmentSlot.OFFHAND, false);
            }
            for (ItemStack stack : EquipmentManager.getAllItems(entity)) {
                ModularArmorEventHandler.getUndyingEntities(stack, undyingModules, null, true);
            }
        } else if (EquipmentManager.equipModLoaded()) {
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                ModularArmorEventHandler.getUndyingEntities(entity.m_6844_(slot), undyingModules, slot, true);
            }
        }
        if (undyingModules.isEmpty() || event.getSource() == KILL_COMMAND) {
            return;
        }
        boolean blocked = undyingModules.stream().sorted(Comparator.comparing(e -> e.getModule().getModuleTechLevel().index)).anyMatch(e -> e.tryBlockDeath(event));
        if (blocked) {
            event.setCanceled(true);
        }
    }

    private static void getUndyingEntities(ItemStack stack, List<UndyingEntity> entities, EquipmentSlot slot, boolean inEquipModSlot) {
        LazyOptional optional = stack.getCapability(DECapabilities.MODULE_HOST_CAPABILITY);
        if (!stack.m_41619_() && stack.m_41720_() instanceof IModularItem && ((IModularItem)stack.m_41720_()).isEquipped(stack, slot, inEquipModSlot)) {
            optional.ifPresent(host -> entities.addAll(host.getModuleEntities().stream().filter(e -> e instanceof UndyingEntity).map(e -> (UndyingEntity)e).collect(Collectors.toList())));
        }
    }

    @SubscribeEvent
    public static void livingTick(LivingEvent.LivingUpdateEvent event) {
        LivingEntity entity = event.getEntityLiving();
        ArmorAbilities armorAbilities = new ArmorAbilities();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            NonNullList stacks = player.m_150109_().f_35974_;
            for (int i = 0; i < stacks.size(); ++i) {
                ModularArmorEventHandler.tryTickStack((ItemStack)stacks.get(i), (LivingEntity)player, (EquipmentSlot)(player.m_150109_().f_35977_ == i ? EquipmentSlot.MAINHAND : null), armorAbilities, false);
            }
            for (EquipmentSlot slot : ARMOR_SLOTS) {
                ModularArmorEventHandler.tryTickStack((ItemStack)player.m_150109_().f_35975_.get(slot.m_20749_()), (LivingEntity)player, slot, armorAbilities, false);
            }
            for (ItemStack stack2 : player.m_150109_().f_35976_) {
                ModularArmorEventHandler.tryTickStack(stack2, (LivingEntity)player, EquipmentSlot.OFFHAND, armorAbilities, false);
            }
            if (EquipmentManager.equipModLoaded()) {
                EquipmentManager.findItems(e -> e.m_41720_() instanceof IModularItem, entity).forEach(stack -> ModularArmorEventHandler.tryTickStack(stack, (LivingEntity)player, null, armorAbilities, true));
            }
        } else {
            for (Player slot : EquipmentSlot.values()) {
                ModularArmorEventHandler.tryTickStack(entity.m_6844_((EquipmentSlot)slot), entity, (EquipmentSlot)slot, armorAbilities, false);
            }
        }
        if (entity.f_19853_.f_46443_) {
            boolean hasHighStep;
            ItemStack chestStack = ModularChestpiece.getChestpiece(entity);
            LazyOptional optional = chestStack.getCapability(DECapabilities.MODULE_HOST_CAPABILITY);
            boolean hasHost = !chestStack.m_41619_() && optional.isPresent();
            boolean highStepListed = playersWithUphillStep.contains(entity.m_142081_()) && entity.f_19793_ >= 1.0f;
            boolean bl = hasHighStep = hasHost && ((ModuleHost)optional.orElseThrow(IllegalStateException::new)).getEntitiesByType(ModuleTypes.HILL_STEP).findAny().isPresent() && !entity.m_6144_();
            if (hasHighStep && !highStepListed) {
                playersWithUphillStep.add(entity.m_142081_());
                entity.f_19793_ = 1.0625f;
            }
            if (!hasHighStep && highStepListed) {
                playersWithUphillStep.remove(entity.m_142081_());
                entity.f_19793_ = 0.6f;
            }
        }
        Attribute speedAttr = Attributes.f_22279_;
        double speedModifier = 0.0;
        if (armorAbilities.data != null) {
            speedModifier = armorAbilities.data.speedMultiplier();
            if (entity.m_20142_() && armorAbilities.speedSettingRun != -1.0f) {
                speedModifier = Math.min(speedModifier, (double)armorAbilities.speedSettingRun);
            } else if (armorAbilities.speedSetting != -1.0f) {
                speedModifier = Math.min(speedModifier, (double)armorAbilities.speedSetting);
            }
        }
        AttributeModifier currentModifier = entity.m_21051_(speedAttr).m_22111_(WALK_SPEED_UUID);
        if (speedModifier > 0.0) {
            if (currentModifier == null) {
                entity.m_21051_(speedAttr).m_22118_(new AttributeModifier(WALK_SPEED_UUID, speedAttr.m_22087_(), speedModifier, AttributeModifier.Operation.MULTIPLY_BASE));
            } else if (currentModifier.m_22218_() != speedModifier) {
                entity.m_21051_(speedAttr).m_22130_(currentModifier);
                entity.m_21051_(speedAttr).m_22118_(new AttributeModifier(WALK_SPEED_UUID, speedAttr.m_22087_(), speedModifier, AttributeModifier.Operation.MULTIPLY_BASE));
            }
            if (!entity.m_20096_() && entity.m_20202_() == null) {
                entity.f_20887_ = 0.02f + 0.02f * (float)speedModifier;
            }
        } else if (currentModifier != null) {
            entity.m_21051_(speedAttr).m_22130_(currentModifier);
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            boolean canFly = true;
            boolean noPower = false;
            if (armorAbilities.creativeFlight && armorAbilities.flightPower != null && !player.m_150110_().f_35937_ && !player.m_5833_()) {
                canFly = armorAbilities.flightPower.getOPStored() >= (long)EquipCfg.creativeFlightEnergy;
                boolean bl = noPower = !canFly;
                if (canFly && player.m_150110_().f_35935_ && !entity.f_19853_.f_46443_) {
                    if (armorAbilities.flightPower instanceof IOPStorageModifiable) {
                        ((IOPStorageModifiable)armorAbilities.flightPower).modifyEnergyStored((long)(-EquipCfg.creativeFlightEnergy));
                    } else {
                        armorAbilities.flightPower.extractOP((long)EquipCfg.creativeFlightEnergy, false);
                    }
                }
            }
            if (armorAbilities.creativeFlight && canFly) {
                player.m_150110_().f_35936_ = true;
                playersWithFlight.put(player, true);
            } else {
                if (!playersWithFlight.containsKey(player)) {
                    playersWithFlight.put(player, false);
                }
                if (playersWithFlight.get(player).booleanValue() && !entity.f_19853_.f_46443_) {
                    playersWithFlight.put(player, false);
                    if (!player.m_150110_().f_35937_ && !player.m_5833_()) {
                        boolean wasFlying = player.m_150110_().f_35935_;
                        player.m_150110_().f_35936_ = false;
                        player.m_150110_().f_35935_ = false;
                        player.m_6885_();
                        if (wasFlying && noPower) {
                            player.m_36319_();
                        }
                    }
                }
                if (player.f_19853_.f_46443_ && playersWithFlight.get(player).booleanValue()) {
                    playersWithFlight.put(player, false);
                    if (!player.m_150110_().f_35937_) {
                        player.m_150110_().f_35936_ = false;
                        player.m_150110_().f_35935_ = false;
                    }
                }
            }
        }
    }

    private static float getJumpBoost(LivingEntity entity, boolean max) {
        ModuleHost host;
        JumpData jumpData;
        ItemStack chestStack = ModularChestpiece.getChestpiece(entity);
        LazyOptional optional = chestStack.getCapability(DECapabilities.MODULE_HOST_CAPABILITY);
        if (optional.isPresent() && (jumpData = (host = (ModuleHost)optional.orElseThrow(IllegalStateException::new)).getModuleData(ModuleTypes.JUMP_BOOST)) != null) {
            double jump = jumpData.multiplier();
            if (max) {
                return (float)jump;
            }
            if (entity.m_20142_()) {
                if (host instanceof PropertyProvider && ((PropertyProvider)((Object)host)).hasDecimal("jump_boost_run")) {
                    jump = Math.min(jump, ((PropertyProvider)((Object)host)).getDecimal("jump_boost_run").getValue());
                }
            } else if (host instanceof PropertyProvider && ((PropertyProvider)((Object)host)).hasDecimal("jump_boost")) {
                jump = Math.min(jump, ((PropertyProvider)((Object)host)).getDecimal("jump_boost").getValue());
            }
            return (float)jump;
        }
        return 0.0f;
    }

    private static void tryTickStack(ItemStack stack, LivingEntity entity, EquipmentSlot slot, ArmorAbilities abilities, boolean equipMod) {
        if (stack.m_41720_() instanceof IModularItem) {
            ((IModularItem)stack.m_41720_()).handleTick(stack, entity, slot, equipMod);
            if (slot != null && slot.m_20743_() == EquipmentSlot.Type.ARMOR || equipMod) {
                LazyOptional optional = stack.getCapability(DECapabilities.MODULE_HOST_CAPABILITY);
                optional.ifPresent(host -> ModularArmorEventHandler.gatherArmorProps(stack, host, entity, abilities));
            }
        }
    }

    @SubscribeEvent
    public static void onLivingJumpEvent(LivingEvent.LivingJumpEvent event) {
        LivingEntity entity = event.getEntityLiving();
        float jumpBoost = ModularArmorEventHandler.getJumpBoost(entity, false);
        if (jumpBoost > 0.0f && !entity.m_6144_()) {
            entity.m_5997_(0.0, (double)(0.1f * (jumpBoost + 1.0f)), 0.0);
        }
    }

    public static void gatherArmorProps(ItemStack stack, ModuleHost host, LivingEntity entity, ArmorAbilities abilities) {
        FlightEntity flight;
        SpeedData speed = host.getModuleData(ModuleTypes.SPEED);
        if (speed != null) {
            abilities.addSpeedData(speed, host);
        }
        if ((flight = (FlightEntity)host.getEntitiesByType(ModuleTypes.FLIGHT).map(e -> (FlightEntity)e).findAny().orElse(null)) != null) {
            LazyOptional optional = stack.getCapability(DECapabilities.OP_STORAGE);
            abilities.addFlightData(flight, optional.isPresent() ? (IOPStorage)optional.orElseThrow(IllegalStateException::new) : null);
        }
    }

    private static class ArmorAbilities {
        private float speedSetting = -1.0f;
        private float speedSettingRun = -1.0f;
        private SpeedData data;
        private boolean elytraFlight = false;
        private boolean creativeFlight = false;
        private IOPStorage flightPower = null;

        private ArmorAbilities() {
        }

        private void addSpeedData(SpeedData data, ModuleHost host) {
            SpeedData speedData = this.data = this.data == null ? data : this.data.combine(data);
            if (host instanceof PropertyProvider) {
                if (((PropertyProvider)((Object)host)).hasDecimal("run_speed")) {
                    if (this.speedSettingRun == -1.0f) {
                        this.speedSettingRun = 0.0f;
                    }
                    this.speedSettingRun = (float)((double)this.speedSettingRun + ((PropertyProvider)((Object)host)).getDecimal("run_speed").getValue());
                }
                if (((PropertyProvider)((Object)host)).hasDecimal("walk_speed")) {
                    if (this.speedSetting == -1.0f) {
                        this.speedSetting = 0.0f;
                    }
                    this.speedSetting = (float)((double)this.speedSetting + ((PropertyProvider)((Object)host)).getDecimal("walk_speed").getValue());
                }
            }
        }

        private void addFlightData(FlightEntity entity, IOPStorage flightPower) {
            this.elytraFlight = this.elytraFlight || entity.getElytraEnabled();
            boolean bl = this.creativeFlight = this.creativeFlight || entity.getCreativeEnabled();
            if (flightPower != null && (this.flightPower == null || flightPower.getOPStored() > this.flightPower.getOPStored())) {
                this.flightPower = flightPower;
            }
        }
    }
}

