/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.handlers;

import com.brandon3055.brandonscore.api.power.IOPStorage;
import com.brandon3055.brandonscore.utils.EnergyUtils;
import com.brandon3055.draconicevolution.DEConfig;
import com.brandon3055.draconicevolution.api.IReaperItem;
import com.brandon3055.draconicevolution.api.capability.DECapabilities;
import com.brandon3055.draconicevolution.api.modules.ModuleTypes;
import com.brandon3055.draconicevolution.api.modules.entities.EnderCollectionEntity;
import com.brandon3055.draconicevolution.api.modules.entities.JunkFilterEntity;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleEntity;
import com.brandon3055.draconicevolution.entity.guardian.DraconicGuardianEntity;
import com.brandon3055.draconicevolution.init.DEContent;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.function.Predicate;
import net.covers1624.quack.util.CrashLock;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.dimension.end.EndDragonFight;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.EndPodiumFeature;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LootEventHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final CrashLock LOCK = new CrashLock("Already Initialized");
    private static final Random RANDOM = new Random();
    private static final List<UUID> deadDragons = new LinkedList<UUID>();

    public static void init() {
        LOCK.lock();
        MinecraftForge.EVENT_BUS.addListener(EventPriority.HIGH, LootEventHandler::addDrops);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.LOWEST, LootEventHandler::processDrops);
    }

    public static void addDrops(LivingDropsEvent event) {
        LivingEntity entity = event.getEntityLiving();
        Level level = entity.f_19853_;
        if (level.m_5776_() || event.isCanceled()) {
            return;
        }
        LootEventHandler.handleDragonDrops(entity, event);
        Entity attacker = event.getSource().m_7639_();
        if (!(attacker instanceof Player)) {
            return;
        }
        Player player = (Player)attacker;
        LootEventHandler.handleSoulDrops(entity, player, level, event);
    }

    public static void processDrops(LivingDropsEvent event) {
        Player player;
        block3: {
            block2: {
                Entity attacker = event.getSource().m_7639_();
                if (!(attacker instanceof Player)) break block2;
                player = (Player)attacker;
                if (!player.f_19853_.m_5776_()) break block3;
            }
            return;
        }
        LootEventHandler.handleLootCollection(player, event);
    }

    private static void handleDragonDrops(LivingEntity entity, LivingDropsEvent event) {
        if (deadDragons.contains(entity.m_142081_())) {
            event.setCanceled(true);
            return;
        }
        if (entity instanceof EnderDragon || entity instanceof DraconicGuardianEntity) {
            deadDragons.add(entity.m_142081_());
            ItemEntity item = (ItemEntity)EntityType.f_20461_.m_20615_(entity.f_19853_);
            if (item != null) {
                item.m_32045_(new ItemStack((ItemLike)DEContent.dragon_heart));
                BlockPos podiumPos = entity.f_19853_.m_5452_(Heightmap.Types.WORLD_SURFACE, EndPodiumFeature.f_65714_).m_142082_(0, 3, 0);
                item.m_7678_((double)podiumPos.m_123341_() + 0.5, (double)podiumPos.m_123342_(), (double)podiumPos.m_123343_() + 0.5, 0.0f, 0.0f);
                item.m_20334_(0.0, 0.0, 0.0);
                item.f_31985_ = -32767;
                item.m_20242_(true);
                entity.f_19853_.m_7967_((Entity)item);
            }
            if (entity instanceof EnderDragon) {
                EndDragonFight manager = ((EnderDragon)entity).m_31158_();
                if (DEConfig.dragonEggSpawnOverride && manager != null && manager.m_64099_()) {
                    entity.f_19853_.m_46597_(entity.f_19853_.m_5452_(Heightmap.Types.WORLD_SURFACE, EndPodiumFeature.f_65714_).m_142082_(0, 0, -4), Blocks.f_50260_.m_49966_());
                }
            }
            if (DEConfig.dragonDustLootModifier > 0) {
                double count = (double)DEConfig.dragonDustLootModifier * 0.9 + entity.f_19853_.f_46441_.nextDouble() * ((double)DEConfig.dragonDustLootModifier * 0.2);
                for (int i = 0; i < (int)count; ++i) {
                    float mm = 0.3f;
                    ItemEntity dust = new ItemEntity(entity.f_19853_, entity.m_20185_() - 2.0 + (double)entity.f_19853_.f_46441_.nextInt(4), entity.m_20186_() - 2.0 + (double)entity.f_19853_.f_46441_.nextInt(4), entity.m_20189_() - 2.0 + (double)entity.f_19853_.f_46441_.nextInt(4), new ItemStack((ItemLike)DEContent.dust_draconium));
                    dust.m_20334_((double)(mm * ((float)entity.f_19853_.f_46441_.nextInt(100) / 100.0f - 0.5f)), (double)(mm * ((float)entity.f_19853_.f_46441_.nextInt(100) / 100.0f - 0.5f)), (double)(mm * ((float)entity.f_19853_.f_46441_.nextInt(100) / 100.0f - 0.5f)));
                    entity.f_19853_.m_7967_((Entity)dust);
                }
            }
        }
    }

    private static void handleSoulDrops(LivingEntity entity, Player player, Level level, LivingDropsEvent event) {
        if (!event.getSource().f_19326_.equals("player") && !event.getSource().f_19326_.equals("arrow") || !LootEventHandler.canEntityDropSoul(entity)) {
            return;
        }
        if (entity instanceof Player) {
            return;
        }
        int dropChanceModifier = LootEventHandler.getSoulDropChance(player.m_21205_());
        if (dropChanceModifier == 0) {
            return;
        }
        int rand = RANDOM.nextInt(Math.max(DEConfig.soulDropChance / dropChanceModifier, 1));
        int rand2 = RANDOM.nextInt(Math.max(DEConfig.passiveSoulDropChance / dropChanceModifier, 1));
        boolean isAnimal = entity instanceof Animal;
        if (rand == 0 && !isAnimal || rand2 == 0 && isAnimal) {
            ItemStack soul = DEContent.mob_soul.getSoulFromEntity((Entity)entity, false);
            event.getDrops().add(new ItemEntity(level, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), soul));
        }
    }

    private static int getSoulDropChance(ItemStack stack) {
        int chance = 0;
        if (stack.m_41619_()) {
            return 0;
        }
        if (stack.m_41720_() instanceof IReaperItem) {
            chance = ((IReaperItem)stack.m_41720_()).getReaperLevel(stack);
        }
        return chance += EnchantmentHelper.m_44843_((Enchantment)DEContent.reaperEnchant, (ItemStack)stack);
    }

    private static boolean canEntityDropSoul(LivingEntity entity) {
        if (!entity.m_6072_() && !DEConfig.allowBossSouls) {
            return false;
        }
        String regName = entity.m_6095_().getRegistryName().toString();
        if (DEConfig.spawnerList.contains(regName) && DEConfig.spawnerListWhiteList) {
            return true;
        }
        if (DEConfig.spawnerList.contains(regName) && !DEConfig.spawnerListWhiteList) {
            return false;
        }
        return !DEConfig.spawnerListWhiteList;
    }

    private static void handleLootCollection(Player player, LivingDropsEvent event) {
        ItemStack hostStack = player.m_21205_();
        if (hostStack.m_41619_() || event.getDrops().isEmpty()) {
            return;
        }
        hostStack.getCapability(DECapabilities.MODULE_HOST_CAPABILITY).ifPresent(host -> {
            Predicate<ItemStack> junkTest = null;
            for (ModuleEntity<?> entity : host.getEntitiesByType(ModuleTypes.JUNK_FILTER).toList()) {
                junkTest = junkTest == null ? ((JunkFilterEntity)entity).createFilterTest() : junkTest.or(((JunkFilterEntity)entity).createFilterTest());
            }
            if (junkTest != null) {
                Predicate<ItemStack> finalJunkTest = junkTest;
                event.getDrops().removeIf(e -> finalJunkTest.test(e.m_32055_()));
            }
            if (event.getDrops().isEmpty()) {
                return;
            }
            IOPStorage storage = EnergyUtils.getStorage((ItemStack)hostStack);
            ModuleEntity optionalCollector = host.getEntitiesByType(ModuleTypes.ENDER_COLLECTION).findAny().orElse(null);
            if (optionalCollector instanceof EnderCollectionEntity) {
                EnderCollectionEntity collector = (EnderCollectionEntity)optionalCollector;
                ArrayList<ItemEntity> remove = new ArrayList<ItemEntity>();
                for (ItemEntity drop : event.getDrops()) {
                    ItemStack stack = drop.m_32055_();
                    int remainder = collector.insertStack(player, stack, storage);
                    if (remainder == 0) {
                        drop.m_32045_(ItemStack.f_41583_);
                        remove.add(drop);
                        continue;
                    }
                    stack.m_41764_(remainder);
                    drop.m_32045_(stack);
                }
                event.getDrops().removeAll(remove);
            }
        });
    }
}

