/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.entity.projectile;

import com.brandon3055.brandonscore.network.BCoreNetwork;
import com.brandon3055.brandonscore.utils.Utils;
import com.brandon3055.draconicevolution.api.modules.Module;
import com.brandon3055.draconicevolution.api.modules.data.DamageModData;
import com.brandon3055.draconicevolution.api.modules.lib.IDamageModifier;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.items.equipment.damage.DefaultStaffDmgMod;
import com.brandon3055.draconicevolution.lib.Serializers;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@Deprecated
public class DraconicProjectileEntity
extends AbstractArrow {
    private static final EntityDataAccessor<Integer> COLOR = SynchedEntityData.m_135353_(DraconicProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> ARROW_PROJECTILE = SynchedEntityData.m_135353_(DraconicProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> NO_DRAG = SynchedEntityData.m_135353_(DraconicProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> EFFECT_COLOR = SynchedEntityData.m_135353_(DraconicProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Optional<Module<?>>> DAMAGE_MODIFIER = SynchedEntityData.m_135353_(DraconicProjectileEntity.class, Serializers.OPT_MODULE_SERIALIZER);
    private static final IDamageModifier defaultStaffModifier = new DefaultStaffDmgMod();
    private Potion potion = Potions.f_43598_;
    private final Set<MobEffectInstance> customPotionEffects = Sets.newHashSet();
    private boolean fixedColor;
    private int flightTime = 0;
    private int maxFlightTime = -1;
    private int explosivePower = 0;
    private boolean explodeBlocks = false;
    private float projectileBaseDamage = 0.0f;
    private float secondaryChange = 0.0f;
    private boolean useDefaultStaffModifier = false;
    private boolean pseudoInstantTravel = false;

    public DraconicProjectileEntity(EntityType<? extends DraconicProjectileEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    public DraconicProjectileEntity(Level worldIn, double x, double y, double z) {
        super(DEContent.draconicArrow, x, y, z, worldIn);
    }

    public DraconicProjectileEntity(Level worldIn, LivingEntity shooter) {
        super(DEContent.draconicArrow, shooter, worldIn);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(COLOR, (Object)-1);
        this.f_19804_.m_135372_(ARROW_PROJECTILE, (Object)true);
        this.f_19804_.m_135372_(NO_DRAG, (Object)false);
        this.f_19804_.m_135372_(EFFECT_COLOR, (Object)-1);
        this.f_19804_.m_135372_(DAMAGE_MODIFIER, Optional.empty());
    }

    public void setArrowProjectile(boolean isArrowProjectile) {
        this.f_19804_.m_135381_(ARROW_PROJECTILE, (Object)isArrowProjectile);
    }

    public boolean isArrowProjectile() {
        return (Boolean)this.f_19804_.m_135370_(ARROW_PROJECTILE);
    }

    public void setDamageModifier(Module<?> damageModule) {
        if (damageModule != null && damageModule.getData() instanceof DamageModData) {
            this.f_19804_.m_135381_(DAMAGE_MODIFIER, Optional.of(damageModule));
        } else {
            this.f_19804_.m_135381_(DAMAGE_MODIFIER, Optional.empty());
        }
    }

    @Nullable
    public Module<DamageModData> getDamageModifier() {
        Optional opt = (Optional)this.f_19804_.m_135370_(DAMAGE_MODIFIER);
        if (opt.isPresent() && ((Module)opt.get()).getData() instanceof DamageModData) {
            return (Module)opt.get();
        }
        return null;
    }

    public void setNoDrag(boolean hasNoDrag) {
        this.f_19804_.m_135381_(NO_DRAG, (Object)hasNoDrag);
    }

    public boolean hasNoDrag() {
        return (Boolean)this.f_19804_.m_135370_(NO_DRAG);
    }

    public void setMaxFlightTime(int maxFlightTime) {
        this.maxFlightTime = maxFlightTime;
    }

    public void setExplosivePower(int explosivePower, boolean damageBlocks) {
        this.explosivePower = explosivePower;
        this.explodeBlocks = damageBlocks;
    }

    public void setEffectColour(int colour) {
        this.f_19804_.m_135381_(EFFECT_COLOR, (Object)colour);
    }

    public int getEffectColor() {
        return (Integer)this.f_19804_.m_135370_(EFFECT_COLOR);
    }

    public void useDefaultStaffModifier() {
        this.useDefaultStaffModifier = true;
    }

    public void setPseudoInstantTravel(boolean pseudoInstantTravel) {
        this.pseudoInstantTravel = pseudoInstantTravel;
    }

    public void setProjectileBaseDamage(float projectileBaseDamage) {
        this.projectileBaseDamage = projectileBaseDamage;
    }

    protected boolean activateDamageEffect(@Nullable HitResult traceResult) {
        if (this.f_19853_.f_46443_) {
            return true;
        }
        Entity owner = this.m_37282_();
        Module<DamageModData> damageMod = this.getDamageModifier();
        Vec3 pos = this.m_20182_();
        if (traceResult != null) {
            if (traceResult instanceof EntityHitResult) {
                pos = traceResult.m_82450_();
            } else {
                Vec3 hitPos = traceResult.m_82450_();
                if (hitPos.m_82554_(pos) > 1.0) {
                    Vec3 dirVec = pos.m_82546_(hitPos).m_82541_();
                    pos = hitPos.m_82549_(dirVec);
                }
            }
        }
        boolean disableDefault = false;
        if (damageMod != null || this.useDefaultStaffModifier) {
            IDamageModifier modifier = this.useDefaultStaffModifier ? defaultStaffModifier : damageMod.getData().modifier();
            modifier.doDamageAndEffects(this.f_19853_, pos, traceResult, owner instanceof LivingEntity ? (LivingEntity)owner : null, this.projectileBaseDamage, this.secondaryChange, true);
            this.setDamageModifier(null);
            disableDefault = true;
        } else if (this.explosivePower > 0) {
            if (owner instanceof LivingEntity) {
                this.f_19853_.m_7703_(owner, DamageSource.m_19373_((LivingEntity)((LivingEntity)owner)), null, pos.f_82479_, pos.f_82480_, pos.f_82481_, (float)this.explosivePower, false, this.explodeBlocks ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.NONE);
            } else {
                this.f_19853_.m_46518_((Entity)this, pos.f_82479_, pos.f_82480_, pos.f_82481_, (float)this.explosivePower, false, this.explodeBlocks ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.NONE);
            }
            this.explosivePower = 0;
            disableDefault = true;
        }
        if (!this.isArrowProjectile()) {
            this.m_6074_();
        }
        return disableDefault;
    }

    public void m_37251_(Entity p_234612_1_, float playerXRot, float playerYRot, float someZeroOffset, float power, float inaccuracy) {
        if (power >= 100.0f) {
            this.setPseudoInstantTravel(true);
        }
        super.m_37251_(p_234612_1_, playerXRot, playerYRot, someZeroOffset, power, inaccuracy);
    }

    protected void m_5790_(EntityHitResult entityRayTraceResult) {
        if (this.activateDamageEffect((HitResult)entityRayTraceResult)) {
            return;
        }
        super.m_5790_(entityRayTraceResult);
    }

    protected void m_8060_(BlockHitResult blockRayTraceResult) {
        if (this.activateDamageEffect((HitResult)blockRayTraceResult)) {
            return;
        }
        super.m_8060_(blockRayTraceResult);
    }

    public void setPotionEffect(ItemStack stack) {
        if (stack.m_41720_() == Items.f_42738_) {
            int i;
            this.potion = PotionUtils.m_43579_((ItemStack)stack);
            List collection = PotionUtils.m_43571_((ItemStack)stack);
            if (!collection.isEmpty()) {
                for (MobEffectInstance effectinstance : collection) {
                    this.customPotionEffects.add(new MobEffectInstance(effectinstance));
                }
            }
            if ((i = DraconicProjectileEntity.getCustomColor(stack)) == -1) {
                this.refreshColor();
            } else {
                this.setFixedColor(i);
            }
        } else if (stack.m_41720_() == Items.f_42412_) {
            this.potion = Potions.f_43598_;
            this.customPotionEffects.clear();
            this.f_19804_.m_135381_(COLOR, (Object)-1);
        }
    }

    public static int getCustomColor(ItemStack colour) {
        CompoundTag compoundnbt = colour.m_41783_();
        return compoundnbt != null && compoundnbt.m_128425_("CustomPotionColor", 99) ? compoundnbt.m_128451_("CustomPotionColor") : -1;
    }

    private void refreshColor() {
        this.fixedColor = false;
        if (this.potion == Potions.f_43598_ && this.customPotionEffects.isEmpty()) {
            this.f_19804_.m_135381_(COLOR, (Object)-1);
        } else {
            this.f_19804_.m_135381_(COLOR, (Object)PotionUtils.m_43564_((Collection)PotionUtils.m_43561_((Potion)this.potion, this.customPotionEffects)));
        }
    }

    public void addEffect(MobEffectInstance effect) {
        this.customPotionEffects.add(effect);
        this.m_20088_().m_135381_(COLOR, (Object)PotionUtils.m_43564_((Collection)PotionUtils.m_43561_((Potion)this.potion, this.customPotionEffects)));
    }

    public void m_8119_() {
        boolean forceActivation;
        boolean bl = forceActivation = this.pseudoInstantTravel && !Utils.isAreaLoaded((Level)this.f_19853_, (BlockPos)new BlockPos(this.m_20182_().m_82549_(this.m_20184_().m_82542_(1.1, 1.1, 1.1))), (ChunkHolder.FullChunkStatus)ChunkHolder.FullChunkStatus.ENTITY_TICKING);
        if (this.hasNoDrag()) {
            Vec3 velocity = this.m_20184_();
            super.m_8119_();
            if (!this.m_20068_()) {
                velocity = velocity.m_82492_(0.0, 0.05, 0.0);
            }
            this.m_20256_(velocity);
        } else {
            super.m_8119_();
        }
        if (this.f_19853_.f_46443_) {
            if (this.f_36703_) {
                if (this.f_36704_ % 5 == 0) {
                    this.spawnPotionParticles(1);
                }
            } else {
                this.spawnPotionParticles(2);
            }
        } else if (this.f_36703_ && this.f_36704_ != 0 && !this.customPotionEffects.isEmpty() && this.f_36704_ >= 600) {
            this.f_19853_.m_7605_((Entity)this, (byte)0);
            this.potion = Potions.f_43598_;
            this.customPotionEffects.clear();
            this.f_19804_.m_135381_(COLOR, (Object)-1);
        }
        if (!this.f_36703_) {
            if (this.maxFlightTime > 0) {
                ++this.flightTime;
                if (this.flightTime >= this.maxFlightTime || forceActivation) {
                    this.activateDamageEffect(null);
                }
            }
        } else {
            this.flightTime = 0;
        }
    }

    private void spawnPotionParticles(int particleCount) {
        int i = this.getColor();
        if (i != -1 && particleCount > 0) {
            double d0 = (double)(i >> 16 & 0xFF) / 255.0;
            double d1 = (double)(i >> 8 & 0xFF) / 255.0;
            double d2 = (double)(i >> 0 & 0xFF) / 255.0;
            for (int j = 0; j < particleCount; ++j) {
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123811_, this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), d0, d1, d2);
            }
        }
    }

    public int getColor() {
        return (Integer)this.f_19804_.m_135370_(COLOR);
    }

    private void setFixedColor(int colour) {
        this.fixedColor = true;
        this.f_19804_.m_135381_(COLOR, (Object)colour);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (this.potion != Potions.f_43598_ && this.potion != null) {
            compound.m_128359_("Potion", Registry.f_122828_.m_7981_((Object)this.potion).toString());
        }
        if (this.fixedColor) {
            compound.m_128405_("Color", this.getColor());
        }
        if (!this.customPotionEffects.isEmpty()) {
            ListTag listnbt = new ListTag();
            for (MobEffectInstance effectinstance : this.customPotionEffects) {
                listnbt.add((Object)effectinstance.m_19555_(new CompoundTag()));
            }
            compound.m_128365_("CustomPotionEffects", (Tag)listnbt);
        }
        if (this.maxFlightTime != -1) {
            compound.m_128405_("MaxFlightTime", this.maxFlightTime);
            compound.m_128405_("FlightTime", this.flightTime);
        }
        if (this.explosivePower > 0) {
            compound.m_128376_("ExplosivePower", (short)this.explosivePower);
            compound.m_128379_("ExplodeBlocks", this.explodeBlocks);
        }
        compound.m_128379_("PseudoInstantTravel", this.pseudoInstantTravel);
        compound.m_128350_("ProjectileBaseDamage", this.projectileBaseDamage);
        compound.m_128350_("SecondaryChange", this.secondaryChange);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128425_("Potion", 8)) {
            this.potion = PotionUtils.m_43577_((CompoundTag)compound);
        }
        for (MobEffectInstance effectinstance : PotionUtils.m_43573_((CompoundTag)compound)) {
            this.addEffect(effectinstance);
        }
        if (compound.m_128425_("Color", 99)) {
            this.setFixedColor(compound.m_128451_("Color"));
        } else {
            this.refreshColor();
        }
        if (compound.m_128441_("MaxFlightTime")) {
            this.maxFlightTime = compound.m_128451_("MaxFlightTime");
            this.flightTime = compound.m_128451_("FlightTime");
        }
        if (compound.m_128441_("ExplosivePower")) {
            this.explosivePower = compound.m_128448_("ExplosivePower");
            this.explodeBlocks = compound.m_128471_("ExplodeBlocks");
        }
        this.pseudoInstantTravel = compound.m_128471_("PseudoInstantTravel");
        this.projectileBaseDamage = compound.m_128457_("ProjectileBaseDamage");
        this.secondaryChange = compound.m_128457_("SecondaryChange");
    }

    protected void m_7761_(LivingEntity living) {
        super.m_7761_(living);
        for (MobEffectInstance effectinstance : this.potion.m_43488_()) {
            living.m_7292_(new MobEffectInstance(effectinstance.m_19544_(), Math.max(effectinstance.m_19557_() / 8, 1), effectinstance.m_19564_(), effectinstance.m_19571_(), effectinstance.m_19572_()));
        }
        if (!this.customPotionEffects.isEmpty()) {
            for (MobEffectInstance effectinstance1 : this.customPotionEffects) {
                living.m_7292_(effectinstance1);
            }
        }
    }

    protected ItemStack m_7941_() {
        if (this.customPotionEffects.isEmpty() && this.potion == Potions.f_43598_) {
            return new ItemStack((ItemLike)Items.f_42412_);
        }
        ItemStack itemstack = new ItemStack((ItemLike)Items.f_42738_);
        PotionUtils.m_43549_((ItemStack)itemstack, (Potion)this.potion);
        PotionUtils.m_43552_((ItemStack)itemstack, this.customPotionEffects);
        if (this.fixedColor) {
            itemstack.m_41784_().m_128405_("CustomPotionColor", this.getColor());
        }
        return itemstack;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7822_(byte id) {
        if (id == 0) {
            int i = this.getColor();
            if (i != -1) {
                double d0 = (double)(i >> 16 & 0xFF) / 255.0;
                double d1 = (double)(i >> 8 & 0xFF) / 255.0;
                double d2 = (double)(i >> 0 & 0xFF) / 255.0;
                for (int j = 0; j < 20; ++j) {
                    this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123811_, this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), d0, d1, d2);
                }
            }
        } else {
            super.m_7822_(id);
        }
    }

    public Packet<?> m_5654_() {
        return BCoreNetwork.getEntitySpawnPacket((Entity)this);
    }
}

