/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.entity.guardian.control;

import com.brandon3055.draconicevolution.entity.guardian.DraconicGuardianEntity;
import com.brandon3055.draconicevolution.entity.guardian.GuardianFightManager;
import com.brandon3055.draconicevolution.entity.guardian.control.IPhase;
import com.brandon3055.draconicevolution.entity.guardian.control.PhaseType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PhaseManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private final DraconicGuardianEntity dragon;
    private final IPhase[] phases = new IPhase[PhaseType.getTotalPhases()];
    private IPhase phase;

    public PhaseManager(DraconicGuardianEntity guardisn) {
        this.dragon = guardisn;
        this.setPhase(PhaseType.HOVER);
    }

    public <T extends IPhase> T setPhase(PhaseType<T> phaseIn) {
        if (this.phase == null || phaseIn != this.phase.getType()) {
            if (this.phase != null) {
                this.phase.removeAreaEffect();
            }
            this.phase = this.getPhase(phaseIn);
            if (!this.dragon.f_19853_.f_46443_) {
                this.dragon.m_20088_().m_135381_(DraconicGuardianEntity.PHASE, (Object)phaseIn.getId());
                GuardianFightManager manager = this.dragon.getFightManager();
                if (manager != null) {
                    manager.guardianUpdate(this.dragon);
                }
            }
            this.phase.initPhase();
            return (T)this.phase;
        }
        return (T)this.phase;
    }

    public IPhase getCurrentPhase() {
        return this.phase;
    }

    public <T extends IPhase> T getPhase(PhaseType<T> phaseIn) {
        int i = phaseIn.getId();
        if (this.phases[i] == null) {
            this.phases[i] = phaseIn.createPhase(this.dragon);
        }
        return (T)this.phases[i];
    }

    public void globalServerTick() {
        for (IPhase phase : this.phases) {
            if (phase == null) continue;
            phase.globalServerTick();
        }
    }
}

