/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.entity.guardian.control;

import com.brandon3055.draconicevolution.DraconicEvolution;
import com.brandon3055.draconicevolution.entity.guardian.DraconicGuardianEntity;
import com.brandon3055.draconicevolution.entity.guardian.GuardianProjectileEntity;
import com.brandon3055.draconicevolution.entity.guardian.control.Phase;
import com.brandon3055.draconicevolution.entity.guardian.control.PhaseType;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.Logger;

public class CoverFirePhase
extends Phase {
    private static final Logger LOGGER = DraconicEvolution.LOGGER;
    private Path currentPath;
    private Vec3 targetLocation;
    private boolean clockwise;
    private int tick;

    public CoverFirePhase(DraconicGuardianEntity guardisn) {
        super(guardisn);
    }

    public PhaseType<CoverFirePhase> getType() {
        return PhaseType.COVER_FIRE;
    }

    @Override
    public void serverTick() {
        double distanceFromTarget;
        Vec3 vector3d2 = this.guardian.m_20252_(1.0f);
        double headX = this.guardian.dragonPartHead.m_20185_() - vector3d2.f_82479_ * 1.0;
        double headY = this.guardian.dragonPartHead.m_20227_(0.5) + 0.5;
        double headZ = this.guardian.dragonPartHead.m_20189_() - vector3d2.f_82481_ * 1.0;
        Vec3 targetPos = this.guardian.m_20182_();
        targetPos = targetPos.m_82520_((this.guardian.m_21187_().nextDouble() - 0.5) * 50.0, (this.guardian.m_21187_().nextDouble() - 0.5) * 50.0, (this.guardian.m_21187_().nextDouble() - 0.5) * 50.0);
        double targetRelX = targetPos.f_82479_ - headX;
        double targetRelY = targetPos.f_82480_ - headY;
        double targetRelZ = targetPos.f_82481_ - headZ;
        if (!this.guardian.m_20067_()) {
            this.guardian.f_19853_.m_5898_(null, 1017, this.guardian.m_142538_(), 0);
        }
        GuardianProjectileEntity projectile = new GuardianProjectileEntity(this.guardian.f_19853_, (LivingEntity)this.guardian, targetRelX, targetRelY, targetRelZ, targetPos, 25.0, 15.0);
        projectile.m_7678_(headX, headY, headZ, 0.0f, 0.0f);
        this.guardian.f_19853_.m_7967_((Entity)projectile);
        double d = distanceFromTarget = this.targetLocation == null ? 0.0 : this.targetLocation.m_82531_(this.guardian.m_20185_(), this.guardian.m_20186_(), this.guardian.m_20189_());
        if (this.currentPath != null && this.currentPath.m_77392_() && distanceFromTarget < 100.0) {
            this.guardian.getPhaseManager().setPhase(PhaseType.START).immediateAttack(null);
            return;
        }
        if (distanceFromTarget < 100.0) {
            this.updatePathing();
        }
        if (this.tick++ > 60) {
            this.guardian.getPhaseManager().setPhase(PhaseType.START).immediateAttack(null);
        }
    }

    @Override
    public void initPhase() {
        this.currentPath = null;
        this.targetLocation = null;
        this.tick = 0;
    }

    private void updatePathing() {
        if (this.currentPath == null || this.currentPath.m_77392_()) {
            int nearestIndex;
            int endIndex = nearestIndex = this.guardian.initPathPoints(false);
            if (this.guardian.m_21187_().nextInt(8) == 0) {
                boolean bl = this.clockwise = !this.clockwise;
            }
            endIndex = this.clockwise ? (endIndex += 12) : (endIndex -= 12);
            endIndex = Math.floorMod(endIndex, 24);
            this.currentPath = this.guardian.findPath(nearestIndex, endIndex, null);
            if (this.currentPath != null) {
                this.currentPath.m_77374_();
            }
        }
        this.navigateToNextPathNode();
    }

    private void navigateToNextPathNode() {
        if (this.currentPath != null && !this.currentPath.m_77392_()) {
            BlockPos nextPos = this.currentPath.m_77400_();
            this.currentPath.m_77374_();
            double x = nextPos.m_123341_();
            double z = nextPos.m_123343_();
            double y = (float)nextPos.m_123342_() + this.guardian.m_21187_().nextFloat() * 20.0f;
            this.targetLocation = new Vec3(x, y, z);
        }
    }

    @Override
    public double getGuardianSpeed() {
        return 3.0;
    }

    @Override
    @Nullable
    public Vec3 getTargetLocation() {
        return this.targetLocation;
    }
}

