/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.entity.guardian.control;

import com.brandon3055.brandonscore.network.BCoreNetwork;
import com.brandon3055.draconicevolution.DraconicEvolution;
import com.brandon3055.draconicevolution.entity.guardian.DraconicGuardianEntity;
import com.brandon3055.draconicevolution.entity.guardian.GuardianProjectileEntity;
import com.brandon3055.draconicevolution.entity.guardian.control.Phase;
import com.brandon3055.draconicevolution.entity.guardian.control.PhaseType;
import javax.annotation.Nullable;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.Logger;

public class BombardPlayerPhase
extends Phase {
    private static final Logger LOGGER = DraconicEvolution.LOGGER;
    private int tick;
    private int timeSinceStart;
    private float damageTaken;
    private boolean bombarding = false;
    private Vec3 targetLocation;
    private Player targetPlayer;
    private int minAttackRange = 20;
    private int maxAttackRange = 90;

    public BombardPlayerPhase(DraconicGuardianEntity guardisn) {
        super(guardisn);
    }

    @Override
    public void serverTick() {
        if (this.targetPlayer == null || !this.isValidTarget((LivingEntity)this.targetPlayer)) {
            this.debug("Aborting bombardment as no target is available. or target is dead.");
            this.guardian.getPhaseManager().setPhase(PhaseType.START).prevAttackFailed();
        } else if (this.timeSinceStart > 0 && this.timeSinceStart >= 160) {
            this.guardian.getPhaseManager().setPhase(PhaseType.START);
            this.debug("Ending bombardment, Timed out");
        } else {
            double distance = this.targetPlayer.m_20270_((Entity)this.guardian);
            this.targetLocation = this.targetPlayer.m_20182_();
            if (!this.bombarding) {
                double tRelZ;
                double tRelX = this.targetLocation.f_82479_ - this.guardian.m_20185_();
                double relTargetAngle = Mth.m_14008_((double)Mth.m_14175_((double)(180.0 - Mth.m_14136_((double)tRelX, (double)(tRelZ = this.targetLocation.f_82481_ - this.guardian.m_20189_())) * 57.2957763671875 - (double)this.guardian.m_146908_())), (double)-50.0, (double)50.0);
                boolean bl = this.bombarding = Math.abs(relTargetAngle) < 1.0;
                if (this.bombarding) {
                    this.debug("Bombs Away!");
                }
            } else {
                ++this.timeSinceStart;
            }
            if (distance < (double)this.minAttackRange) {
                this.guardian.getPhaseManager().setPhase(PhaseType.START).prevAttackFailed();
                this.debug("Ending bombardment, To close");
            } else if (this.bombarding && distance <= (double)this.maxAttackRange && this.timeSinceStart % 2 == 0) {
                Vec3 vector3d2 = this.guardian.m_20252_(1.0f);
                double headX = this.guardian.dragonPartHead.m_20185_() - vector3d2.f_82479_;
                double headY = this.guardian.dragonPartHead.m_20227_(0.5) + 0.5;
                double headZ = this.guardian.dragonPartHead.m_20189_() - vector3d2.f_82481_;
                Vec3 targetPos = this.targetPlayer.m_20182_().m_82549_(this.targetPlayer.m_20184_().m_82542_(5.0, 5.0, 5.0));
                targetPos = targetPos.m_82520_(this.guardian.m_21187_().nextGaussian() * 10.0, this.guardian.m_21187_().nextGaussian() * 10.0, this.guardian.m_21187_().nextGaussian() * 10.0);
                double targetRelX = targetPos.f_82479_ - headX;
                double targetRelY = targetPos.f_82480_ - headY;
                double targetRelZ = targetPos.f_82481_ - headZ;
                if (!this.guardian.m_20067_()) {
                    BCoreNetwork.sendSound((Level)this.guardian.f_19853_, (Entity)this.guardian, (SoundEvent)SoundEvents.f_11896_, (SoundSource)SoundSource.HOSTILE, (float)32.0f, (float)((this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f), (boolean)false);
                }
                GuardianProjectileEntity projectile = new GuardianProjectileEntity(this.guardian.f_19853_, (LivingEntity)this.guardian, targetRelX, targetRelY, targetRelZ, targetPos, 25.0, 15.0);
                projectile.m_7678_(headX, headY, headZ, 0.0f, 0.0f);
                this.guardian.f_19853_.m_7967_((Entity)projectile);
            }
        }
        if (this.tick > 100) {
            this.guardian.getPhaseManager().setPhase(PhaseType.START).prevAttackFailed();
            this.debug("Aborting charge, Master timed out");
        } else if (this.bombarding && this.timeSinceStart < 20 && this.timeSinceStart % 5 == 0) {
            this.guardian.m_5496_(SoundEvents.f_11894_, 20.0f, 0.95f + this.guardian.m_21187_().nextFloat() * 0.2f);
        }
        ++this.tick;
    }

    @Override
    public void initPhase() {
        this.targetLocation = null;
        this.timeSinceStart = 0;
        this.bombarding = false;
        this.tick = 0;
        this.damageTaken = 0.0f;
    }

    @Override
    public void targetPlayer(Player player) {
        this.targetPlayer = player;
    }

    @Override
    public float getMaxRiseOrFall() {
        return 3.0f;
    }

    @Override
    @Nullable
    public Vec3 getTargetLocation() {
        return this.targetLocation;
    }

    public PhaseType<BombardPlayerPhase> getType() {
        return PhaseType.BOMBARD_PLAYER;
    }

    @Override
    public double getGuardianSpeed() {
        double speed = 1.0;
        if (this.targetPlayer != null) {
            double distance = this.targetPlayer.m_20270_((Entity)this.guardian);
            double sweetSpot = (double)this.minAttackRange + (double)(this.maxAttackRange - this.minAttackRange) / 2.0;
            speed = Mth.m_14008_((double)((distance - sweetSpot) / 10.0), (double)0.5, (double)3.0);
        }
        return this.bombarding ? speed : 0.5;
    }

    @Override
    public float getYawFactor() {
        return super.getYawFactor() * (float)(this.bombarding ? 2 : 1);
    }

    @Override
    public boolean highVerticalAgility() {
        return false;
    }

    @Override
    public float onAttacked(DamageSource source, float damage, float shield, boolean effective) {
        float abortThreshold;
        this.damageTaken += damage;
        float f = abortThreshold = shield > damage ? 512.0f : 128.0f;
        if (this.damageTaken > abortThreshold && !this.bombarding && this.tick > 80) {
            this.guardian.getPhaseManager().setPhase(PhaseType.START).prevAttackFailed();
            this.debug("Aborting bombardment, Damage Taken");
        }
        return super.onAttacked(source, damage, shield, effective);
    }
}

