/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.entity.guardian;

import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.draconicevolution.api.damage.DraconicIndirectEntityDamage;
import com.brandon3055.draconicevolution.entity.guardian.DraconicGuardianEntity;
import com.brandon3055.draconicevolution.entity.guardian.GuardianFightManager;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.network.DraconicNetwork;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.network.NetworkHooks;

public class GuardianProjectileEntity
extends AbstractHurtingProjectile
implements IEntityAdditionalSpawnData {
    private Vec3 target;
    private double splashRange = 15.0;
    private double power = 10.0;
    private DamageSource damageSource = new DamageSource("damage.draconicevolution.guardian_projectile").m_19382_().m_19380_().m_19389_().m_19375_();
    private double closestApproach;

    public GuardianProjectileEntity(EntityType<?> type, Level world) {
        super(DEContent.guardianProjectile, world);
    }

    public GuardianProjectileEntity(Level worldIn, LivingEntity shooter, double accelX, double accelY, double accelZ, Vec3 target, double splashRange, double power) {
        super(DEContent.guardianProjectile, shooter, accelX, accelY, accelZ, worldIn);
        double accelDotProduct;
        this.target = target;
        this.splashRange = splashRange;
        this.power = power;
        this.damageSource = new DraconicIndirectEntityDamage("draconicevolution.guardian_projectile", (Entity)this, (Entity)shooter, TechLevel.CHAOTIC).m_19382_().m_19380_().m_19389_().m_19375_();
        if (target != null) {
            this.closestApproach = this.m_20238_(target);
        }
        if ((accelDotProduct = Math.sqrt(accelX * accelX + accelY * accelY + accelZ * accelZ)) != 0.0) {
            this.f_36813_ = accelX / accelDotProduct * 0.3;
            this.f_36814_ = accelY / accelDotProduct * 0.3;
            this.f_36815_ = accelZ / accelDotProduct * 0.3;
        }
    }

    protected void m_6532_(HitResult result) {
        super.m_6532_(result);
        Entity shooter = this.m_37282_();
        if (!(result.m_6662_() == HitResult.Type.ENTITY && ((EntityHitResult)result).m_82443_().m_7306_(shooter) || this.f_19853_.f_46443_)) {
            this.detonate();
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.target != null) {
            double distSq = this.m_20238_(this.target);
            if (distSq <= 1.0) {
                this.detonate();
            } else if (distSq < this.closestApproach) {
                this.closestApproach = distSq;
            } else if (this.f_19797_ > 5) {
                this.detonate();
            }
        }
    }

    private void detonate() {
        GuardianFightManager manager;
        List list = this.f_19853_.m_6443_(LivingEntity.class, this.m_142469_().m_82400_(this.splashRange), EntitySelector.f_20406_);
        Entity shooter = this.m_37282_();
        for (LivingEntity entity : list) {
            double distance;
            double df;
            if (entity == shooter || (df = 1.0 - (distance = (double)entity.m_20270_((Entity)this)) / this.power) <= 0.0) continue;
            float damage = (int)(((df *= (double)Explosion.m_46064_((Vec3)this.m_20182_(), (Entity)entity)) * df + df) / 2.0 * 6.0 * this.power + 1.0);
            entity.m_6469_(this.damageSource, damage);
        }
        boolean destroy = false;
        if (shooter instanceof DraconicGuardianEntity && (manager = ((DraconicGuardianEntity)shooter).getFightManager()) != null && this.m_142538_().m_123342_() > manager.getArenaOrigin().m_123342_() + 20) {
            destroy = true;
        }
        this.f_19853_.m_46511_(shooter, (double)this.m_142538_().m_123341_(), (double)this.m_142538_().m_123342_(), (double)this.m_142538_().m_123343_(), 8.0f, destroy ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.NONE);
        DraconicNetwork.sendImpactEffect(this.f_19853_, this.m_142538_(), 0);
        this.m_146870_();
    }

    public boolean m_6087_() {
        return false;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        return false;
    }

    protected ParticleOptions m_5967_() {
        return ParticleTypes.f_123799_;
    }

    protected boolean m_5931_() {
        return false;
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
    }

    public void readSpawnData(FriendlyByteBuf additionalData) {
    }
}

