/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.entity.guardian;

import codechicken.lib.math.MathHelper;
import com.brandon3055.brandonscore.network.BCoreNetwork;
import com.brandon3055.brandonscore.worldentity.WorldEntityHandler;
import com.brandon3055.draconicevolution.DEConfig;
import com.brandon3055.draconicevolution.DraconicEvolution;
import com.brandon3055.draconicevolution.entity.GuardianCrystalEntity;
import com.brandon3055.draconicevolution.entity.guardian.DraconicGuardianPartEntity;
import com.brandon3055.draconicevolution.entity.guardian.GuardianFightManager;
import com.brandon3055.draconicevolution.entity.guardian.control.IPhase;
import com.brandon3055.draconicevolution.entity.guardian.control.PhaseManager;
import com.brandon3055.draconicevolution.entity.guardian.control.PhaseType;
import com.brandon3055.draconicevolution.handlers.DESounds;
import com.brandon3055.draconicevolution.init.DEContent;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.EntityDamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.pathfinder.BinaryHeap;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class DraconicGuardianEntity
extends Mob
implements Enemy {
    private static final Logger LOGGER = DraconicEvolution.LOGGER;
    public static final EntityDataAccessor<Integer> PHASE = SynchedEntityData.m_135353_(DraconicGuardianEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> CRYSTAL_ID = SynchedEntityData.m_135353_(DraconicGuardianEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Float> SHIELD_POWER = SynchedEntityData.m_135353_(DraconicGuardianEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Optional<BlockPos>> ORIGIN = SynchedEntityData.m_135353_(DraconicGuardianEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135039_);
    private static final TargetingConditions PLAYER_INVADER_CONDITION = TargetingConditions.m_148352_().m_26883_(64.0);
    public final double[][] ringBuffer = new double[64][3];
    public int ringBufferIndex = -1;
    private final DraconicGuardianPartEntity[] dragonParts;
    public final DraconicGuardianPartEntity dragonPartHead;
    private final DraconicGuardianPartEntity dragonPartNeck;
    private final DraconicGuardianPartEntity dragonPartBody;
    private final DraconicGuardianPartEntity dragonPartTail1;
    private final DraconicGuardianPartEntity dragonPartTail2;
    private final DraconicGuardianPartEntity dragonPartTail3;
    private final DraconicGuardianPartEntity dragonPartRightWing;
    private final DraconicGuardianPartEntity dragonPartLeftWing;
    public float oFlapTime;
    public float flapTime;
    public boolean slowed;
    public int deathTicks;
    public float yRotA;
    @javax.annotation.Nullable
    public GuardianCrystalEntity closestGuardianCrystal;
    @javax.annotation.Nullable
    private GuardianFightManager fightManager;
    private final PhaseManager phaseManager;
    private int growlTime = 100;
    private Node[] pathPoints = new Node[24];
    private final BinaryHeap pathFindQueue = new BinaryHeap();
    private double speedMult = 1.0;
    public float dpm = 0.0f;
    private float lastDamage;
    private int hitCoolDown;

    public DraconicGuardianEntity(EntityType<?> type, Level world) {
        super(DEContent.draconicGuardian, world);
        this.dragonPartHead = new DraconicGuardianPartEntity(this, "head", 1.0f, 1.0f);
        this.dragonPartNeck = new DraconicGuardianPartEntity(this, "neck", 3.0f, 3.0f);
        this.dragonPartBody = new DraconicGuardianPartEntity(this, "body", 5.0f, 3.0f);
        this.dragonPartTail1 = new DraconicGuardianPartEntity(this, "tail", 2.0f, 2.0f);
        this.dragonPartTail2 = new DraconicGuardianPartEntity(this, "tail", 2.0f, 2.0f);
        this.dragonPartTail3 = new DraconicGuardianPartEntity(this, "tail", 2.0f, 2.0f);
        this.dragonPartRightWing = new DraconicGuardianPartEntity(this, "wing", 4.0f, 2.0f);
        this.dragonPartLeftWing = new DraconicGuardianPartEntity(this, "wing", 4.0f, 2.0f);
        this.dragonParts = new DraconicGuardianPartEntity[]{this.dragonPartHead, this.dragonPartNeck, this.dragonPartBody, this.dragonPartTail1, this.dragonPartTail2, this.dragonPartTail3, this.dragonPartRightWing, this.dragonPartLeftWing};
        this.m_21153_(this.m_21233_());
        this.f_19794_ = true;
        this.f_19811_ = true;
        this.phaseManager = new PhaseManager(this);
    }

    public void m_147240_(double p_147241_, double p_147242_, double p_147243_) {
    }

    public void setFightManager(GuardianFightManager fightManager) {
        this.fightManager = fightManager;
    }

    public void setArenaOrigin(BlockPos arenaOrigin) {
        this.f_19804_.m_135381_(ORIGIN, Optional.ofNullable(arenaOrigin));
    }

    public BlockPos getArenaOrigin() {
        return ((Optional)this.f_19804_.m_135370_(ORIGIN)).orElse(null);
    }

    public AttributeMap m_21204_() {
        return super.m_21204_();
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, (double)DEConfig.guardianHealth);
    }

    public float getShieldPower() {
        return ((Float)this.f_19804_.m_135370_(SHIELD_POWER)).floatValue();
    }

    public void setShieldPower(float shieldPower) {
        this.f_19804_.m_135381_(SHIELD_POWER, (Object)Float.valueOf(shieldPower));
        GuardianFightManager manager = this.getFightManager();
        if (manager != null) {
            manager.guardianUpdate(this);
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(PHASE, (Object)PhaseType.HOVER.getId());
        this.m_20088_().m_135372_(CRYSTAL_ID, (Object)-1);
        this.m_20088_().m_135372_(SHIELD_POWER, (Object)Float.valueOf(0.0f));
        this.m_20088_().m_135372_(ORIGIN, Optional.empty());
    }

    public void m_8119_() {
        GuardianFightManager manager;
        super.m_8119_();
        if (!this.f_19853_.f_46443_ && this.getShieldPower() < (float)DEConfig.guardianShield && (manager = this.getFightManager()) != null && manager.getNumAliveCrystals() > 0) {
            this.setShieldPower(Math.min((float)DEConfig.guardianShield, this.getShieldPower() + (float)DEConfig.guardianShield / 200.0f));
        }
        if (this.hitCoolDown > 0) {
            --this.hitCoolDown;
        }
    }

    public double[] getLatencyPos(int index, float partialTicks) {
        if (this.m_21224_()) {
            partialTicks = 0.0f;
        }
        partialTicks = 1.0f - partialTicks;
        int i = this.ringBufferIndex - index & 0x3F;
        int j = this.ringBufferIndex - index - 1 & 0x3F;
        double[] adouble = new double[3];
        double d0 = this.ringBuffer[i][0];
        double d1 = Mth.m_14175_((double)(this.ringBuffer[j][0] - d0));
        adouble[0] = d0 + d1 * (double)partialTicks;
        d0 = this.ringBuffer[i][1];
        d1 = this.ringBuffer[j][1] - d0;
        adouble[1] = d0 + d1 * (double)partialTicks;
        adouble[2] = Mth.m_14139_((double)partialTicks, (double)this.ringBuffer[i][2], (double)this.ringBuffer[j][2]);
        return adouble;
    }

    public void m_8107_() {
        this.speedMult = MathHelper.approachLinear((double)this.speedMult, (double)this.phaseManager.getCurrentPhase().getGuardianSpeed(), (double)0.1);
        if (this.f_19853_.f_46443_) {
            this.m_21153_(this.m_21223_());
            if (!this.m_20067_()) {
                float f = Mth.m_14089_((float)(this.flapTime * ((float)Math.PI * 2)));
                float f1 = Mth.m_14089_((float)(this.oFlapTime * ((float)Math.PI * 2)));
                if (f1 <= -0.3f && f >= -0.3f) {
                    this.f_19853_.m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11893_, this.m_5720_(), 5.0f, 0.8f + this.f_19796_.nextFloat() * 0.3f, false);
                }
                if (!this.phaseManager.getCurrentPhase().getIsStationary() && --this.growlTime < 0) {
                    this.f_19853_.m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11894_, this.m_5720_(), 2.5f, 0.8f + this.f_19796_.nextFloat() * 0.3f, false);
                    this.growlTime = 200 + this.f_19796_.nextInt(200);
                }
            }
        }
        this.oFlapTime = this.flapTime;
        if (this.m_21224_()) {
            float randX = (this.f_19796_.nextFloat() - 0.5f) * 8.0f;
            float randY = (this.f_19796_.nextFloat() - 0.5f) * 4.0f;
            float randZ = (this.f_19796_.nextFloat() - 0.5f) * 8.0f;
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123813_, this.m_20185_() + (double)randX, this.m_20186_() + 2.0 + (double)randY, this.m_20189_() + (double)randZ, 0.0, 0.0, 0.0);
        } else {
            this.updateDragonEnderCrystal();
            Vec3 vec3 = this.m_20184_();
            float f = 0.2f / ((float)vec3.m_165924_() * 10.0f + 1.0f);
            this.flapTime = this.phaseManager.getCurrentPhase().getIsStationary() ? (this.flapTime += 0.1f) : (this.slowed ? (this.flapTime += f * 0.5f) : (this.flapTime += (f *= (float)Math.pow(2.0, vec3.f_82480_))));
            this.m_146922_(Mth.m_14177_((float)this.m_146908_()));
            if (this.m_21525_()) {
                this.flapTime = 0.5f;
            } else {
                if (this.ringBufferIndex < 0) {
                    for (int i = 0; i < this.ringBuffer.length; ++i) {
                        this.ringBuffer[i][0] = this.m_146908_();
                        this.ringBuffer[i][1] = this.m_20186_();
                    }
                }
                if (++this.ringBufferIndex == this.ringBuffer.length) {
                    this.ringBufferIndex = 0;
                }
                this.ringBuffer[this.ringBufferIndex][0] = this.m_146908_();
                this.ringBuffer[this.ringBufferIndex][1] = this.m_20186_();
                if (this.f_19853_.f_46443_) {
                    if (this.f_20903_ > 0) {
                        double d7 = this.m_20185_() + (this.f_20904_ - this.m_20185_()) / (double)this.f_20903_;
                        double d0 = this.m_20186_() + (this.f_20905_ - this.m_20186_()) / (double)this.f_20903_;
                        double d1 = this.m_20189_() + (this.f_20906_ - this.m_20189_()) / (double)this.f_20903_;
                        double d2 = Mth.m_14175_((double)(this.f_20907_ - (double)this.m_146908_()));
                        this.m_146922_((float)((double)this.m_146908_() + d2 / (double)this.f_20903_));
                        this.m_146926_((float)((double)this.m_146909_() + (this.f_20908_ - (double)this.m_146909_()) / (double)this.f_20903_));
                        --this.f_20903_;
                        this.m_6034_(d7, d0, d1);
                        this.m_19915_(this.m_146908_(), this.m_146909_());
                    }
                    this.phaseManager.getCurrentPhase().clientTick();
                } else {
                    IPhase iphase = this.phaseManager.getCurrentPhase();
                    iphase.serverTick();
                    if (this.phaseManager.getCurrentPhase() != iphase) {
                        iphase = this.phaseManager.getCurrentPhase();
                        iphase.serverTick();
                    }
                    this.phaseManager.globalServerTick();
                    Vec3 targetLocation = iphase.getTargetLocation();
                    if (targetLocation != null) {
                        double tRelX = targetLocation.f_82479_ - this.m_20185_();
                        double tRelY = targetLocation.f_82480_ - this.m_20186_();
                        double tRelZ = targetLocation.f_82481_ - this.m_20189_();
                        double distanceSq = tRelX * tRelX + tRelY * tRelY + tRelZ * tRelZ;
                        float maxRiseOrFall = iphase.getMaxRiseOrFall();
                        double distanceXZ = Math.sqrt(tRelX * tRelX + tRelZ * tRelZ);
                        if (distanceXZ > 0.0) {
                            tRelY = this.phaseManager.getCurrentPhase().highVerticalAgility() ? Mth.m_14008_((double)tRelY, (double)(-maxRiseOrFall), (double)maxRiseOrFall) : Mth.m_14008_((double)(tRelY / distanceXZ), (double)(-maxRiseOrFall), (double)maxRiseOrFall);
                        }
                        this.m_20256_(this.m_20184_().m_82520_(0.0, tRelY * 0.01, 0.0));
                        this.m_146922_(Mth.m_14177_((float)this.m_146908_()));
                        double relTargetAngle = Mth.m_14008_((double)Mth.m_14175_((double)(180.0 - Mth.m_14136_((double)tRelX, (double)tRelZ) * 57.2957763671875 - (double)this.m_146908_())), (double)-50.0, (double)50.0);
                        if (Math.abs(relTargetAngle) < 5.0) {
                            relTargetAngle *= this.speedMult * 5.0;
                        }
                        Vec3 targetVector = targetLocation.m_82492_(this.m_20185_(), this.m_20186_(), this.m_20189_()).m_82541_();
                        Vec3 vector3d2 = new Vec3((double)Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))), this.m_20184_().f_82480_, (double)(-Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180))))).m_82541_();
                        float f8 = Math.max(((float)vector3d2.m_82526_(targetVector) + 0.5f) / 1.5f, 0.0f);
                        this.yRotA *= 0.8f;
                        this.yRotA = (float)((double)this.yRotA + relTargetAngle * (double)iphase.getYawFactor());
                        this.m_146922_(this.m_146908_() + this.yRotA * 0.1f);
                        float f9 = (float)(2.0 / (distanceSq + 1.0));
                        float f10 = 0.06f;
                        this.m_19920_(f10 * (f8 * f9 + (1.0f - f9)), new Vec3(0.0, 0.0, -1.0));
                        if (this.slowed) {
                            this.m_6478_(MoverType.SELF, this.m_20184_().m_82490_((double)0.8f).m_82490_(this.speedMult));
                        } else {
                            this.m_6478_(MoverType.SELF, this.m_20184_().m_82490_(this.speedMult));
                        }
                        Vec3 vector3d3 = this.m_20184_().m_82541_();
                        double d6 = 0.8 + 0.15 * (vector3d3.m_82526_(vector3d2) + 1.0) / 2.0;
                        this.m_20256_(this.m_20184_().m_82542_(d6, (double)0.91f, d6));
                    }
                }
                this.f_20883_ = this.m_146908_();
                Vec3[] avector3d = new Vec3[this.dragonParts.length];
                for (int j = 0; j < this.dragonParts.length; ++j) {
                    avector3d[j] = new Vec3(this.dragonParts[j].m_20185_(), this.dragonParts[j].m_20186_(), this.dragonParts[j].m_20189_());
                }
                float f15 = (float)(this.getLatencyPos(5, 1.0f)[1] - this.getLatencyPos(10, 1.0f)[1]) * 10.0f * ((float)Math.PI / 180);
                float f16 = Mth.m_14089_((float)f15);
                float f2 = Mth.m_14031_((float)f15);
                float f17 = this.m_146908_() * ((float)Math.PI / 180);
                float f3 = Mth.m_14031_((float)f17);
                float f18 = Mth.m_14089_((float)f17);
                this.setPartPosition(this.dragonPartBody, f3 * 0.5f, 0.0, -f18 * 0.5f);
                this.setPartPosition(this.dragonPartRightWing, f18 * 4.5f, 2.0, f3 * 4.5f);
                this.setPartPosition(this.dragonPartLeftWing, f18 * -4.5f, 2.0, f3 * -4.5f);
                if (!this.f_19853_.f_46443_ && this.f_20916_ == 0) {
                    this.collideWithEntities(this.f_19853_.m_6249_((Entity)this, this.dragonPartRightWing.m_142469_().m_82377_(4.0, 2.0, 4.0).m_82386_(0.0, -2.0, 0.0), EntitySelector.f_20406_));
                    this.collideWithEntities(this.f_19853_.m_6249_((Entity)this, this.dragonPartLeftWing.m_142469_().m_82377_(4.0, 2.0, 4.0).m_82386_(0.0, -2.0, 0.0), EntitySelector.f_20406_));
                    this.attackEntitiesInList(this.f_19853_.m_6249_((Entity)this, this.dragonPartHead.m_142469_().m_82400_(1.0), EntitySelector.f_20406_));
                    this.attackEntitiesInList(this.f_19853_.m_6249_((Entity)this, this.dragonPartNeck.m_142469_().m_82400_(1.0), EntitySelector.f_20406_));
                }
                float f4 = Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180) - this.yRotA * 0.01f));
                float f19 = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180) - this.yRotA * 0.01f));
                float f5 = this.getHeadAndNeckYOffset();
                this.setPartPosition(this.dragonPartHead, f4 * 6.5f * f16, f5 + f2 * 6.5f, -f19 * 6.5f * f16);
                this.setPartPosition(this.dragonPartNeck, f4 * 5.5f * f16, f5 + f2 * 5.5f, -f19 * 5.5f * f16);
                double[] adouble = this.getLatencyPos(5, 1.0f);
                for (int k = 0; k < 3; ++k) {
                    DraconicGuardianPartEntity enderdragonpartentity = null;
                    if (k == 0) {
                        enderdragonpartentity = this.dragonPartTail1;
                    }
                    if (k == 1) {
                        enderdragonpartentity = this.dragonPartTail2;
                    }
                    if (k == 2) {
                        enderdragonpartentity = this.dragonPartTail3;
                    }
                    double[] adouble1 = this.getLatencyPos(12 + k * 2, 1.0f);
                    float f7 = this.m_146908_() * ((float)Math.PI / 180) + this.simplifyAngle(adouble1[0] - adouble[0]) * ((float)Math.PI / 180);
                    float f20 = Mth.m_14031_((float)f7);
                    float f21 = Mth.m_14089_((float)f7);
                    float f22 = 1.5f;
                    float f23 = (float)(k + 1) * 2.0f;
                    this.setPartPosition(enderdragonpartentity, -(f3 * 1.5f + f20 * f23) * f16, adouble1[1] - adouble[1] - (double)((f23 + 1.5f) * f2) + 1.5, (f18 * 1.5f + f21 * f23) * f16);
                }
                if (!this.f_19853_.f_46443_) {
                    this.slowed = this.destroyBlocksInAABB(this.dragonPartHead.m_142469_()) | this.destroyBlocksInAABB(this.dragonPartNeck.m_142469_()) | this.destroyBlocksInAABB(this.dragonPartBody.m_142469_());
                    if (this.fightManager != null) {
                        this.fightManager.guardianUpdate(this);
                    }
                }
                for (int l = 0; l < this.dragonParts.length; ++l) {
                    this.dragonParts[l].f_19854_ = avector3d[l].f_82479_;
                    this.dragonParts[l].f_19855_ = avector3d[l].f_82480_;
                    this.dragonParts[l].f_19856_ = avector3d[l].f_82481_;
                    this.dragonParts[l].f_19790_ = avector3d[l].f_82479_;
                    this.dragonParts[l].f_19791_ = avector3d[l].f_82480_;
                    this.dragonParts[l].f_19792_ = avector3d[l].f_82481_;
                }
            }
        }
    }

    private void setPartPosition(DraconicGuardianPartEntity part, double offsetX, double offsetY, double offsetZ) {
        part.m_6034_(this.m_20185_() + offsetX, this.m_20186_() + offsetY, this.m_20189_() + offsetZ);
    }

    private float getHeadAndNeckYOffset() {
        if (this.phaseManager.getCurrentPhase().getIsStationary()) {
            return -1.0f;
        }
        double[] adouble = this.getLatencyPos(5, 1.0f);
        double[] adouble1 = this.getLatencyPos(0, 1.0f);
        return (float)(adouble[1] - adouble1[1]);
    }

    private void updateDragonEnderCrystal() {
        if (this.closestGuardianCrystal != null) {
            if (!this.closestGuardianCrystal.m_6084_()) {
                this.closestGuardianCrystal = null;
            } else if (this.f_19797_ % 10 == 0 && this.m_21223_() < this.m_21233_()) {
                this.m_21153_(this.m_21223_() + 1.0f);
            }
        }
        if (this.f_19796_.nextInt(10) == 0 && !this.f_19853_.f_46443_) {
            if (this.fightManager != null) {
                this.closestGuardianCrystal = this.fightManager.getCrystals().stream().min(Comparator.comparingDouble(arg_0 -> ((DraconicGuardianEntity)this).m_20280_(arg_0))).orElse(null);
            } else {
                List list = this.f_19853_.m_45976_(GuardianCrystalEntity.class, this.m_142469_().m_82400_(32.0));
                GuardianCrystalEntity crystal = null;
                double d0 = Double.MAX_VALUE;
                for (GuardianCrystalEntity endercrystalentity1 : list) {
                    double d1 = endercrystalentity1.m_20280_((Entity)this);
                    if (!(d1 < d0)) continue;
                    d0 = d1;
                    crystal = endercrystalentity1;
                }
                this.closestGuardianCrystal = crystal;
            }
            this.m_20088_().m_135381_(CRYSTAL_ID, (Object)(this.closestGuardianCrystal == null ? -1 : this.closestGuardianCrystal.m_142049_()));
        }
    }

    private void collideWithEntities(List<Entity> entities) {
        double d0 = (this.dragonPartBody.m_142469_().f_82288_ + this.dragonPartBody.m_142469_().f_82291_) / 2.0;
        double d1 = (this.dragonPartBody.m_142469_().f_82290_ + this.dragonPartBody.m_142469_().f_82293_) / 2.0;
        for (Entity entity : entities) {
            if (!(entity instanceof LivingEntity)) continue;
            double d2 = entity.m_20185_() - d0;
            double d3 = entity.m_20189_() - d1;
            double d4 = Math.max(d2 * d2 + d3 * d3, 0.1);
            entity.m_5997_(d2 / d4 * 4.0, (double)0.2f, d3 / d4 * 4.0);
            if (this.phaseManager.getCurrentPhase().getIsStationary() || ((LivingEntity)entity).m_21213_() >= entity.f_19797_ - 2) continue;
            entity.m_6469_((DamageSource)new EntityDamageSource("draconicevolution.draconic_guardian", (Entity)this), 15.0f);
            this.m_19970_((LivingEntity)this, entity);
        }
    }

    private void attackEntitiesInList(List<Entity> entities) {
        for (Entity entity : entities) {
            if (!(entity instanceof LivingEntity)) continue;
            entity.m_6469_((DamageSource)new EntityDamageSource("draconicevolution.draconic_guardian", (Entity)this), 20.0f);
            this.m_19970_((LivingEntity)this, entity);
        }
    }

    private float simplifyAngle(double angle) {
        return (float)Mth.m_14175_((double)angle);
    }

    private boolean destroyBlocksInAABB(AABB area) {
        int i = Mth.m_14107_((double)area.f_82288_);
        int j = Mth.m_14107_((double)area.f_82289_);
        int k = Mth.m_14107_((double)area.f_82290_);
        int l = Mth.m_14107_((double)area.f_82291_);
        int i1 = Mth.m_14107_((double)area.f_82292_);
        int j1 = Mth.m_14107_((double)area.f_82293_);
        boolean flag = false;
        boolean flag1 = false;
        for (int k1 = i; k1 <= l; ++k1) {
            for (int l1 = j; l1 <= i1; ++l1) {
                for (int i2 = k; i2 <= j1; ++i2) {
                    BlockPos blockpos = new BlockPos(k1, l1, i2);
                    BlockState blockstate = this.f_19853_.m_8055_(blockpos);
                    Block block = blockstate.m_60734_();
                    if (blockstate.m_60795_() || blockstate.m_60767_() == Material.f_76309_) continue;
                    if (ForgeHooks.canEntityDestroy((Level)this.f_19853_, (BlockPos)blockpos, (LivingEntity)this) && !blockstate.m_204336_(BlockTags.f_13069_) && block != Blocks.f_50197_ && block != Blocks.f_50412_) {
                        flag1 = this.f_19853_.m_7471_(blockpos, false) || flag1;
                        continue;
                    }
                    flag = true;
                }
            }
        }
        if (flag1) {
            BlockPos blockpos1 = new BlockPos(i + this.f_19796_.nextInt(l - i + 1), j + this.f_19796_.nextInt(i1 - j + 1), k + this.f_19796_.nextInt(j1 - k + 1));
            this.f_19853_.m_46796_(2008, blockpos1, 0);
        }
        return flag;
    }

    public boolean attackEntityPartFrom(DraconicGuardianPartEntity part, DamageSource source, float damage) {
        if (this.phaseManager.getCurrentPhase().getType() == PhaseType.DYING || source.m_7639_() == this) {
            return false;
        }
        float shieldPower = this.getShieldPower();
        if (shieldPower > 0.0f) {
            BCoreNetwork.sendSound((Level)this.f_19853_, (BlockPos)this.m_142538_(), (SoundEvent)DESounds.shieldStrike, (SoundSource)SoundSource.HOSTILE, (float)20.0f, (float)(this.f_19796_.nextFloat() * 0.2f + 0.9f), (boolean)false);
        }
        if (this.hitCoolDown > 0 && damage < this.lastDamage * 1.1f) {
            this.lastDamage = damage;
            return false;
        }
        this.lastDamage = damage;
        this.hitCoolDown = 5;
        if (this.fightManager != null && !this.fightManager.onGuardianAttacked(this, source, damage)) {
            this.phaseManager.getCurrentPhase().onAttacked(source, damage, shieldPower, false);
            return false;
        }
        damage = this.phaseManager.getCurrentPhase().onAttacked(source, damage, shieldPower, true);
        if (damage > 500.0f) {
            damage = 500.0f;
        }
        if ((shieldPower -= Math.min(shieldPower, damage)) > 0.0f) {
            this.setShieldPower(shieldPower);
            return true;
        }
        damage -= this.getShieldPower();
        this.setShieldPower(0.0f);
        if (damage > 100.0f) {
            damage = 100.0f;
        }
        if (part != this.dragonPartHead) {
            damage = damage / 4.0f + Math.min(damage, 1.0f);
        }
        if (damage < 0.01f) {
            return false;
        }
        if (source.m_7639_() instanceof Player || source.m_19372_()) {
            this.attackDragonFrom(source, damage);
            if (this.m_21224_() && !this.phaseManager.getCurrentPhase().getIsStationary()) {
                this.m_21153_(1.0f);
                this.phaseManager.setPhase(PhaseType.DYING);
            }
        }
        return true;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source instanceof EntityDamageSource && ((EntityDamageSource)source).m_19403_()) {
            this.attackEntityPartFrom(this.dragonPartBody, source, amount);
        }
        return false;
    }

    protected boolean attackDragonFrom(DamageSource source, float amount) {
        return super.m_6469_(source, amount);
    }

    public void m_6074_() {
        this.m_142687_(Entity.RemovalReason.KILLED);
        if (this.fightManager != null) {
            this.fightManager.guardianUpdate(this);
            this.fightManager.processDragonDeath(this);
        }
    }

    protected void m_6153_() {
        if (this.fightManager != null) {
            this.fightManager.guardianUpdate(this);
        }
        ++this.deathTicks;
        if (this.deathTicks >= 180 && this.deathTicks <= 200) {
            float f = (this.f_19796_.nextFloat() - 0.5f) * 8.0f;
            float f1 = (this.f_19796_.nextFloat() - 0.5f) * 4.0f;
            float f2 = (this.f_19796_.nextFloat() - 0.5f) * 8.0f;
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123812_, this.m_20185_() + (double)f, this.m_20186_() + 2.0 + (double)f1, this.m_20189_() + (double)f2, 0.0, 0.0, 0.0);
        }
        boolean flag = this.f_19853_.m_46469_().m_46207_(GameRules.f_46135_);
        int xpAmount = 24000;
        if (!this.f_19853_.f_46443_) {
            if (this.deathTicks > 150 && this.deathTicks % 5 == 0 && flag) {
                this.dropExperience(Mth.m_14143_((float)((float)xpAmount * 0.08f)));
            }
            if (this.deathTicks == 1 && !this.m_20067_()) {
                this.f_19853_.m_6798_(1028, this.m_142538_(), 0);
            }
        }
        this.m_6478_(MoverType.SELF, new Vec3(0.0, (double)0.1f, 0.0));
        this.m_146922_(this.m_146908_() + 20.0f);
        this.f_20883_ = this.m_146908_();
        if (this.deathTicks == 200 && !this.f_19853_.f_46443_) {
            if (flag) {
                this.dropExperience(Mth.m_14143_((float)((float)xpAmount * 0.2f)));
            }
            if (this.fightManager != null) {
                this.fightManager.processDragonDeath(this);
            }
            this.m_146870_();
        }
    }

    private void dropExperience(int xp) {
        while (xp > 0) {
            int i = ExperienceOrb.m_20782_((int)xp);
            xp -= i;
            this.f_19853_.m_7967_((Entity)new ExperienceOrb(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), i));
        }
    }

    public int initPathPoints(boolean regenerate) {
        if (this.pathPoints[0] == null || regenerate) {
            if (this.getArenaOrigin() == null) {
                this.setArenaOrigin(this.m_142538_());
            }
            BlockPos arenaOrigin = this.getArenaOrigin();
            for (int i = 0; i < 24; ++i) {
                float loopPos = (float)i / 24.0f;
                float angle = loopPos * 360.0f;
                int pointX = MathHelper.floor((double)(70.0 * Math.cos((double)angle * 0.017453292519943)));
                int pointZ = MathHelper.floor((double)(70.0 * Math.sin((double)angle * 0.017453292519943)));
                int pointY = Math.max(arenaOrigin.m_123342_() + 40, this.f_19853_.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, new BlockPos(pointX, 0, pointZ)).m_123342_());
                this.pathPoints[i] = new Node(arenaOrigin.m_123341_() + pointX, pointY, arenaOrigin.m_123343_() + pointZ);
            }
        }
        return this.getNearestPpIdx(this.m_20185_(), this.m_20186_(), this.m_20189_());
    }

    public int getNearestPpIdx(double x, double y, double z) {
        float f = 10000.0f;
        int i = 0;
        Node pathpoint = new Node(Mth.m_14107_((double)x), Mth.m_14107_((double)y), Mth.m_14107_((double)z));
        int j = 0;
        if (this.fightManager == null || this.fightManager.getNumAliveCrystals() == 0) {
            j = 12;
        }
        for (int k = j; k < 24; ++k) {
            float f1;
            if (this.pathPoints[k] == null || !((f1 = this.pathPoints[k].m_77299_(pathpoint)) < f)) continue;
            f = f1;
            i = k;
        }
        return i;
    }

    @javax.annotation.Nullable
    public Path findPath(int startIdx, int finishIdx, @javax.annotation.Nullable Node andThen) {
        for (int i = 0; i < 24; ++i) {
            Node pathpoint = this.pathPoints[i];
            pathpoint.f_77279_ = false;
            pathpoint.f_77277_ = 0.0f;
            pathpoint.f_77275_ = 0.0f;
            pathpoint.f_77276_ = 0.0f;
            pathpoint.f_77278_ = null;
            pathpoint.f_77274_ = -1;
        }
        Node startPoint = this.pathPoints[startIdx];
        Node endPoint = this.pathPoints[finishIdx];
        startPoint.f_77275_ = 0.0f;
        startPoint.f_77277_ = startPoint.f_77276_ = startPoint.m_77293_(endPoint);
        this.pathFindQueue.m_77081_();
        this.pathFindQueue.m_77084_(startPoint);
        Node nextPoint = startPoint;
        int startIndex = 0;
        while (!this.pathFindQueue.m_77092_()) {
            Node testPoint = this.pathFindQueue.m_77091_();
            if (testPoint.equals((Object)endPoint)) {
                if (andThen != null) {
                    andThen.f_77278_ = endPoint;
                    endPoint = andThen;
                }
                return this.makePath(startPoint, endPoint);
            }
            if (testPoint.m_77299_(endPoint) < nextPoint.m_77299_(endPoint)) {
                nextPoint = testPoint;
            }
            testPoint.f_77279_ = true;
            int testPointIntex = 0;
            for (int l = 0; l < 24; ++l) {
                if (this.pathPoints[l] != testPoint) continue;
                testPointIntex = l;
                break;
            }
            for (int index = startIndex; index < 24; ++index) {
                Node pathpoint3 = this.pathPoints[index];
                if (pathpoint3.f_77279_) continue;
                float f = testPoint.f_77275_ + testPoint.m_77293_(pathpoint3);
                if (pathpoint3.m_77303_() && !(f < pathpoint3.f_77275_)) continue;
                pathpoint3.f_77278_ = testPoint;
                pathpoint3.f_77275_ = f;
                pathpoint3.f_77276_ = pathpoint3.m_77293_(endPoint);
                if (pathpoint3.m_77303_()) {
                    this.pathFindQueue.m_77086_(pathpoint3, pathpoint3.f_77275_ + pathpoint3.f_77276_);
                    continue;
                }
                pathpoint3.f_77277_ = pathpoint3.f_77275_ + pathpoint3.f_77276_;
                this.pathFindQueue.m_77084_(pathpoint3);
            }
        }
        if (nextPoint == startPoint) {
            return null;
        }
        LOGGER.debug("Failed to find path from {} to {}", (Object)startIdx, (Object)finishIdx);
        if (andThen != null) {
            andThen.f_77278_ = nextPoint;
            nextPoint = andThen;
        }
        return this.makePath(startPoint, nextPoint);
    }

    private Path makePath(Node start, Node finish) {
        ArrayList list = Lists.newArrayList();
        Node pathpoint = finish;
        list.add(0, finish);
        while (pathpoint.f_77278_ != null) {
            pathpoint = pathpoint.f_77278_;
            list.add(0, pathpoint);
        }
        return new Path((List)list, new BlockPos(finish.f_77271_, finish.f_77272_, finish.f_77273_), true);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("dragon_phase", this.phaseManager.getCurrentPhase().getType().getId());
        if (this.getArenaOrigin() != null) {
            compound.m_128365_("arena_origin", (Tag)NbtUtils.m_129224_((BlockPos)this.getArenaOrigin()));
        }
        compound.m_128350_("shield_power", this.getShieldPower());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("dragon_phase")) {
            this.phaseManager.setPhase(PhaseType.getById(compound.m_128451_("dragon_phase")));
        }
        if (compound.m_128441_("arena_origin")) {
            this.setArenaOrigin(NbtUtils.m_129239_((CompoundTag)compound.m_128469_("arena_origin")));
        }
        if (this.f_19853_ instanceof ServerLevel) {
            this.fightManager = WorldEntityHandler.getWorldEntities().stream().filter(e -> e instanceof GuardianFightManager).map(e -> (GuardianFightManager)((Object)e)).filter(e -> this.m_142081_().equals(e.getGuardianUniqueId())).findFirst().orElse(null);
            if (this.fightManager != null) {
                this.setArenaOrigin(this.fightManager.getArenaOrigin());
            }
        } else {
            this.fightManager = null;
        }
        if (compound.m_128425_("shield_power", 5)) {
            this.setShieldPower(compound.m_128457_("shield_power"));
        }
    }

    public void m_6043_() {
    }

    public DraconicGuardianPartEntity[] getDragonParts() {
        return this.dragonParts;
    }

    public boolean m_6087_() {
        return false;
    }

    public SoundSource m_5720_() {
        return SoundSource.HOSTILE;
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_11890_;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SoundEvents.f_11895_;
    }

    protected float m_6121_() {
        return 5.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getHeadPartYOffset(int p_184667_1_, double[] spineEndOffsets, double[] headPartOffsets) {
        IPhase iphase = this.phaseManager.getCurrentPhase();
        PhaseType<? extends IPhase> phasetype = iphase.getType();
        double d0 = iphase.getIsStationary() ? (double)p_184667_1_ : (p_184667_1_ == 6 ? 0.0 : headPartOffsets[1] - spineEndOffsets[1]);
        return (float)d0;
    }

    public Vec3 getHeadLookVec(float partialTicks) {
        Vec3 vector3d;
        IPhase iphase = this.phaseManager.getCurrentPhase();
        PhaseType<? extends IPhase> phasetype = iphase.getType();
        if (iphase.getIsStationary()) {
            float f4 = this.m_146909_();
            float f5 = 1.5f;
            this.m_146926_(-45.0f);
            vector3d = this.m_20252_(partialTicks);
            this.m_146926_(f4);
        } else {
            vector3d = this.m_20252_(partialTicks);
        }
        return vector3d;
    }

    public void onCrystalAttacked(GuardianCrystalEntity crystal, BlockPos pos, DamageSource dmgSrc, float damage, boolean destroyed) {
        Player playerentity = dmgSrc.m_7639_() instanceof Player ? (Player)dmgSrc.m_7639_() : this.f_19853_.m_45941_(PLAYER_INVADER_CONDITION, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
        if (crystal == this.closestGuardianCrystal && destroyed) {
            this.attackEntityPartFrom(this.dragonPartHead, DamageSource.m_19373_((LivingEntity)playerentity), 10.0f);
        }
        this.phaseManager.getCurrentPhase().onCrystalAttacked(crystal, pos, dmgSrc, playerentity, damage, destroyed);
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        if (PHASE.equals(key) && this.f_19853_.f_46443_) {
            this.phaseManager.setPhase(PhaseType.getById((Integer)this.m_20088_().m_135370_(PHASE)));
        } else if (CRYSTAL_ID.equals(key) && this.f_19853_.f_46443_) {
            Entity entity;
            int id = (Integer)this.m_20088_().m_135370_(CRYSTAL_ID);
            this.closestGuardianCrystal = id == -1 ? null : ((entity = this.f_19853_.m_6815_(id)) instanceof GuardianCrystalEntity ? (GuardianCrystalEntity)entity : null);
        }
        super.m_7350_(key);
    }

    public PhaseManager getPhaseManager() {
        return this.phaseManager;
    }

    @javax.annotation.Nullable
    public GuardianFightManager getFightManager() {
        return this.fightManager;
    }

    public boolean m_147207_(MobEffectInstance effectInstanceIn, @Nullable Entity p_147209_) {
        if (effectInstanceIn.m_19544_().m_19486_()) {
            return super.m_147207_(effectInstanceIn, p_147209_);
        }
        return false;
    }

    protected boolean m_7341_(Entity entityIn) {
        return false;
    }

    public boolean m_6072_() {
        return false;
    }

    @javax.annotation.Nullable
    public DraconicGuardianPartEntity[] getParts() {
        return this.dragonParts;
    }

    public boolean isMultipartEntity() {
        return true;
    }

    public Packet<?> m_5654_() {
        return super.m_5654_();
    }
}

