/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.entity;

import codechicken.lib.vec.Vector3;
import com.brandon3055.brandonscore.network.BCoreNetwork;
import com.brandon3055.brandonscore.worldentity.WorldEntity;
import com.brandon3055.brandonscore.worldentity.WorldEntityHandler;
import com.brandon3055.draconicevolution.DEConfig;
import com.brandon3055.draconicevolution.entity.guardian.GuardianFightManager;
import com.brandon3055.draconicevolution.handlers.DESounds;
import com.brandon3055.draconicevolution.init.DEContent;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.material.PushReaction;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;

public class GuardianCrystalEntity
extends Entity {
    private static final EntityDataAccessor<Optional<BlockPos>> BEAM_TARGET = SynchedEntityData.m_135353_(GuardianCrystalEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135039_);
    private static final EntityDataAccessor<Boolean> SHOW_BOTTOM = SynchedEntityData.m_135353_(GuardianCrystalEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Float> SHIELD_POWER = SynchedEntityData.m_135353_(GuardianCrystalEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> BEAM_POWER = SynchedEntityData.m_135353_(GuardianCrystalEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> UNSTABLE_TIME = SynchedEntityData.m_135353_(GuardianCrystalEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private UUID managerId;
    public int time;
    private int beamChargeAnim = 0;

    public GuardianCrystalEntity(EntityType<?> type, Level world) {
        super(type, world);
        this.f_19850_ = true;
        this.time = this.f_19796_.nextInt(100000);
    }

    public GuardianCrystalEntity(Level worldIn, double x, double y, double z, UUID managerId) {
        this(DEContent.guardianCrystal, worldIn);
        this.managerId = managerId;
        this.m_6034_(x, y, z);
    }

    public UUID getManagerId() {
        return this.managerId;
    }

    public void setUnstableTime(int unstableTime) {
        this.f_19804_.m_135381_(UNSTABLE_TIME, (Object)unstableTime);
    }

    public int getUnstableTime() {
        return (Integer)this.f_19804_.m_135370_(UNSTABLE_TIME);
    }

    public float getShieldPower() {
        return ((Float)this.f_19804_.m_135370_(SHIELD_POWER)).floatValue();
    }

    public void setShieldPower(float shieldPower) {
        this.f_19804_.m_135381_(SHIELD_POWER, (Object)Float.valueOf(shieldPower));
    }

    public void setManagerId(UUID managerId) {
        this.managerId = managerId;
    }

    public PushReaction m_7752_() {
        return PushReaction.IGNORE;
    }

    protected void m_8097_() {
        this.m_20088_().m_135372_(BEAM_TARGET, Optional.empty());
        this.m_20088_().m_135372_(SHOW_BOTTOM, (Object)true);
        this.m_20088_().m_135372_(SHIELD_POWER, (Object)Float.valueOf(Math.max(20.0f, (float)DEConfig.guardianCrystalShield)));
        this.m_20088_().m_135372_(UNSTABLE_TIME, (Object)0);
        this.m_20088_().m_135372_(BEAM_POWER, (Object)Float.valueOf(1.0f));
    }

    public void m_8119_() {
        ++this.time;
        if (this.f_19853_ instanceof ServerLevel) {
            GuardianFightManager manager;
            BlockPos blockpos = this.m_142538_();
            if (this.getManagerId() != null && this.f_19853_.m_8055_(blockpos).m_60795_()) {
                this.f_19853_.m_46597_(blockpos, BaseFireBlock.m_49245_((BlockGetter)this.f_19853_, (BlockPos)blockpos));
            }
            if ((manager = this.getManager()) != null) {
                if (this.getUnstableTime() > 0) {
                    this.setBeamTarget(null);
                    this.setUnstableTime(this.getUnstableTime() - 1);
                    if (this.getUnstableTime() > 0) {
                        for (int i = 0; i < 3; ++i) {
                            BCoreNetwork.sendParticle((Level)this.f_19853_, (ParticleOptions)ParticleTypes.f_123815_, (Vector3)Vector3.fromEntity((Entity)this), (Vector3)new Vector3((double)this.f_19796_.nextFloat(), 0.5 + (double)(this.f_19796_.nextFloat() / 2.0f), (double)this.f_19796_.nextFloat()).subtract(0.5).multiply(1.5), (boolean)true);
                        }
                        if (this.f_19796_.nextInt(3) == 0) {
                            this.setBeamTarget(manager.getArenaOrigin());
                            BCoreNetwork.sendSound((Level)this.f_19853_, (Entity)this, (SoundEvent)DESounds.crystalUnstable, (SoundSource)SoundSource.HOSTILE, (float)6.0f, (float)(0.9f + this.f_19796_.nextFloat() * 0.2f), (boolean)false);
                        }
                    } else {
                        BCoreNetwork.sendSound((Level)this.f_19853_, (Entity)this, (SoundEvent)DESounds.crystalRestore, (SoundSource)SoundSource.HOSTILE, (float)8.0f, (float)(0.5f + this.f_19853_.f_46441_.nextFloat() * 0.2f), (boolean)false);
                    }
                } else if (this.getShieldPower() < (float)DEConfig.guardianCrystalShield) {
                    this.setShieldPower(Math.min((float)DEConfig.guardianCrystalShield, this.getShieldPower() + (float)DEConfig.guardianCrystalShield / 1200.0f));
                    this.playChargeAnimation();
                } else if (this.beamChargeAnim <= 0 && manager.respawnState == null) {
                    this.setBeamTarget(null);
                }
                if (this.beamChargeAnim > 0) {
                    this.setBeamPower(Mth.m_14031_((float)((float)this.beamChargeAnim / 20.0f * (float)Math.PI)));
                    --this.beamChargeAnim;
                    if (this.beamChargeAnim <= 0) {
                        this.beamChargeAnim = 0;
                        this.setBeamTarget(null);
                        this.setBeamPower(1.0f);
                    }
                }
            }
        }
    }

    protected void m_7380_(CompoundTag compound) {
        if (this.getBeamTarget() != null) {
            compound.m_128365_("BeamTarget", (Tag)NbtUtils.m_129224_((BlockPos)this.getBeamTarget()));
        }
        compound.m_128379_("ShowBottom", this.showsBottom());
        compound.m_128362_("manager_id", this.managerId);
    }

    protected void m_7378_(CompoundTag compound) {
        if (compound.m_128425_("BeamTarget", 10)) {
            this.setBeamTarget(NbtUtils.m_129239_((CompoundTag)compound.m_128469_("BeamTarget")));
        }
        if (compound.m_128425_("ShowBottom", 1)) {
            this.setShowBottom(compound.m_128471_("ShowBottom"));
        }
        if (compound.m_128441_("manager_id")) {
            this.managerId = compound.m_128342_("manager_id");
        }
    }

    public boolean m_6087_() {
        return true;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_6673_(source)) {
            return false;
        }
        if (!this.m_146910_() && !this.f_19853_.f_46443_) {
            float newPower;
            GuardianFightManager manager = this.getManager();
            float shield = this.getShieldPower() / (float)DEConfig.guardianCrystalShield;
            if (shield > 0.0f) {
                BCoreNetwork.sendSound((Level)this.f_19853_, (Entity)this, (SoundEvent)DESounds.shieldStrike, (SoundSource)SoundSource.HOSTILE, (float)6.0f, (float)(0.5f + shield), (boolean)false);
            }
            if (manager != null && shield > 0.0f) {
                float modifier = manager.getCrystalDamageModifier(this, source);
                if (modifier == 0.0f) {
                    this.playChargeAnimation();
                    return false;
                }
                amount *= modifier;
            }
            if (shield > 0.0f && (newPower = (float)((int)(this.getShieldPower() - amount))) > 0.0f) {
                this.setShieldPower(newPower);
                this.onCrystalAttacked(source, amount, false);
                return true;
            }
            this.m_146870_();
            if (!source.m_19372_()) {
                this.f_19853_.m_46511_((Entity)null, this.m_20185_(), this.m_20186_(), this.m_20189_(), 10.0f, Explosion.BlockInteraction.DESTROY);
            }
            this.onCrystalAttacked(source, amount, true);
        }
        return true;
    }

    private void playChargeAnimation() {
        GuardianFightManager manager = this.getManager();
        if (this.beamChargeAnim == 0 && manager != null) {
            BCoreNetwork.sendSound((Level)this.f_19853_, (Entity)this, (SoundEvent)DESounds.crystalBeam, (SoundSource)SoundSource.HOSTILE, (float)6.0f, (float)1.0f, (boolean)false);
            this.beamChargeAnim = 20;
            this.setBeamTarget(manager.getArenaOrigin());
            this.setBeamPower(0.0f);
        }
    }

    public void m_6074_() {
        this.onCrystalAttacked(DamageSource.f_19318_, 0.0f, true);
        super.m_6074_();
    }

    private void onCrystalAttacked(DamageSource source, float damage, boolean destroyed) {
        GuardianFightManager manager = this.getManager();
        if (manager != null) {
            manager.onCrystalAttacked(this, source, damage, destroyed);
        }
    }

    public void setBeamTarget(@Nullable BlockPos beamTarget) {
        this.setBeamPower(1.0f);
        this.m_20088_().m_135381_(BEAM_TARGET, Optional.ofNullable(beamTarget));
    }

    public void setBeamPower(float beamPower) {
        this.f_19804_.m_135381_(BEAM_POWER, (Object)Float.valueOf(beamPower));
    }

    public float getBeamPower() {
        return ((Float)this.f_19804_.m_135370_(BEAM_POWER)).floatValue();
    }

    @Nullable
    public BlockPos getBeamTarget() {
        return ((Optional)this.m_20088_().m_135370_(BEAM_TARGET)).orElse(null);
    }

    public void setShowBottom(boolean showBottom) {
        this.m_20088_().m_135381_(SHOW_BOTTOM, (Object)showBottom);
    }

    public boolean showsBottom() {
        return (Boolean)this.m_20088_().m_135370_(SHOW_BOTTOM);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean m_6783_(double distance) {
        return super.m_6783_(distance) || this.getBeamTarget() != null;
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void destabilize() {
        if (this.getUnstableTime() == 0) {
            BCoreNetwork.sendSound((Level)this.f_19853_, (Entity)this, (SoundEvent)DESounds.crystalDestabilize, (SoundSource)SoundSource.HOSTILE, (float)8.0f, (float)(0.5f + this.f_19853_.f_46441_.nextFloat() * 0.2f), (boolean)false);
        }
        this.setUnstableTime(DEConfig.guardianCrystalUnstableWindow);
    }

    public GuardianFightManager getManager() {
        WorldEntity worldEntity;
        if (this.f_19853_ instanceof ServerLevel && this.getManagerId() != null && (worldEntity = WorldEntityHandler.getWorldEntity((Level)this.f_19853_, (UUID)this.managerId)) instanceof GuardianFightManager) {
            return (GuardianFightManager)worldEntity;
        }
        return null;
    }
}

