/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.entity;

import com.brandon3055.brandonscore.inventory.InventoryDynamic;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.ForgeEventFactory;

public class EntityLootCore
extends Entity {
    private InventoryDynamic inventory = new InventoryDynamic();
    public double rotX = 0.0;
    public double rotY = 0.0;
    public int timeOffset = 0;
    public int pickupDellay = 0;
    public Map<ItemStack, Integer> displayMap = new HashMap<ItemStack, Integer>();
    public boolean isLooking = false;
    public float lookAnimation = 0.0f;
    private int despawnTimer = 0;
    private int lifespan = 6000;
    private boolean canDespawn = true;
    private List<ServerPlayer> trackingPlayers = new ArrayList<ServerPlayer>();

    public EntityLootCore(EntityType<?> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
    }

    protected void m_8097_() {
    }

    public Packet<?> m_5654_() {
        return null;
    }

    public boolean m_6087_() {
        return true;
    }

    public void m_8119_() {
        if (this.f_19853_.f_46443_) {
            if (this.isLooking && this.lookAnimation < 1.0f) {
                this.lookAnimation += 0.05f;
            } else if (!this.isLooking && this.lookAnimation > 0.0f) {
                this.lookAnimation -= 0.05f;
            }
        } else if (this.canDespawn && this.despawnTimer++ > this.lifespan) {
            this.m_146870_();
        }
        super.m_8119_();
    }

    public void m_6123_(Player player) {
        if (this.f_19853_.f_46443_) {
            return;
        }
        this.despawnTimer = 0;
        if (this.pickupDellay > 0) {
            --this.pickupDellay;
            return;
        }
        if (this.inventory.xp > 0) {
            player.m_6756_(this.inventory.xp);
            this.inventory.xp = 0;
        }
        boolean inserted = false;
        for (int i = this.inventory.m_6643_() - 1; i >= 0; --i) {
            ItemStack stack = this.inventory.m_8020_(i);
            if (stack.m_41619_()) continue;
            int start = stack.m_41613_();
            ItemEntity item = new ItemEntity(this.f_19853_, 0.0, 0.0, 0.0, stack);
            item.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
            int result = ForgeEventFactory.onItemPickup((ItemEntity)item, (Player)player);
            if (result != 1 && stack.m_41613_() > 0 && !player.m_150109_().m_36054_(stack)) continue;
            if (!item.m_6084_()) {
                stack.m_41764_(0);
            }
            if (stack.m_41613_() == 0) {
                this.inventory.m_6836_(i, ItemStack.f_41583_);
            } else {
                this.inventory.m_6836_(i, stack);
            }
            if (stack.m_41613_() >= start) continue;
            inserted = true;
        }
        if (inserted) {
            this.f_19853_.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, ((this.f_19796_.nextFloat() - this.f_19796_.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            this.updateStored();
        }
        this.pickupDellay = 10;
        if (this.inventory.m_6643_() == 1 && this.inventory.m_8020_(0).m_41619_()) {
            this.m_146870_();
        }
    }

    private void updateStored() {
        if (this.f_19853_.f_46443_) {
            return;
        }
        this.displayMap = new HashMap<ItemStack, Integer>();
        for (int i = 0; i < this.inventory.m_6643_(); ++i) {
            ItemStack insert = this.inventory.m_8020_(i);
            if (insert.m_41619_()) continue;
            boolean added = false;
            for (ItemStack stack : this.displayMap.keySet()) {
                if (!insert.m_41656_(stack) || !ItemStack.m_41658_((ItemStack)insert, (ItemStack)stack)) continue;
                added = true;
                this.displayMap.put(stack, this.displayMap.get(stack) + insert.m_41613_());
                break;
            }
            if (added) continue;
            this.displayMap.put(insert, insert.m_41613_());
        }
        for (ServerPlayer serverPlayer : this.trackingPlayers) {
        }
    }

    public void m_6457_(ServerPlayer player) {
        this.trackingPlayers.add(player);
        super.m_6457_(player);
    }

    public void m_6452_(ServerPlayer player) {
        this.trackingPlayers.remove(player);
        super.m_6452_(player);
    }

    protected void m_7378_(CompoundTag compound) {
        this.inventory.readFromNBT(compound);
        this.updateStored();
        this.despawnTimer = compound.m_128451_("DespawnTimer");
        this.lifespan = compound.m_128451_("Lifespan");
        this.canDespawn = compound.m_128471_("CanDespawn");
    }

    protected void m_7380_(CompoundTag compound) {
        this.inventory.writeToNBT(compound);
        compound.m_128405_("DespawnTimer", this.despawnTimer);
        compound.m_128405_("Lifespan", this.lifespan);
        compound.m_128379_("CanDespawn", this.canDespawn);
    }
}

