/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.datagen;

import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.draconicevolution.api.DraconicAPI;
import com.brandon3055.draconicevolution.api.crafting.FusionRecipe;
import com.brandon3055.draconicevolution.api.crafting.IngredientStack;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;

public class FusionRecipeBuilder {
    private final ItemStack result;
    private Ingredient catalyst = null;
    private long energy = -1L;
    private TechLevel techLevel = null;
    private List<FusionRecipe.FusionIngredient> ingredients = new ArrayList<FusionRecipe.FusionIngredient>();

    public FusionRecipeBuilder(ItemStack result) {
        this.result = result;
    }

    public static FusionRecipeBuilder fusionRecipe(ItemLike resultIn) {
        return FusionRecipeBuilder.fusionRecipe(resultIn, 1);
    }

    public static FusionRecipeBuilder fusionRecipe(ItemLike resultIn, int countIn) {
        return FusionRecipeBuilder.fusionRecipe(new ItemStack(resultIn, countIn));
    }

    public static FusionRecipeBuilder fusionRecipe(ItemStack result) {
        return new FusionRecipeBuilder(result);
    }

    public FusionRecipeBuilder catalyst(TagKey<Item> catalyst) {
        return this.catalyst(Ingredient.m_204132_(catalyst));
    }

    public FusionRecipeBuilder catalyst(ItemLike ... catalyst) {
        return this.catalyst(Ingredient.m_43929_((ItemLike[])catalyst));
    }

    public FusionRecipeBuilder catalyst(ItemStack ... catalyst) {
        return this.catalyst(Ingredient.m_43927_((ItemStack[])catalyst));
    }

    public FusionRecipeBuilder catalyst(int count, TagKey<Item> catalyst) {
        return this.catalyst(IngredientStack.fromTag(catalyst, count));
    }

    public FusionRecipeBuilder catalyst(int count, ItemLike ... catalyst) {
        return this.catalyst(IngredientStack.fromItems(count, catalyst));
    }

    public FusionRecipeBuilder catalyst(int count, ItemStack ... catalyst) {
        return this.catalyst(IngredientStack.fromStacks(count, catalyst));
    }

    public FusionRecipeBuilder catalyst(Ingredient catalyst) {
        this.catalyst = catalyst;
        return this;
    }

    public FusionRecipeBuilder energy(long totalEnergy) {
        this.energy = totalEnergy;
        return this;
    }

    public FusionRecipeBuilder techLevel(TechLevel techLevel) {
        this.techLevel = techLevel;
        return this;
    }

    public FusionRecipeBuilder ingredient(boolean consume, Ingredient ingredient) {
        this.ingredients.add(new FusionRecipe.FusionIngredient(ingredient, consume));
        return this;
    }

    public FusionRecipeBuilder ingredient(Ingredient ingredient) {
        return this.ingredient(true, ingredient);
    }

    public FusionRecipeBuilder ingredient(boolean consume, ItemStack ... ingredient) {
        return this.ingredient(consume, Ingredient.m_43927_((ItemStack[])ingredient));
    }

    public FusionRecipeBuilder ingredient(ItemStack ... ingredient) {
        return this.ingredient(true, ingredient);
    }

    public FusionRecipeBuilder ingredient(boolean consume, ItemLike ... ingredient) {
        return this.ingredient(consume, Ingredient.m_43929_((ItemLike[])ingredient));
    }

    public FusionRecipeBuilder ingredient(ItemLike ... ingredient) {
        return this.ingredient(true, ingredient);
    }

    public FusionRecipeBuilder ingredient(boolean consume, TagKey<Item> ingredient) {
        return this.ingredient(consume, Ingredient.m_204132_(ingredient));
    }

    public FusionRecipeBuilder ingredient(TagKey<Item> ingredient) {
        return this.ingredient(true, ingredient);
    }

    public void build(Consumer<FinishedRecipe> consumer) {
        this.build(consumer, this.result.m_41720_().getRegistryName());
    }

    public void build(Consumer<FinishedRecipe> consumer, String save) {
        ResourceLocation resourcelocation = this.result.m_41720_().getRegistryName();
        if (new ResourceLocation(save).equals((Object)resourcelocation)) {
            throw new IllegalStateException("Fusion Recipe " + save + " should remove its 'save' argument");
        }
        this.build(consumer, new ResourceLocation(save));
    }

    public void build(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        if (this.result.m_41619_()) {
            return;
        }
        this.validate(id);
        consumer.accept(new Result(id, this.result, this.catalyst, this.energy, this.techLevel, this.ingredients));
    }

    private void validate(ResourceLocation id) {
        if (this.catalyst == null) {
            throw new IllegalStateException("No catalyst is defined for fusion recipe " + id + "!");
        }
        if (this.energy == -1L) {
            throw new IllegalStateException("Energy requirement is not defined for fusion recipe " + id + "!");
        }
        if (this.techLevel == null) {
            throw new IllegalStateException("No TechLevel (crafting tier) is defined for fusion recipe " + id + "!");
        }
        if (this.ingredients.isEmpty()) {
            throw new IllegalStateException("No ingredients are defined for fusion recipe " + id + "!");
        }
    }

    public static JsonObject writeItemStack(ItemStack stack) {
        JsonObject json = new JsonObject();
        json.addProperty("item", stack.m_41720_().getRegistryName().toString());
        if (stack.m_41613_() != 1) {
            json.addProperty("count", (Number)stack.m_41613_());
        }
        if (stack.m_41782_()) {
            json.addProperty("nbt", stack.m_41783_().toString());
        }
        return json;
    }

    public static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final ItemStack result;
        private final Ingredient catalyst;
        private final TechLevel techLevel;
        private final Collection<FusionRecipe.FusionIngredient> ingredients;
        private final long energy;

        public Result(ResourceLocation id, ItemStack result, Ingredient catalyst, long energy, TechLevel techLevel, Collection<FusionRecipe.FusionIngredient> ingredients) {
            this.id = id;
            this.result = result;
            this.catalyst = catalyst;
            this.energy = energy;
            this.techLevel = techLevel;
            this.ingredients = ingredients;
        }

        public void m_7917_(JsonObject json) {
            json.add("result", (JsonElement)FusionRecipeBuilder.writeItemStack(this.result));
            json.add("catalyst", this.catalyst.m_43942_());
            json.addProperty("total_energy", (Number)this.energy);
            json.addProperty("tier", this.techLevel.name());
            JsonArray ingredientArray = new JsonArray();
            for (FusionRecipe.FusionIngredient ingredient : this.ingredients) {
                JsonElement element = ingredient.get().m_43942_();
                if (!ingredient.consume()) {
                    JsonObject object = new JsonObject();
                    object.addProperty("consume", Boolean.valueOf(false));
                    object.add("ingredient", element);
                    ingredientArray.add((JsonElement)object);
                    continue;
                }
                ingredientArray.add(element);
            }
            json.add("ingredients", (JsonElement)ingredientArray);
        }

        public RecipeSerializer<?> m_6637_() {
            return DraconicAPI.FUSION_RECIPE_SERIALIZER;
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

