/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.datagen;

import com.brandon3055.draconicevolution.DraconicEvolution;
import com.brandon3055.draconicevolution.datagen.BlockStateGenerator;
import com.brandon3055.draconicevolution.datagen.BlockTagGenerator;
import com.brandon3055.draconicevolution.datagen.ItemModelGenerator;
import com.brandon3055.draconicevolution.datagen.LangGenerator;
import com.brandon3055.draconicevolution.datagen.LootTableGenerator;
import com.brandon3055.draconicevolution.datagen.MultiBlockGenerator;
import com.brandon3055.draconicevolution.datagen.RecipeGenerator;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.init.DETags;
import com.brandon3055.draconicevolution.integration.equipment.CuriosIntegration;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.data.advancements.AdvancementProvider;
import net.minecraft.data.tags.BlockTagsProvider;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.forge.event.lifecycle.GatherDataEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class DataGenEventHandler {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        if (event.includeClient()) {
            gen.m_123914_((DataProvider)new LangGenerator(gen));
            gen.m_123914_((DataProvider)new BlockStateGenerator(gen, event.getExistingFileHelper()));
            gen.m_123914_((DataProvider)new ItemModelGenerator(gen, event.getExistingFileHelper()));
            gen.m_123914_((DataProvider)new MultiBlockGenerator(gen));
        }
        if (event.includeServer()) {
            gen.m_123914_((DataProvider)new RecipeGenerator(gen));
            gen.m_123914_((DataProvider)new LootTableGenerator(gen));
            BlockTagGenerator blockGenerator = new BlockTagGenerator(gen, "draconicevolution", event.getExistingFileHelper());
            gen.m_123914_((DataProvider)blockGenerator);
            gen.m_123914_((DataProvider)new ItemTagGenerator(gen, blockGenerator, "draconicevolution", event.getExistingFileHelper()));
        }
    }

    private static class ItemTagGenerator
    extends ItemTagsProvider {
        public ItemTagGenerator(DataGenerator dataGenerator, BlockTagsProvider blockTagProvider, String modId, @Nullable ExistingFileHelper existingFileHelper) {
            super(dataGenerator, blockTagProvider, modId, existingFileHelper);
        }

        protected void m_6577_() {
            this.m_206424_(DETags.Items.DUSTS_DRACONIUM).m_126582_((Object)DEContent.dust_draconium);
            this.m_206424_(DETags.Items.DUSTS_DRACONIUM_AWAKENED).m_126582_((Object)DEContent.dust_draconium_awakened);
            this.m_206424_(Tags.Items.DUSTS).addTags(new TagKey[]{DETags.Items.DUSTS_DRACONIUM_AWAKENED, DETags.Items.DUSTS_DRACONIUM});
            this.m_206424_(DETags.Items.NUGGETS_DRACONIUM).m_126582_((Object)DEContent.nugget_draconium);
            this.m_206424_(DETags.Items.NUGGETS_DRACONIUM_AWAKENED).m_126582_((Object)DEContent.nugget_draconium_awakened);
            this.m_206424_(Tags.Items.NUGGETS).addTags(new TagKey[]{DETags.Items.NUGGETS_DRACONIUM_AWAKENED, DETags.Items.NUGGETS_DRACONIUM});
            this.m_206424_(DETags.Items.INGOTS_DRACONIUM).m_126582_((Object)DEContent.ingot_draconium);
            this.m_206424_(DETags.Items.INGOTS_DRACONIUM_AWAKENED).m_126582_((Object)DEContent.ingot_draconium_awakened);
            this.m_206424_(Tags.Items.INGOTS).addTags(new TagKey[]{DETags.Items.INGOTS_DRACONIUM_AWAKENED, DETags.Items.INGOTS_DRACONIUM});
            this.m_206424_(DETags.Items.STORAGE_BLOCKS_DRACONIUM).m_126582_((Object)DEContent.block_draconium.m_5456_());
            this.m_206424_(DETags.Items.STORAGE_BLOCKS_DRACONIUM_AWAKENED).m_126582_((Object)DEContent.block_draconium_awakened.m_5456_());
            this.m_206424_(Tags.Items.STORAGE_BLOCKS).addTags(new TagKey[]{DETags.Items.STORAGE_BLOCKS_DRACONIUM, DETags.Items.STORAGE_BLOCKS_DRACONIUM_AWAKENED});
            this.m_206424_(DETags.Items.ORES_DRACONIUM).m_126584_((Object[])new Item[]{DEContent.ore_draconium_end.m_5456_(), DEContent.ore_draconium_nether.m_5456_(), DEContent.ore_draconium_overworld.m_5456_()});
            this.m_206424_(Tags.Items.ORES).m_206428_(DETags.Items.ORES_DRACONIUM);
            if (ModList.get().isLoaded("curios")) {
                CuriosIntegration.generateTags(x$0 -> this.m_206424_((TagKey)x$0));
            }
        }
    }

    private static class AdvancementBuilder
    extends AdvancementProvider {
        private DataGenerator generator;
        private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

        public AdvancementBuilder(DataGenerator generator) {
            super(generator);
            this.generator = generator;
        }

        private void aggAdvancements(Consumer<Advancement> consumer) {
        }

        public void m_6865_(HashCache cache) {
            Path path = this.generator.m_123916_();
            HashSet set = Sets.newHashSet();
            Consumer<Advancement> consumer = advancement -> {
                if (!set.add(advancement.m_138327_())) {
                    throw new IllegalStateException("Duplicate advancement " + advancement.m_138327_());
                }
                Path path1 = this.makePath(advancement.m_138327_());
                try {
                    DataProvider.m_123920_((Gson)GSON, (HashCache)cache, (JsonElement)advancement.m_138313_().m_138400_(), (Path)path1);
                }
                catch (IOException ioexception) {
                    DraconicEvolution.LOGGER.error("Couldn't save advancement {}", (Object)path1, (Object)ioexception);
                }
            };
            this.aggAdvancements(consumer);
        }

        protected Path makePath(ResourceLocation id) {
            return this.generator.m_123916_().resolve("data/" + id.m_135827_() + "/advancements/" + id.m_135815_() + ".json");
        }
    }
}

