/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.datagen;

import com.brandon3055.draconicevolution.blocks.DislocatorReceptacle;
import com.brandon3055.draconicevolution.blocks.Portal;
import com.brandon3055.draconicevolution.blocks.RainSensor;
import com.brandon3055.draconicevolution.blocks.machines.EnergyPylon;
import com.brandon3055.draconicevolution.blocks.machines.Generator;
import com.brandon3055.draconicevolution.blocks.machines.Grinder;
import com.brandon3055.draconicevolution.init.DEContent;
import java.util.function.Function;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Direction;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.BarrelBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.FurnaceBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.client.model.generators.loaders.MultiLayerModelBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BlockStateGenerator
extends BlockStateProvider {
    private static final Logger LOGGER = LogManager.getLogger();

    public BlockStateGenerator(DataGenerator gen, ExistingFileHelper exFileHelper) {
        super(gen, "draconicevolution", exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.simpleBlock((Block)DEContent.block_draconium);
        this.simpleBlock((Block)DEContent.block_draconium_awakened, (ModelFile)this.models().cubeBottomTop("awakened_draconium_block", this.modLoc("block/awakened_draconium_block_side"), this.modLoc("block/awakened_draconium_block"), this.modLoc("block/awakened_draconium_block")));
        this.simpleBlock((Block)DEContent.infused_obsidian);
        this.simpleBlock((Block)DEContent.energy_core);
        this.simpleBlock((Block)DEContent.energy_core_stabilizer, (ModelFile)this.models().getExistingFile(this.modLoc("block/energy_core_stabilizer")));
        this.simpleBlock((Block)DEContent.creative_op_capacitor);
        this.simpleBlock((Block)DEContent.stabilized_spawner, (ModelFile)this.models().getExistingFile(this.modLoc("block/stabilized_spawner")));
        this.simpleBlock((Block)DEContent.particle_generator, (ModelFile)this.models().getExistingFile(this.modLoc("block/particle_generator")));
        this.simpleBlock((Block)DEContent.crafting_core, (ModelFile)this.models().getExistingFile(this.modLoc("block/crafting/fusion_crafting_core")));
        this.simpleBlock((Block)DEContent.dislocation_inhibitor, (ModelFile)this.models().cubeBottomTop("dislocation_inhibitor", this.modLoc("block/dislocation_inhibitor"), this.modLoc("block/parts/machine_top"), this.modLoc("block/parts/machine_top")));
        this.multiLayerBlock((Block)DEContent.ore_draconium_overworld, this.mcLoc("block/stone"), this.modLoc("block/draconium_ore_overlay"));
        this.multiLayerBlock((Block)DEContent.ore_draconium_nether, this.mcLoc("block/netherrack"), this.modLoc("block/draconium_ore_overlay"));
        this.multiLayerBlock((Block)DEContent.ore_draconium_end, this.mcLoc("block/end_stone"), this.modLoc("block/draconium_ore_overlay"));
        this.multiLayerBlock((Block)DEContent.ore_draconium_deepslate, this.mcLoc("block/deepslate"), this.modLoc("block/draconium_ore_overlay"));
        this.directionalBlock((Block)DEContent.crafting_injector_basic, (ModelFile)this.models().getExistingFile(this.modLoc("block/crafting/crafting_injector_draconium")));
        this.directionalBlock((Block)DEContent.crafting_injector_wyvern, (ModelFile)this.models().getExistingFile(this.modLoc("block/crafting/crafting_injector_wyvern")));
        this.directionalBlock((Block)DEContent.crafting_injector_awakened, (ModelFile)this.models().getExistingFile(this.modLoc("block/crafting/crafting_injector_draconic")));
        this.directionalBlock((Block)DEContent.crafting_injector_chaotic, (ModelFile)this.models().getExistingFile(this.modLoc("block/crafting/crafting_injector_chaotic")));
        this.directionalFromNorth((Block)DEContent.fluid_gate, (ModelFile)this.models().getExistingFile(this.modLoc("block/fluid_gate")));
        this.directionalFromNorth((Block)DEContent.flux_gate, (ModelFile)this.models().getExistingFile(this.modLoc("block/flux_gate")));
        this.getVariantBuilder((Block)DEContent.rain_sensor).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)this.models().getExistingFile((Boolean)state.m_61143_((Property)RainSensor.ACTIVE) != false ? this.modLoc("block/rain_sensor_active") : this.modLoc("block/rain_sensor"))).build());
        this.directionalBlock((Block)DEContent.potentiometer, (ModelFile)this.models().getExistingFile(this.modLoc("block/potentiometer")));
        this.simpleBlock((Block)DEContent.energy_transfuser, (ModelFile)this.models().getExistingFile(this.modLoc("block/energy_transfuser")));
        this.simpleBlock((Block)DEContent.disenchanter, (ModelFile)this.models().getExistingFile(this.modLoc("block/disenchanter")));
        this.simpleBlock((Block)DEContent.celestial_manipulator, (ModelFile)this.models().getExistingFile(this.modLoc("block/celestial_manipulator")));
        this.simpleBlock((Block)DEContent.entity_detector, (ModelFile)this.models().getExistingFile(this.modLoc("block/entity_detector")));
        this.simpleBlock((Block)DEContent.entity_detector_advanced, (ModelFile)this.models().getExistingFile(this.modLoc("block/entity_detector_advanced")));
        this.dummyBlock((Block)DEContent.crystal_io_basic);
        this.dummyBlock((Block)DEContent.crystal_io_wyvern);
        this.dummyBlock((Block)DEContent.crystal_io_draconic);
        this.dummyBlock((Block)DEContent.crystal_relay_basic);
        this.dummyBlock((Block)DEContent.crystal_relay_wyvern);
        this.dummyBlock((Block)DEContent.crystal_relay_draconic);
        this.dummyBlock((Block)DEContent.crystal_wireless_basic);
        this.dummyBlock((Block)DEContent.crystal_wireless_wyvern);
        this.dummyBlock((Block)DEContent.crystal_wireless_draconic);
        this.dummyBlock((Block)DEContent.structure_block);
        this.dummyBlock((Block)DEContent.chaos_crystal);
        this.dummyBlock((Block)DEContent.placed_item);
        this.dummyBlock((Block)DEContent.chaos_crystal_part);
        this.dummyBlock((Block)DEContent.draconium_chest);
        this.dummyBlock((Block)DEContent.reactor_core);
        this.dummyBlock((Block)DEContent.reactor_stabilizer);
        this.dummyBlock((Block)DEContent.reactor_injector);
        VariantBlockStateBuilder pylonBuilder = this.getVariantBuilder((Block)DEContent.energy_pylon);
        for (EnergyPylon.Mode mode : EnergyPylon.Mode.values()) {
            String io = mode == EnergyPylon.Mode.OUTPUT ? "output" : "input";
            ModelBuilder model = this.models().cubeBottomTop("energy_pylon_" + io, this.modLoc("block/energy_pylon/energy_pylon_" + io), this.modLoc("block/energy_pylon/energy_pylon_" + io), this.modLoc("block/energy_pylon/energy_pylon_active_face"));
            for (Direction dir : Direction.values()) {
                pylonBuilder.partialState().with((Property)EnergyPylon.FACING, (Comparable)dir).with(EnergyPylon.MODE, (Comparable)((Object)mode)).modelForState().modelFile((ModelFile)model).rotationY(dir.m_122434_() == Direction.Axis.Y ? 0 : 180 + 90 * dir.m_122416_()).rotationX(dir == Direction.UP ? 0 : (dir == Direction.DOWN ? 180 : 90)).addModel();
            }
        }
        this.simpleBlock((Block)DEContent.dislocator_pedestal, (ModelFile)this.models().getExistingFile(this.modLoc("block/dislocator_pedestal")));
        VariantBlockStateBuilder receptacleBuilder = this.getVariantBuilder((Block)DEContent.dislocator_receptacle);
        receptacleBuilder.addModels(receptacleBuilder.partialState().with((Property)DislocatorReceptacle.CAMO, (Comparable)Boolean.valueOf(true)), ConfiguredModel.builder().modelFile((ModelFile)this.models().cubeAll("infused_obsidian", this.modLoc("block/infused_obsidian"))).build());
        receptacleBuilder.addModels(receptacleBuilder.partialState().with((Property)DislocatorReceptacle.ACTIVE, (Comparable)Boolean.valueOf(false)).with((Property)DislocatorReceptacle.CAMO, (Comparable)Boolean.valueOf(false)), ConfiguredModel.builder().modelFile((ModelFile)this.models().cubeAll("dislocator_receptacle_inactive", this.modLoc("block/dislocator_receptacle_inactive"))).build());
        receptacleBuilder.addModels(receptacleBuilder.partialState().with((Property)DislocatorReceptacle.ACTIVE, (Comparable)Boolean.valueOf(true)).with((Property)DislocatorReceptacle.CAMO, (Comparable)Boolean.valueOf(false)), ConfiguredModel.builder().modelFile((ModelFile)this.models().cubeAll("dislocator_receptacle_active", this.modLoc("block/dislocator_receptacle_active"))).build());
        ModelFile.ExistingModelFile portalModel = this.models().getExistingFile(this.modLoc("block/portal/portal"));
        ModelFile.ExistingModelFile portalWallX = this.models().getExistingFile(this.modLoc("block/portal/portal_wall_x"));
        ModelFile.ExistingModelFile portalWallY = this.models().getExistingFile(this.modLoc("block/portal/portal_wall_y"));
        ModelFile.ExistingModelFile portalWallZ = this.models().getExistingFile(this.modLoc("block/portal/portal_wall_z"));
        MultiPartBlockStateBuilder portalBuilder = this.getMultipartBuilder((Block)DEContent.portal);
        for (Direction.Axis axis : Direction.Axis.values()) {
            ModelFile.ExistingModelFile wallWestEast = axis == Direction.Axis.Z ? portalWallX : (axis == Direction.Axis.Y ? portalWallY : portalWallZ);
            ModelFile.ExistingModelFile wallUpDown = axis == Direction.Axis.Z || axis == Direction.Axis.Y ? portalWallY : portalWallZ;
            ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)portalBuilder.part().modelFile((ModelFile)portalModel).rotationX(axis != Direction.Axis.Y ? 90 : 0).rotationY(axis == Direction.Axis.X ? 90 : 0).addModel()).condition((Property)Portal.VISIBLE, (Comparable[])new Boolean[]{true}).condition(Portal.AXIS, (Comparable[])new Direction.Axis[]{axis}).end().part().modelFile((ModelFile)wallUpDown).rotationX(axis == Direction.Axis.X || axis == Direction.Axis.Z ? -90 : 0).addModel()).condition((Property)Portal.DRAW_UP, (Comparable[])new Boolean[]{true}).condition(Portal.AXIS, (Comparable[])new Direction.Axis[]{axis}).end().part().modelFile((ModelFile)wallUpDown).rotationX(axis == Direction.Axis.X || axis == Direction.Axis.Z ? 90 : 0).rotationY(axis == Direction.Axis.Y ? 180 : 0).addModel()).condition((Property)Portal.DRAW_DOWN, (Comparable[])new Boolean[]{true}).condition(Portal.AXIS, (Comparable[])new Direction.Axis[]{axis}).end().part().modelFile((ModelFile)wallWestEast).rotationY(axis == Direction.Axis.Z ? 180 : (axis == Direction.Axis.Y ? -90 : 0)).addModel()).condition((Property)Portal.DRAW_WEST, (Comparable[])new Boolean[]{true}).condition(Portal.AXIS, (Comparable[])new Direction.Axis[]{axis}).end().part().modelFile((ModelFile)wallWestEast).rotationY(axis == Direction.Axis.Y ? 90 : 0).rotationX(axis == Direction.Axis.X ? 180 : 0).addModel()).condition((Property)Portal.DRAW_EAST, (Comparable[])new Boolean[]{true}).condition(Portal.AXIS, (Comparable[])new Direction.Axis[]{axis}).end();
        }
        ModelFile.ExistingModelFile modelGenerator = this.models().getExistingFile(this.modLoc("block/generator/generator"));
        ModelFile.ExistingModelFile modelGeneratorFlame = this.models().getExistingFile(this.modLoc("block/generator/generator_flame"));
        MultiPartBlockStateBuilder generatorBuilder = this.getMultipartBuilder((Block)DEContent.generator);
        for (Direction dir : FenceGateBlock.f_54117_.m_6908_()) {
            int angle = (int)dir.m_122424_().m_122435_();
            ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)generatorBuilder.part().modelFile((ModelFile)modelGenerator).rotationY(angle).addModel()).condition((Property)Generator.FACING, (Comparable[])new Direction[]{dir}).end().part().modelFile((ModelFile)modelGeneratorFlame).rotationY(angle).addModel()).condition((Property)Generator.FACING, (Comparable[])new Direction[]{dir}).condition((Property)Generator.ACTIVE, (Comparable[])new Boolean[]{true}).end();
        }
        ModelFile.ExistingModelFile modelGrinder = this.models().getExistingFile(this.modLoc("block/grinder/grinder"));
        ModelFile.ExistingModelFile modelGrinderActive = this.models().getExistingFile(this.modLoc("block/grinder/grinder_eyes"));
        MultiPartBlockStateBuilder grinderBuilder = this.getMultipartBuilder((Block)DEContent.grinder);
        for (Direction dir : Direction.f_122349_) {
            int angle = (int)dir.m_122424_().m_122435_();
            ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)grinderBuilder.part().modelFile((ModelFile)modelGrinder).rotationY(angle).addModel()).condition((Property)Grinder.FACING, (Comparable[])new Direction[]{dir}).end().part().modelFile((ModelFile)modelGrinderActive).rotationY(angle).addModel()).condition((Property)Grinder.FACING, (Comparable[])new Direction[]{dir}).condition((Property)Grinder.ACTIVE, (Comparable[])new Boolean[]{true}).end();
        }
    }

    private void dummyBlock(Block block) {
        ModelBuilder model = ((BlockModelBuilder)this.models().withExistingParent("dummy", "block")).texture("particle", "minecraft:block/glass");
        this.simpleBlock(block, (ModelFile)model);
    }

    public void directionalFromNorth(Block block, ModelFile model) {
        this.directionalFromNorth(block, model, 180);
    }

    public void directionalFromNorth(Block block, ModelFile model, int angleOffset) {
        this.directionalFromNorth(block, (BlockState $) -> model, angleOffset);
    }

    public void directionalFromNorth(Block block, Function<BlockState, ModelFile> modelFunc) {
        this.directionalFromNorth(block, modelFunc, 180);
    }

    public void directionalFromNorth(Block block, Function<BlockState, ModelFile> modelFunc, int angleOffset) {
        this.getVariantBuilder(block).forAllStates(state -> {
            Direction dir = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
            return ConfiguredModel.builder().modelFile((ModelFile)modelFunc.apply((BlockState)state)).rotationX(dir == Direction.DOWN ? 90 : (dir == Direction.UP ? -90 : 0)).rotationY(dir.m_122434_().m_122478_() ? 0 : ((int)dir.m_122435_() + angleOffset) % 360).build();
        });
    }

    public void multiLayerBlock(Block block, ResourceLocation solid, ResourceLocation overlay) {
        this.simpleBlock(block, (ModelFile)((MultiLayerModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(block.getRegistryName().m_135815_())).parent((ModelFile)this.models().getExistingFile(this.mcLoc("block/block")))).texture("particle", solid)).customLoader(MultiLayerModelBuilder::begin)).submodel(RenderType.m_110451_(), (ModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().nested()).parent((ModelFile)this.models().getExistingFile(this.mcLoc("block/cube_all")))).texture("all", solid))).submodel(RenderType.m_110457_(), (ModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().nested()).parent((ModelFile)this.models().getExistingFile(this.mcLoc("block/cube_all")))).texture("all", overlay))).end());
    }

    public String m_6055_() {
        return "Draconic Evolution Blockstates";
    }

    private static /* synthetic */ ModelFile lambda$registerStatesAndModels$2(ModelFile barrelOpen, ModelFile barrel, BlockState state) {
        return (Boolean)state.m_61143_((Property)BarrelBlock.f_49043_) != false ? barrelOpen : barrel;
    }

    private static /* synthetic */ ConfiguredModel[] lambda$registerStatesAndModels$1(ModelFile furnaceLit, ModelFile furnace, BlockState state) {
        return ConfiguredModel.builder().modelFile((Boolean)state.m_61143_((Property)FurnaceBlock.f_48684_) != false ? furnaceLit : furnace).rotationY((int)((Direction)state.m_61143_((Property)FurnaceBlock.f_48683_)).m_122424_().m_122435_()).build();
    }
}

