/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.command;

import codechicken.lib.raytracer.RayTracer;
import com.brandon3055.brandonscore.BrandonsCore;
import com.brandon3055.brandonscore.lib.ChatHelper;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.init.DETags;
import com.brandon3055.draconicevolution.lib.WTFException;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.commands.CommandRuntimeException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class CommandMakeRecipe {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"gen_recipe").requires(cs -> cs.m_6761_(3))).then(Commands.m_82127_((String)"fusion").executes(CommandMakeRecipe::genFusion))).then(Commands.m_82127_((String)"crafting").executes(CommandMakeRecipe::genCrafting)));
    }

    private static int genFusion(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        BlockHitResult result = RayTracer.retrace((Player)player, (double)10.0, (ClipContext.Block)ClipContext.Block.OUTLINE);
        if (result.m_6662_() != HitResult.Type.BLOCK) {
            throw new CommandRuntimeException((Component)new TextComponent("No chest found.\nYou must be looking at a single chest with the recipe laid out on the far left and the result in the center slot.\nFor fusion recipes all slots other than center are ingredients except row 2, slot 2 which is the catalyst."));
        }
        BlockPos pos = result.m_82425_();
        IItemHandler handler = CommandMakeRecipe.getInventory(player.f_19853_, pos);
        Object recipe = CommandMakeRecipe.getFusionRecipe(handler);
        while (player.m_21206_().m_41720_() == Items.f_42436_ && player.f_19853_.m_7702_(pos = pos.m_7494_()) instanceof ChestBlockEntity) {
            handler = CommandMakeRecipe.getInventory(player.f_19853_, pos);
            recipe = (String)recipe + "\n\n" + CommandMakeRecipe.getFusionRecipe(handler);
        }
        BrandonsCore.proxy.setClipboardString((String)recipe);
        ChatHelper.sendMessage((Player)player, (Component)new TextComponent("Recipe copied to clipboard"));
        return 0;
    }

    private static int genCrafting(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        return 0;
    }

    private static String getFusionRecipe(IItemHandler handler) {
        ArrayList<ItemStack> ingredients = new ArrayList<ItemStack>();
        ItemStack result = ItemStack.f_41583_;
        ItemStack catalyst = ItemStack.f_41583_;
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stack = handler.getStackInSlot(i);
            if (i == 13) {
                result = stack;
                continue;
            }
            if (i == 10) {
                catalyst = stack;
                continue;
            }
            if (stack.m_41619_()) continue;
            ingredients.add(stack);
        }
        if (result.m_41619_()) {
            throw new CommandRuntimeException((Component)new TextComponent("Result slot (center of chest) is empty"));
        }
        if (catalyst.m_41619_()) {
            throw new CommandRuntimeException((Component)new TextComponent("Catalyst slot (row 2 column 2) is empty"));
        }
        StringBuilder recipeCode = new StringBuilder();
        if (result.m_41613_() > 1) {
            recipeCode.append(String.format("FusionRecipeBuilder.fusionRecipe(%s, %s)", CommandMakeRecipe.getItem(result, true), result.m_41613_())).append("\n");
        } else {
            recipeCode.append(String.format("FusionRecipeBuilder.fusionRecipe(%s)", CommandMakeRecipe.getItem(result))).append("\n");
        }
        if (catalyst.m_41613_() > 1) {
            recipeCode.append(String.format(".catalyst(%s, %s)", catalyst.m_41613_(), CommandMakeRecipe.getIngredient(catalyst, true))).append("\n");
        } else {
            recipeCode.append(String.format(".catalyst(%s)", CommandMakeRecipe.getIngredient(catalyst))).append("\n");
        }
        recipeCode.append(".energy(energyvalue)").append("\n");
        recipeCode.append(".techLevel(tecklevel)").append("\n");
        for (ItemStack stack : ingredients) {
            recipeCode.append(String.format(".ingredient(%s)", CommandMakeRecipe.getIngredient(stack, true))).append("\n");
        }
        recipeCode.append(String.format(".build(consumer, folder(\"tools\", " + CommandMakeRecipe.getItem(result, true) + "));", result.m_41720_().getRegistryName()));
        return recipeCode.toString();
    }

    public static Map<ResourceLocation, String> getFields() {
        HashMap<ResourceLocation, String> names = new HashMap<ResourceLocation, String>();
        try {
            for (Field field : DEContent.class.getFields()) {
                if (field.get(null) != null && Item.class.isAssignableFrom(field.getType()) && (field.getModifiers() & 9) != 0) {
                    names.put(((Item)field.get(null)).getRegistryName(), "DEContent." + field.getName());
                }
                if (field.get(null) == null || !Block.class.isAssignableFrom(field.getType()) || (field.getModifiers() & 9) == 0) continue;
                names.put(((Block)field.get(null)).getRegistryName(), "DEContent." + field.getName());
            }
            for (Field field : Items.class.getFields()) {
                if (!Item.class.isAssignableFrom(field.getType()) || (field.getModifiers() & 9) == 0) continue;
                names.put(((Item)field.get(null)).getRegistryName(), "Items." + field.getName());
            }
            for (Field field : Blocks.class.getFields()) {
                if (!Block.class.isAssignableFrom(field.getType()) || (field.getModifiers() & 9) == 0) continue;
                names.put(((Block)field.get(null)).getRegistryName(), "Blocks." + field.getName());
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new CommandRuntimeException((Component)new TextComponent("An error occurred while getting items"));
        }
        return names;
    }

    public static Map<ResourceLocation, String> getTags() {
        HashMap<ResourceLocation, Object> names = new HashMap<ResourceLocation, Object>();
        try {
            for (Field field2 : Tags.Items.class.getFields()) {
                if (!TagKey.class.isAssignableFrom(field2.getType()) || (field2.getModifiers() & 9) == 0) continue;
                names.put(((TagKey)field2.get(null)).f_203868_(), "Tags.Items." + field2.getName());
            }
            for (Field field2 : DETags.Items.class.getFields()) {
                if (!TagKey.class.isAssignableFrom(field2.getType()) || (field2.getModifiers() & 9) == 0) continue;
                names.put(((TagKey)field2.get(null)).f_203868_(), "DETags.Items." + field2.getName());
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new CommandRuntimeException((Component)new TextComponent("An error occurred while getting tags"));
        }
        ArrayList<String> tagPrefixes = new ArrayList<String>();
        tagPrefixes.add("forge:dusts/");
        tagPrefixes.add("forge:nuggets/");
        tagPrefixes.add("forge:ingots/");
        tagPrefixes.add("forge:gems/");
        tagPrefixes.add("forge:storage_blocks/");
        tagPrefixes.add("forge:rods/");
        tagPrefixes.add("forge:glass/");
        tagPrefixes.add("forge:glass_panes/");
        tagPrefixes.add("forge:ores/");
        HashMap<ResourceLocation, String> tagMap = new HashMap<ResourceLocation, String>();
        names.forEach((name, field) -> {
            for (String prefix : tagPrefixes) {
                if (!name.toString().startsWith(prefix)) continue;
                tagMap.put((ResourceLocation)name, (String)field);
                break;
            }
        });
        return tagMap;
    }

    public static String getItem(ItemStack stack, boolean ignnoreSize) {
        ResourceLocation key;
        Map<ResourceLocation, String> fields = CommandMakeRecipe.getFields();
        if (fields.containsKey(key = stack.m_41720_().getRegistryName())) {
            if (stack.m_41613_() > 1 && !ignnoreSize) {
                return "new ItemStack(" + fields.get(key) + ", " + stack.m_41613_() + ")";
            }
            return fields.get(key);
        }
        throw new CommandRuntimeException((Component)new TextComponent("Failed to locate item field for key: " + key));
    }

    public static String getItem(ItemStack stack) {
        return CommandMakeRecipe.getItem(stack, false);
    }

    public static String getIngredient(ItemStack stack, boolean ignoreSize) {
        Map<ResourceLocation, String> tags = CommandMakeRecipe.getTags();
        for (ResourceLocation tag : stack.m_204131_().map(TagKey::f_203868_).toList()) {
            if (!tags.containsKey(tag)) continue;
            if (stack.m_41613_() > 1 && !ignoreSize) {
                return "IngredientStack.fromTag(" + tags.get(tag) + ", " + stack.m_41613_() + ")";
            }
            return tags.get(tag);
        }
        String item = CommandMakeRecipe.getItem(stack);
        if (stack.m_41613_() > 1 && !ignoreSize) {
            return "IngredientStack.fromItems(" + stack.m_41613_() + "," + item + ")";
        }
        return item;
    }

    public static String getIngredient(ItemStack stack) {
        return CommandMakeRecipe.getIngredient(stack, false);
    }

    private static IItemHandler getInventory(Level world, BlockPos pos) {
        LazyOptional optional;
        BlockEntity tile = world.m_7702_(pos);
        if (tile instanceof ChestBlockEntity && (optional = tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY)).isPresent()) {
            IItemHandler handler = (IItemHandler)optional.orElseThrow(WTFException::new);
            if (handler.getSlots() != 27) {
                throw new CommandRuntimeException((Component)new TextComponent("Must be a single chest with result in center slot"));
            }
            return handler;
        }
        throw new CommandRuntimeException((Component)new TextComponent("No chest found.\nYou must be looking at a single chest with the recipe laid out on the far left and the result in the center slot.\nFor fusion recipes all slots other than center are ingredients except row 2, slot 2 which is the catalyst."));
    }
}

